/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.visuals;

import com.sas.metadata.remote.MdException;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDescriptionWizardTab;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.rmi.RemoteException;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;

public abstract class WizardRunTab
extends WsDescriptionWizardTab {
    protected JPanel contentPane;
    protected JTextPane m_textPane;
    protected JCheckBox m_checkBox;
    protected String m_strCheckBox = null;
    protected String m_strRunInfo = null;
    protected LimitedStyledDocument lsd;
    protected String newline = "\n";
    private static WAdminResource bundle = WAdminResource.getBundle(WizardRunTab.class);

    public WizardRunTab() {
        super(bundle.getString("WizardRunTab.Description.txt"));
        this.setHelpTopic("WizardRunTab");
        this._initialize();
    }

    public WizardRunTab(String strDescription) {
        this(strDescription, null);
    }

    public WizardRunTab(String strDescription, String strCheckBox) {
        super(strDescription);
        this.setHelpTopic("WizardRunTab");
        this.m_strCheckBox = strCheckBox;
        this._initialize();
    }

    @Override
    public boolean doDataExchange(boolean bSaveToModel) throws MdException, RemoteException {
        if (!bSaveToModel) {
            WAWizardDialog myParent = (WAWizardDialog)this.getTopLevelAncestor();
            myParent.setCursor(Cursor.getPredefinedCursor(3));
            String initString = (String)myParent.getWizardData("PROCESSINFO");
            this.initDocument(initString);
            this.m_textPane.setCaretPosition(0);
            myParent.setCursor(null);
        }
        return true;
    }

    protected void _initialize() {
        this.lsd = new LimitedStyledDocument(10000);
        this.setLayout(new GridBagLayout());
        this.m_textPane = new JTextPane(this.lsd);
        this.m_textPane.setEnabled(false);
        this.m_textPane.setCaretPosition(0);
        this.m_textPane.setMargin(new Insets(5, 5, 5, 5));
        this.m_textPane.setBackground(SystemColor.control);
        this.m_textPane.setEditable(false);
        JScrollPane scrollPaneForText = new JScrollPane(this.m_textPane);
        scrollPaneForText.setBorder(BorderFactory.createLoweredBevelBorder());
        this.add((Component)scrollPaneForText, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        if (this.m_strCheckBox != null) {
            this.m_checkBox = new JCheckBox(this.m_strCheckBox);
            this.add((Component)this.m_checkBox, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        }
    }

    protected void initDocument(String initString) {
        try {
            this.lsd.insertString(this.lsd.getLength(), initString, null);
        }
        catch (BadLocationException ble) {
            Workspace.getDefaultLogger().error("Couldn't insert initial text.");
        }
    }

    @Override
    public void onBack() {
        int len = this.lsd.getLength();
        try {
            this.lsd.remove(0, len);
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().error((Object)"", e);
        }
    }

    @Override
    public boolean validateData() {
        WAWizardDialog myParent = (WAWizardDialog)this.getTopLevelAncestor();
        if (this.m_strCheckBox == null || !this.m_checkBox.isSelected()) {
            return this.runProcess(myParent);
        }
        return true;
    }

    public abstract boolean runProcess(WAWizardDialog var1);

    class LimitedStyledDocument
    extends DefaultStyledDocument {
        private static final long serialVersionUID = 1L;

        public LimitedStyledDocument(int maxChars) {
        }
    }
}

