/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.visuals;

import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.ServerComponent;
import com.sas.services.ServiceException;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.visuals.AppServerPanel;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.rmi.RemoteException;
import java.util.HashMap;

public class SubmitType {
    private static String REMOTE_LIBARY = "RMT_WORK";
    private static final String WORK_LIBREF = "WORK";
    private HashMap m_hSubmitTypes;
    private WAComboBox m_cSubmitType;
    private String m_sAppServerId;
    private static final int BOX_HEIGHT = 21;
    private static final WAdminResource bundle = WAdminResource.getBundle(SubmitType.class);
    private PropertyChangeListener m_lsnrAppDefaults = null;
    private ActionListener m_lsnrSubmitTypeCombo = null;
    private static SubmitType m_SubmitTypeInstance = new SubmitType();

    public static SubmitType getInstance() {
        return m_SubmitTypeInstance;
    }

    private SubmitType() {
        this.initialize();
    }

    private void initialize() {
        this.m_cSubmitType = new WAComboBox();
        WorkspaceFile wsFile = Workspace.getWorkspace().getWorkspaceFile();
        this.m_lsnrAppDefaults = new cAppDefaultsListener();
        wsFile.addPropertyChangeListener(this.m_lsnrAppDefaults);
        this.m_hSubmitTypes = new HashMap();
        this.loadSubmitType();
        this.m_cSubmitType.setToolTipText(bundle.getString("SubmitType.SubmitTypeCombo.ToolTip.txt"));
        String sWidth = bundle.getString("SubmitType.Prototype.txt");
        this.m_cSubmitType.setPreferredSize(new Dimension(sWidth.length() + 100, 21));
        this.m_cSubmitType.setMaximumSize(new Dimension(sWidth.length() + 100, 21));
        this.m_cSubmitType.setEditable(false);
        this.m_cSubmitType.setVisible(false);
        this.m_cSubmitType.setEnabled(false);
        this.m_lsnrSubmitTypeCombo = new cSubmitTypeComboListener();
        this.m_cSubmitType.addActionListener(this.m_lsnrSubmitTypeCombo);
    }

    public String getSubmittedWorkLibrary() {
        if (SubmitType.getInstance().getSelectedSubmitType().equals("D7E796B4-654C-4ab3-B690-657EE79309FB")) {
            return REMOTE_LIBARY;
        }
        return WORK_LIBREF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadSubmitType() {
        WorkspaceFile ws = Workspace.getWorkspace().getWorkspaceFile();
        String sAppServerId = ws.getPropertyString("AppServer.Default");
        if (this.m_sAppServerId != null && !this.m_sAppServerId.equalsIgnoreCase("") && this.m_sAppServerId.equalsIgnoreCase(sAppServerId)) {
            return;
        }
        this.m_sAppServerId = sAppServerId;
        this.m_cSubmitType.removeAllItems();
        this.m_hSubmitTypes.clear();
        MdObjectStore store = null;
        WsAppServer appServer = null;
        ServerComponent gridSC = null;
        ServerComponent workSC = null;
        try {
            if (this.m_sAppServerId != null && this.m_sAppServerId.length() > 0) {
                store = Workspace.getMdFactory().createObjectStore(null, "SubmitType store");
                appServer = WsAppServer.createDefaultAppServer();
                gridSC = appServer.getGridServerComponent();
                workSC = appServer.getWorkspaceComponent();
            }
            String sDefaultSubmitType = this.getGlobalSubmitTypeDefault();
            if (workSC != null) {
                this.m_cSubmitType.addItem(bundle.getString("SubmitType.Workspace.txt"));
                this.m_hSubmitTypes.put(bundle.getString("SubmitType.Workspace.txt"), workSC.getClassIdentifier());
                if (sDefaultSubmitType.equalsIgnoreCase(bundle.getString("SubmitType.Workspace.txt"))) {
                    this.m_cSubmitType.setSelectedItem(bundle.getString("SubmitType.Workspace.txt"));
                }
            }
            if (gridSC != null) {
                this.m_cSubmitType.addItem(bundle.getString("SubmitType.Grid.txt"));
                this.m_hSubmitTypes.put(bundle.getString("SubmitType.Grid.txt"), gridSC.getClassIdentifier());
                if (sDefaultSubmitType.equalsIgnoreCase(bundle.getString("SubmitType.Grid.txt"))) {
                    this.m_cSubmitType.setSelectedItem(bundle.getString("SubmitType.Grid.txt"));
                }
            }
        }
        catch (MdException me) {
            MessageUtil.displayMetadataExceptionMessage(me, "Reading");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException(re);
        }
        catch (ServiceException se) {
            MessageUtil.displayServiceExceptionMessage(se);
        }
        finally {
            if (appServer != null) {
                appServer.dispose();
            }
            if (store != null) {
                try {
                    store.dispose();
                }
                catch (RemoteException ex) {
                    Workspace.handleRemoteException(ex);
                }
            }
        }
    }

    public void setEnabled(boolean bEnabled) {
        this.m_cSubmitType.setEnabled(bEnabled);
    }

    public void setVisible(boolean bVisible) {
        this.m_cSubmitType.setVisible(bVisible);
        if (bVisible) {
            this.loadSubmitType();
        }
    }

    public void setActive(boolean bActive) {
        this.setEnabled(bActive);
        this.setVisible(bActive);
    }

    private String getGlobalSubmitTypeDefault() {
        return Workspace.getWorkspace().getAppDefaultsFile().getPropertyString("SubmitType", "");
    }

    private void setGlobalSubmitTypeDefault(String submitType) {
        Workspace.getWorkspace().getAppDefaultsFile().setPropertyString("SubmitType", submitType);
        Workspace.getWorkspace().getAppDefaultsFile().saveExisting();
    }

    public String getAppServerId() {
        return this.m_sAppServerId;
    }

    public String getSelectedSubmitType() {
        String sName = (String)this.m_cSubmitType.getSelectedItem();
        return (String)this.m_hSubmitTypes.get(sName);
    }

    public WAComboBox getSubmitTypeComboBox() {
        return this.m_cSubmitType;
    }

    public void changeAppServer(String appServerId) {
        if (this.m_sAppServerId.equalsIgnoreCase(appServerId)) {
            return;
        }
        this.m_sAppServerId = appServerId;
        this.loadSubmitType();
    }

    protected class cAppDefaultsListener
    implements PropertyChangeListener {
        protected cAppDefaultsListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals(AppServerPanel.DefaultServerId)) {
                SubmitType.this.loadSubmitType();
            }
        }
    }

    protected class cSubmitTypeComboListener
    implements ActionListener {
        protected cSubmitTypeComboListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SubmitType.this.m_cSubmitType.getSelectedItem() != null) {
                SubmitType.this.setGlobalSubmitTypeDefault((String)SubmitType.this.m_cSubmitType.getSelectedItem());
            }
        }
    }
}

