/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.visuals;

import com.sas.editor.LogListDocument;
import com.sas.editor.LogListHolder;
import com.sas.editor.LogListViewer;
import com.sas.editor.LogStorageConfigDataInterface;
import com.sas.editor.LogTemporaryRollingFileStorageConfigData;
import com.sas.workspace.AppServer;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WARootPane;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.WsButtonsLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class SASLogDialog
extends WAStandardDialog {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = WAdminResource.getBundle(SASLogDialog.class);
    AppServer m_appServer;
    WsAppServer m_WsAppServer;
    LogListHolder m_log;
    private JButton m_btnSaveSASLog;
    private static final String SAS_LOGFILE_KEY = "SASLogDialog.Filename";
    protected LogListViewer m_logView = null;

    public SASLogDialog(Dialog dlgOwner, String sTitle, boolean bModal) {
        super(dlgOwner, sTitle, bModal);
    }

    public SASLogDialog(Frame dlgOwner, String sTitle, boolean bModal) {
        super(dlgOwner, sTitle, bModal);
    }

    public SASLogDialog(Dialog dlgOwner, String sTitle, boolean bModal, AppServer server) {
        super(dlgOwner, sTitle, bModal);
        this.m_appServer = server;
    }

    public SASLogDialog(Frame dlgOwner, String sTitle, boolean bModal, AppServer server) {
        super(dlgOwner, sTitle, bModal);
        this.m_appServer = server;
    }

    public SASLogDialog(Frame dlgOwner, String sTitle, boolean bModal, LogListViewer viewer) {
        super(dlgOwner, sTitle, bModal);
        this.m_logView = viewer;
    }

    public SASLogDialog(Frame dlgOwner, String sTitle, boolean bModal, LogListHolder log) {
        super(dlgOwner, sTitle, bModal);
        this.m_log = log;
    }

    public SASLogDialog(Dialog dlgOwner, String sTitle, boolean bModal, WsAppServer server) {
        super(dlgOwner, sTitle, bModal);
        this.m_WsAppServer = server;
    }

    public SASLogDialog(Frame dlgOwner, String sTitle, boolean bModal, WsAppServer server) {
        super(dlgOwner, sTitle, bModal);
        this.m_WsAppServer = server;
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.setHelpProduct("texteditor");
        this.setHelpTopic("logspace");
        LogListHolder logData = null;
        if (this.m_log == null && this.m_WsAppServer != null) {
            try {
                logData = this.m_WsAppServer.getLog();
            }
            catch (WsAppServerFailException wsfe) {
                MessageUtil.displayMessage(wsfe.getLocalizedMessage(), 0);
            }
        } else {
            logData = this.m_log == null && this.m_appServer != null ? new LogListHolder(this.m_appServer.getLogLinesHolder(), this.m_appServer.getLogCCHolder(), this.m_appServer.getLogTypeHolder()) : this.m_log;
        }
        if (this.m_logView == null && logData != null) {
            this.m_logView = new LogListViewer(5, null, Workspace.getWorkspace().getCodeEditorDefaults());
            try {
                LogTemporaryRollingFileStorageConfigData data = new LogTemporaryRollingFileStorageConfigData(5000, 20);
                ((LogListDocument)this.m_logView.getEditorPane().getCodeEditorDocument()).setStorageParameters((LogStorageConfigDataInterface)data);
            }
            catch (IOException e) {
                MessageUtil.displayMessage(e.getLocalizedMessage(), 0);
            }
            this.m_logView.append(logData);
        } else if (this.m_logView == null && logData == null) {
            this.m_logView = new LogListViewer(5, logData, Workspace.getWorkspace().getCodeEditorDefaults());
        }
        this.m_logView.getEditorPane().setCaretPosition(0);
        this.m_btnSaveSASLog = new JButton(bundle.getString("SASLogDialog.Action.SaveLogFile.txt"));
        this.m_btnSaveSASLog.setMnemonic(bundle.getString("SASLogDialog.Action.SaveLogFile.mnem").charAt(0));
        this.m_btnSaveSASLog.setToolTipText(bundle.getString("SASLogDialog.Action.SaveLogFile.ToolTip.txt"));
        this.m_btnSaveSASLog.addActionListener(this);
        this.m_btnCancel.addActionListener(this);
        this.setResizable(true);
    }

    @Override
    protected void updateButtonsPanel() {
        this.removeKeyListeners(this.m_pnlButtons, this.m_KeyHandler);
        this.m_pnlButtons.removeAll();
        this.m_pnlButtons.setLayout(new WsButtonsLayout());
        this.m_pnlButtons.add(this.m_btnSaveSASLog);
        this.m_pnlButtons.add(this.m_btnCancel);
        ((WARootPane)this.getRootPane()).setRealDefaultButton(this.m_btnCancel);
        this.addKeyListeners(this.m_pnlButtons, this.m_KeyHandler);
    }

    @Override
    protected void layoutWidgets() {
        super.layoutWidgets();
        WAPanel centerPanel = new WAPanel();
        centerPanel.setLayout(new BorderLayout());
        centerPanel.add((Component)this.m_logView);
        centerPanel.setPreferredSize(new Dimension(600, 400));
        this.setMainPanel(centerPanel);
    }

    @Override
    public boolean doDataExchange(boolean bSaveToModel) {
        if (!bSaveToModel) {
            this.populateStore();
            this.moveDataToView();
        } else {
            this.moveDataToStore();
        }
        return true;
    }

    public void populateStore() {
    }

    public void moveDataToView() {
    }

    public void moveDataToStore() {
    }

    @Override
    public boolean validateData() {
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_btnCancel) {
            if (this.onCancel()) {
                this.dispose();
            }
        } else if (src == this.m_btnSaveSASLog && this.onSaveSASLog()) {
            this.dispose();
        }
    }

    protected boolean onSaveSASLog() {
        if (this.validateData()) {
            return this.performSASLogFileSaveAction();
        }
        return false;
    }

    public boolean writeSASLogFile(File logFilename) {
        try {
            this.m_logView.saveFile(logFilename.toString());
        }
        catch (IOException ioe) {
            MessageUtil.displayMessage(ioe.getLocalizedMessage(), bundle.getString("SASLogDialog.ErrorWritingLog.title.txt"), 0);
            return false;
        }
        return true;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.m_logView != null) {
            this.m_logView.cleanup();
        }
        this.m_logView = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean performSASLogFileSaveAction() {
        boolean fileSaved = false;
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            String sFilename = this.getSavedLogFilename();
            if (sFilename.toLowerCase().lastIndexOf(".log") == -1) {
                StringBuffer sbFilename = new StringBuffer(sFilename);
                sFilename = sbFilename.append(".log").toString();
            }
            File file = new File(sFilename);
            File selectedFile = this.promptForSASLogFile(bundle.getString("SASLogDialog.BrowseSASLogFile.Title.txt"), file);
            if (selectedFile != null && selectedFile.toString().length() > 0) {
                int answer;
                if (selectedFile.exists() && (answer = MessageUtil.displayMessage(bundle.formatString("SASLogDialog.DuplicateFileWarning.fmt.txt", selectedFile.toString()), bundle.getString("SASLogDialog.DuplicateFileWarning.Title.txt"), 2, 0)) != 0) {
                    boolean bl = false;
                    return bl;
                }
                this.saveDefaultLogFilename(selectedFile.toString());
                fileSaved = this.writeSASLogFile(selectedFile);
            }
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
        return fileSaved;
    }

    protected File promptForSASLogFile(String title, File inFile) {
        File selectedFile = null;
        JFileChooser chooser = new JFileChooser(inFile);
        chooser.setDialogTitle(title);
        chooser.setSelectedFile(inFile);
        chooser.setApproveButtonText(bundle.getString("SASLogDialog.JFileChooser.SaveButton.txt"));
        chooser.setApproveButtonToolTipText(bundle.getString("SASLogDialog.JFileChooser.SaveButton.ToolTip.txt"));
        chooser.setApproveButtonMnemonic(bundle.getString("SASLogDialog.JFileChooser.SaveButton.mnem").charAt(0));
        chooser.ensureFileIsVisible(inFile);
        chooser.addChoosableFileFilter(new SASLogFileFilter());
        int retValue = chooser.showOpenDialog(chooser);
        if (retValue == 0) {
            try {
                selectedFile = chooser.getSelectedFile();
            }
            catch (Exception e) {
                Workspace.getDefaultLogger().error((Object)"", e);
                MessageUtil.displayMessage(e.getLocalizedMessage(), 0);
                return null;
            }
        }
        return selectedFile;
    }

    public String getSavedLogFilename() {
        WorkspaceFile appDefaults = Workspace.getWorkspace().getAppDefaultsFile();
        String logFilename = appDefaults.getPropertyString(SAS_LOGFILE_KEY, "");
        return logFilename;
    }

    public void saveDefaultLogFilename(String filename) {
        WorkspaceFile appDefaults = Workspace.getWorkspace().getAppDefaultsFile();
        if (filename == null || filename.length() == 0) {
            return;
        }
        appDefaults.setPropertyString(SAS_LOGFILE_KEY, filename);
    }

    public static String getExtension(File f) {
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    public void setAppServer(AppServer appServer) {
        this.m_appServer = appServer;
    }

    public void setLog(LogListHolder log) {
        this.m_log = log;
    }

    public void setWsAppServer(WsAppServer wsAppServer) {
        this.m_WsAppServer = wsAppServer;
    }

    public int findStringInLog(String searchString, boolean caseSensitive) {
        int returnValue = -1;
        if (searchString == null || searchString == "") {
            return returnValue;
        }
        if (this.m_log != null) {
            String[] strLogLinesArray = this.m_log.getLineArray();
            int iLogLines = strLogLinesArray.length;
            for (int i = 0; i < iLogLines; ++i) {
                String logLine = strLogLinesArray[i];
                if (!caseSensitive) {
                    searchString = searchString.toLowerCase();
                    logLine = logLine.toLowerCase();
                }
                if (logLine.indexOf(searchString) <= 0) continue;
                returnValue = i;
                break;
            }
        }
        return returnValue;
    }

    public class SASLogFileFilter
    extends FileFilter {
        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String extension = SASLogDialog.getExtension(f);
            if (extension != null) {
                return extension.equals("log");
            }
            return false;
        }

        @Override
        public String getDescription() {
            return bundle.getString("SASLogDialog.LogFilesType.Description.txt");
        }
    }
}

