/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.visuals;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Person;
import com.sas.metadata.remote.ResponsibleParty;
import com.sas.metadata.remote.Root;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractPopulateOnDemandTableColumn;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsEnumeratedTableColumn;
import com.sas.workspace.WsMetadataTableColumn;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;

public class ResponsiblePartyTableModel
extends WsAbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = WAdminResource.getBundle(ResponsiblePartyTableModel.class);
    protected static boolean[] m_baIsEditableColumns = new boolean[]{true, true, false};
    protected static boolean[] m_baIsChoiceColumns = new boolean[]{true, true, false};
    public static final int NAME_COLUMN = 0;
    public static final int ROLE_COLUMN = 1;
    public static final int RESPONSIBLEPARTY_COLUMN = 2;
    protected static final int TOTAL_COLS = 2;
    protected static final int TOTAL_HIDDEN_COLS = 1;
    protected Root m_oMetadata;
    protected List m_lPersons;
    protected String[] m_saPersons;
    public static final String OWNER_MODEL_ROLE = "OWNER";
    private static final String ADMINISTRATOR_MODEL_ROLE = "ADMINISTRATOR";
    private static final String OWNER_VIEW_ROLE = bundle.getString("ResponsiblePartyTableModel.Owner.txt");
    private static final String ADMINISTRATOR_VIEW_ROLE = bundle.getString("ResponsiblePartyTableModel.Admin.txt");
    private List m_lDeletedRPs;

    public static String getViewRole(ResponsibleParty mdoParty) {
        String role = null;
        try {
            role = mdoParty.getRole();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
        return role;
    }

    public static String getViewRole(String sModelRole) {
        if (OWNER_MODEL_ROLE.equalsIgnoreCase(sModelRole)) {
            return OWNER_VIEW_ROLE;
        }
        if (ADMINISTRATOR_MODEL_ROLE.equalsIgnoreCase(sModelRole)) {
            return ADMINISTRATOR_VIEW_ROLE;
        }
        return sModelRole;
    }

    public static String getModelRole(String sViewRole) {
        if (OWNER_VIEW_ROLE.equals(sViewRole)) {
            return OWNER_MODEL_ROLE;
        }
        if (ADMINISTRATOR_VIEW_ROLE.equals(sViewRole)) {
            return ADMINISTRATOR_MODEL_ROLE;
        }
        return sViewRole;
    }

    public ResponsiblePartyTableModel() {
        this.createColumnDefinitions();
    }

    protected void createColumnDefinitions() {
        String[] saRoles = new String[]{OWNER_VIEW_ROLE, ADMINISTRATOR_VIEW_ROLE};
        this.m_aColumns = new WsAbstractTableColumn[this.getColumnCount() + this.getHiddenColumnCount()];
        this.m_aColumns[0] = new cNameTableColumn(0, bundle.getString("ResponsiblePartyTableModel.Name.txt"), 150);
        this.m_aColumns[1] = new WsEnumeratedTableColumn(1, bundle.getString("ResponsiblePartyTableModel.Role.txt"), 150, saRoles, saRoles[0]);
        this.m_aColumns[2] = new WsMetadataTableColumn();
        ((WsEnumeratedTableColumn)this.m_aColumns[0]).setSorted(true);
        this.m_lDeletedRPs = new ArrayList();
    }

    public void setMetadata(Root oMetadata) {
        this.m_oMetadata = oMetadata;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getHiddenColumnCount() {
        return 1;
    }

    @Override
    public void deleteRow(int iRow) {
        List lDeletedRowValues = (List)this.m_lData.get(iRow);
        ResponsibleParty deletedRP = (ResponsibleParty)lDeletedRowValues.get(2);
        this.m_lDeletedRPs.add(deletedRP);
        super.deleteRow(iRow);
    }

    @Override
    public void populateStore() throws MdException, RemoteException {
        if (this.isStorePopulated()) {
            return;
        }
        String sTemplate = "<Templates><ResponsibleParty><Persons/></ResponsibleParty></Templates>";
        ArrayList<String> lAssociations = new ArrayList<String>();
        lAssociations.add("ResponsibleParties");
        Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)this.m_oMetadata, null, lAssociations, sTemplate, 12);
        this.setStorePopulated(true);
    }

    @Override
    public void moveDataToModel() throws MdException, RemoteException {
        this.clear();
        AssociationList alParties = this.m_oMetadata.getResponsibleParties();
        int nParties = alParties.size();
        for (int iParty = 0; iParty < nParties; ++iParty) {
            ResponsibleParty oParty = (ResponsibleParty)alParties.get(iParty);
            AssociationList alPersons = oParty.getPersons();
            String sRole = oParty.getRole();
            if (sRole.length() == 0) {
                sRole = oParty.getName();
            }
            if (alPersons.size() <= 0 || "Modified By".equalsIgnoreCase(sRole) || "Created By".equalsIgnoreCase(sRole)) continue;
            ArrayList<String> lColumnValues = new ArrayList<String>();
            lColumnValues.add(((Person)alPersons.get(0)).getName());
            lColumnValues.add(ResponsiblePartyTableModel.getViewRole(sRole));
            lColumnValues.add((String)oParty);
            this.m_lData.add(lColumnValues);
        }
        this.fireTableModelPopulated();
    }

    @Override
    public void moveDataToStore() throws MdException, RemoteException {
        MdObjectStore store = (MdObjectStore)this.m_oMetadata.getObjectStore();
        MdFactory factory = store.getFactory();
        AssociationList alResponsibleParties = this.m_oMetadata.getResponsibleParties(false);
        int nParties = alResponsibleParties.size();
        ResponsibleParty[] respPartiesArray = (ResponsibleParty[])alResponsibleParties.toArray((Object[])new ResponsibleParty[nParties]);
        for (int iParty = 0; iParty < nParties; ++iParty) {
            ResponsibleParty oParty = respPartiesArray[iParty];
            String sRole = oParty.getRole();
            if ("Created By".equalsIgnoreCase(sRole)) continue;
            alResponsibleParties.remove((Object)oParty);
        }
        for (int iResponsibleParty = 0; iResponsibleParty < this.getRowCount(); ++iResponsibleParty) {
            String sName = (String)this.getValueAt(iResponsibleParty, 0);
            String sRole = (String)this.getValueAt(iResponsibleParty, 1);
            ResponsibleParty mdoResponsibleParty = factory.getOMIUtil().getResponsibleParty(store, sName, ResponsiblePartyTableModel.getModelRole(sRole));
            alResponsibleParties.add((Object)mdoResponsibleParty);
        }
    }

    public String[] getPersons() {
        if (this.m_saPersons == null) {
            try {
                String sRepositoryId = Workspace.getWorkspace().getDefaultRepository().getFQID();
                this.m_lPersons = Workspace.getMdFactory().getOMIUtil().getMetadataObjects(sRepositoryId, "Person", 8448);
                int nPersons = this.m_lPersons.size();
                this.m_saPersons = new String[nPersons];
                for (int iPerson = 0; iPerson < nPersons; ++iPerson) {
                    this.m_saPersons[iPerson] = ((CMetadata)this.m_lPersons.get(iPerson)).getName();
                }
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage(e, "Reading");
                this.m_saPersons = new String[0];
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException(re);
            }
        }
        return this.m_saPersons;
    }

    protected CMetadata getPerson(String sName) {
        int nPersons = this.m_saPersons.length;
        for (int iPerson = 0; iPerson < nPersons; ++iPerson) {
            if (!this.m_saPersons[iPerson].equals(sName)) continue;
            return (CMetadata)this.m_lPersons.get(iPerson);
        }
        return null;
    }

    protected class cNameTableColumn
    extends WsAbstractPopulateOnDemandTableColumn {
        private boolean m_bPopulated;

        public cNameTableColumn(int iModelIndex, String sName, int cxWidth) {
            super(iModelIndex, sName, cxWidth);
        }

        @Override
        public Object createDefaultValue() {
            this.populate(null, 0, 0);
            return this.m_sDefault;
        }

        @Override
        protected void populate(JTable table, int iRow, int iColumn) {
            if (!this.m_bPopulated) {
                String[] saPersons = ResponsiblePartyTableModel.this.getPersons();
                this.setPossibleValues(saPersons);
                this.m_bPopulated = true;
            }
        }
    }
}

