/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.visuals;

import com.sas.editor.LogListHolder;
import com.sas.iom.SAS.IBinaryStream;
import com.sas.iom.SAS.IFileService;
import com.sas.iom.SAS.IFileref;
import com.sas.iom.SAS.IWorkspace;
import com.sas.iom.SAS.StreamOpenMode;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASIOMDefs.OctetSeqHolder;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Tree;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OpRequestUI;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.plugins.MetadataImporterInterface;
import com.sas.workspace.visuals.SASLogDialog;
import com.sas.workspace.visuals.WizardFinishTab2;
import com.sas.workspace.visuals.WsAppServerPanel;
import java.awt.Frame;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.List;
import org.omg.CORBA.StringHolder;

public class MetaImporterWizardFinishTab2
extends WizardFinishTab2 {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = WAdminResource.getBundle(MetaImporterWizardFinishTab2.class);
    protected MetadataImporterInterface m_plugin;
    protected String m_inXML;
    protected String m_reposID;
    protected boolean m_bSuccess = false;
    protected String lMessage;
    private String m_localFileName;

    public MetaImporterWizardFinishTab2(MetadataImporterInterface plugin) {
        this.m_plugin = plugin;
    }

    public MetaImporterWizardFinishTab2(String description, MetadataImporterInterface plugin) {
        super(description);
        this.m_plugin = plugin;
    }

    public MetaImporterWizardFinishTab2(String description) {
        super(description);
    }

    public void setPlugin(MetadataImporterInterface plugin) {
        this.m_plugin = plugin;
    }

    @Override
    protected void initialize() {
        this.setHelpProduct("imprt");
        this.setHelpTopic("importwiz_6");
        super.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doDataExchange(boolean bSaveToModel) throws MdException, RemoteException {
        block13: {
            WAWizardDialog wizard = (WAWizardDialog)this.getTopLevelAncestor();
            if (!bSaveToModel) {
                super.doDataExchange(bSaveToModel);
            } else {
                try {
                    Boolean changeAnalysis;
                    CMetadata repository = (CMetadata)wizard.getWizardData("REPOSITORY");
                    this.m_reposID = repository.getFQID();
                    Tree tree = (Tree)wizard.getWizardData("GROUP");
                    if (tree != null) {
                        this.m_plugin.setWriteGroup(tree);
                    }
                    if ((changeAnalysis = (Boolean)wizard.getWizardData("ChangeAnalysis")) != null && changeAnalysis.booleanValue()) {
                        Boolean comparisonMode = (Boolean)wizard.getWizardData("ComparisonMode");
                        if (comparisonMode != null && comparisonMode.booleanValue()) {
                            boolean bl = true;
                            return bl;
                        }
                        OpRequestUI request = new OpRequestUI(Workspace.getWorkspace(), bundle.getString("MetadataImporter.ChangeAnalysis.RemoteFile.ProgressIndicator.Message.txt"), bundle.getString("MetadataImporter.ChangeAnalysis.RemoteFile.ProgressIndicator.Title.txt"));
                        request.setDelayBeforeProgressCancelDialog(500);
                        request.setProgressShownOnStatusBar(false);
                        request.execute(new RemoteFileRunnable());
                        request = new OpRequestUI(Workspace.getWorkspace(), bundle.getString("MetadataImporter.ChangeAnalysis.ModelConversion.ProgressIndicator.Message.txt"), bundle.getString("MetadataImporter.ChangeAnalysis.ModelConversion.ProgressIndicator.Title.txt"));
                        request.setDelayBeforeProgressCancelDialog(500);
                        request.setProgressShownOnStatusBar(false);
                        ConversionRunnable conversionRunnable = new ConversionRunnable();
                        request.execute(conversionRunnable);
                        this.m_inXML = conversionRunnable.getXML();
                    } else {
                        this.m_inXML = this.m_plugin.getWriteXML();
                    }
                    if (this.m_inXML != null) {
                        String message = bundle.getString("WriteMetadataProgressIndicator.Msg.Message.txt");
                        String title = bundle.getString("WriteMetadataProgressIndicator.Msg.Title");
                        String cancelText = bundle.getString("WriteMetadataProgressIndicator.Msg.Cancel.txt");
                        OpRequestUI request = new OpRequestUI(Workspace.getWorkspace(), message, title, cancelText);
                        request.setDelayBeforeProgressCancelDialog(500);
                        request.setProgressShownOnStatusBar(false);
                        request.execute(this.DoThreadedWrite(wizard));
                        if (!this.m_bSuccess) {
                            MessageUtil.displayMessage(bundle.getString("Common.ErrorWritingMetadata.txt") + "\n" + this.lMessage, bundle.getString("Common.Error.txt"), 0);
                            throw new MdException("Undisplayable");
                        }
                        this.showLogDialog();
                        MdObjectStore store = (MdObjectStore)wizard.getWizardData("OBJECTSTORE");
                        if (store != null) {
                            store.dispose();
                            Workspace.getWorkspace().getMdObjectFactory().dumpDetailHashMap();
                            store = null;
                        }
                        break block13;
                    }
                    throw new MdException("Undisplayable");
                }
                finally {
                    this.removeLocalFile();
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean transferRemoteFile() {
        WAWizardDialog wizard = (WAWizardDialog)this.getTopLevelAncestor();
        wizard.getWizardData("OBJECTSTORE");
        String fileName = (String)wizard.getWizardData("m_CWMFilePath");
        String fileServerFQID = (String)wizard.getWizardData("FileServerFQID");
        if (fileServerFQID == null || fileServerFQID.equalsIgnoreCase(WsAppServerPanel.Local)) {
            return true;
        }
        int suffixPosition = fileName.lastIndexOf(46);
        String suffix = "";
        if (suffixPosition > 0 && suffixPosition < fileName.length() - 1) {
            suffix = fileName.substring(suffixPosition);
        }
        try {
            String encoding;
            File localFile = File.createTempFile("MIm", suffix);
            this.m_localFileName = localFile.getAbsolutePath();
            localFile.deleteOnExit();
            WsAppServer appServer = WsAppServer.createAppServer(fileServerFQID);
            if (appServer == null) {
                return false;
            }
            if (!appServer.isOpen()) {
                appServer.open();
            }
            String options = !(encoding = "").equals("") ? "encoding=" + encoding : "";
            IWorkspace workspace = appServer.getWorkspace();
            IFileService fileService = workspace.FileService();
            IFileref fileRef = fileService.AssignFileref("TempRef", "DISK", fileName, options, new StringHolder());
            IBinaryStream binaryStream = fileRef.OpenBinaryStream(StreamOpenMode.StreamOpenModeForReading);
            OctetSeqHolder binaryData = new OctetSeqHolder();
            DataOutputStream out = new DataOutputStream(new FileOutputStream(localFile));
            try {
                binaryStream.Read(1024, binaryData);
                while (binaryData.value.length > 0) {
                    out.write(binaryData.value);
                    binaryStream.Read(1024, binaryData);
                }
            }
            finally {
                out.flush();
                out.close();
                try {
                    binaryStream.Close();
                }
                catch (GenericError genericError) {}
                appServer.close();
                wizard.replaceWizardData("ImportFile", fileName);
                wizard.replaceWizardData("m_CWMFilePath", localFile.getAbsolutePath());
            }
        }
        catch (IOException e) {
            MessageUtil.displayMessage(e.getLocalizedMessage(), 0);
            return false;
        }
        catch (GenericError e) {
            MessageUtil.displayMessage(e.getLocalizedMessage(), 0);
            return false;
        }
        catch (WsAppServerFailException e) {
            MessageUtil.displayMessage(e.getLocalizedMessage(), 0);
            return false;
        }
        return true;
    }

    public void removeLocalFile() {
        File localFile;
        if (this.m_localFileName != null && this.m_localFileName.length() > 0 && (localFile = new File(this.m_localFileName)).exists()) {
            localFile.delete();
        }
    }

    protected Runnable DoThreadedWrite(WAWizardDialog wizard) {
        return new cDoThreadedWrite(wizard);
    }

    public void showLogDialog() {
        WAWizardDialog wizard = (WAWizardDialog)this.getTopLevelAncestor();
        String[] miLog = (String[])wizard.getWizardData("MILog");
        String[] sasLog = (String[])wizard.getWizardData("SASImportLog");
        int numLines = 0;
        if (miLog != null) {
            numLines = miLog.length;
        }
        if (sasLog != null) {
            numLines += sasLog.length;
        }
        if (numLines > 0) {
            String[] lines = new String[numLines];
            int start = 0;
            if (miLog != null) {
                start = miLog.length;
                System.arraycopy(miLog, 0, lines, 0, start);
            }
            if (sasLog != null) {
                System.arraycopy(sasLog, 0, lines, start, sasLog.length);
            }
            Integer[] types = new Integer[lines.length];
            for (int i = 0; i < types.length; ++i) {
                types[i] = new Integer(0);
            }
            LogListHolder log = new LogListHolder(lines, types);
            int choice = MessageUtil.displayMessage(bundle.getString("MetadataImporter.SASLog.dialog.txt"), 1, 0);
            if (choice == 0) {
                SASLogDialog dlg = new SASLogDialog((Frame)Workspace.getWorkspace(), bundle.getString("MetadataImporter.SASLog.title.txt"), true, log);
                dlg.show();
            }
        }
    }

    protected class RemoteFileRunnable
    implements Runnable {
        protected RemoteFileRunnable() {
        }

        @Override
        public void run() {
            MetaImporterWizardFinishTab2.this.transferRemoteFile();
        }
    }

    protected class ConversionRunnable
    implements Runnable {
        private String m_xml;

        protected ConversionRunnable() {
        }

        public String getXML() {
            return this.m_xml;
        }

        @Override
        public void run() {
            this.m_xml = MetaImporterWizardFinishTab2.this.m_plugin.getWriteXML();
        }
    }

    protected class cDoThreadedWrite
    implements Runnable {
        WAWizardDialog m_wizard;

        protected cDoThreadedWrite(WAWizardDialog wizard) {
            this.m_wizard = wizard;
        }

        @Override
        public void run() {
            try {
                this.executeThreadedWrite();
                MetaImporterWizardFinishTab2.this.m_bSuccess = true;
            }
            catch (MdException e) {
                MetaImporterWizardFinishTab2.this.lMessage = e.getLocalizedMessage();
                MetaImporterWizardFinishTab2.this.m_bSuccess = false;
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException(re);
            }
        }

        public void executeThreadedWrite() throws MdException, RemoteException {
            if (MetaImporterWizardFinishTab2.this.m_inXML.equals("MIRImport")) {
                MdObjectStore store = (MdObjectStore)this.m_wizard.getWizardData("OBJECTSTORE");
                List newObjs = store.getNewObjects();
                if (newObjs.size() > 1) {
                    store.updatedMetadataAll();
                }
            } else {
                Workspace.getMdFactory().getOMIUtil().ApplyXML(MetaImporterWizardFinishTab2.this.m_inXML, MetaImporterWizardFinishTab2.this.m_reposID);
            }
        }
    }
}

