/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.visuals;

import com.sas.editor.LogListHolder;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OpRequestUI;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.plugins.MetadataExporterInterface;
import com.sas.workspace.visuals.SASLogDialog;
import com.sas.workspace.visuals.WizardFinishTab;
import java.awt.Cursor;
import java.awt.Frame;
import java.rmi.RemoteException;
import javax.swing.JOptionPane;

public class MetaExporterWizardFinishTab
extends WizardFinishTab {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = WAdminResource.getBundle(MetaExporterWizardFinishTab.class);
    protected String m_reposID;
    protected MetadataExporterInterface m_plugin;
    protected String m_queryXML;
    protected boolean m_bSuccess = false;
    protected String lMessage;

    public MetaExporterWizardFinishTab(MetadataExporterInterface plugin) {
        this.m_plugin = plugin;
    }

    public MetaExporterWizardFinishTab(String strDescription, MetadataExporterInterface plugin) {
        super(strDescription);
        this.m_plugin = plugin;
    }

    public MetaExporterWizardFinishTab(String strDescription) {
        super(strDescription);
    }

    public void setPlugin(MetadataExporterInterface plugin) {
        this.m_plugin = plugin;
    }

    @Override
    protected void _initialize() {
        this.setHelpProduct("export");
        this.setHelpTopic("exportwiz_4");
        super._initialize();
    }

    @Override
    public boolean doDataExchange(boolean bSaveToModel) throws MdException, RemoteException {
        WAWizardDialog myParent = (WAWizardDialog)this.getTopLevelAncestor();
        if (!bSaveToModel) {
            myParent.setCursor(Cursor.getPredefinedCursor(3));
            myParent.runFinish();
            String initString = (String)myParent.getWizardData("FINISHINFO");
            String pluginString = this.m_plugin.getFinishString();
            if (pluginString != null) {
                initString = initString + pluginString;
            }
            this.initDocument(initString);
            this.m_textPane.setCaretPosition(0);
            myParent.setCursor(null);
        } else {
            CMetadata repository = (CMetadata)myParent.getWizardData("REPOSITORY");
            this.m_reposID = repository.getFQID();
            String str1 = bundle.getString("WriteMetadataProgressIndicator.Msg.Message.txt");
            String str2 = bundle.getString("WriteMetadataProgressIndicator.Msg.Title");
            String str3 = bundle.getString("WriteMetadataProgressIndicator.Msg.Cancel.txt");
            OpRequestUI request = new OpRequestUI(Workspace.getWorkspace(), str1, str2, str3);
            request.setDelayBeforeProgressCancelDialog(0);
            request.setProgressShownOnStatusBar(false);
            request.execute(this.DoThreadedExport(myParent));
            this.showLogDialog();
            if (!this.m_bSuccess) {
                if (this.lMessage != null) {
                    JOptionPane.showMessageDialog(myParent, bundle.getString("Common.ErrorWritingMetadata.txt") + "\n" + this.lMessage, bundle.getString("Common.Error.txt"), 0);
                }
                throw new MdException("Undisplayable");
            }
            MdObjectStore store = (MdObjectStore)myParent.getWizardData("OBJECTSTORE");
            if (store != null) {
                store.dispose();
                Workspace.getWorkspace().getMdObjectFactory().dumpDetailHashMap();
                store = null;
            }
        }
        return true;
    }

    protected Runnable DoThreadedExport(WAWizardDialog myParent) {
        return new cDoThreadedExport(myParent);
    }

    public void showLogDialog() {
        WAWizardDialog wizard = (WAWizardDialog)this.getTopLevelAncestor();
        String[] sasExportLog = (String[])wizard.getWizardData("SASExportLog");
        String[] miExportLog = (String[])wizard.getWizardData("MILog");
        int numLines = 0;
        if (sasExportLog != null) {
            numLines = sasExportLog.length;
        }
        if (miExportLog != null) {
            numLines += miExportLog.length;
        }
        if (numLines > 0) {
            String[] lines = new String[numLines];
            int start = 0;
            if (sasExportLog != null) {
                start = sasExportLog.length;
                System.arraycopy(sasExportLog, 0, lines, 0, start);
            }
            if (miExportLog != null) {
                System.arraycopy(miExportLog, 0, lines, start, miExportLog.length);
            }
            Integer[] types = new Integer[lines.length];
            for (int i = 0; i < types.length; ++i) {
                types[i] = new Integer(0);
            }
            LogListHolder log = new LogListHolder(lines, types);
            int choice = MessageUtil.displayMessage(bundle.getString("MetadataExporter.SASLog.dialog.txt"), 1, 0);
            if (choice == 0) {
                SASLogDialog dlg = new SASLogDialog((Frame)Workspace.getWorkspace(), bundle.getString("MetadataExporter.SASLog.title.txt"), true, log);
                dlg.show();
            }
        }
    }

    protected class cDoThreadedExport
    implements Runnable {
        WAWizardDialog mParent;

        protected cDoThreadedExport(WAWizardDialog myParent) {
            this.mParent = myParent;
        }

        @Override
        public void run() {
            try {
                MetaExporterWizardFinishTab.this.m_plugin.exportMetadata();
                MetaExporterWizardFinishTab.this.m_bSuccess = true;
            }
            catch (Exception e) {
                Workspace.getDefaultLogger().error((Object)"", e);
                MetaExporterWizardFinishTab.this.lMessage = e.getMessage();
                if (MetaExporterWizardFinishTab.this.lMessage != null && MetaExporterWizardFinishTab.this.lMessage.equalsIgnoreCase("WriteXMLError")) {
                    MetaExporterWizardFinishTab.this.m_bSuccess = false;
                }
                if (MetaExporterWizardFinishTab.this.lMessage != null && e.getMessage().equalsIgnoreCase("NoExportedXML")) {
                    MetaExporterWizardFinishTab.this.lMessage = bundle.getString("MetadataCommon.NoSchema.Export.txt");
                    MetaExporterWizardFinishTab.this.m_bSuccess = false;
                }
                MetaExporterWizardFinishTab.this.lMessage = e.toString();
                MetaExporterWizardFinishTab.this.m_bSuccess = false;
            }
        }
    }
}

