/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.visuals;

import com.sas.workspace.WATable;
import com.sas.workspace.WAdminResource;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public class BaseTableMenu
implements MouseListener,
ActionListener {
    protected JMenuItem jmi = null;
    private static WAdminResource bundle = WAdminResource.getBundle(BaseTableMenu.class);
    protected JPopupMenu pMenu = new JPopupMenu(bundle.getString("WATable.tableactions.txt"));
    protected JLabel hideLabel = null;
    protected JLabel menuLabel = null;
    protected JLabel sortLabel = null;
    protected Point currentPoint = null;
    protected WATable parent = null;
    protected boolean hide = true;
    protected boolean rowHeader = false;

    public BaseTableMenu(WATable _parent) {
        this.parent = _parent;
        int i = 0;
        this.jmi = new JMenuItem(bundle.getString("Common.New.txt"));
        this.jmi.setMnemonic(bundle.getString("Common.New.mnem").charAt(0));
        this.jmi.setActionCommand("new");
        this.jmi.addActionListener(this);
        this.pMenu.insert(this.jmi, i++);
        this.jmi = new JMenuItem(bundle.getString("Common.Delete.txt"));
        this.jmi.setMnemonic(bundle.getString("Common.Delete.mnem").charAt(0));
        this.jmi.setActionCommand("delRow");
        this.jmi.addActionListener(this);
        this.pMenu.insert(this.jmi, i++);
    }

    public void setRowHeader(boolean f) {
        this.rowHeader = f;
    }

    public boolean getRowHeader() {
        return this.rowHeader;
    }

    public void postPopup(int x, int y) {
        int row = this.parent.rowAtPoint(new Point(x, y));
        this.currentPoint = new Point(x, y);
        Container view = null;
        if (!this.rowHeader) {
            view = this.parent.getParent();
        } else {
            JViewport jvp = (JViewport)this.parent.getParent();
            JScrollPane jsp = (JScrollPane)jvp.getParent();
            view = jsp.getRowHeader();
        }
        if (view instanceof JViewport) {
            Point cornerPoint = ((JViewport)view).getViewPosition();
            Point transPoint = ((JViewport)view).toViewCoordinates(this.currentPoint);
            int x_prime = Math.abs(transPoint.x - cornerPoint.x);
            int y_prime = Math.abs(transPoint.y - cornerPoint.y);
            if (row != -1) {
                this.pMenu.show(view, x_prime, y_prime);
            } else {
                this.pMenu.show(view.getParent(), x, y);
            }
        } else {
            this.pMenu.show(this.parent, x, y);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.postPopup(e.getX(), e.getY());
        }
    }

    protected class TableMenuItem
    extends JMenuItem {
        private static final long serialVersionUID = 1L;
        int u_id;
        int pos;

        public TableMenuItem(String s) {
            super(s);
            this.u_id = -1;
            this.pos = -1;
        }

        public int getPos() {
            return this.pos;
        }

        public void setPos(int i) {
            this.pos = i;
        }

        public int getId() {
            return this.u_id;
        }

        public void setId(int i) {
            this.u_id = i;
        }
    }
}

