/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.models.tree.inventory;

import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.Workspace;
import com.sas.workspace.models.SimpleBrowseObject;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.models.impl.SimpleBrowseObjectImpl;
import com.sas.workspace.models.tree.inventory.AbstractElement;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class LibraryElement
extends AbstractElement {
    @Override
    public boolean areChildrenAllowed(SimpleObject simpleObject) {
        return true;
    }

    @Override
    public SimpleBrowseObject[] getChildrenOf(SimpleObject simpleObject) {
        ArrayList<SimpleBrowseObjectImpl> lSimpleTables = new ArrayList<SimpleBrowseObjectImpl>();
        try {
            List lTables;
            List lPackages;
            Filter filter = new Filter();
            filter.setOMRTemplate("<Templates><RelationalSchema><Tables/><UsingPackages/></RelationalSchema></Templates>");
            filter.setOMRFlags(16);
            String sKey = simpleObject.getID() + "/" + simpleObject.getMetadataType();
            BrowseMetadataInterface relSchema = this.m_server.browseFetch(sKey, (FilterInterface)filter);
            if (relSchema.get("IsDBMSLibname").equals("1") && (lPackages = (List)relSchema.get("UsingPackages")) != null && lPackages.size() > 0) {
                relSchema = (BrowseMetadataInterface)lPackages.get(0);
            }
            if ((lTables = (List)relSchema.get("Tables")) != null && !lTables.isEmpty()) {
                for (int i = 0; i < lTables.size(); ++i) {
                    BrowseMetadataInterface table = (BrowseMetadataInterface)lTables.get(i);
                    if (!"Table".equals(table.getSmartType())) continue;
                    lSimpleTables.add(new SimpleBrowseObjectImpl(table));
                }
            }
        }
        catch (ServiceException ex) {
            MessageUtil.displayServiceExceptionMessage(ex);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
        return lSimpleTables.toArray(new SimpleBrowseObject[lSimpleTables.size()]);
    }

    @Override
    public SimpleBrowseObject[] getParentsOf(SimpleObject simpleObject) {
        return new SimpleBrowseObject[0];
    }
}

