/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.models.tree;

import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.ServerInterface;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractIconFactory;
import com.sas.workspace.models.SimpleBrowseObject;
import com.sas.workspace.models.tree.AbstractTreeNode;
import com.sas.workspace.models.tree.IDataTreeNode;
import java.rmi.RemoteException;
import javax.swing.Icon;

public class SimpleBrowseObjectTreeNode
extends AbstractTreeNode
implements IDataTreeNode {
    protected SimpleBrowseObject m_simpleBrowseObject;
    protected Icon m_icon;

    public SimpleBrowseObjectTreeNode(SimpleBrowseObject simpleBrowseObject) {
        super(simpleBrowseObject.getName(), simpleBrowseObject.isAFolder());
        this.m_simpleBrowseObject = simpleBrowseObject;
        this.m_icon = WsAbstractIconFactory.getInstance().getDecoratableIconForSimpleObject(simpleBrowseObject);
    }

    public SimpleBrowseObject getSimpleBrowseObject() {
        return this.m_simpleBrowseObject;
    }

    @Override
    public Object getData() {
        return this.m_simpleBrowseObject;
    }

    @Override
    public String getName() {
        return this.m_simpleBrowseObject.getName();
    }

    @Override
    public String getType() {
        return this.m_simpleBrowseObject.getPublicType();
    }

    @Override
    public String getID() {
        return this.m_simpleBrowseObject.getID();
    }

    @Override
    public Icon getIcon() {
        return this.m_icon;
    }

    @Override
    public boolean isValidName(String sNewName) {
        return true;
    }

    @Override
    public boolean isRenameAllowed() {
        return this.isEditable();
    }

    @Override
    public void rename(String sNewName) {
    }

    @Override
    public boolean isDeleteAllowed() {
        return this.isEditable();
    }

    @Override
    public boolean delete() {
        return false;
    }

    @Override
    public void update() {
        try {
            ServerInterface server = this.m_model.getUserContext().getAuthServer();
            Filter filter = new Filter();
            filter.setOMRTemplate("<Templates><Root Name=\"\" PublicType=\"\" ChangeState=\"\" LockedBy=\"\"><ParentTree/><SoftwareComponents/><Trees/></Root></Templates>");
            filter.setOMRFlags(-2147483628);
            this.m_simpleBrowseObject.setBrowseObject(server.browseFolder(this.m_simpleBrowseObject.getISEntityKey(), (FilterInterface)filter));
            this.userObject = this.m_simpleBrowseObject.getName();
            this.m_icon = WsAbstractIconFactory.getInstance().getDecoratableIconForSimpleObject(this.m_simpleBrowseObject);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
        catch (ServiceException ex) {
            MessageUtil.displayServiceExceptionMessage(ex);
        }
    }

    @Override
    public boolean isFolder() {
        return this.m_simpleBrowseObject.isAFolder();
    }
}

