/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.models.tree;

import com.sas.services.ServiceException;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractIconFactory;
import com.sas.workspace.models.tree.AbstractTreeNode;
import com.sas.workspace.models.tree.ITreeNode;
import java.rmi.RemoteException;
import javax.swing.Icon;

public class CategoryTreeNode
extends AbstractTreeNode
implements ITreeNode {
    private Object m_categoryObject;
    private Icon m_icon;

    public CategoryTreeNode(Object userObject) {
        super(userObject, true);
        this.setEditable(false);
    }

    public void setCategoryObject(Object categoryObject) {
        this.m_categoryObject = categoryObject;
    }

    public Object getCategoryObject() {
        return this.m_categoryObject;
    }

    @Override
    public Icon getIcon() {
        if (this.m_icon == null && this.m_categoryObject instanceof TypeDescriptorInterface) {
            try {
                String sPublicType = ((TypeDescriptorInterface)this.m_categoryObject).getTypeName();
                this.m_icon = WsAbstractIconFactory.getInstance().getIconForPublicType(sPublicType);
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException(ex);
            }
            catch (ServiceException ex) {
                MessageUtil.displayServiceExceptionMessage(ex);
            }
        }
        return this.m_icon;
    }

    public void setIcon(Icon icon) {
        this.m_icon = icon;
    }

    @Override
    public boolean isFolder() {
        return true;
    }
}

