/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.models.impl;

import com.sas.services.information.ServerInterface;
import com.sas.workspace.models.ISimpleObjectHierarchyElement;
import com.sas.workspace.models.ISimpleObjectHierarchyModel;
import com.sas.workspace.models.SimpleBrowseObject;
import com.sas.workspace.models.SimpleObject;
import java.util.HashMap;
import java.util.Map;

public class SimpleObjectHierarchyModel
implements ISimpleObjectHierarchyModel {
    private Map m_elements = new HashMap();
    private ServerInterface m_server;

    public SimpleObjectHierarchyModel(ServerInterface server) {
        this.m_server = server;
    }

    public void addElement(ISimpleObjectHierarchyElement element, String sPublicType) {
        element.setServer(this.m_server);
        this.m_elements.put(sPublicType, element);
    }

    @Override
    public boolean areChildrenAllowed(SimpleObject simpleObject) {
        ISimpleObjectHierarchyElement element = (ISimpleObjectHierarchyElement)this.m_elements.get(simpleObject.getPublicType());
        if (element != null) {
            return element.areChildrenAllowed(simpleObject);
        }
        return false;
    }

    @Override
    public SimpleBrowseObject[] getChildrenOf(SimpleObject simpleObject) {
        ISimpleObjectHierarchyElement element = (ISimpleObjectHierarchyElement)this.m_elements.get(simpleObject.getPublicType());
        if (element != null) {
            return element.getChildrenOf(simpleObject);
        }
        return new SimpleBrowseObject[0];
    }

    @Override
    public SimpleBrowseObject[] getParentsOf(SimpleObject simpleObject) {
        ISimpleObjectHierarchyElement element = (ISimpleObjectHierarchyElement)this.m_elements.get(simpleObject.getPublicType());
        if (element != null) {
            return element.getParentsOf(simpleObject);
        }
        return new SimpleBrowseObject[0];
    }
}

