/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.models.impl;

import com.sas.services.ServiceException;
import com.sas.services.information.ServerInterface;
import com.sas.workspace.models.DecoratableIcon;
import com.sas.workspace.models.ISimpleObjectDecorator;
import com.sas.workspace.models.ISimpleObjectDecoratorElement;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.models.decorators.ChangeManagementDecorator;
import com.sas.workspace.models.decorators.ColumnTypeDecorator;
import com.sas.workspace.models.decorators.CubeDecorator;
import com.sas.workspace.models.decorators.CubeDeploymentDecorator;
import com.sas.workspace.models.decorators.DeploymentDecorator;
import com.sas.workspace.models.decorators.ParameterizedDecorator;
import com.sas.workspace.models.decorators.PluginDecorator;
import com.sas.workspace.models.decorators.SharedDimensionDecorator;
import com.sas.workspace.models.decorators.WebStreamDecorator;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SimpleObjectDecorator
implements ISimpleObjectDecorator {
    private Map m_elements = new HashMap();
    private ServerInterface m_server;
    private ISimpleObjectDecoratorElement m_CMDecorator;
    private ISimpleObjectDecoratorElement m_pluginDecorator;

    public SimpleObjectDecorator(ServerInterface server) {
        this.m_server = server;
        this.m_CMDecorator = new ChangeManagementDecorator();
        this.m_CMDecorator.setServer(server);
        this.m_pluginDecorator = new PluginDecorator();
        this.m_pluginDecorator.setServer(server);
        this.addElement((ISimpleObjectDecoratorElement)new ColumnTypeDecorator(), "Column");
        this.addElement((ISimpleObjectDecoratorElement)new DeploymentDecorator(), "Job");
        this.addElement((ISimpleObjectDecoratorElement)new ParameterizedDecorator(), new String[]{"Job", "Table", "ExternalFile"});
        this.addElement((ISimpleObjectDecoratorElement)new WebStreamDecorator(), "Table");
        this.addElement((ISimpleObjectDecoratorElement)new CubeDecorator(), "Cube");
        this.addElement((ISimpleObjectDecoratorElement)new CubeDeploymentDecorator(), "Job.CubeBuild");
        this.addElement((ISimpleObjectDecoratorElement)new SharedDimensionDecorator(), "SharedDimension");
    }

    public void addElement(ISimpleObjectDecoratorElement element, String sPublicType) {
        this.addElement(element, new String[]{sPublicType});
    }

    public void addElement(ISimpleObjectDecoratorElement element, String[] aPublicTypes) {
        element.setServer(this.m_server);
        for (int i = 0; i < aPublicTypes.length; ++i) {
            String sPublicType = aPublicTypes[i];
            ArrayList<ISimpleObjectDecoratorElement> lElements = (ArrayList<ISimpleObjectDecoratorElement>)this.m_elements.get(sPublicType);
            if (lElements == null) {
                lElements = new ArrayList<ISimpleObjectDecoratorElement>();
                this.m_elements.put(sPublicType, lElements);
            }
            lElements.add(element);
        }
    }

    @Override
    public boolean decorateIcon(DecoratableIcon icon, SimpleObject simpleObject) throws ServiceException, RemoteException {
        boolean bIconModified = false;
        bIconModified |= icon.clearDecorations();
        bIconModified |= this.m_CMDecorator.decorateIcon(icon, simpleObject);
        bIconModified |= this.m_pluginDecorator.decorateIcon(icon, simpleObject);
        List lElements = (List)this.m_elements.get(simpleObject.getPublicType());
        if (lElements != null) {
            for (int i = 0; i < lElements.size(); ++i) {
                ISimpleObjectDecoratorElement element = (ISimpleObjectDecoratorElement)lElements.get(i);
                bIconModified |= element.decorateIcon(icon, simpleObject);
            }
        }
        return bIconModified;
    }
}

