/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.models.impl;

import com.sas.services.ServiceException;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.Workspace;
import com.sas.workspace.models.IPublicTypeFilter;
import java.rmi.RemoteException;
import java.util.Map;

public class PublicTypeFilter
implements IPublicTypeFilter {
    @Override
    public boolean accept(String sPublicType) {
        if (sPublicType == null) {
            return false;
        }
        try {
            if (Workspace.getWorkspace().getUserContext() == null) {
                return false;
            }
            MetadataServerInterface server = (MetadataServerInterface)Workspace.getWorkspace().getUserContext().getAuthServer();
            Map typesMap = server.getTypeDictionaryMap();
            if (typesMap == null) {
                return false;
            }
            for (TypeDescriptorInterface tdi : typesMap.values()) {
                if (!sPublicType.equals(tdi.getTypeName())) continue;
                return true;
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
        catch (ServiceException ex) {
            MessageUtil.displayServiceExceptionMessage(ex);
        }
        return false;
    }
}

