/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.metadata;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Person;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.ResponsibleParty;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.ServerContext;
import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceException;
import com.sas.services.information.ChildServerInterface;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.UserFolderType;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.user.UserContextInterface;
import com.sas.swing.visuals.remotefileselector2.BaseRemoteFileSelectorPanel;
import com.sas.swing.visuals.remotefileselector2.FileSelectionValidatorInterface;
import com.sas.swing.visuals.remotefileselector2.InformationServicesSelectorPanel;
import com.sas.swing.visuals.remotefileselector2.RemoteFileSelectorDialog;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.PropertyHandler;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractValidationFactory;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsRepositoryUtil;
import com.sas.workspace.models.SimpleObject;
import java.awt.Frame;
import java.rmi.RemoteException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;

public class WsMetadataUtil {
    public static final String MODIFIED_BY = "Modified By";
    public static final String CREATED_BY = "Created By";
    private static final String MODIFIED_BY_PRODUCT = "ModifiedByProduct";
    private static final String MODIFIED_BY_PRODUCT_PROPERTY_SET = "ModifiedByProductPropertySet";
    private static DateFormat g_fmtParse = new SimpleDateFormat("ddMMMyyyy:HH:mm:ss z", Locale.US);
    private static DateFormat g_fmtDefault = DateFormat.getDateTimeInstance(2, 2);
    private static WAdminResource bundle = WAdminResource.getBundle(WsMetadataUtil.class);

    private WsMetadataUtil() {
    }

    public static Date parseUnformattedDate(String sDate) throws NumberFormatException {
        double secondsSince1Jan1960 = Double.parseDouble(sDate);
        double secondsSince1Jan1970 = secondsSince1Jan1960 - 3.156192E8;
        long millisecondsSince1Jan1970 = (long)(secondsSince1Jan1970 * 1000.0);
        return new Date(millisecondsSince1Jan1970);
    }

    public static Date parseFormattedDate(String sDate) throws ParseException {
        return g_fmtParse.parse(sDate + " GMT");
    }

    public static Date parseDate(String sDate) throws ParseException {
        try {
            return WsMetadataUtil.parseUnformattedDate(sDate);
        }
        catch (NumberFormatException ex) {
            return g_fmtParse.parse(sDate + " GMT");
        }
    }

    public static String formatDate(String sDate, DateFormat fmt) {
        try {
            Date date = WsMetadataUtil.parseDate(sDate);
            if (fmt == null) {
                return g_fmtDefault.format(date);
            }
            return fmt.format(date);
        }
        catch (ParseException exParse) {
            return sDate;
        }
    }

    public static boolean isNewObject(String sID) {
        return sID.indexOf("$") > -1;
    }

    private static void updateModifiedByUserFor(Root r) throws MdException, RemoteException {
        if (r == null) {
            return;
        }
        MdObjectStore store = (MdObjectStore)r.getObjectStore();
        String identityID = Workspace.getWorkspace().getMyIdentityID();
        String sIdentityName = Workspace.getWorkspace().getConnectionManager().getUserContext().getName();
        ResponsibleParty RPcurrent = null;
        if (identityID != null && !identityID.equals("UNKNOWN:")) {
            MdFactory factory = store.getFactory();
            RPcurrent = factory.getOMIUtil().getResponsibleParty(store, sIdentityName, MODIFIED_BY);
        }
        ResponsibleParty RPold = WsMetadataUtil.getModifiedByResponsiblePartyFor(r);
        while (RPold != null) {
            r.getResponsibleParties().remove((Object)RPold);
            RPold = WsMetadataUtil.getModifiedByResponsiblePartyFor(r);
        }
        if (RPcurrent != null) {
            r.getResponsibleParties().add(RPcurrent);
        }
    }

    private static ResponsibleParty getModifiedByResponsiblePartyFor(Root r) throws MdException, RemoteException {
        if (r == null) {
            return null;
        }
        AssociationList alParties = r.getResponsibleParties();
        for (int i = 0; i < alParties.size(); ++i) {
            ResponsibleParty rp = (ResponsibleParty)alParties.get(i);
            if (!MODIFIED_BY.equals(rp.getRole())) continue;
            return rp;
        }
        return null;
    }

    public static String getModifiedByUserFor(Root r) throws MdException, RemoteException {
        AssociationList persons;
        ResponsibleParty rp = WsMetadataUtil.getModifiedByResponsiblePartyFor(r);
        if (rp != null && !(persons = rp.getPersons()).isEmpty()) {
            Person p = (Person)persons.get(0);
            return p.getName();
        }
        return null;
    }

    public static void removeDuplicateModifiedByProductFor(Root r) throws MdException, RemoteException {
        PropertySet ps;
        String idToKeep;
        PropertyHandler handler = new PropertyHandler(r, MODIFIED_BY_PRODUCT_PROPERTY_SET);
        AssociationList lPropSets = r.getPropertySets();
        if (lPropSets != null && lPropSets.size() > 1 && (idToKeep = (ps = handler.getPropertySet()).getFQID()) != null && !idToKeep.isEmpty()) {
            WsMetadataUtil.removeExtraPropertySets(r, idToKeep);
        }
    }

    public static void updateModifiedByProductFor(Root r) throws MdException, RemoteException {
        PropertySet ps;
        String idToKeep;
        PropertyHandler handler = new PropertyHandler(r, MODIFIED_BY_PRODUCT_PROPERTY_SET);
        handler.setSpecificProperty(MODIFIED_BY_PRODUCT, Workspace.getWorkspace().getApplicationShortName());
        AssociationList lPropSets = r.getPropertySets();
        if (lPropSets != null && lPropSets.size() > 1 && (idToKeep = (ps = handler.getPropertySet()).getFQID()) != null && !idToKeep.isEmpty()) {
            WsMetadataUtil.removeExtraPropertySets(r, idToKeep);
        }
    }

    public static void removeExtraPropertySets(Root r, String idToKeep) {
        try {
            AssociationList lSets = r.getPropertySets();
            PropertySet propSet = null;
            if (lSets == null) {
                return;
            }
            ArrayList<PropertySet> lPropSets = new ArrayList<PropertySet>();
            for (int i = 0; i < lSets.size(); ++i) {
                if (((PropertySet)lSets.get(i)).getSetRole().compareToIgnoreCase(MODIFIED_BY_PRODUCT_PROPERTY_SET) != 0) continue;
                propSet = (PropertySet)lSets.get(i);
                lPropSets.add(propSet);
            }
            for (int j = 0; j < lPropSets.size(); ++j) {
                PropertySet myps = (PropertySet)lPropSets.get(j);
                if (myps.getFQID().equals(idToKeep)) continue;
                AssociationList l_p = myps.getProperties();
                if (l_p.size() > 0) {
                    Property p = (Property)l_p.get(0);
                    p.delete();
                }
                myps.delete();
            }
        }
        catch (RemoteException e1) {
            e1.printStackTrace();
        }
        catch (MdException e1) {
            e1.printStackTrace();
        }
    }

    public static String getFileNavigationValue(ServerContext serverContext) {
        String returnValue = "";
        try {
            AssociationList associationList = null;
            associationList = serverContext.getUsingComponents(true);
            LogicalServer server = null;
            for (int i = associationList.size() - 1; i >= 0 && server == null; --i) {
                server = (LogicalServer)associationList.get(i);
                if (server.getPublicType().equalsIgnoreCase("LogicalServer.Workspace")) continue;
                server = null;
            }
            ServerComponent serverComponent = null;
            if (server != null) {
                associationList = server.getUsingComponents(true);
                for (int i = associationList.size() - 1; i >= 0 && serverComponent == null; --i) {
                    serverComponent = (ServerComponent)associationList.get(i);
                    if (serverComponent.getPublicType().equalsIgnoreCase("Server.Workspace")) continue;
                    serverComponent = null;
                }
            }
            if (serverComponent != null) {
                PropertyHandler ph = new PropertyHandler((Root)serverComponent, "", false);
                ph.setUsePropertySet(false);
                returnValue = ph.getSpecificOptionValue("FileNavigation");
            }
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException(re);
        }
        catch (MdException mde) {
            MessageUtil.displayMetadataExceptionMessage(mde, "Accessing");
        }
        return returnValue;
    }

    public static String getFileNavigationValue(WsAppServer appserver) {
        String returnValue = "";
        try {
            ServerComponent scmp = appserver.getWorkspaceComponent();
            PropertyHandler ph = new PropertyHandler((Root)scmp, "", false);
            ph.setUsePropertySet(false);
            returnValue = ph.getSpecificOptionValue("FileNavigation");
        }
        catch (ServiceException e) {
            MessageUtil.displayServiceExceptionMessage(e);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException(re);
        }
        catch (MdException mde) {
            MessageUtil.displayMetadataExceptionMessage(mde, "Accessing");
        }
        return returnValue;
    }

    public static String getModifiedByProductFor(Root r) throws MdException, RemoteException {
        PropertyHandler handler = new PropertyHandler(r, MODIFIED_BY_PRODUCT_PROPERTY_SET);
        return handler.getSpecificOptionValue(MODIFIED_BY_PRODUCT);
    }

    public static void updateModifiedByFor(SimpleObject o) throws MdException, RemoteException {
        MdObjectStore store = Workspace.getMdFactory().createObjectStore(null, "WsMetadataUtil:updateModifiedByFor");
        try {
            Root r = (Root)Workspace.getMdFactory().createComplexMetadataObject(store, o.getName(), o.getMetadataType(), o.getID());
            WsMetadataUtil.updateModifiedByFor(r);
            r.updateMetadataAll();
        }
        finally {
            store.dispose();
        }
    }

    public static void updateModifiedByFor(Root r) throws MdException, RemoteException {
        String type = r.getCMetadataType();
        if (type.equals("Job") || type.equals("PhysicalTable") || type.equals("ExternalTable") || type.equals("Document") || type.equals("JFJob") || type.equals("Prototype") || type.equals("Transformation") || type.equals("SASLibrary") || type.equals("MiningResult") || type.equals("TextStore") || type.equals("Tree")) {
            WsMetadataUtil.updateModifiedByUserFor(r);
            if (type.equals("Job") || type.equals("PhysicalTable") || type.equals("ExternalTable")) {
                r.getPropertySets(true);
            }
            WsMetadataUtil.updateModifiedByProductFor(r);
            if (r instanceof Job) {
                PropertyHandler handler = new PropertyHandler(r, false);
                handler.setSpecificProperty("DISVersion", Double.toString(Workspace.getWorkspace().getApplicationVersionNumber()), "DISVersion", "", 0, null);
            }
        }
    }

    public static String getSimpleAttribute(String sType, String sFQID, String sAttr) throws MdException, RemoteException {
        ArrayList<String> lAttrs = new ArrayList<String>();
        lAttrs.add(sAttr);
        List lValues = Workspace.getMdFactory().getOMIUtil().getMetadataSimple(sType, sFQID, lAttrs);
        return (String)lValues.get(0);
    }

    public static void populateSimpleAttributes(Root mdo, List lAttrs) throws MdException, RemoteException {
        Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)mdo, lAttrs, null, null, 0);
    }

    public static boolean doesObjectExist(SimpleObject obj) throws MdException, RemoteException {
        return WsMetadataUtil.doesObjectExist(obj.getID(), obj.getMetadataType());
    }

    public static boolean doesObjectExist(Root mdo) throws MdException, RemoteException {
        return WsMetadataUtil.doesObjectExist(mdo.getFQID(), mdo.getCMetadataType());
    }

    public static boolean doesObjectExist(String sID, String sType) throws MdException, RemoteException {
        if (sID.indexOf(36) > -1) {
            return false;
        }
        String options = "<XMLSELECT search=\"@Id='" + sID + "'\"/>";
        int nObjects = Workspace.getMdFactory().getOMIUtil().doesObjectExist("A0000001." + sID.substring(0, 8), sType, options);
        return nObjects == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Tree getDefaultFolder(MdObjectStore store) throws MdException, RemoteException, ServiceException {
        ChildServerInterface transaction = null;
        Tree m_groupTree = null;
        try {
            MetadataInterface object;
            List objects;
            String options;
            ServerInterface authServer = Workspace.getWorkspace().getUserContext().getAuthServer();
            transaction = authServer.newChild(true);
            try {
                String strDefaultID = Workspace.getWorkspace().getAppDefaultsFile().getPropertyString("LastSelectedTreeIDGroupPanel");
                if (strDefaultID.length() != 0) {
                    options = "<XMLSELECT search=\"@Id='" + strDefaultID + "'\"/>";
                    int objCount = Workspace.getMdFactory().getOMIUtil().doesObjectExist("A0000001." + strDefaultID.substring(0, 8), "Tree", options);
                    if (objCount > 0) {
                        m_groupTree = (Tree)Workspace.getMdFactory().createComplexMetadataObject(store, "", "Tree", strDefaultID);
                        Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)m_groupTree, null, null, "", 8);
                        if (m_groupTree != null) {
                            Tree tree = m_groupTree;
                            return tree;
                        }
                    }
                }
            }
            catch (RemoteException strDefaultID) {
            }
            catch (MdException strDefaultID) {
                // empty catch block
            }
            if (!Workspace.getWorkspace().isChangeManagementOn() && !Workspace.getWorkspace().isUnrestrictedUser()) {
                try {
                    FolderInterface myFolder = transaction.getHomeFolder(null, UserFolderType.MYFOLDER, null);
                    if (myFolder != null) {
                        m_groupTree = (Tree)Workspace.getMdFactory().createComplexMetadataObject(store, "", "Tree", myFolder.getIdentifier());
                        Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)m_groupTree, null, null, "", 8);
                        if (m_groupTree != null) {
                            options = m_groupTree;
                            return options;
                        }
                    }
                }
                catch (RemoteException myFolder) {
                }
                catch (MdException myFolder) {
                }
                catch (ServiceException myFolder) {
                    // empty catch block
                }
            }
            if ((objects = transaction.search((FilterInterface)new Filter("Name", 0, "Shared Data"))).size() > 0 && (object = (MetadataInterface)objects.get(0)) != null) {
                m_groupTree = (Tree)Workspace.getMdFactory().createComplexMetadataObject(store, object.getName(), "Tree", object.getIdentifier());
                Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)m_groupTree, null, null, "", 8);
            }
        }
        finally {
            if (transaction != null) {
                transaction.destroy();
            }
        }
        return m_groupTree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PathUrl getDefaultFolderPathUrl() throws MdException, RemoteException, ServiceException {
        PathUrl url = null;
        ChildServerInterface transaction = null;
        try {
            MetadataInterface object;
            List objects;
            String options;
            ServerInterface authServer = Workspace.getWorkspace().getUserContext().getAuthServer();
            transaction = authServer.newChild(true);
            try {
                String strDefaultID = Workspace.getWorkspace().getAppDefaultsFile().getPropertyString("LastSelectedTreeIDGroupPanel");
                if (strDefaultID.length() != 0) {
                    MetadataInterface metadata;
                    options = "<XMLSELECT search=\"@Id='" + strDefaultID + "'\"/>";
                    int objCount = Workspace.getMdFactory().getOMIUtil().doesObjectExist("A0000001." + strDefaultID.substring(0, 8), "Tree", options);
                    if (objCount > 0 && (metadata = transaction.fetch(strDefaultID + "/" + "Tree", true)) != null && (url = metadata.getPathUrl()) != null) {
                        PathUrl pathUrl = url;
                        return pathUrl;
                    }
                }
            }
            catch (RemoteException strDefaultID) {
            }
            catch (MdException strDefaultID) {
            }
            catch (ServiceException strDefaultID) {
                // empty catch block
            }
            if (!Workspace.getWorkspace().isChangeManagementOn() && !Workspace.getWorkspace().isUnrestrictedUser()) {
                try {
                    FolderInterface myFolder = transaction.getHomeFolder(null, UserFolderType.MYFOLDER, null);
                    if (myFolder != null && (url = myFolder.getPathUrl()) != null) {
                        options = url;
                        return options;
                    }
                }
                catch (RemoteException myFolder) {
                }
                catch (ServiceException myFolder) {
                }
                catch (IllegalStateException myFolder) {
                    // empty catch block
                }
            }
            if ((objects = transaction.search((FilterInterface)new Filter("Name", 0, "Shared Data"))).size() > 0 && (object = (MetadataInterface)objects.get(0)) != null && (url = object.getPathUrl()) != null) {
                PathUrl pathUrl = url;
                return pathUrl;
            }
        }
        finally {
            if (transaction != null) {
                transaction.destroy();
            }
        }
        return url;
    }

    public static Tree getMyFolder(MdObjectStore store) throws MdException, RemoteException, ServiceException {
        Tree m_myFolderTree = null;
        UserContextInterface userContext = Workspace.getWorkspace().getUserContext();
        ServerInterface server = userContext.getAuthServer();
        FolderInterface myFolder = server.getHomeFolder(null, UserFolderType.MYFOLDER, null);
        if (myFolder != null) {
            m_myFolderTree = (Tree)Workspace.getMdFactory().createComplexMetadataObject(store, "", "Tree", myFolder.getIdentifier());
            Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)m_myFolderTree, null, null, "", 8);
        }
        return m_myFolderTree;
    }

    public static void setDefaultFolder(String nodeID) {
        Workspace.getWorkspace().getAppDefaultsFile().setPropertyString("LastSelectedTreeIDGroupPanel", nodeID);
    }

    public static PathUrl promptForPathUrl() {
        return WsMetadataUtil.promptForPathUrl(null, false);
    }

    public static PathUrl promptForPathUrl(String sInitialPath, boolean bAllowRootSelection) {
        return WsMetadataUtil.promptForPathUrl(sInitialPath, bAllowRootSelection, null);
    }

    public static PathUrl promptForPathUrl(String sInitialPath, boolean bAllowRootSelection, SimpleObject[] aObjects) {
        return WsMetadataUtil.promptForPathUrl(sInitialPath, bAllowRootSelection, aObjects, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PathUrl promptForPathUrl(String sInitialPath, boolean bAllowRootSelection, SimpleObject[] aObjects, String sReposID) {
        FileSelectionValidatorInterface validator = null;
        WsAbstractValidationFactory vFactory = WsAbstractValidationFactory.getInstance();
        if (vFactory != null && aObjects != null) {
            validator = vFactory.createFolderValidator(aObjects);
        }
        if (sInitialPath != null && Workspace.getWorkspace().isChangeManagementOn()) {
            try {
                ServerInterface server = Workspace.getWorkspace().getUserContext().getAuthServer();
                PathUrl pathUrl2 = new PathUrl(sInitialPath);
                MetadataInterface mi = server.getObjectByPath(pathUrl2);
                if (mi == null) {
                    sInitialPath = "";
                }
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException(ex);
            }
            catch (ServiceException ex) {
                MessageUtil.displayServiceExceptionMessage(ex);
            }
        }
        LinkedHashMap mapFileTypes = new LinkedHashMap();
        try {
            ServerInterface server = Workspace.getWorkspace().getUserContext().getAuthServer();
            RepositoryInterface reposInterface = null;
            String reposName = server.getRepositoryName(sReposID);
            if (sReposID != null && reposName != null) {
                reposInterface = server.getRepository(reposName);
            }
            InformationServicesSelectorPanel panel = new InformationServicesSelectorPanel(sInitialPath, server, reposInterface, mapFileTypes);
            panel.setShowDirectoriesOnly(true);
            panel.setSelectionMode(InformationServicesSelectorPanel.DIRECTORIES_ONLY);
            panel.setMultiSelectionEnabled(false);
            panel.setRootFolderSelectable(bAllowRootSelection);
            RemoteFileSelectorDialog dialog = null;
            dialog = new RemoteFileSelectorDialog((Frame)Workspace.getWorkspace(), bundle.getString("WsMetadataUtil.SelectFolder.title.txt"), true, 2, (BaseRemoteFileSelectorPanel)panel);
            dialog.setAllowNonExistentSelections(false);
            if (validator != null) {
                dialog.setSelectionValidator(validator);
            }
            dialog.setVisible(true);
            try {
                PathUrl pathUrl;
                if (panel.isCancelled()) return null;
                List lReturnedItems = panel.getReturnedInformation(true);
                if (lReturnedItems == null) return null;
                if (lReturnedItems.isEmpty()) return null;
                String path = lReturnedItems.get(0).toString();
                PathUrl pathUrl3 = pathUrl = new PathUrl(path);
                return pathUrl3;
            }
            finally {
                dialog.dispose();
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
            return null;
        }
        catch (ServiceException ex) {
            MessageUtil.displayServiceExceptionMessage(ex);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PathUrl getPathURLFromString(UserContextInterface userContext, String url) throws MdException, RemoteException {
        PathUrl pathurl;
        block6: {
            pathurl = null;
            try {
                if (url.startsWith("SBIP")) {
                    pathurl = new PathUrl(url);
                    break block6;
                }
                ServerInterface authServer = userContext.getAuthServer();
                ChildServerInterface childServer = authServer.newChild(true);
                try {
                    pathurl = PathUrl.newPathUrlFromAbsolutePath((ServerInterface)childServer, (String)url);
                }
                finally {
                    childServer.destroy();
                }
            }
            catch (ServiceException exc) {
                throw new MdException((Throwable)exc);
            }
        }
        return pathurl;
    }

    public static Root promptForFolder() {
        return WsMetadataUtil.promptForFolder(null, false);
    }

    public static Root promptForFolder(String sInitialPath, boolean bAllowRootSelection) {
        return WsMetadataUtil.promptForFolder(sInitialPath, bAllowRootSelection, null);
    }

    public static Root promptForFolder(String sInitialPath, boolean bAllowRootSelection, SimpleObject[] aObjects) {
        return WsMetadataUtil.promptForFolder(sInitialPath, bAllowRootSelection, aObjects, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Root promptForFolder(String sInitialPath, boolean bAllowRootSelection, SimpleObject[] aObjects, String sReposID) {
        FileSelectionValidatorInterface validator = null;
        WsAbstractValidationFactory vFactory = WsAbstractValidationFactory.getInstance();
        if (vFactory != null && aObjects != null) {
            validator = vFactory.createFolderValidator(aObjects);
        }
        if (sInitialPath != null && Workspace.getWorkspace().isChangeManagementOn()) {
            try {
                ServerInterface server = Workspace.getWorkspace().getUserContext().getAuthServer();
                PathUrl pathUrl = new PathUrl(sInitialPath);
                MetadataInterface mi = server.getObjectByPath(pathUrl);
                if (mi == null) {
                    sInitialPath = "";
                }
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException(ex);
            }
            catch (ServiceException ex) {
                MessageUtil.displayServiceExceptionMessage(ex);
            }
            catch (IllegalArgumentException ex) {
                Workspace.getDefaultLogger().error((Object)ex.getLocalizedMessage(), ex);
            }
        }
        Root tree = null;
        LinkedHashMap mapFileTypes = new LinkedHashMap();
        try {
            ServerInterface server = Workspace.getWorkspace().getUserContext().getAuthServer();
            RepositoryInterface reposInterface = null;
            String reposName = server.getRepositoryName(sReposID);
            if (sReposID != null && reposName != null) {
                reposInterface = server.getRepository(reposName);
            }
            InformationServicesSelectorPanel panel = new InformationServicesSelectorPanel(sInitialPath, server, reposInterface, mapFileTypes);
            panel.setShowDirectoriesOnly(true);
            panel.setSelectionMode(InformationServicesSelectorPanel.DIRECTORIES_ONLY);
            panel.setMultiSelectionEnabled(false);
            panel.setRootFolderSelectable(bAllowRootSelection);
            RemoteFileSelectorDialog dialog = null;
            dialog = new RemoteFileSelectorDialog((Frame)Workspace.getWorkspace(), bundle.getString("WsMetadataUtil.SelectFolder.title.txt"), true, 2, (BaseRemoteFileSelectorPanel)panel);
            dialog.setAllowNonExistentSelections(false);
            if (validator != null) {
                dialog.setSelectionValidator(validator);
            }
            dialog.setVisible(true);
            try {
                if (panel.isCancelled()) return null;
                List lReturnedItems = panel.getReturnedInformation(true);
                if (lReturnedItems == null) return null;
                if (lReturnedItems.isEmpty()) return null;
                String path = lReturnedItems.get(0).toString();
                PathUrl pathUrl = new PathUrl(path);
                MetadataInterface metadataObject = Workspace.getWorkspace().getInformationService().getObjectByPath(Workspace.getWorkspace().getUserContext(), pathUrl);
                Root root = tree = (Root)metadataObject.getRepositoryEntity();
                return root;
            }
            finally {
                dialog.dispose();
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
            return null;
        }
        catch (ServiceException ex) {
            MessageUtil.displayServiceExceptionMessage(ex);
        }
        return null;
    }

    public static Tree getFolderForMetadata(Root oRoot) throws MdException, RemoteException {
        if (oRoot == null) {
            return null;
        }
        if (oRoot.getCMetadataType().equals("Tree")) {
            return ((Tree)oRoot).getParentTree();
        }
        AssociationList lTrees = oRoot.getTrees();
        for (int iTree = 0; iTree < lTrees.size(); ++iTree) {
            Tree oTree = (Tree)lTrees.get(iTree);
            if (!oTree.getTreeType().equalsIgnoreCase("BIP Folder")) continue;
            return oTree;
        }
        return null;
    }

    public static String getFolderLocationForMetadata(Root oRoot) throws MdException, RemoteException, ServiceException {
        Tree tree = WsMetadataUtil.getFolderForMetadata(oRoot);
        if (tree == null) {
            return "";
        }
        return Workspace.getMdFactory().getOMIUtil().getObjectPath((MdObjectStore)tree.getObjectStore(), (PrimaryType)tree, false);
    }

    public static boolean isProjectObject(CMetadata iObject) {
        try {
            String sReposID = "A0000001." + iObject.getFQID().substring(0, 8);
            String sReposType = WsRepositoryUtil.getRepositoryType(Workspace.getMdFactory(), sReposID);
            return sReposType.equals("PROJECT");
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
            return false;
        }
    }

    public static boolean isProjectObject(SimpleObject iObject) {
        String sReposID = "A0000001." + iObject.getID().substring(0, 8);
        String sReposType = WsRepositoryUtil.getRepositoryType(Workspace.getMdFactory(), sReposID);
        return sReposType.equals("PROJECT");
    }
}

