/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.metadata;

import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.WorkTable;
import com.sas.rio.MVAResultSet;
import com.sas.rio.MVAStatement;
import com.sas.workspace.DBMSNamesUtil;
import com.sas.workspace.LibraryUtil;
import com.sas.workspace.ParametersInterface;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerCodeException;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.WsAppServerLibraryException;
import java.rmi.RemoteException;
import java.sql.SQLException;

public class WsMetadataPhysicalTableUtil {
    private static WAdminResource bundle = WAdminResource.getBundle(WsMetadataPhysicalTableUtil.class);
    public static final int ROW_COUNT_UNKNOWN = -1;
    public static final long ROW_COUNT_UNKNOWN_LONG = -1L;

    public static int getRowCount(PhysicalTable table) throws SQLException, WsAppServerFailException, WsAppServerLibraryException, WsAppServerCodeException, MdException, RemoteException {
        return WsMetadataPhysicalTableUtil.getRowCount(table, (WsAppServer)null);
    }

    public static int getRowCount(PhysicalTable table, WsAppServer useAppServer) throws SQLException, WsAppServerFailException, WsAppServerLibraryException, WsAppServerCodeException, MdException, RemoteException {
        return WsMetadataPhysicalTableUtil.getRowCount(table, useAppServer, null);
    }

    public static int getRowCount(PhysicalTable table, ParametersInterface parmInterface) throws SQLException, WsAppServerFailException, WsAppServerLibraryException, WsAppServerCodeException, MdException, RemoteException {
        return WsMetadataPhysicalTableUtil.getRowCount(table, null, parmInterface);
    }

    public static int getRowCount(PhysicalTable table, WsAppServer useAppServer, ParametersInterface parmInterface) throws SQLException, WsAppServerFailException, WsAppServerLibraryException, WsAppServerCodeException, MdException, RemoteException {
        return WsMetadataPhysicalTableUtil.getRowCount(table, useAppServer, parmInterface, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getRowCount(PhysicalTable table, WsAppServer useAppServer, ParametersInterface parmInterface, String tableName) throws SQLException, WsAppServerFailException, WsAppServerLibraryException, WsAppServerCodeException, MdException, RemoteException {
        boolean createdAppServer = false;
        boolean createdConnection = false;
        WsAppServer defAppServer = null;
        WsAppServer appServer = null;
        int count = -1;
        if (table == null) {
            Workspace.getDefaultLogger().info(bundle.getString("WsMetadataPhysicalTableUtil.GetRowCount.Error.NoTable.txt"));
            return -1;
        }
        try {
            Object o;
            SASLibrary library = LibraryUtil.findLibraryForTable(table.getTablePackages());
            if (library == null && !(table instanceof WorkTable)) {
                throw new WsAppServerLibraryException(bundle.formatString("WsMetadataPhysicalTableUtil.GetRowCount.Error.NoLibrary.fmt", table.getName()));
            }
            String quotedTableName = tableName != null ? DBMSNamesUtil.getQuotedString(tableName) : DBMSNamesUtil.getQuotedString(table.getSASTableName());
            if (useAppServer == null) {
                defAppServer = WsAppServer.createDefaultAppServer(false);
                if (defAppServer == null) {
                    int n = count;
                    return n;
                }
                useAppServer = defAppServer;
            }
            String libref = "";
            if (library == null) {
                if (!(table instanceof WorkTable)) {
                    Workspace.getDefaultLogger().info(bundle.formatString("WsMetadataPhysicalTableUtil.GetRowCount.Error.NoLibrary.fmt", table.getName()));
                    int n = -1;
                    return n;
                }
                libref = "work";
            } else {
                libref = library.getLibref();
            }
            if (table instanceof WorkTable && library == null) {
                appServer = useAppServer;
            } else {
                StringBuffer parms = null;
                if (parmInterface != null) {
                    parmInterface.setMetadata((Root)table);
                    parms = parmInterface.getParameterMacroCode();
                }
                String parmString = parms == null ? "" : parms.toString();
                appServer = LibraryUtil.interactiveAccessPath(library, useAppServer, parmString, false);
                createdAppServer = true;
            }
            if (appServer == null) {
                Workspace.getDefaultLogger().info(bundle.formatString("WsMetadataPhysicalTableUtil.GetRowCount.Error.NoServer.fmt", table.getName()));
                int parms = -1;
                return parms;
            }
            appServer.open(false);
            if (!appServer.isSQLConnectionOpen()) {
                appServer.openSQLConnection();
                createdConnection = true;
            }
            appServer.submitSASCode("options obs = max;");
            if (DBMSNamesUtil.isTableQuoted((DataTable)table)) {
                appServer.submitSASCode("options VALIDVARNAME=ANY VALIDMEMNAME=EXTEND;\n");
            }
            StringBuffer query = new StringBuffer();
            query.append("select nobs - delobs from Sashelp.Vtable where libname = '");
            query.append(libref.toUpperCase());
            query.append("' and memname = ");
            query.append(quotedTableName);
            query.append(" and memtype = 'DATA'");
            MVAStatement stmt = (MVAStatement)appServer.getSQLConnection().createStatement();
            MVAResultSet rs = appServer.submitSQLStatement(query.toString(), stmt, 10);
            if (rs.next()) {
                o = rs.getObject(1);
                if (o != null) {
                    count = rs.getInt(1);
                }
                rs.close();
                stmt.close();
            }
            if (count >= 0) return count;
            quotedTableName = tableName != null ? DBMSNamesUtil.getQuotedString(tableName, false) : DBMSNamesUtil.getQuotedString(table.getSASTableName(), table);
            query = new StringBuffer();
            query.append("select count(*) from ");
            query.append(libref);
            query.append(".");
            query.append(quotedTableName);
            stmt = (MVAStatement)appServer.getSQLConnection().createStatement();
            rs = appServer.submitSQLStatement(query.toString(), stmt, 10);
            if (!rs.next()) return count;
            o = rs.getObject(1);
            if (o != null) {
                count = rs.getInt(1);
            }
            rs.close();
            stmt.close();
            return count;
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().debug((Object)e.getLocalizedMessage(), e);
            return count;
        }
        finally {
            if (appServer != null) {
                if (createdConnection) {
                    appServer.closeSQLConnection();
                }
                if (createdAppServer) {
                    appServer.dispose();
                }
            }
        }
    }

    public static long getRowCountLong(PhysicalTable table) throws SQLException, WsAppServerFailException, WsAppServerLibraryException, WsAppServerCodeException, MdException, RemoteException {
        return WsMetadataPhysicalTableUtil.getRowCountLong(table, (WsAppServer)null);
    }

    public static long getRowCountLong(PhysicalTable table, WsAppServer useAppServer) throws SQLException, WsAppServerFailException, WsAppServerLibraryException, WsAppServerCodeException, MdException, RemoteException {
        return WsMetadataPhysicalTableUtil.getRowCountLong(table, useAppServer, null);
    }

    public static long getRowCountLong(PhysicalTable table, ParametersInterface parmInterface) throws SQLException, WsAppServerFailException, WsAppServerLibraryException, WsAppServerCodeException, MdException, RemoteException {
        return WsMetadataPhysicalTableUtil.getRowCountLong(table, null, parmInterface);
    }

    public static long getRowCountLong(PhysicalTable table, WsAppServer useAppServer, ParametersInterface parmInterface) throws SQLException, WsAppServerFailException, WsAppServerLibraryException, WsAppServerCodeException, MdException, RemoteException {
        return WsMetadataPhysicalTableUtil.getRowCountLong(table, useAppServer, parmInterface, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long getRowCountLong(PhysicalTable table, WsAppServer useAppServer, ParametersInterface parmInterface, String tableName) throws SQLException, WsAppServerFailException, WsAppServerLibraryException, WsAppServerCodeException, MdException, RemoteException {
        boolean createdAppServer = false;
        boolean createdConnection = false;
        WsAppServer defAppServer = null;
        WsAppServer appServer = null;
        long count = -1L;
        if (table == null) {
            Workspace.getDefaultLogger().info(bundle.getString("WsMetadataPhysicalTableUtil.GetRowCount.Error.NoTable.txt"));
            return -1L;
        }
        try {
            Object o;
            SASLibrary library = LibraryUtil.findLibraryForTable(table.getTablePackages());
            if (library == null && !(table instanceof WorkTable)) {
                throw new WsAppServerLibraryException(bundle.formatString("WsMetadataPhysicalTableUtil.GetRowCount.Error.NoLibrary.fmt", table.getName()));
            }
            String quotedTableName = tableName != null ? DBMSNamesUtil.getQuotedString(tableName) : DBMSNamesUtil.getQuotedString(table.getSASTableName());
            if (useAppServer == null) {
                defAppServer = WsAppServer.createDefaultAppServer(false);
                if (defAppServer == null) {
                    long l = count;
                    return l;
                }
                useAppServer = defAppServer;
            }
            String libref = "";
            if (library == null) {
                if (!(table instanceof WorkTable)) {
                    Workspace.getDefaultLogger().info(bundle.formatString("WsMetadataPhysicalTableUtil.GetRowCount.Error.NoLibrary.fmt", table.getName()));
                    long l = -1L;
                    return l;
                }
                libref = "work";
            } else {
                libref = library.getLibref();
            }
            if (table instanceof WorkTable && library == null) {
                appServer = useAppServer;
            } else {
                StringBuffer parms = null;
                if (parmInterface != null) {
                    parmInterface.setMetadata((Root)table);
                    parms = parmInterface.getParameterMacroCode();
                }
                String parmString = parms == null ? "" : parms.toString();
                appServer = LibraryUtil.interactiveAccessPath(library, useAppServer, parmString, false);
                createdAppServer = true;
            }
            if (appServer == null) {
                Workspace.getDefaultLogger().info(bundle.formatString("WsMetadataPhysicalTableUtil.GetRowCount.Error.NoServer.fmt", table.getName()));
                long parms = -1L;
                return parms;
            }
            appServer.open(false);
            if (!appServer.isSQLConnectionOpen()) {
                appServer.openSQLConnection();
                createdConnection = true;
            }
            appServer.submitSASCode("options obs = max;");
            if (DBMSNamesUtil.isTableQuoted((DataTable)table)) {
                appServer.submitSASCode("options VALIDVARNAME=ANY VALIDMEMNAME=EXTEND;\n");
            }
            StringBuffer query = new StringBuffer();
            query.append("select nobs - delobs from Sashelp.Vtable where libname = '");
            query.append(libref.toUpperCase());
            query.append("' and memname = ");
            query.append(quotedTableName);
            query.append(" and memtype = 'DATA'");
            MVAStatement stmt = (MVAStatement)appServer.getSQLConnection().createStatement();
            MVAResultSet rs = appServer.submitSQLStatement(query.toString(), stmt, 10);
            if (rs.next()) {
                o = rs.getObject(1);
                if (o != null) {
                    count = rs.getLong(1);
                }
                rs.close();
                stmt.close();
            }
            if (count >= 0L) return count;
            quotedTableName = tableName != null ? DBMSNamesUtil.getQuotedString(tableName, false) : DBMSNamesUtil.getQuotedString(table.getSASTableName(), table);
            query = new StringBuffer();
            query.append("select count(*) from ");
            query.append(libref);
            query.append(".");
            query.append(quotedTableName);
            stmt = (MVAStatement)appServer.getSQLConnection().createStatement();
            rs = appServer.submitSQLStatement(query.toString(), stmt, 10);
            if (!rs.next()) return count;
            o = rs.getObject(1);
            if (o != null) {
                count = rs.getLong(1);
            }
            rs.close();
            stmt.close();
            return count;
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().debug((Object)e.getLocalizedMessage(), e);
            return count;
        }
        finally {
            if (appServer != null) {
                if (createdConnection) {
                    appServer.closeSQLConnection();
                }
                if (createdAppServer) {
                    appServer.dispose();
                }
            }
        }
    }
}

