/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.metadata;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.ExternalTable;
import com.sas.metadata.remote.File;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.List;

public class ExternalFormatFileUtil {
    private static final String FormatFile = "FormatFile";
    private static final String COBEFF = "COBEFF";
    private static final String CSV = "CSV";
    private static final String EFF = "EFF";
    private static final String CobolFormatFile = "CobolFormatFile";
    private static final String COBOL = "COBOL";
    private static final String COPYBOOK = "COPYBOOK";
    private MdObjectStore m_store;
    private String m_fqid;

    public ExternalFormatFileUtil() {
    }

    public ExternalFormatFileUtil(MdObjectStore objectStore, String fqid) {
        this.setStore(objectStore);
        this.setFQID(fqid);
    }

    public void setStore(MdObjectStore store) {
        this.m_store = store;
    }

    public void setFQID(String fqid) {
        this.m_fqid = fqid;
    }

    public File buildCobolFormatFileMd(File cobolFileObject, String cobolFilename, String cobolFormatFilename, DeployedComponent dc) throws MdException, RemoteException {
        File cobolFile = null;
        cobolFile = cobolFileObject == null ? this.setExternalFormatFile(cobolFormatFilename, dc, COPYBOOK, COBOL) : cobolFileObject;
        File cobolEffFile = this.setExternalFormatFile(cobolFilename, dc, COBEFF, CSV);
        ClassifierMap cm = this.buildExternalFormatFileCM(cobolFilename, (CMetadata)cobolEffFile, CobolFormatFile);
        cobolFile.getSourceTransformations().add((Object)cm);
        return cobolFile;
    }

    public File buildFormatFileMd(String filename, DeployedComponent dc, ExternalTable externalTable) throws MdException, RemoteException {
        File file = this.setExternalFormatFile(filename, dc, EFF, CSV);
        ClassifierMap cm = this.buildExternalFormatFileCM(filename, (CMetadata)externalTable, FormatFile);
        file.getSourceTransformations().add((Object)cm);
        return file;
    }

    private File setExternalFormatFile(String filename, DeployedComponent dc, String role, String textType) throws MdException, RemoteException {
        String fqid = this.m_fqid.substring(0, 8);
        File effFile = (File)Workspace.getMdFactory().createComplexMetadataObject(this.m_store, filename, "File", fqid);
        effFile.setName(filename);
        effFile.setFileName(filename);
        effFile.setTextRole(role);
        effFile.setTextType(textType);
        effFile.setFileExtension(textType);
        effFile.getDeployedComponents().add((Object)dc);
        return effFile;
    }

    private ClassifierMap buildExternalFormatFileCM(String effFilename, CMetadata transformationTarget, String transformRole) throws MdException, RemoteException {
        String fqid = this.m_fqid.substring(0, 8);
        ClassifierMap effCM = (ClassifierMap)Workspace.getMdFactory().createComplexMetadataObject(this.m_store, effFilename, "ClassifierMap", fqid);
        effCM.setName(effFilename);
        effCM.setTransformRole(transformRole);
        effCM.getTransformationTargets().add((Object)transformationTarget);
        return effCM;
    }

    public List getCobolFormatFiles() throws MdException, RemoteException {
        String fqid = this.m_fqid.substring(0, 8);
        String effType = COBEFF;
        String sOptions = "<XMLSELECT Search=\"@TEXTROLE='" + effType + "'\"/>";
        List lFile = null;
        lFile = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)this.m_store, "A0000001." + fqid, "File", 8588, sOptions);
        return lFile;
    }

    public File getAssociatedFormatFile(String effType, ExternalTable externalTable) throws MdException, RemoteException {
        File file = null;
        AssociationList cmList = externalTable.getTargetTransformations();
        if (cmList.isEmpty()) {
            return null;
        }
        CMetadata met = (CMetadata)cmList.get(0);
        if (!met.getCMetadataType().equals("ClassifierMap")) {
            return null;
        }
        ClassifierMap cm = (ClassifierMap)cmList.get(0);
        if (cm.getTransformRole().equals(FormatFile)) {
            AssociationList sourceCodes = cm.getTransformationSources();
            for (int i = 0; i < sourceCodes.size(); ++i) {
                CMetadata fileObj = (CMetadata)sourceCodes.get(i);
                if (!fileObj.getCMetadataType().equals("File") || !((File)fileObj).getTextRole().equals(effType)) continue;
                file = (File)fileObj;
                break;
            }
        }
        return file;
    }

    public ClassifierMap buildFormatFileAssociation(File file, ExternalTable externalTable) throws MdException, RemoteException {
        ClassifierMap cm = this.buildExternalFormatFileCM(file.getFileName(), (CMetadata)externalTable, FormatFile);
        file.getSourceTransformations().add((Object)cm);
        return cm;
    }
}

