/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.metadata;

import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.ExternalTable;
import com.sas.metadata.remote.File;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.PropertyType;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASFileRef;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.ServerContext;
import com.sas.metadata.remote.Text;
import com.sas.metadata.remote.TextStore;
import com.sas.util.UsageVersion;
import com.sas.workspace.DBMSNamesUtil;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.SASCodeGeneration;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.metadata.AccessMethodUtil;
import com.sas.workspace.metadata.ExternalFormatFileUtil;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

public class EFIDataModel {
    private static WAdminResource bundle = WAdminResource.getBundle(EFIDataModel.class);
    private static final String MISSING_VALUE_VARIABLE = "missval";
    private static final char[] MISSING_VALUE_DELIMITER = new char[]{' '};
    private static final String FORMATFILE = "FormatFile";
    private static final String USERWRITTENSOURCECODE = "UserWrittenSourceCode";
    private static final String EFI_FILE_STRUCTURE = "EFI_FILE_STRUCTURE";
    private static final String TRUNCOVER = "TRUNCOVER";
    private static final String PAD = "PAD";
    private static final String LRECL = "LRECL";
    private static final String DELIMITER = "DELIMTER";
    private static final String CONSECUTIVEDELIMITERS = "CONSECUTIVEDELIMITERS";
    private static final String MISSOVER = "MISSOVER";
    private static final String EFI_GENERAL = "EFI_GENERAL";
    private static final String CREATEVIEW = "CREATEVIEW";
    private static final String STARTRECORD = "STARTRECORD";
    private static final String MISSINGVALUES_SPECIAL = "MISSINGVALUES_SPECIAL";
    private static final String MISSINGVALUES_NUMBERS = "MISSINGVALUES_NUMBERS";
    private static final String INFILEENCODING = "INFILEENCODING";
    private static final String INFILEOPTIONS = "INFILEOPTIONS";
    private static final String INFILEOVERRIDE = "INFILEOVERRIDE";
    private static final String READIRECTORY = "READDIRECTORY";
    private static final String YES = "YES";
    private static final String NO = "NO";
    private static final String FIXEDWIDTH = "FIXEDWIDTH";
    private static final String INFILEDELIMITER = "INFILEDELIMITER";
    private static final String MULTIRECORDSPERLINE = "MULTIRECORDSPERLINE";
    private static final String NUMMISS = "NUMMISS";
    private static final String SPECMISS = "SPECMISS";
    private static final String BLANK = " ";
    private static final String NAMEDPIPE = "NAMEDPIPE";
    private static final String ETLFILEREF = "ETLFILEREF";
    private static final String OBS = "OBS";
    private static final String CASESENSITIVECOLUMNS = "CASESENSITIVECOLUMNS";
    private static final String SPECIALCHARACTERSINCOLUMNS = "SPECIALCHARACTERSINCOLUMNS";
    private static final String FTPSERVER = "Ftp Server";
    private static final String HTTPSERVER = "Http Server";
    private static final String SAS = "SAS";
    private static final String DOUBLEQUOTE = "DOUBLEQUOTE";
    private static final String NOQUOTE = "NOQUOTE";
    private static final String OVERLAP = "OVERLAP";
    private static final String PREINFILE = "PREINFILE";
    private static final String PREATTRIBINPUTSTATEMENT = "PREATTRIBINPUTSTATEMENT";
    private static final String ATTRIBINPUTSTATEMENT = "ATTRIBINPUTSTATEMENT";
    private static final String POSTATTRIBINPUTSTATEMENT = "POSTATTRIBINPUTSTATEMENT";
    private static final String OVERRIDEDELIMITER = "OVERRIDEDELIMITER";
    public static final String PUBLICTYPE_EXTERNALFILE = "ExternalFile";
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);
    private String m_fqid;
    private boolean m_ftp_access;
    private boolean m_pipe_access;
    private boolean m_http_access;
    private boolean m_hadoop_access;
    private boolean m_doubleQuotesEnabled;
    private boolean m_noQuotesEnabled;
    private boolean m_default_access = true;
    private DeployedComponent m_ftp_server;
    private DeployedComponent m_http_server;
    private DeployedComponent m_hadoop_server;
    private boolean m_infile_override;
    private String m_infile_override_text;
    private boolean m_infile_options;
    private boolean m_infile_encoding;
    private String m_infile_encoding_text = "";
    private String m_infile_options_text = "";
    private DeployedComponent m_appServerDC;
    private String m_filename = "";
    private MdObjectStore m_store;
    private File m_newFile;
    private ExternalTable m_newExternalTable;
    private SASFileRef m_newFileRef;
    private boolean m_fixed_width;
    private boolean m_pad;
    private boolean m_truncover;
    private boolean m_delimited;
    private String m_appDefaultsDelimiterValue = Workspace.getWorkspace().getAppDefaultsFile().getPropertyString("DelimitedExternalTablePanel.Delimiters");
    private String m_delimiterValue = this.m_appDefaultsDelimiterValue.length() != 0 ? this.m_appDefaultsDelimiterValue : " ";
    private boolean m_consecutiveDelimiters;
    private boolean m_missover;
    private int m_startRecord = 1;
    private int m_numberObservations = 0;
    private String m_missingNumeric = "";
    private String m_missingSpecial = "";
    private boolean m_delimMultiRecPerLine;
    private TextStore m_newTextStore;
    private boolean m_createView;
    private PropertySet m_efiStructurePS;
    private PropertySet m_efiGeneralPS;
    private Property m_fixedWidthProp;
    private Property m_delimiterProp;
    private Property m_truncoverProp;
    private Property m_padProp;
    private Property m_consecProp;
    private Property m_missoverProp;
    private Property m_multiRecsProp;
    private Property m_numberObsProp;
    private TextStore m_infileDelimiterText;
    private Property m_infileOverrideProp;
    private TextStore m_infileOverrideText;
    private Property m_infileEncodingProp;
    private TextStore m_infileEncodingText;
    private Property m_infileOptionsProp;
    private TextStore m_infileOptionsText;
    private TextStore m_specMissText;
    private TextStore m_numMissText;
    private boolean m_isStorePopulated;
    private Property m_pipeProperty;
    private Property m_viewProperty;
    private Property m_startProperty;
    private Property m_missingNumericProp;
    private Property m_missingSpecialProp;
    private Property m_isDirectoryProp;
    private boolean m_bIsDirectory;
    private boolean m_new_table;
    private List m_columnList;
    private int m_logicalRecordLength = 0;
    private Property m_lreclProp;
    private boolean m_pfdPopulatedStore;
    private AccessMethodUtil m_accessMethod = new AccessMethodUtil();
    private boolean m_caseSensitiveColumnNames;
    private boolean m_specialCharactersInColumnNames;
    private Property m_caseSensitiveColumnNamesProperty;
    private Property m_specialCharactersInColumnNamesProperty;
    private ExternalFormatFileUtil m_formatFileUtil = new ExternalFormatFileUtil();
    private File m_externalFormatFile;
    private ClassifierMap m_formatFileClassifierMap;
    private ClassifierMap m_userWrittenSourceCodeCM;
    private Text m_userWrittenText;
    private boolean m_headerLineOutputFile;
    private boolean m_numericMissing;
    private List m_missingValuesList;
    private boolean m_userWritten;
    private String m_fileOptions;
    private Property m_noQuotesEnabledProperty;
    private Property m_doubleQuotesEnabledProperty;
    private String m_logicalFilename;
    private boolean m_overlapColumns;
    private Property m_overlapProperty;
    private String m_preInfileStatement;
    private boolean m_preInfile;
    private Property m_preInfileProperty;
    private TextStore m_preInfileText;
    private String m_preAttribInputStatement;
    private boolean m_preAttribInput;
    private Property m_preAttribInputProperty;
    private TextStore m_preAttribInputText;
    private String m_attribInputStatement;
    private boolean m_attribInput;
    private Property m_attribInputProperty;
    private TextStore m_attribInputText;
    private String m_postAttribInputStatement;
    private boolean m_postAttribInput;
    private Property m_postAttribInputProperty;
    private TextStore m_postAttribInputText;
    private String m_overrideDelimiterVal;
    private boolean m_overrideDelimiter;
    private Property m_overrideDelimiterProp;
    private int m_iEFIType = 0;
    public static final int EFI_TYPE_NOTSET = 0;
    public static final int EFI_TYPE_DELIMITED = 1;
    public static final int EFI_TYPE_FIXEDWIDTH = 2;
    public static final int EFI_TYPE_USERWRITTEN = 3;
    private WsAppServer m_appServer;

    public void setFtpAccessMethod(boolean access) throws MdException, RemoteException {
        this.m_ftp_access = access;
        if (access) {
            this.setHadoopAccessMethod(false);
            this.setPipeAccessMethod(false);
            this.setHttpAccessMethod(false);
            this.setDefaultAccessMethod(false);
        } else {
            this.setFtpServer(null);
        }
    }

    public void setPipeAccessMethod(boolean access) throws MdException, RemoteException {
        this.m_pipe_access = access;
        if (access) {
            this.setHadoopAccessMethod(false);
            this.setHttpAccessMethod(false);
            this.setFtpAccessMethod(false);
            this.setDefaultAccessMethod(false);
        }
        this.setPipeProperty(access);
    }

    public void setHttpAccessMethod(boolean access) throws MdException, RemoteException {
        this.m_http_access = access;
        if (access) {
            this.setHadoopAccessMethod(false);
            this.setFtpAccessMethod(false);
            this.setPipeAccessMethod(false);
            this.setDefaultAccessMethod(false);
        } else {
            this.setHttpServer(null);
        }
        if (access) {
            this.setDoubleQuotesEnabled(false);
            this.setNoQuotesEnabled(false);
        }
    }

    public void setHadoopAccessMethod(boolean access) throws MdException, RemoteException {
        this.m_hadoop_access = access;
        if (access) {
            this.setHttpAccessMethod(false);
            this.setFtpAccessMethod(false);
            this.setPipeAccessMethod(false);
            this.setDefaultAccessMethod(false);
        } else {
            this.setHadoopServer(null);
        }
        if (access) {
            this.setDoubleQuotesEnabled(false);
            this.setNoQuotesEnabled(false);
        }
    }

    private void setPipeProperty(boolean pipeAccess) throws MdException, RemoteException {
        Property prop = this.getPipeProperty();
        if (pipeAccess) {
            if (prop == null) {
                this.m_pipeProperty = this.buildPropertyHandler(NAMEDPIPE, null, null);
            }
        } else if (prop != null) {
            this.deleteObject((CMetadata)prop);
        }
    }

    private Property getPipeProperty() {
        return this.m_pipeProperty;
    }

    public void setDefaultAccessMethod(boolean access) throws MdException, RemoteException {
        this.m_default_access = access;
        if (access) {
            this.setFtpAccessMethod(false);
            this.setHttpAccessMethod(false);
            this.setPipeAccessMethod(false);
            this.setHadoopAccessMethod(false);
        }
    }

    public boolean isDefaultAccessMethod() {
        return this.m_default_access;
    }

    public void setHttpServer(DeployedComponent server) throws MdException, RemoteException {
        DeployedComponent dc = this.getHttpServer();
        if (dc == server) {
            return;
        }
        if (dc != null) {
            this.removeFileDCAssociation(dc);
        }
        if (server != null) {
            this.addFileDCAssociation(server);
        }
        this.m_http_server = server;
        this.m_accessMethod.populateHTTPServer((ServerComponent)server, this.isPasswordEncoded());
    }

    public AccessMethodUtil getAccessMethodUtil() {
        return this.m_accessMethod;
    }

    public void setHadoopServer(DeployedComponent server) throws MdException, RemoteException {
        DeployedComponent dc = this.getHadoopServer();
        if (dc == server) {
            return;
        }
        if (dc != null) {
            this.removeFileDCAssociation(dc);
        }
        if (server != null) {
            this.addFileDCAssociation(server);
        }
        this.m_hadoop_server = server;
        this.m_accessMethod.populateHadoopServer((ServerComponent)server, this.isPasswordEncoded());
    }

    public void setFtpServer(DeployedComponent server) throws MdException, RemoteException {
        DeployedComponent dc = this.getFtpServer();
        if (dc == server) {
            return;
        }
        if (dc != null) {
            this.removeFileDCAssociation(dc);
        }
        if (server != null) {
            this.addFileDCAssociation(server);
        }
        this.m_ftp_server = server;
        this.m_accessMethod.populateFTPServer((ServerComponent)server, this.isPasswordEncoded());
    }

    private boolean isPasswordEncoded() {
        String encodePassword = Workspace.getWorkspace().getAppDefaultsFile().getPropertyString("Workspace.EncodePasswords");
        boolean encode = false;
        if (encodePassword.trim().equals("true")) {
            encode = true;
        }
        return encode;
    }

    public void setAppServerDC(DeployedComponent server) throws MdException, RemoteException {
        DeployedComponent dc = this.getAppServerDC();
        if (dc == server) {
            return;
        }
        if (dc != null) {
            this.removeDCAssociation(dc);
        }
        if (server != null) {
            this.addDCAssociation(server);
        }
        this.m_appServerDC = server;
    }

    private void addDCAssociation(DeployedComponent server) throws MdException, RemoteException {
        SASFileRef fileref = this.getExternalFileref();
        if (fileref != null) {
            fileref.getDeployedComponents().add((Object)server);
        }
    }

    private void removeDCAssociation(DeployedComponent server) throws MdException, RemoteException {
        if (server == null) {
            return;
        }
        ArrayList<DeployedComponent> keepList = new ArrayList<DeployedComponent>();
        AssociationList alist = this.getExternalFileref().getDeployedComponents();
        int alSize = 0;
        DeployedComponent dc = null;
        if (alist != null) {
            alSize = alist.size();
        }
        for (int i = 0; i < alSize; ++i) {
            dc = (DeployedComponent)alist.get(i);
            if (dc.getFQID().equals(server.getFQID())) continue;
            keepList.add(dc);
        }
        int keepSize = keepList.size();
        if (keepSize == 0) {
            alist.removeAllElements();
        } else if (keepSize != alSize) {
            alist.removeAllElements();
            alist.addAll(keepList);
        }
    }

    private void addFileDCAssociation(DeployedComponent server) throws MdException, RemoteException {
        File file = this.getExternalFile();
        if (file != null) {
            file.getDeployedComponents().add((Object)server);
        }
    }

    private void removeFileDCAssociation(DeployedComponent server) throws MdException, RemoteException {
        if (server == null) {
            return;
        }
        ArrayList<DeployedComponent> keepList = new ArrayList<DeployedComponent>();
        AssociationList alist = this.getExternalFile().getDeployedComponents();
        int alSize = 0;
        DeployedComponent dc = null;
        if (alist != null) {
            alSize = alist.size();
        }
        for (int i = 0; i < alSize; ++i) {
            dc = (DeployedComponent)alist.get(i);
            if (server.getFQID().equals(dc.getFQID())) continue;
            keepList.add(dc);
        }
        int keepSize = keepList.size();
        if (keepSize == 0) {
            alist.removeAllElements();
        } else if (keepSize != alSize) {
            alist.removeAllElements();
            alist.addAll(keepList);
        }
    }

    public DeployedComponent getHadoopServer() {
        return this.m_hadoop_server;
    }

    public DeployedComponent getHttpServer() {
        return this.m_http_server;
    }

    public DeployedComponent getFtpServer() {
        return this.m_ftp_server;
    }

    public boolean isFtpAccessMethod() {
        return this.m_ftp_access;
    }

    public boolean isHttpAccessMethod() {
        return this.m_http_access;
    }

    public boolean isHadoopAccessMethod() {
        return this.m_hadoop_access;
    }

    public String getAccessMethodNickName() {
        if (this.isFtpAccessMethod()) {
            return WsAppServer.FILE_ACCESS_METHOD_FTP;
        }
        if (this.isHttpAccessMethod()) {
            return WsAppServer.FILE_ACCESS_METHOD_URL;
        }
        if (this.isHadoopAccessMethod()) {
            return WsAppServer.FILE_ACCESS_METHOD_HADOOP;
        }
        return WsAppServer.FILE_ACCESS_METHOD_DEFAULT;
    }

    public String getAccessMethodOptions(String fileRef) {
        if (this.isFtpAccessMethod()) {
            return this.getFTPOptions(false);
        }
        if (this.isHttpAccessMethod()) {
            return this.getHttpOptions();
        }
        if (this.isHadoopAccessMethod() && this.getHadoopServer() != null) {
            return this.getHadoopOptions(false, fileRef);
        }
        return "";
    }

    public String getAccessMethodPreCode(String fileRef) throws RemoteException, MdException {
        return null;
    }

    public String getAccessMethodFileName(String name) {
        if (this.isHttpAccessMethod()) {
            return this.getHttpFilePath(name);
        }
        return name;
    }

    public boolean doesFileExist(String fileName) throws WsAppServerFailException, GenericError, RemoteException, MdException {
        WsAppServer appServer = this.getAppServer();
        if (appServer == null) {
            return false;
        }
        return appServer.doesFileExist(this.getAccessMethodFileName(fileName), this.getAccessMethodNickName(), this.getAccessMethodOptions("_temp"), this.getAccessMethodPreCode("_temp"));
    }

    public boolean isPipeAccessMethod() {
        return this.m_pipe_access;
    }

    public void setInfileEncoding(String encodingText) throws MdException, RemoteException {
        this.m_infile_encoding = encodingText.length() != 0;
        this.m_infile_encoding_text = encodingText;
        Property prop = this.getInfileEncodingProperty();
        TextStore text = this.getInfileEncodingTextStore();
        if (!this.m_infile_encoding) {
            this.deleteObject((CMetadata)text);
            this.deleteObject((CMetadata)prop);
            this.setInfileEncodingProperty(null);
            this.m_infileEncodingText = null;
        } else if (prop != null && text != null) {
            if (text.getStoredText() != encodingText) {
                text.setStoredText(encodingText);
            }
        } else {
            prop = this.buildPropertyHandler(INFILEENCODING, this.getGeneralPropSet(), null);
            this.setInfileEncodingProperty(prop);
            this.setInfileEncodingText(encodingText, prop);
        }
    }

    public boolean isInfileEncoding() {
        return this.m_infile_encoding;
    }

    private void setInfileEncodingText(String text, Property property) throws MdException, RemoteException {
        TextStore textSt = this.getInfileEncodingTextStore();
        if (textSt == null) {
            this.setInfileEncodingTextStore(text, property);
        } else {
            textSt.setStoredText(text);
        }
        this.m_infile_encoding_text = text;
    }

    private void setInfileEncodingProperty(Property prop) {
        this.m_infileEncodingProp = prop;
    }

    private Property getInfileEncodingProperty() {
        return this.m_infileEncodingProp;
    }

    private void setInfileEncodingTextStore(String text, Property property) throws MdException, RemoteException {
        this.m_infileEncodingText = this.buildPropertyText(INFILEENCODING, text, property);
    }

    private TextStore getInfileEncodingTextStore() {
        return this.m_infileEncodingText;
    }

    public String getInfileEncodingText() {
        return this.m_infile_encoding_text;
    }

    public String getInfileEncodingTextQuoted() {
        if (this.getInfileEncodingText().length() == 0) {
            return this.m_infile_encoding_text;
        }
        String doubleQuote = "\"";
        String singleQuote = "'";
        String encodingVal = this.getInfileEncodingText();
        if (!this.getInfileEncodingText().startsWith(doubleQuote) && !this.getInfileEncodingText().startsWith(singleQuote)) {
            encodingVal = "\"" + this.getInfileEncodingText() + "\"";
        }
        return encodingVal;
    }

    public void setInfileOptions(String infileOptions) throws MdException, RemoteException {
        this.m_infile_options_text = infileOptions;
        this.m_infile_options = infileOptions.length() != 0;
        Property prop = this.getInfileOptionsProperty();
        TextStore text = this.getInfileOptionsTextStore();
        if (!this.m_infile_options) {
            this.deleteObject((CMetadata)text);
            this.deleteObject((CMetadata)prop);
            this.setInfileOptionsProperty(null);
            this.setInfileOptionsTextStore(null, null);
        } else if (prop != null && text != null) {
            if (text.getStoredText() != infileOptions) {
                text.setStoredText(infileOptions);
            }
        } else {
            prop = this.buildPropertyHandler(INFILEOPTIONS, this.getGeneralPropSet(), null);
            this.setInfileOptionsProperty(prop);
            this.setInfileOptionsText(infileOptions, prop);
        }
    }

    public boolean hasInfileOptions() {
        return this.m_infile_options;
    }

    private void setInfileOptionsText(String text, Property property) throws MdException, RemoteException {
        TextStore textSt = this.getInfileOptionsTextStore();
        if (textSt == null) {
            this.setInfileOptionsTextStore(text, property);
        } else {
            textSt.setStoredText(text);
        }
        this.m_infile_options_text = text;
    }

    public String getInfileOptionsText() {
        return this.m_infile_options_text;
    }

    private void setInfileOptionsProperty(Property prop) {
        this.m_infileOptionsProp = prop;
    }

    private Property getInfileOptionsProperty() {
        return this.m_infileOptionsProp;
    }

    private void setInfileOptionsTextStore(String text, Property property) throws MdException, RemoteException {
        this.m_infileOptionsText = text == null ? null : this.buildPropertyText(INFILEOPTIONS, text, property);
    }

    private TextStore getInfileOptionsTextStore() {
        return this.m_infileOptionsText;
    }

    public void setInfileOverride(boolean override, String overrideText) throws MdException, RemoteException {
        this.m_infile_override = override;
        Property prop = this.getInfileOverrideProperty();
        TextStore text = this.getInfileOverrideTextStore();
        if (!this.m_infile_override) {
            if (overrideText.length() == 0) {
                this.deleteObject((CMetadata)text);
                this.deleteObject((CMetadata)prop);
                this.setInfileOverrideProperty(null);
                this.m_infileOverrideText = null;
            } else if (prop != null) {
                prop.setDefaultValue(NO);
            }
        } else {
            if (prop != null && text != null) {
                if (text.getStoredText() != overrideText) {
                    text.setStoredText(overrideText);
                }
            } else {
                prop = this.buildPropertyHandler(INFILEOVERRIDE, this.getGeneralPropSet(), null);
                this.setInfileOverrideProperty(prop);
                this.setInfileOverrideText(overrideText, prop);
            }
            this.m_infile_override_text = overrideText;
            prop.setDefaultValue(YES);
        }
    }

    private void setInfileOverrideProperty(Property prop) {
        this.m_infileOverrideProp = prop;
    }

    private Property getInfileOverrideProperty() {
        return this.m_infileOverrideProp;
    }

    public boolean isInfileOverriden() {
        return this.m_infile_override;
    }

    public boolean isDoubleQuotesEnabled() {
        return this.m_doubleQuotesEnabled;
    }

    public void setDoubleQuotesEnabled(boolean enabled) throws MdException, RemoteException {
        this.m_doubleQuotesEnabled = enabled;
        this.setDoubleQuoteProperty(this.m_doubleQuotesEnabled);
    }

    private void setDoubleQuoteProperty(boolean dquote) throws MdException, RemoteException {
        Property doubleProp = this.getDoubleQuoteProperty();
        if (dquote) {
            if (doubleProp == null) {
                doubleProp = this.buildPropertyHandler(DOUBLEQUOTE, this.getGeneralPropSet(), null);
                this.setDoubleQuoteProp(doubleProp);
            }
        } else if (doubleProp != null) {
            this.deleteObject((CMetadata)doubleProp);
            this.setDoubleQuoteProp(null);
        }
    }

    private Property getDoubleQuoteProperty() {
        return this.m_doubleQuotesEnabledProperty;
    }

    private void setDoubleQuoteProp(Property doubleProp) {
        this.m_doubleQuotesEnabledProperty = doubleProp;
    }

    private void setInfileOverrideText(String textString, Property property) throws MdException, RemoteException {
        TextStore textSt = this.getInfileOverrideTextStore();
        if (textSt == null) {
            this.setInfileOverrideTextStore(textString, property);
        } else {
            textSt.setStoredText(textString);
        }
        this.m_infile_override_text = textString;
    }

    public String getInfileOverrideText() {
        return this.m_infile_override_text;
    }

    private void setInfileOverrideTextStore(String text, Property property) throws MdException, RemoteException {
        this.m_infileOverrideText = this.buildPropertyText(INFILEOVERRIDE, text, property);
    }

    private TextStore getInfileOverrideTextStore() {
        return this.m_infileOverrideText;
    }

    public void setFileName(String file) {
        File eFile = this.getExternalFile();
        if (eFile != null) {
            try {
                eFile.setFileName(file);
                eFile.setName(file);
                this.getExternalFileref().setName(file);
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException(ex);
            }
        }
        this.m_filename = file;
    }

    public void setLogicalFilename(String file) {
        this.m_logicalFilename = file;
        try {
            if (this.isNoQuotesEnabled()) {
                this.getNoQuotesEnabledProperty().setDefaultValue(this.m_logicalFilename);
            } else if (this.isDoubleQuotesEnabled()) {
                this.getDoubleQuoteProperty().setDefaultValue(this.m_logicalFilename);
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
    }

    public String getLogicalFilename() {
        if (this.m_logicalFilename != null && this.m_logicalFilename.trim() != "") {
            return this.m_logicalFilename;
        }
        return this.m_filename;
    }

    private void setStructurePropSet(PropertySet ps) {
        this.m_efiStructurePS = ps;
    }

    private PropertySet getStructurePropSet() {
        return this.m_efiStructurePS;
    }

    private void setGeneralPropSet(PropertySet ps) {
        this.m_efiGeneralPS = ps;
    }

    private PropertySet getGeneralPropSet() {
        return this.m_efiGeneralPS;
    }

    public String getFilename() {
        return this.m_filename;
    }

    private File buildExternalFile() throws MdException, RemoteException {
        this.m_newFile = (File)Workspace.getMdFactory().createComplexMetadataObject(this.m_store, this.m_filename, "File", this.m_fqid);
        this.m_newFile.setName(this.m_filename);
        this.m_newFile.setAssociatedExternalTable(this.getExternalTable());
        AssociationList filerefs = this.m_newFile.getFileRefs();
        if (this.getExternalFileref() != null) {
            filerefs.add((Object)this.getExternalFileref());
            this.m_newFile.setFileRefs(filerefs);
        }
        return this.m_newFile;
    }

    public File getExternalFile() {
        return this.m_newFile;
    }

    public ExternalTable getExternalTable() {
        return this.m_newExternalTable;
    }

    public void setCreateNewTable(boolean createNew) {
        this.m_new_table = createNew;
    }

    public boolean isCreateNewTable() {
        return this.m_new_table;
    }

    public void setExternalTable(ExternalTable table, boolean user_Written) throws MdException, RemoteException {
        this.m_newExternalTable = table;
        this.m_store = (MdObjectStore)this.m_newExternalTable.getObjectStore();
        this.m_fqid = this.m_newExternalTable.getRepositoryID();
        this.m_formatFileUtil.setStore(this.m_store);
        this.m_formatFileUtil.setFQID(this.m_fqid);
        this.buildExternalFile();
        this.setUserWritten(user_Written);
    }

    public void setExternalTable(ExternalTable table) throws MdException, RemoteException {
        this.m_newExternalTable = table;
        this.m_store = (MdObjectStore)this.m_newExternalTable.getObjectStore();
        this.m_fqid = this.m_newExternalTable.getRepositoryID();
        this.m_accessMethod.setStore(this.m_store);
        this.m_accessMethod.setFQID(this.m_fqid);
        this.m_formatFileUtil.setStore(this.m_store);
        this.m_formatFileUtil.setFQID(this.m_fqid);
        if (this.isCreateNewTable()) {
            File file = null;
            if (this.getExternalFile() == null) {
                if (this.m_iEFIType != 3) {
                    this.buildExternalFileref();
                }
                file = this.buildExternalFile();
                PropertySet propertySet = this.buildPropertySet(EFI_FILE_STRUCTURE);
                file.getPropertySets().add((Object)propertySet);
                this.setStructurePropSet(propertySet);
                propertySet = this.buildPropertySet(EFI_GENERAL);
                file.getPropertySets().add((Object)propertySet);
                this.setGeneralPropSet(propertySet);
                this.setCreateView(true);
            }
        }
    }

    private void buildExternalFileref() {
        try {
            this.m_newFileRef = (SASFileRef)Workspace.getMdFactory().createComplexMetadataObject(this.m_store, this.m_filename, "SASFileRef", this.m_fqid);
            this.m_newFileRef.setName(this.getFilename());
            this.m_newFileRef.setFileref(ETLFILEREF);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
    }

    private SASFileRef getExternalFileref() {
        return this.m_newFileRef;
    }

    private Property buildPropertyHandler(String propName, PropertySet propertyset, Property property) throws MdException, RemoteException {
        Property newProperty = null;
        newProperty = (Property)Workspace.getMdFactory().createComplexMetadataObject(this.m_store, propName, "Property", this.m_fqid);
        newProperty.setName(propName);
        PropertyType l_propertyType = this.buildPropertyType(propName);
        newProperty.setOwningType(l_propertyType);
        if (propertyset != null) {
            newProperty.getAssociatedPropertySets().add((Object)propertyset);
        }
        if (property != null) {
            property.getProperties().add((Object)newProperty);
        }
        return newProperty;
    }

    public void setPFDpopulatedStore(boolean pop) {
        this.m_pfdPopulatedStore = pop;
    }

    private boolean isStorePopulatedPFD() {
        return this.m_pfdPopulatedStore;
    }

    public void populateStore() throws MdException, RemoteException {
        AssociationList fileServerList;
        SASFileRef newFileRef;
        if (this.m_isStorePopulated) {
            return;
        }
        this.m_newExternalTable = this.getExternalTable();
        if (!this.isStorePopulatedPFD()) {
            StringBuffer template = new StringBuffer();
            template.append("<Templates>");
            template.append("   <ExternalTable>");
            template.append("         <OwningFile/>");
            template.append("         <Columns/>");
            template.append("         <Properties/>");
            template.append("         <TargetTransformations/>");
            template.append("  </ExternalTable>");
            template.append("  <File Name=\"\">");
            template.append("     <FileRefs/>");
            template.append("     <PropertySets/>");
            template.append("     <DeployedComponents/>");
            template.append("  </File>");
            template.append("  <SASFileRef Name=\"\">");
            template.append("     <DeployedComponents Name=\"\"/>");
            template.append("     </SASFileRef>");
            template.append("     <PropertySet Name=\"\">");
            template.append("      <SetProperties/>");
            template.append("     </PropertySet>");
            template.append("  <Property Name=\"\">");
            template.append("    <Notes/>");
            template.append("    <OwningType/>");
            template.append("    <Properties/>");
            template.append("   </Property>");
            template.append("  <TextStore Name=\"\"/>");
            template.append("   <Column Name=\"\">");
            template.append("   <SourceFeatureMaps/>");
            template.append("   </Column>");
            template.append("   <DeployedComponent Name=\"\">");
            template.append("     <ServerContext Name=\"\"/>");
            template.append("     </DeployedComponent>");
            template.append("   <FeatureMap Name=\"\"/>");
            template.append("   </Templates>");
            Vector complex = new Vector(10);
            String templateS = template.toString();
            this.m_newExternalTable = (ExternalTable)Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)this.m_newExternalTable, null, complex, templateS, 13, true);
        }
        if (EFIDataModel.isLegacyEFIObject(this.getExternalTable())) {
            this.m_isStorePopulated = true;
            return;
        }
        this.m_columnList = this.m_newExternalTable.getColumns();
        File newFile = this.m_newExternalTable.getOwningFile();
        if (newFile == null) {
            throw new MdException(bundle.getString("EFIDataModel.PopulateStore.MDIncomplete.txt"));
        }
        this.m_newFile = newFile;
        AssociationList filerefs = newFile.getFileRefs();
        if (filerefs.size() == 0) {
            this.setUserWritten(true);
            this.populateStoreUserWritten();
            return;
        }
        AssociationList transList = this.m_newExternalTable.getTargetTransformations();
        if (!transList.isEmpty()) {
            for (int i = 0; i < transList.size(); ++i) {
                AssociationList list;
                CMetadata cmd = (CMetadata)transList.get(i);
                if (!cmd.getCMetadataType().equals("ClassifierMap")) continue;
                ClassifierMap cm = (ClassifierMap)transList.get(i);
                String role = cm.getTransformRole();
                if (role.equals(FORMATFILE)) {
                    CMetadata lmd;
                    this.m_formatFileClassifierMap = cm;
                    list = cm.getSourceTransformations();
                    if (list.isEmpty() || !(lmd = (CMetadata)list.get(0)).getCMetadataType().equals("File")) continue;
                    this.m_externalFormatFile = (File)list.get(0);
                    continue;
                }
                if (!role.equals(USERWRITTENSOURCECODE)) continue;
                this.m_userWrittenSourceCodeCM = cm;
                list = this.m_userWrittenSourceCodeCM.getSourceTransformations();
                if (list.isEmpty()) continue;
                this.m_userWrittenText = (Text)list.get(0);
            }
        }
        this.m_newFileRef = newFileRef = (SASFileRef)filerefs.get(0);
        this.m_filename = newFile.getFileName();
        AssociationList serverList = this.m_newFileRef.getDeployedComponents();
        if (!serverList.isEmpty()) {
            for (int i = 0; i < serverList.size(); ++i) {
                ServerComponent sc = (ServerComponent)serverList.get(i);
                if (!sc.getProductName().equals(SAS)) continue;
                this.m_appServerDC = sc;
            }
        }
        if (!(fileServerList = this.m_newFile.getDeployedComponents()).isEmpty()) {
            for (int i = 0; i < fileServerList.size(); ++i) {
                ServerComponent sc = (ServerComponent)fileServerList.get(i);
                if (sc.getProductName().equals(FTPSERVER)) {
                    this.m_ftp_server = sc;
                    this.m_ftp_access = true;
                    this.m_accessMethod.populateFTPServer(sc, this.isPasswordEncoded());
                    continue;
                }
                if (sc.getProductName().equals(HTTPSERVER)) {
                    this.m_http_server = sc;
                    this.m_http_access = true;
                    this.m_accessMethod.populateHTTPServer(sc, this.isPasswordEncoded());
                    continue;
                }
                if (!sc.getProductName().equals("HADOOP")) continue;
                this.m_hadoop_server = sc;
                this.m_hadoop_access = true;
                this.m_accessMethod.populateHadoopServer(sc, this.isPasswordEncoded());
            }
        }
        this.m_default_access = !this.m_http_access & !this.m_ftp_access & !this.m_hadoop_access;
        AssociationList ps = this.m_newFile.getPropertySets();
        int propertySetsSize = ps.size();
        if (propertySetsSize == 0) {
            throw new MdException(bundle.getString("EFIDataModel.PopulateStore.MDIncomplete.txt"));
        }
        for (int i = 0; i < propertySetsSize; ++i) {
            Property jprop;
            int j;
            int numProps;
            PropertySet PS = (PropertySet)ps.get(i);
            if (PS.getName().equals(EFI_FILE_STRUCTURE)) {
                this.setStructurePropSet(PS);
                AssociationList structProps = this.m_efiStructurePS.getSetProperties();
                numProps = 0;
                numProps = structProps.size();
                for (j = 0; j < numProps; ++j) {
                    jprop = (Property)structProps.get(j);
                    if (jprop.getName().equals(FIXEDWIDTH)) {
                        this.m_fixed_width = true;
                        this.m_fixedWidthProp = jprop;
                        AssociationList fixedprops = this.m_fixedWidthProp.getProperties();
                        int numfprops = fixedprops.size();
                        for (int k = 0; k < numfprops; ++k) {
                            Property fp = (Property)fixedprops.get(k);
                            String defaultValue = "";
                            defaultValue = fp.getDefaultValue();
                            if (fp.getName().equals(TRUNCOVER) && !defaultValue.equalsIgnoreCase("false")) {
                                this.m_truncover = true;
                                this.m_truncoverProp = fp;
                                continue;
                            }
                            if (fp.getName().equals(PAD) && !defaultValue.equalsIgnoreCase("false")) {
                                this.m_pad = true;
                                this.m_padProp = fp;
                                continue;
                            }
                            if (!fp.getName().equals(OVERLAP) || defaultValue.equalsIgnoreCase("false")) continue;
                            this.m_overlapColumns = true;
                            this.m_overlapProperty = fp;
                        }
                        this.m_fixed_width = true;
                    }
                    if (!jprop.getName().equals(DELIMITER)) continue;
                    this.m_delimiterProp = jprop;
                    this.m_delimited = true;
                    TextStore delimiterText = null;
                    AssociationList textList = this.m_delimiterProp.getNotes();
                    if (textList.size() > 0) {
                        delimiterText = (TextStore)textList.get(0);
                        this.m_delimiterValue = delimiterText.getStoredText();
                        if (this.m_delimiterValue.length() == 0) {
                            this.m_delimiterValue = BLANK;
                        }
                        this.setDelimitedValueText(delimiterText);
                    } else {
                        this.m_delimiterValue = BLANK;
                    }
                    AssociationList delimprops = this.m_delimiterProp.getProperties();
                    int numdprops = delimprops.size();
                    for (int m = 0; m < numdprops; ++m) {
                        Property dp = (Property)delimprops.get(m);
                        String defaultValue = "";
                        defaultValue = dp.getDefaultValue();
                        if (dp.getName().equals(CONSECUTIVEDELIMITERS) && !defaultValue.equalsIgnoreCase("false")) {
                            this.m_consecutiveDelimiters = true;
                            this.m_consecProp = dp;
                            continue;
                        }
                        if (dp.getName().equals(MISSOVER) && !defaultValue.equalsIgnoreCase("false")) {
                            this.m_missover = true;
                            this.m_missoverProp = dp;
                            continue;
                        }
                        if (dp.getName().equals(MULTIRECORDSPERLINE) && !defaultValue.equalsIgnoreCase("false")) {
                            this.m_delimMultiRecPerLine = true;
                            this.m_multiRecsProp = dp;
                            continue;
                        }
                        if (!dp.getName().equals(OVERRIDEDELIMITER) || defaultValue.length() <= 0) continue;
                        this.m_overrideDelimiter = true;
                        this.m_overrideDelimiterVal = dp.getDefaultValue();
                        this.m_overrideDelimiterProp = dp;
                    }
                }
            }
            if (!PS.getName().equals(EFI_GENERAL)) continue;
            this.setGeneralPropSet(PS);
            AssociationList genProps = this.m_efiGeneralPS.getSetProperties();
            numProps = 0;
            numProps = genProps.size();
            for (j = 0; j < numProps; ++j) {
                TextStore l_optionsText;
                AssociationList l_optionsList;
                TextStore l_missingText;
                AssociationList l_missingList;
                jprop = (Property)genProps.get(j);
                String propName = jprop.getName();
                String defaultValue = jprop.getDefaultValue();
                if (propName.equals(CREATEVIEW) && !defaultValue.equalsIgnoreCase("false")) {
                    this.m_viewProperty = jprop;
                    this.m_createView = true;
                    continue;
                }
                if (propName.equals(STARTRECORD) && defaultValue.length() > 0) {
                    this.m_startProperty = jprop;
                    String l_startRecord = defaultValue;
                    this.m_startRecord = Integer.parseInt(l_startRecord);
                    continue;
                }
                if (READIRECTORY.equals(propName)) {
                    this.m_isDirectoryProp = jprop;
                    this.m_bIsDirectory = true;
                    continue;
                }
                if (propName.equals(OBS) && defaultValue.length() > 0) {
                    this.m_numberObsProp = jprop;
                    String l_numberObservations = defaultValue;
                    if (l_numberObservations.length() <= 0) continue;
                    this.m_numberObservations = Integer.parseInt(l_numberObservations);
                    continue;
                }
                if (propName.equals(MISSINGVALUES_SPECIAL)) {
                    this.m_missingSpecialProp = jprop;
                    l_missingList = jprop.getNotes();
                    if (l_missingList.isEmpty()) continue;
                    this.m_specMissText = l_missingText = (TextStore)l_missingList.get(0);
                    this.m_missingSpecial = l_missingText.getStoredText();
                    continue;
                }
                if (propName.equals(MISSINGVALUES_NUMBERS)) {
                    this.m_missingNumericProp = jprop;
                    l_missingList = jprop.getNotes();
                    if (l_missingList.isEmpty()) continue;
                    this.m_numMissText = l_missingText = (TextStore)l_missingList.get(0);
                    this.m_missingNumeric = l_missingText.getStoredText();
                    if (this.m_missingNumeric.length() <= 0) continue;
                    this.m_numericMissing = true;
                    this.m_missingValuesList = this.createMissingListFromString(this.m_missingNumeric);
                    continue;
                }
                if (propName.equals(LRECL) && defaultValue.length() > 0) {
                    this.m_lreclProp = jprop;
                    String lreclS = defaultValue;
                    this.m_logicalRecordLength = Integer.parseInt(lreclS);
                    continue;
                }
                if (propName.equals(INFILEENCODING)) {
                    TextStore l_encodeText;
                    this.m_infileEncodingProp = jprop;
                    AssociationList l_encodingList = jprop.getNotes();
                    if (l_encodingList.isEmpty()) continue;
                    this.m_infileEncodingText = l_encodeText = (TextStore)l_encodingList.get(0);
                    this.m_infile_encoding_text = l_encodeText.getStoredText();
                    if (this.m_infile_encoding_text.length() <= 0) continue;
                    this.m_infile_encoding = true;
                    continue;
                }
                if (propName.equals(INFILEOPTIONS)) {
                    this.m_infileOptionsProp = jprop;
                    l_optionsList = jprop.getNotes();
                    if (l_optionsList.isEmpty()) continue;
                    this.m_infileOptionsText = l_optionsText = (TextStore)l_optionsList.get(0);
                    this.m_infile_options_text = l_optionsText.getStoredText();
                    if (this.m_infile_options_text.length() <= 0) continue;
                    this.m_infile_options = true;
                    continue;
                }
                if (propName.equals(INFILEOVERRIDE)) {
                    this.m_infileOverrideProp = jprop;
                    l_optionsList = jprop.getNotes();
                    if (l_optionsList.isEmpty()) continue;
                    this.m_infileOverrideText = l_optionsText = (TextStore)l_optionsList.get(0);
                    this.m_infile_override_text = l_optionsText.getStoredText();
                    this.m_infile_override = defaultValue.equals(YES) || defaultValue.equalsIgnoreCase("true");
                    continue;
                }
                if (propName.equals(CASESENSITIVECOLUMNS) && !defaultValue.equalsIgnoreCase("false")) {
                    this.m_caseSensitiveColumnNames = true;
                    this.m_caseSensitiveColumnNamesProperty = jprop;
                    continue;
                }
                if (propName.equals(SPECIALCHARACTERSINCOLUMNS) && !defaultValue.equalsIgnoreCase("false")) {
                    this.m_specialCharactersInColumnNamesProperty = jprop;
                    this.m_specialCharactersInColumnNames = true;
                    continue;
                }
                if (propName.equals(DOUBLEQUOTE)) {
                    this.m_doubleQuotesEnabledProperty = jprop;
                    this.m_doubleQuotesEnabled = true;
                    this.m_logicalFilename = this.m_doubleQuotesEnabledProperty.getDefaultValue();
                    continue;
                }
                if (propName.equals(NOQUOTE)) {
                    this.m_noQuotesEnabledProperty = jprop;
                    this.m_noQuotesEnabled = true;
                    this.m_logicalFilename = this.m_noQuotesEnabledProperty.getDefaultValue();
                    continue;
                }
                if (propName.equals(PREINFILE)) {
                    this.m_preInfileProperty = jprop;
                    l_optionsList = jprop.getNotes();
                    this.m_preInfileText = l_optionsText = (TextStore)l_optionsList.get(0);
                    this.m_preInfileStatement = l_optionsText.getStoredText();
                    this.m_preInfile = jprop.getDefaultValue().equals(YES);
                    continue;
                }
                if (propName.equals(PREATTRIBINPUTSTATEMENT)) {
                    this.m_preAttribInputProperty = jprop;
                    l_optionsList = jprop.getNotes();
                    this.m_preAttribInputText = l_optionsText = (TextStore)l_optionsList.get(0);
                    this.m_preAttribInputStatement = l_optionsText.getStoredText();
                    this.m_preAttribInput = jprop.getDefaultValue().equals(YES);
                    continue;
                }
                if (!propName.equals(POSTATTRIBINPUTSTATEMENT)) continue;
                this.m_postAttribInputProperty = jprop;
                l_optionsList = jprop.getNotes();
                this.m_postAttribInputText = l_optionsText = (TextStore)l_optionsList.get(0);
                this.m_postAttribInputStatement = l_optionsText.getStoredText();
                this.m_postAttribInput = jprop.getDefaultValue().equals(YES);
            }
        }
        if (!this.isStorePopulatedPFD()) {
            this.m_isStorePopulated = true;
        }
    }

    private void populateStoreUserWritten() throws MdException, RemoteException {
        this.m_newExternalTable = this.getExternalTable();
        AssociationList transList = this.m_newExternalTable.getTargetTransformations();
        if (!transList.isEmpty()) {
            for (int i = 0; i < transList.size(); ++i) {
                CMetadata lmd;
                AssociationList list;
                CMetadata cmd = (CMetadata)transList.get(i);
                if (!cmd.getCMetadataType().equals("ClassifierMap")) continue;
                ClassifierMap cm = (ClassifierMap)transList.get(i);
                String role = cm.getTransformRole();
                if (role.equals(USERWRITTENSOURCECODE)) {
                    AssociationList dcList;
                    this.m_userWrittenSourceCodeCM = cm;
                    list = this.m_userWrittenSourceCodeCM.getTransformationSources();
                    Text sourceCode = this.m_userWrittenSourceCodeCM.getSourceCode();
                    if (sourceCode != null) {
                        this.m_userWrittenText = sourceCode;
                    } else if (!list.isEmpty()) {
                        this.m_userWrittenText = (Text)list.get(0);
                    }
                    if (this.m_userWrittenText == null || (dcList = this.m_userWrittenText.getDeployedComponents()).isEmpty()) continue;
                    this.m_appServerDC = (DeployedComponent)dcList.get(0);
                    continue;
                }
                if (!role.equals(FORMATFILE)) continue;
                this.m_formatFileClassifierMap = cm;
                list = cm.getTransformationSources();
                if (list.isEmpty() || !(lmd = (CMetadata)list.get(0)).getCMetadataType().equals("File")) continue;
                this.m_externalFormatFile = (File)list.get(0);
            }
        }
        if (!this.isStorePopulatedPFD()) {
            this.m_isStorePopulated = true;
        }
    }

    private void deleteObjects(List objs) throws MdException, RemoteException {
        if (objs == null) {
            return;
        }
        for (int i = 0; i < objs.size(); ++i) {
            this.deleteObject((CMetadata)((Root)objs.get(i)));
        }
    }

    private void deleteObject(CMetadata object) throws MdException, RemoteException {
        if (object == null) {
            return;
        }
        WAdminResource metabundle = new WAdminResource(MdFactory.class);
        String sRemoveTemplate = metabundle.getRawString("RemoveTemplate." + object.getCMetadataType() + ".notrans.txt");
        if (sRemoveTemplate == null) {
            Workspace.getMdFactory().deleteMetadataObject(object);
        } else {
            Workspace.getMdFactory().deleteMetadataObjects(object, sRemoveTemplate);
        }
    }

    public boolean isUserWritten() {
        return this.m_userWritten;
    }

    public void setUserWritten(boolean userWritten) {
        this.m_userWritten = userWritten;
    }

    public void setFixedWidth(boolean fixed) throws MdException, RemoteException {
        this.m_fixed_width = fixed;
        this.setFixedWidthProperty(this.m_fixed_width);
        this.setFixedPad(true);
    }

    public void setFixedPad(boolean pad) throws MdException, RemoteException {
        this.m_pad = pad;
        this.setPadProperty(this.m_pad);
    }

    public boolean isFixedPad() {
        return this.m_pad;
    }

    public void setFixedTruncover(boolean trunc) throws MdException, RemoteException {
        this.m_truncover = trunc;
        this.setTruncoverProperty(this.m_truncover);
    }

    public boolean isFixedTruncover() {
        return this.m_truncover;
    }

    private void setFixedWidthProperty(boolean fixed) throws MdException, RemoteException {
        Property fixedWidthProp;
        this.m_fixedWidthProp = null;
        this.m_fixedWidthProp = fixedWidthProp = this.getFixedWidthProperty();
        if (fixed) {
            if (fixedWidthProp == null) {
                this.m_fixedWidthProp = this.buildPropertyHandler(FIXEDWIDTH, this.getStructurePropSet(), null);
            }
        } else if (fixedWidthProp != null) {
            this.deleteObject((CMetadata)fixedWidthProp);
            this.m_fixedWidthProp = null;
        }
    }

    private Property getFixedWidthProperty() {
        return this.m_fixedWidthProp;
    }

    private Property setTruncoverProperty(boolean truncover) throws MdException, RemoteException {
        Property l_truncoverProp = this.getTruncoverProp();
        if (truncover) {
            if (l_truncoverProp == null) {
                l_truncoverProp = this.buildPropertyHandler(TRUNCOVER, null, this.getFixedWidthProperty());
                this.setTruncoverProp(l_truncoverProp);
            }
        } else if (l_truncoverProp != null) {
            this.deleteObject((CMetadata)l_truncoverProp);
            this.setTruncoverProp(null);
        }
        return l_truncoverProp;
    }

    private void setTruncoverProp(Property truncProp) {
        this.m_truncoverProp = truncProp;
    }

    private Property getTruncoverProp() {
        return this.m_truncoverProp;
    }

    private void setPadProperty(boolean pad) throws MdException, RemoteException {
        Property padProp = this.getPadProp();
        if (pad) {
            if (padProp == null) {
                padProp = this.buildPropertyHandler(PAD, null, this.getFixedWidthProperty());
                this.setPadProp(padProp);
            }
        } else if (padProp != null) {
            this.deleteObject((CMetadata)padProp);
            this.setPadProp(null);
        }
    }

    private void setPadProp(Property padProp) {
        this.m_padProp = padProp;
    }

    private Property getPadProp() {
        return this.m_padProp;
    }

    public boolean isDelimited() {
        return this.m_delimited;
    }

    public boolean isNoQuotesEnabled() {
        return this.m_noQuotesEnabled;
    }

    public void setNoQuotesEnabled(boolean bool) throws MdException, RemoteException {
        this.m_noQuotesEnabled = bool;
        this.setNoQuotesEnabledProperty(this.m_noQuotesEnabled);
    }

    private void setNoQuotesEnabledProperty(boolean bool) throws MdException, RemoteException {
        Property noQuotesEnabledProp = this.getNoQuotesEnabledProperty();
        if (bool) {
            if (noQuotesEnabledProp == null) {
                noQuotesEnabledProp = this.buildPropertyHandler(NOQUOTE, this.getGeneralPropSet(), null);
                this.setNoQuotesEnabledProp(noQuotesEnabledProp);
            }
        } else if (noQuotesEnabledProp != null) {
            this.deleteObject((CMetadata)noQuotesEnabledProp);
            this.setNoQuotesEnabledProp(null);
        }
    }

    private void setNoQuotesEnabledProp(Property property) {
        this.m_noQuotesEnabledProperty = property;
    }

    private Property getNoQuotesEnabledProperty() {
        return this.m_noQuotesEnabledProperty;
    }

    public boolean isFixedWidth() {
        return this.m_fixed_width;
    }

    public void setEFIType(int type) {
        this.m_iEFIType = type;
    }

    public void setDelimited(boolean delim) throws MdException, RemoteException {
        Property delimprop = this.getDelimitedProperty();
        if (delim) {
            if (delimprop == null) {
                this.m_delimited = delim;
                delimprop = this.buildPropertyHandler(DELIMITER, this.getStructurePropSet(), null);
                this.setDelimitedProperty(delimprop);
            }
            if (this.getDelimiterValue() == null) {
                this.setDelimiterValue(BLANK);
            }
        } else if (delimprop != null) {
            this.deleteObject((CMetadata)delimprop);
            this.deleteObject((CMetadata)this.getDelimitedValueText());
            this.setDelimitedProperty(null);
            this.setDelimitedValueText(null);
        }
    }

    private void setDelimitedProperty(Property prop) {
        this.m_delimiterProp = prop;
    }

    private Property getDelimitedProperty() {
        return this.m_delimiterProp;
    }

    public void setDelimiterValue(String delimVal) throws MdException, RemoteException {
        TextStore delimText = this.getDelimitedValueText();
        if (delimText != null) {
            delimText.setStoredText(delimVal);
        } else {
            delimText = this.buildPropertyText(INFILEDELIMITER, delimVal, this.getDelimitedProperty());
            this.setDelimitedValueText(delimText);
        }
        this.m_delimiterValue = delimVal;
    }

    public String getDelimiterValue() {
        return this.m_delimiterValue;
    }

    private void setDelimitedValueText(TextStore text) {
        this.m_infileDelimiterText = text;
    }

    private TextStore getDelimitedValueText() {
        return this.m_infileDelimiterText;
    }

    public void setConsecDelim(boolean consec) throws MdException, RemoteException {
        this.m_consecutiveDelimiters = consec;
        this.setConsecProperty(consec);
    }

    public boolean isConsecDelim() {
        return this.m_consecutiveDelimiters;
    }

    private void setConsecProperty(boolean consec) throws MdException, RemoteException {
        Property consecProp = this.getConsecutiveProperty();
        if (consec) {
            if (consecProp == null) {
                consecProp = this.buildPropertyHandler(CONSECUTIVEDELIMITERS, null, this.getDelimitedProperty());
                this.setConsecutiveProperty(consecProp);
            }
        } else if (consecProp != null) {
            this.deleteObject((CMetadata)consecProp);
            this.setConsecutiveProperty(null);
        }
    }

    private void setConsecutiveProperty(Property property) {
        this.m_consecProp = property;
    }

    private Property getConsecutiveProperty() {
        return this.m_consecProp;
    }

    public void setMultiPerLine(boolean multi) throws MdException, RemoteException {
        this.m_delimMultiRecPerLine = multi;
        this.setMultProperty(multi);
    }

    public boolean isMultiPerLine() {
        return this.m_delimMultiRecPerLine;
    }

    private void setMultProperty(boolean multi) throws MdException, RemoteException {
        Property multiProp = this.getMultiProperty();
        if (multi) {
            if (multiProp == null) {
                multiProp = this.buildPropertyHandler(MULTIRECORDSPERLINE, null, this.getDelimitedProperty());
                this.setMultiProperty(multiProp);
            }
        } else if (multiProp != null) {
            this.deleteObject((CMetadata)multiProp);
            this.setMultiProperty(null);
        }
    }

    private void setMultiProperty(Property property) {
        this.m_multiRecsProp = property;
    }

    private Property getMultiProperty() {
        return this.m_multiRecsProp;
    }

    public void setMissover(boolean miss) throws MdException, RemoteException {
        this.m_missover = miss;
        this.setMissProperty(miss);
    }

    public boolean isMissover() {
        return this.m_missover;
    }

    private void setMissProperty(boolean miss) throws MdException, RemoteException {
        Property missProp = this.getMissoverProperty();
        if (miss) {
            if (missProp == null) {
                missProp = this.buildPropertyHandler(MISSOVER, null, this.getDelimitedProperty());
                this.setMissoverProperty(missProp);
            }
        } else if (missProp != null) {
            this.deleteObject((CMetadata)missProp);
            this.setMissoverProperty(null);
        }
    }

    private void setMissoverProperty(Property property) {
        this.m_missoverProp = property;
    }

    private Property getMissoverProperty() {
        return this.m_missoverProp;
    }

    private void setIsDirectoryProperty(boolean isDir) throws MdException, RemoteException {
        Property isDirProp = this.getIsDirectoryProperty();
        if (isDir) {
            if (isDirProp == null) {
                isDirProp = this.buildPropertyHandler(READIRECTORY, this.getGeneralPropSet(), null);
                this.setIsDirectoryProperty(isDirProp);
            }
        } else if (isDirProp != null) {
            this.deleteObject((CMetadata)isDirProp);
            this.setIsDirectoryProperty(null);
        }
    }

    private void setIsDirectoryProperty(Property property) {
        this.m_isDirectoryProp = property;
    }

    private Property getIsDirectoryProperty() {
        return this.m_isDirectoryProp;
    }

    public boolean isDirectory() {
        return this.m_bIsDirectory;
    }

    public void setIsDirectory(boolean isDirectory) throws MdException, RemoteException {
        this.m_bIsDirectory = isDirectory;
        this.setIsDirectoryProperty(isDirectory);
    }

    public void setCreateView(boolean create_view) throws MdException, RemoteException {
        this.m_createView = create_view;
        this.setViewProperty(create_view);
    }

    private void setViewProperty(boolean createView) throws MdException, RemoteException {
        Property viewProp = this.getViewProperty();
        if (createView) {
            if (viewProp == null) {
                viewProp = this.buildPropertyHandler(CREATEVIEW, this.getGeneralPropSet(), null);
                this.setViewProp(viewProp);
            }
        } else if (viewProp != null) {
            this.deleteObject((CMetadata)viewProp);
            this.setViewProp(null);
        }
    }

    private Property getViewProperty() {
        return this.m_viewProperty;
    }

    private void setViewProp(Property property) {
        this.m_viewProperty = property;
    }

    public boolean isCreateView() {
        return this.m_createView;
    }

    public void setStartRecord(int start) throws MdException, RemoteException {
        this.m_startRecord = start;
        if (start < 1) {
            this.setStartProperty(false);
        } else {
            Property prop = this.setStartProperty(true);
            String str = BLANK;
            str = String.valueOf(start);
            prop.setDefaultValue(str);
        }
    }

    public int getStartRecord() {
        return this.m_startRecord;
    }

    private Property setStartProperty(boolean start) throws MdException, RemoteException {
        Property startProp = this.getStartProperty();
        if (start) {
            if (startProp == null) {
                startProp = this.buildPropertyHandler(STARTRECORD, this.getGeneralPropSet(), null);
                this.setStartProp(startProp);
            }
        } else if (startProp != null) {
            this.deleteObject((CMetadata)startProp);
            this.setStartProp(null);
        }
        return startProp;
    }

    private Property getStartProperty() {
        return this.m_startProperty;
    }

    private void setStartProp(Property property) {
        this.m_startProperty = property;
    }

    public void setNumberObservations(int numRead) throws MdException, RemoteException {
        this.m_numberObservations = numRead;
        boolean setObs = false;
        if (numRead >= 0) {
            setObs = true;
        }
        Property numObsProp = this.setNumberObsProperty(setObs);
        if (setObs) {
            String str = BLANK;
            str = String.valueOf(this.m_numberObservations);
            numObsProp.setDefaultValue(str);
        }
    }

    private Property setNumberObsProperty(boolean setObs) throws MdException, RemoteException {
        Property numObsProp = this.getNumberObservationsProperty();
        if (setObs) {
            if (numObsProp == null) {
                numObsProp = this.buildPropertyHandler(OBS, this.getGeneralPropSet(), null);
                this.setNumberObservationsProperty(numObsProp);
            }
        } else if (numObsProp != null) {
            this.deleteObject((CMetadata)numObsProp);
            this.setNumberObservationsProperty(null);
        }
        return numObsProp;
    }

    private void setNumberObservationsProperty(Property obsProp) {
        this.m_numberObsProp = obsProp;
    }

    private Property getNumberObservationsProperty() {
        return this.m_numberObsProp;
    }

    public int getNumberObservations() {
        return this.m_numberObservations;
    }

    private void setMissingValuesNumeric(String missing_numeric) throws MdException, RemoteException {
        if (missing_numeric == null) {
            missing_numeric = "";
        }
        this.m_missingNumeric = missing_numeric;
        if (missing_numeric.length() > 0) {
            Property l_prop = this.setMissingValuesNumericProperty(true);
            this.setNumericMissingText(missing_numeric, l_prop);
        } else {
            this.setMissingValuesNumericProperty(false);
        }
    }

    public void setMissingValuesNumericString(String missingString) throws MdException, RemoteException {
        this.setMissingValuesNumericList(this.createMissingListFromString(missingString));
        this.setMissingValuesNumeric(missingString);
    }

    public void setMissingValuesNumericList(List missingList) {
        this.m_missingValuesList = missingList;
    }

    public List createMissingListFromString(String missingString) {
        ArrayList<String> list = new ArrayList<String>();
        String numericText = missingString;
        if (numericText == null) {
            numericText = "";
        }
        String delimiters = String.valueOf(MISSING_VALUE_DELIMITER);
        StringTokenizer tokenizer = new StringTokenizer(numericText, delimiters);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            list.add(token);
        }
        return list;
    }

    public String createMissingStringFromList(List list) {
        String sMissingValues = "";
        for (int index = 0; index < list.size(); ++index) {
            sMissingValues = sMissingValues + (String)list.get(index);
            if (index >= list.size() - 1) continue;
            sMissingValues = sMissingValues + String.valueOf(MISSING_VALUE_DELIMITER);
        }
        return sMissingValues;
    }

    private void setNumericMissingText(String textString, Property property) throws MdException, RemoteException {
        TextStore l_textSt = this.getNumericMissingTextStore();
        if (l_textSt == null) {
            this.setNumericMissingTextStore(textString, property);
        } else {
            l_textSt.setStoredText(textString);
        }
    }

    private TextStore setNumericMissingTextStore(String text, Property property) throws MdException, RemoteException {
        return this.buildPropertyText(NUMMISS, text, property);
    }

    private TextStore getNumericMissingTextStore() {
        return this.m_numMissText;
    }

    private Property setMissingValuesNumericProperty(boolean missNum) throws MdException, RemoteException {
        Property missNumProp = this.getMissingValuesNumericProperty();
        if (missNum) {
            if (missNumProp == null) {
                missNumProp = this.buildPropertyHandler(MISSINGVALUES_NUMBERS, this.getGeneralPropSet(), null);
                this.setMissingValuesNumericProperty(missNumProp);
            }
        } else if (missNumProp != null) {
            this.deleteObject((CMetadata)missNumProp);
            this.setMissingValuesNumericProperty(null);
        }
        return missNumProp;
    }

    private void setMissingValuesNumericProperty(Property mnumProp) {
        this.m_missingNumericProp = mnumProp;
    }

    private Property getMissingValuesNumericProperty() {
        return this.m_missingNumericProp;
    }

    public String getMissingValuesNumeric() {
        return this.m_missingNumeric;
    }

    private String getMissingValuesNumericForOutput() {
        if (this.getMissingValuesNumericList() != null) {
            if (!this.getMissingValuesNumericList().isEmpty()) {
                return (String)this.getMissingValuesNumericList().get(0);
            }
            return "";
        }
        return "";
    }

    public List getMissingValuesNumericList() {
        if (this.m_missingValuesList == null) {
            ArrayList list = new ArrayList();
            return list;
        }
        return this.m_missingValuesList;
    }

    private void setSpecialMissingText(String textString, Property property) throws MdException, RemoteException {
        TextStore textSt = this.getSpecialMissingTextStore();
        if (textSt == null) {
            this.setSpecialMissingTextStore(textString, property);
        } else {
            textSt.setStoredText(textString);
        }
    }

    private void setSpecialMissingTextStore(String text, Property property) throws MdException, RemoteException {
        this.m_specMissText = this.buildPropertyText(SPECMISS, text, property);
    }

    private TextStore getSpecialMissingTextStore() {
        return this.m_specMissText;
    }

    public void setMissingValuesSpecial(String missing_special) throws MdException, RemoteException {
        if (missing_special == null) {
            missing_special = BLANK;
        }
        this.m_missingSpecial = missing_special;
        if (missing_special.length() > 0) {
            Property prop = this.setMissingValuesSpecialProperty(true);
            this.setSpecialMissingText(this.m_missingSpecial, prop);
        } else {
            this.setMissingValuesSpecialProperty(false);
        }
    }

    private Property setMissingValuesSpecialProperty(boolean specialNum) throws MdException, RemoteException {
        Property missSpecialProp = this.getMissingValuesSpecialProperty();
        TextStore missSpecialText = this.getSpecialMissingTextStore();
        if (specialNum) {
            if (missSpecialProp == null) {
                missSpecialProp = this.buildPropertyHandler(MISSINGVALUES_SPECIAL, this.getGeneralPropSet(), null);
                this.setMissingValuesSpecialProperty(missSpecialProp);
            }
        } else {
            if (missSpecialProp != null) {
                this.deleteObject((CMetadata)missSpecialProp);
                this.setMissingValuesSpecialProperty(null);
            }
            if (missSpecialText != null) {
                this.deleteObject((CMetadata)missSpecialText);
            }
        }
        return missSpecialProp;
    }

    private void setMissingValuesSpecialProperty(Property mspecProp) {
        this.m_missingSpecialProp = mspecProp;
    }

    private Property getMissingValuesSpecialProperty() {
        return this.m_missingSpecialProp;
    }

    public String getMissingValuesSpecial() {
        return this.m_missingSpecial;
    }

    private PropertyType buildPropertyType(String propTypeName) {
        PropertyType l_newPropertyType = null;
        try {
            l_newPropertyType = (PropertyType)Workspace.getMdFactory().createComplexMetadataObject(this.m_store, propTypeName, "PropertyType", this.m_fqid);
            l_newPropertyType.setName(propTypeName);
            l_newPropertyType.setSQLType(1);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
        return l_newPropertyType;
    }

    private PropertySet buildPropertySet(String propSetName) {
        PropertySet l_newPropertySet = null;
        try {
            l_newPropertySet = (PropertySet)Workspace.getMdFactory().createComplexMetadataObject(this.m_store, propSetName, "PropertySet", this.m_fqid);
            l_newPropertySet.setName(propSetName);
            l_newPropertySet.setSetRole(propSetName);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
        return l_newPropertySet;
    }

    private TextStore buildPropertyText(String textName, String inputText, Property property) throws MdException, RemoteException {
        this.m_newTextStore = (TextStore)Workspace.getMdFactory().createComplexMetadataObject(this.m_store, textName, "TextStore", this.m_fqid);
        this.m_newTextStore.setName(textName);
        this.m_newTextStore.setStoredText(inputText);
        property.getNotes().add((Object)this.m_newTextStore);
        return this.m_newTextStore;
    }

    public String getInfileStatement() {
        if (this.isInfileOverriden()) {
            return this.getInfileOverrideText();
        }
        return this.getInfileStatementCG();
    }

    public String getFTPOptions() {
        if (this.m_accessMethod == null) {
            return "";
        }
        return this.m_accessMethod.getFTPOptions();
    }

    public String getFTPOptions(boolean includeEngine) {
        if (this.m_accessMethod == null) {
            return "";
        }
        return this.m_accessMethod.getFTPOptions(includeEngine);
    }

    public String getHadoopOptions(boolean includeEngine, String fileref) {
        if (this.m_accessMethod == null) {
            return this.isDirectory() ? " concat" : "";
        }
        DeployedComponent dc = this.getHadoopServer();
        boolean containsConfigurationXML = false;
        String opts = this.m_accessMethod.getHadoopOptions(includeEngine, fileref, containsConfigurationXML);
        if (this.isDirectory()) {
            opts = opts + " concat";
        }
        return opts;
    }

    public String getHttpFilePath(String filename) {
        if (this.m_accessMethod == null) {
            return "";
        }
        return this.m_accessMethod.getHttpFilePath(filename);
    }

    public String getHttpOptions(String filename) {
        if (this.m_accessMethod == null) {
            return "";
        }
        return this.m_accessMethod.getHttpServerOptions(filename);
    }

    public String getHttpOptions() {
        if (this.m_accessMethod == null) {
            return "";
        }
        return this.m_accessMethod.getHttpOptions();
    }

    private String getInfileStatementCG() {
        String indent = "       ";
        StringBuffer infileString = new StringBuffer();
        String quoteValue = "'";
        if (this.isDoubleQuotesEnabled()) {
            quoteValue = "\"";
        }
        if (this.isHttpAccessMethod()) {
            infileString.append("infile ").append(this.getHttpOptions(this.getFilename()));
        } else {
            StringBuffer filename = new StringBuffer();
            if (!this.isNoQuotesEnabled()) {
                filename.append(quoteValue).append(this.getFilename()).append(quoteValue);
            } else {
                filename.append(this.getFilename());
            }
            if (this.isFtpAccessMethod()) {
                infileString.append("infile ").append(filename.toString()).append(this.getFTPOptions());
            } else if (this.isHadoopAccessMethod()) {
                infileString.append("infile ").append(filename.toString()).append(this.getHadoopOptions(true, "_temp"));
            } else {
                infileString.append("infile ").append(filename.toString());
            }
        }
        if (this.getLogicalRecordLength() > 0) {
            infileString.append("\n").append(indent).append("lrecl = ").append(this.getLogicalRecordLength());
        }
        if (this.isDelimited()) {
            if (this.isDelimiterOverridden()) {
                infileString.append("\n").append(indent).append("delimiter = ").append(this.getOverrideDelimiter());
            } else {
                infileString.append("\n").append(indent).append("delimiter = '").append(this.getDelimiterValue()).append("'");
            }
            if (!this.isConsecDelim()) {
                infileString.append("\n").append(indent).append("dsd");
            }
        } else {
            if (this.isFixedPad()) {
                infileString.append("\n").append(indent).append("pad");
            }
            if (this.isFixedTruncover()) {
                infileString.append("\n").append(indent).append("truncover");
            }
        }
        if (this.getStartRecord() > 0) {
            infileString.append("\n").append(indent).append("firstobs = " + this.getStartRecord());
        }
        if (this.getNumberObservations() > 0) {
            int numobs = this.getNumberObservations() + this.getStartRecord() - 1;
            infileString.append("\n").append(indent).append("obs = " + numobs);
        }
        if (this.m_missover) {
            infileString.append("\n").append(indent).append("missover");
        }
        if (this.isInfileEncoding()) {
            infileString.append("\n").append(indent).append("encoding = ").append(this.getInfileEncodingTextQuoted());
        }
        if (this.hasInfileOptions()) {
            infileString.append("\n").append(indent).append(this.getInfileOptionsText());
        }
        infileString.append(";");
        return infileString.toString();
    }

    private boolean isQuotingNeeded() {
        return this.isCaseSensitiveColumnNamesEnabled() || this.isSpecialCharactersInColumnNamesEnabled();
    }

    public String getSpecialMissingStatement() {
        String missingString = "";
        if (this.getMissingValuesSpecial().length() > 0) {
            missingString = "Missing " + this.getMissingValuesSpecial() + ";\n";
        }
        return missingString;
    }

    public String getSpecialNumericStatements() throws MdException, RemoteException {
        StringBuffer missingString = new StringBuffer();
        List columnList = this.getColumns();
        if (columnList.isEmpty()) {
            return missingString.toString();
        }
        List missingList = this.getMissingValuesNumericList();
        if (!missingList.isEmpty()) {
            for (int i = 0; i < columnList.size(); ++i) {
                Column column = (Column)columnList.get(i);
                if (!column.getSASColumnType().equals("N")) continue;
                String columnName = "";
                columnName = !this.isQuotingNeeded() ? column.getSASColumnName() : this.getQuotedColumnName(column) + "n ";
                for (int j = 0; j < missingList.size(); ++j) {
                    String missingValue = (String)missingList.get(j);
                    if (j > 0) {
                        missingString.append("else if " + columnName + " = " + missingValue + " then \n");
                    } else {
                        missingString.append("if " + columnName + " = " + missingValue + " then \n");
                    }
                    missingString.append("   " + columnName + " = .;\n");
                }
            }
        }
        return missingString.toString();
    }

    public List getColumns() {
        return this.m_columnList;
    }

    public void setColumns(List columnList) {
        this.m_columnList = columnList;
    }

    public ExternalTable copyExternalTable(ExternalTable table) {
        return null;
    }

    public DeployedComponent getAppServerDC() {
        return this.m_appServerDC;
    }

    public String getInputStatement() throws MdException, RemoteException {
        SASCodeGeneration cg = new SASCodeGeneration();
        int numColumns = this.m_columnList.size();
        ArrayList<Column> list = new ArrayList<Column>();
        boolean needInformats = true;
        if (this.isFixedWidth()) {
            needInformats = false;
        }
        for (int i = 0; i < numColumns; ++i) {
            cg.genAttrib((Column)this.m_columnList.get(i), true, false, false, true, needInformats, this.isQuotingNeeded());
            Column column = (Column)this.m_columnList.get(i);
            list.add(column);
        }
        int listSize = list.size();
        if (listSize > 0) {
            cg.addSourceCode("\n").addSourceCode("input ");
        }
        if (this.isDelimited()) {
            String colStatement = cg.makeColumnList(list, "      ", this.isQuotingNeeded());
            cg.addSourceCode(colStatement);
            if (!this.isMultiPerLine()) {
                cg.addSourceCode("; \n");
            } else {
                cg.addSourceCode("\n@@\n; \n");
            }
        } else {
            int iStartValue = 0;
            int iEndValue = 0;
            String startValue = "";
            String endValue = "";
            String informat = "";
            for (int j = 0; j < listSize; ++j) {
                Column column = (Column)list.get(j);
                String columnName = "";
                columnName = !this.isQuotingNeeded() ? column.getSASColumnName() : this.getQuotedColumnName(column) + "n ";
                iStartValue = column.getBeginPosition();
                iEndValue = column.getEndPosition();
                startValue = String.valueOf(iStartValue);
                endValue = String.valueOf(iEndValue);
                informat = column.getSASInformat();
                if (informat.length() > 0) {
                    cg.addSourceCode("@ " + startValue + BLANK);
                    cg.addSourceCode(columnName).addSourceCode(BLANK);
                    cg.addSourceCode(BLANK + informat);
                } else if (iEndValue > 0) {
                    cg.addSourceCode(columnName).addSourceCode(BLANK);
                    if (!column.getSASColumnType().equals("N")) {
                        cg.addSourceCode("$ ");
                    }
                    cg.addSourceCode(startValue + "-" + endValue);
                } else {
                    cg.addSourceCode("@ " + startValue + BLANK);
                    cg.addSourceCode(columnName).addSourceCode(BLANK);
                    if (!column.getSASColumnType().equals("N")) {
                        cg.addSourceCode("$ ");
                    }
                }
                if (j + 1 == listSize) {
                    cg.addSourceCode("; \n");
                    continue;
                }
                cg.addSourceCode("\n       ");
            }
        }
        return cg.getSource();
    }

    public StringBuffer getDataStep(String tableName) throws MdException, RemoteException {
        if (tableName.length() == 0) {
            tableName = "work.etls_EFITable";
        }
        SASCodeGeneration cg = new SASCodeGeneration();
        if (this.isUserWritten()) {
            StringBuffer userCode = new StringBuffer();
            userCode.append("%let _OUTPUT = %nrquote(").append(tableName).append("); \n\n");
            String userWrittenCode = this.getUserWrittenCode();
            if (userWrittenCode != null) {
                userCode.append(userWrittenCode).append("\n");
            }
            return userCode;
        }
        if (this.isSpecialCharactersInColumnNamesEnabled()) {
            cg.addSourceCode("options VALIDVARNAME=ANY VALIDMEMNAME=EXTEND;\n");
        }
        if (this.getSpecialMissingStatement().length() > 0) {
            cg.addSourceCode(this.getSpecialMissingStatement());
        }
        cg.addSourceCode("data " + tableName);
        if (this.isCreateView()) {
            cg.addSourceCode("/ view = " + tableName);
        }
        cg.addSourceCode("; \n\n").indent();
        if (this.isPreInfileStatementOverridden()) {
            cg.addSourceCode(this.getPreInfileStatementText());
            cg.addSourceCode("\n\n");
        }
        cg.addSourceCode(this.getInfileStatement());
        cg.addSourceCode("\n\n");
        if (this.isPreAttribInputStatementOverridden()) {
            cg.addSourceCode(this.getpreAttribInputStatementText());
            cg.addSourceCode("\n\n");
        }
        if (this.isAttribInputStatementOverridden()) {
            cg.addSourceCode(this.getAttribInputStatementText());
            cg.addSourceCode("\n\n");
        } else {
            cg.addSourceCode(this.getInputStatement());
        }
        if (this.getMissingValuesNumeric().length() > 0) {
            cg.addSourceCode(this.getSpecialNumericStatements());
        }
        if (this.isPostAttribInputStatementOverridden()) {
            cg.addSourceCode(this.getPostAttribInputStatementText());
            cg.addSourceCode("\n\n");
        }
        cg.addSourceCode("\n").unIndent().addSourceCode("run; \n\n");
        StringBuffer l_buffer = cg.getSourceBuffer();
        cg.clearSourceBuffer();
        return l_buffer;
    }

    private boolean isNumericMissing() {
        if (this.getMissingValuesNumeric() == null) {
            return false;
        }
        return this.m_numericMissing;
    }

    public void setFileOptions(String fileOptions) {
        this.m_fileOptions = fileOptions;
    }

    public String getFileOptions() {
        return this.m_fileOptions;
    }

    public StringBuffer getLoaderDataStep() throws MdException, RemoteException {
        if (this.isUserWritten()) {
            String userCode = this.getUserWrittenCode();
            if (userCode == null) {
                return new StringBuffer("");
            }
            return new StringBuffer(userCode);
        }
        String quoteValue = "'";
        if (this.isDoubleQuotesEnabled()) {
            quoteValue = "\"";
        }
        StringBuffer fname = new StringBuffer();
        if (!this.isNoQuotesEnabled()) {
            fname.append(quoteValue).append(this.getFilename()).append(quoteValue);
        } else {
            fname.append(this.getFilename());
        }
        String filename = fname.toString();
        ArrayList<Column> list = new ArrayList<Column>();
        SASCodeGeneration cg = new SASCodeGeneration();
        cg.addSourceCode("data _null_; \n");
        cg.indent();
        if (this.isNumericMissing() && this.getMissingValuesNumericForOutput().length() > 0) {
            cg.addSourceCode("length missval 8.;\n");
            cg.addSourceCode("missval=" + this.getMissingValuesNumericForOutput() + ";\n");
        }
        cg.addSourceCode("set &syslast;\n\n");
        for (int i = 0; i < this.m_columnList.size(); ++i) {
            cg.genAttrib((Column)this.m_columnList.get(i), true, false, false, true, this.isQuotingNeeded());
            Column column = (Column)this.m_columnList.get(i);
            list.add(column);
        }
        if (!this.isConsecDelim()) {
            cg.addSourceCode("quote='\"';\n");
        }
        if (this.isDefaultAccessMethod()) {
            cg.addSourceCode("file " + filename + BLANK + this.getFileOptions() + BLANK);
        } else if (this.isFtpAccessMethod()) {
            cg.addSourceCode("file " + filename + BLANK + this.getFTPOptions() + BLANK + this.getFileOptions());
        } else {
            throw new MdException(bundle.getString("EFIDataModel.FileWriter.URLAccessMethodUnsupported.txt"));
        }
        if (this.isDelimited()) {
            if (this.isDelimiterOverridden()) {
                cg.addSourceCode(" dlm=" + this.getOverrideDelimiter());
            } else {
                cg.addSourceCode(" dlm='" + this.getDelimiterValue() + "'");
            }
        }
        cg.addSourceCode(";\n\n");
        if (!list.isEmpty()) {
            this.buildHeaderLine(list, cg, false);
            if (this.isDelimited()) {
                if (this.isNumericMissing()) {
                    this.buildDelimitedPutStatementsWithNumericMissing(list, cg);
                } else {
                    this.buildDelimitedPutStatements(list, cg);
                }
            } else if (this.isNumericMissing()) {
                this.buildFixedWidthPutStatementsWithNumericMissing(list, cg);
            } else {
                this.buildFixedWidthPutStatements(list, cg);
            }
            cg.unIndent(2);
            cg.addSourceCode("\n").unIndent().addSourceCode("run; \n\n");
        }
        StringBuffer l_buffer = cg.getSourceBuffer();
        cg.clearSourceBuffer();
        return l_buffer;
    }

    public void buildDelimitedPutStatements(List columnlist, SASCodeGeneration cgen) throws MdException, RemoteException {
        cgen.setIndent(0);
        cgen.indent();
        if (this.isConsecDelim()) {
            cgen.addSourceCode("put \n");
            cgen.indent();
            for (int j = 0; j < columnlist.size(); ++j) {
                Column column = (Column)columnlist.get(j);
                String columnName = "";
                columnName = !this.isQuotingNeeded() ? column.getSASColumnName() : this.getQuotedColumnName(column) + "n ";
                cgen.addSourceCode(columnName);
                cgen.addSourceCode("\n");
            }
            cgen.addSourceCode(";\n");
            cgen.unIndent();
        } else {
            cgen.addSourceCode("put \n");
            cgen.indent();
            for (int j = 0; j < columnlist.size(); ++j) {
                Column column = (Column)columnlist.get(j);
                String columnName = "";
                columnName = !this.isQuotingNeeded() ? column.getSASColumnName() : this.getQuotedColumnName(column) + "n ";
                cgen.addSourceCode("quote +(-1) ");
                cgen.addSourceCode(columnName);
                cgen.addSourceCode(" +(-1) quote\n");
            }
            cgen.addSourceCode(";\n");
            cgen.unIndent();
        }
        cgen.unIndent();
    }

    public void buildFixedWidthPutStatements(List columnlist, SASCodeGeneration cgen) throws MdException, RemoteException {
        cgen.setIndent(0);
        cgen.indent();
        if (columnlist == null) {
            columnlist = this.getColumns();
        }
        for (int j = 0; j < columnlist.size(); ++j) {
            if (j == 0) {
                cgen.addSourceCode("put \n");
            }
            cgen.indent();
            Column column = (Column)columnlist.get(j);
            String columnName = "";
            columnName = !this.isQuotingNeeded() ? column.getSASColumnName() : this.getQuotedColumnName(column) + "n ";
            cgen.addSourceCode(" @ " + column.getBeginPosition());
            cgen.addSourceCode(BLANK + columnName);
            cgen.addSourceCode(BLANK + column.getSASFormat() + " \n");
            cgen.unIndent();
        }
        cgen.addSourceCode(";\n");
    }

    public void buildFixedWidthPutStatementsWithNumericMissing(List columnlist, SASCodeGeneration cgen) throws MdException, RemoteException {
        cgen.setIndent(0);
        cgen.unIndent();
        int numberColumns = columnlist.size();
        for (int j = 0; j < numberColumns; ++j) {
            Column column = (Column)columnlist.get(j);
            String columnName = "";
            columnName = !this.isQuotingNeeded() ? column.getSASColumnName() : this.getQuotedColumnName(column) + "n ";
            if (column.getSASColumnType().equals("N")) {
                cgen.addSourceCode("   if (" + columnName + "=.) then\n");
                cgen.addSourceCode("      put @ " + column.getBeginPosition() + BLANK);
                cgen.addSourceCode(MISSING_VALUE_VARIABLE);
                if (j < numberColumns - 1) {
                    cgen.addSourceCode(" @;\n");
                } else {
                    cgen.addSourceCode(" ;\n");
                }
                cgen.addSourceCode("   else\n");
                cgen.addSourceCode("      put @ " + column.getBeginPosition() + BLANK);
                cgen.addSourceCode(columnName + BLANK);
                cgen.addSourceCode(column.getSASFormat());
                if (j < numberColumns - 1) {
                    cgen.addSourceCode(" @;\n");
                    continue;
                }
                cgen.addSourceCode(" ;\n");
                continue;
            }
            cgen.addSourceCode("   put @ " + column.getBeginPosition());
            cgen.addSourceCode(BLANK + columnName);
            cgen.addSourceCode(BLANK + column.getSASFormat());
            if (j < numberColumns - 1) {
                cgen.addSourceCode(" @;\n");
                continue;
            }
            cgen.addSourceCode(" ;\n");
        }
    }

    public void buildDelimitedPutStatementsWithNumericMissing(List columnlist, SASCodeGeneration cgen) throws MdException, RemoteException {
        cgen.setIndent(0);
        cgen.unIndent();
        int numberColumns = columnlist.size();
        if (this.isConsecDelim()) {
            for (int j = 0; j < numberColumns; ++j) {
                Column column = (Column)columnlist.get(j);
                String columnName = "";
                columnName = !this.isQuotingNeeded() ? column.getSASColumnName() : this.getQuotedColumnName(column) + "n ";
                if (column.getSASColumnType().equals("N")) {
                    cgen.addSourceCode("   if (" + columnName + "=.) then\n");
                    cgen.addSourceCode("      put missval");
                    if (j < numberColumns - 1) {
                        cgen.addSourceCode(" @;\n");
                    } else {
                        cgen.addSourceCode(" ;\n");
                    }
                    cgen.addSourceCode("   else\n");
                    cgen.addSourceCode("      put " + columnName);
                    if (j < numberColumns - 1) {
                        cgen.addSourceCode(" @;\n");
                        continue;
                    }
                    cgen.addSourceCode(" ;\n");
                    continue;
                }
                cgen.addSourceCode("   put " + columnName);
                if (j < numberColumns - 1) {
                    cgen.addSourceCode(" @;\n");
                    continue;
                }
                cgen.addSourceCode(" ;\n");
            }
        } else {
            for (int j = 0; j < columnlist.size(); ++j) {
                Column column = (Column)columnlist.get(j);
                String columnName = "";
                columnName = !this.isQuotingNeeded() ? column.getSASColumnName() : this.getQuotedColumnName(column) + "n ";
                if (column.getSASColumnType().equals("N")) {
                    cgen.addSourceCode("   if (");
                    cgen.addSourceCode(columnName + "=.) then\n");
                    cgen.addSourceCode("      put quote +(-1) ");
                    cgen.addSourceCode(MISSING_VALUE_VARIABLE);
                    cgen.addSourceCode(" +(-1) quote ");
                    if (j < numberColumns - 1) {
                        cgen.addSourceCode(" @;\n");
                    } else {
                        cgen.addSourceCode(" ;\n");
                    }
                    cgen.addSourceCode("   else\n");
                    cgen.addSourceCode("      put quote +(-1) ");
                    cgen.addSourceCode(columnName);
                    cgen.addSourceCode(" +(-1) quote ");
                    if (j < numberColumns - 1) {
                        cgen.addSourceCode(" @;\n");
                        continue;
                    }
                    cgen.addSourceCode(" ;\n");
                    continue;
                }
                cgen.addSourceCode("   put quote  +(-1) " + columnName);
                cgen.addSourceCode(" +(-1) quote ");
                if (j < numberColumns - 1) {
                    cgen.addSourceCode(" @;\n");
                    continue;
                }
                cgen.addSourceCode(" ;\n");
            }
        }
    }

    public void setOutputHeaderLine(boolean headerLine) {
        this.m_headerLineOutputFile = headerLine;
    }

    public boolean isOutputHeaderLine() {
        return this.m_headerLineOutputFile;
    }

    public void buildHeaderLine(List columnlist, SASCodeGeneration cgen, boolean override) {
        try {
            cgen.setIndent(0);
            if (this.getStartRecord() > 1 || override) {
                this.setOutputHeaderLine(true);
                StringBuffer headerLine = new StringBuffer();
                int clistSize = columnlist.size();
                if (this.isDelimited()) {
                    String delimiter = this.getDelimiterValue();
                    headerLine.append("\"");
                    for (int i = 0; i < clistSize; ++i) {
                        Column column = (Column)columnlist.get(i);
                        if (i < clistSize - 1) {
                            headerLine.append(column.getSASColumnName() + delimiter);
                            continue;
                        }
                        headerLine.append(column.getSASColumnName());
                    }
                    headerLine.append("\"");
                    cgen.addSourceCode("if ( _n_ = 1 ) then \n");
                    cgen.indent();
                    cgen.addSourceCode("do;\n");
                    cgen.indent();
                    cgen.addSourceCode("put \n");
                    cgen.indent();
                    cgen.addSourceCode(headerLine.toString() + ";\n");
                    cgen.unIndent(100);
                    cgen.addSourceCode("end;\n");
                    cgen.unIndent();
                } else {
                    ArrayList<String> columnNamesList = new ArrayList<String>();
                    for (int j = 0; j < columnlist.size(); ++j) {
                        Column col = (Column)columnlist.get(j);
                        columnNamesList.add(col.getSASColumnName());
                    }
                    ArrayList<String> columnPositionsList = new ArrayList<String>();
                    List columnPlist = this.getColumns();
                    for (int k = 0; k < columnPlist.size(); ++k) {
                        Column col = (Column)columnPlist.get(k);
                        String position = String.valueOf(col.getBeginPosition());
                        columnPositionsList.add(position);
                    }
                    cgen.addSourceCode("if ( _n_ = 1 ) then \n");
                    cgen.indent();
                    cgen.addSourceCode("do;\n");
                    cgen.indent();
                    cgen.addSourceCode("put \n");
                    cgen.indent();
                    for (int m = 0; m < columnNamesList.size(); ++m) {
                        Column columnP = (Column)columnPlist.get(m);
                        cgen.addSourceCode(" @ " + columnP.getBeginPosition());
                        cgen.addSourceCode(" '" + (String)columnNamesList.get(m));
                        cgen.addSourceCode("' \n");
                    }
                    cgen.addSourceCode(headerLine.toString() + ";\n");
                    cgen.unIndent();
                    cgen.addSourceCode("end;\n");
                    cgen.unIndent();
                    cgen.unIndent();
                }
                cgen.unIndent();
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
    }

    public void setLogicalRecordLength(int lrecl) throws MdException, RemoteException {
        this.m_logicalRecordLength = lrecl;
        if (lrecl > 0) {
            Property prop = this.setLreclProperty(true);
            String stringValue = String.valueOf(this.m_logicalRecordLength);
            prop.setDefaultValue(stringValue);
        } else {
            this.setLreclProperty(false);
        }
    }

    public int getLogicalRecordLength() {
        return this.m_logicalRecordLength;
    }

    private Property setLreclProperty(boolean lreclB) throws MdException, RemoteException {
        Property lreclProp = this.getLreclProperty();
        if (lreclB) {
            if (lreclProp == null) {
                lreclProp = this.buildPropertyHandler(LRECL, this.getGeneralPropSet(), null);
                this.setLreclProperty(lreclProp);
            }
        } else if (lreclProp != null) {
            this.deleteObject((CMetadata)lreclProp);
            this.setLreclProperty(null);
        }
        return lreclProp;
    }

    private void setLreclProperty(Property mlreclProp) {
        this.m_lreclProp = mlreclProp;
    }

    private Property getLreclProperty() {
        return this.m_lreclProp;
    }

    public List getFtpServers() throws MdException, RemoteException {
        AccessMethodUtil access = new AccessMethodUtil(this.m_store, this.getExternalTable().getRepositoryID());
        return access.getFtpServers();
    }

    public List getHttpServers() throws MdException, RemoteException {
        AccessMethodUtil access = new AccessMethodUtil(this.m_store, this.getExternalTable().getRepositoryID());
        return access.getHttpServers();
    }

    public List getHadoopServers() throws MdException, RemoteException {
        AccessMethodUtil access = new AccessMethodUtil(this.m_store, this.getExternalTable().getRepositoryID());
        return access.getHadoopServers();
    }

    public void setCaseSensitiveColumnNamesEnabled(boolean enabled) throws MdException, RemoteException {
        this.m_caseSensitiveColumnNames = enabled;
        this.setCaseSensitiveColumnNamesEnabledProperty(enabled);
    }

    public boolean isCaseSensitiveColumnNamesEnabled() {
        return this.m_caseSensitiveColumnNames;
    }

    private void setCaseSensitiveColumnNamesEnabledProperty(boolean createProp) throws MdException, RemoteException {
        Property caseProp = this.getCaseSensitiveColumnNamesEnabledProperty();
        if (createProp) {
            if (caseProp == null) {
                caseProp = this.buildPropertyHandler(CASESENSITIVECOLUMNS, this.getGeneralPropSet(), null);
                this.setCaseSensitiveColumnNamesEnabledProp(caseProp);
            }
        } else if (caseProp != null) {
            this.deleteObject((CMetadata)caseProp);
            this.setCaseSensitiveColumnNamesEnabledProp(null);
        }
    }

    private Property getCaseSensitiveColumnNamesEnabledProperty() {
        return this.m_caseSensitiveColumnNamesProperty;
    }

    private void setCaseSensitiveColumnNamesEnabledProp(Property property) {
        this.m_caseSensitiveColumnNamesProperty = property;
    }

    public void setSpecialCharactersInColumnNamesEnabled(boolean enabled) throws MdException, RemoteException {
        this.m_specialCharactersInColumnNames = enabled;
        this.setSpecialCharactersInColumnNamesEnabledProperty(enabled);
    }

    public boolean isSpecialCharactersInColumnNamesEnabled() {
        return this.m_specialCharactersInColumnNames;
    }

    private void setSpecialCharactersInColumnNamesEnabledProperty(boolean createProp) throws MdException, RemoteException {
        Property specialColumnsProp = this.getSpecialCharactersInColumnNamesEnabledProperty();
        if (createProp) {
            if (specialColumnsProp == null) {
                specialColumnsProp = this.buildPropertyHandler(SPECIALCHARACTERSINCOLUMNS, this.getGeneralPropSet(), null);
                this.setSpecialCharactersInColumnNamesEnabledProp(specialColumnsProp);
            }
        } else if (specialColumnsProp != null) {
            this.deleteObject((CMetadata)specialColumnsProp);
            this.setSpecialCharactersInColumnNamesEnabledProp(null);
        }
    }

    private Property getSpecialCharactersInColumnNamesEnabledProperty() {
        return this.m_specialCharactersInColumnNamesProperty;
    }

    private void setSpecialCharactersInColumnNamesEnabledProp(Property property) {
        this.m_specialCharactersInColumnNamesProperty = property;
    }

    private String getQuotedColumnName(Column column) throws MdException, RemoteException {
        String name = column.getSASColumnName();
        name = DBMSNamesUtil.getQuotedString(name);
        return name;
    }

    public void setExternalFormatFile(String filename) throws MdException, RemoteException {
        if (this.m_externalFormatFile != null) {
            if (filename.equals(this.m_externalFormatFile.getFileName())) {
                this.deleteObjects((List)this.m_externalFormatFile.getSourceTransformations());
                this.deleteObject((CMetadata)this.m_externalFormatFile.getAssociatedTransformation());
                this.deleteObject((CMetadata)this.m_externalFormatFile);
                this.m_externalFormatFile = null;
                if (filename.length() > 0) {
                    this.m_externalFormatFile = this.m_formatFileUtil.buildFormatFileMd(filename, this.getAppServerDC(), this.getExternalTable());
                }
            }
        } else {
            this.m_externalFormatFile = this.m_formatFileUtil.buildFormatFileMd(filename, this.getAppServerDC(), this.getExternalTable());
        }
    }

    private void setExternalFormatFileCobol(File file) throws MdException, RemoteException {
        if (this.m_externalFormatFile != null && file != this.m_externalFormatFile) {
            this.deleteObject((CMetadata)this.m_externalFormatFile.getAssociatedTransformation());
            this.deleteObject((CMetadata)this.m_externalFormatFile);
            this.m_externalFormatFile = file;
        }
    }

    public void buildFormatFileAssociation(File file) throws MdException, RemoteException {
        this.m_formatFileClassifierMap = this.m_formatFileUtil.buildFormatFileAssociation(file, this.getExternalTable());
        this.setExternalFormatFileCobol(file);
    }

    public void removeFormatFileAssociation() throws MdException, RemoteException {
        this.deleteObject((CMetadata)this.m_formatFileClassifierMap);
        this.m_formatFileClassifierMap = null;
    }

    private ClassifierMap getFormatFileCM() {
        return this.m_formatFileClassifierMap;
    }

    public File getExternalFormatFile(String effType) throws MdException, RemoteException {
        if (this.m_externalFormatFile != null) {
            return this.m_externalFormatFile;
        }
        return this.m_formatFileUtil.getAssociatedFormatFile(effType, this.getExternalTable());
    }

    public File getExternalFormatFile() {
        return this.m_externalFormatFile;
    }

    public void cleanupFormatFileMD() throws MdException, RemoteException {
        this.deleteObject((CMetadata)this.getFormatFileCM());
        this.deleteObject((CMetadata)this.getExternalFormatFile());
        this.m_formatFileClassifierMap = null;
        this.m_externalFormatFile = null;
    }

    public void setUserWrittenSourceCodeText(Text text) throws MdException, RemoteException {
        if (text == null) {
            return;
        }
        AssociationList dcList = text.getDeployedComponents();
        if (!dcList.isEmpty()) {
            this.m_appServerDC = (DeployedComponent)dcList.get(0);
            this.updateAppServer((ServerContext)this.m_appServerDC);
        }
        if (this.getUserWrittenSourceCodeText() == text) {
            return;
        }
        if (this.getUserWrittenSourceCodeText() != null) {
            if (!this.getUserWrittenSourceCodeText().getSourceTransformations().isEmpty()) {
                this.deleteObject((CMetadata)this.getUserWrittenSourceCodeText().getSourceTransformations().get(0));
            }
            this.deleteObject((CMetadata)this.getUserWrittenSourceCodeText());
        }
        String mdName = text.getName();
        ClassifierMap cm = this.buildUserWrittenSourceCodeCM(mdName);
        cm.setSourceCode(text);
        this.m_userWrittenText = text;
    }

    public String getUserWrittenCode() throws MdException, RemoteException {
        if (this.getUserWrittenSourceCodeText() == null) {
            return null;
        }
        if (this.getUserWrittenSourceCodeText().getCMetadataType().equals("File")) {
            File file = (File)this.getUserWrittenSourceCodeText();
            return this.getFileSource(file.getFileName());
        }
        if (this.getUserWrittenSourceCodeText().getCMetadataType().equals("TextStore")) {
            TextStore source = (TextStore)this.getUserWrittenSourceCodeText();
            return source.getStoredText();
        }
        return null;
    }

    public WsAppServer getAppServer() {
        return this.getAppServer(true);
    }

    public WsAppServer getAppServer(boolean bPrompt) {
        if (this.m_appServer != null) {
            return this.m_appServer;
        }
        ServerContext oServer = (ServerContext)this.getAppServerDC();
        if (oServer != null) {
            this.m_appServer = WsAppServer.createAppServer(oServer);
        } else {
            this.m_appServer = WsAppServer.createDefaultAppServer(bPrompt);
            if (this.m_appServer != null && !this.isUserWritten()) {
                try {
                    this.setAppServerDC((DeployedComponent)this.m_appServer.getServerContext());
                }
                catch (MdException e) {
                    MessageUtil.displayMetadataExceptionMessage(e, "Accessing");
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException(re);
                }
            }
        }
        if (this.m_appServer != null) {
            this.m_appServer.setName("EFIDataModel:" + this.m_filename);
        }
        return this.m_appServer;
    }

    public void updateAppServer(ServerContext oServer) throws MdException, RemoteException {
        if (this.m_appServer != null) {
            if (!this.m_appServer.getServerFQID().equals(oServer.getFQID())) {
                this.m_appServer.close();
                this.m_appServer.setServerContext(oServer);
            }
        } else {
            this.m_appServer = WsAppServer.createAppServer(oServer);
        }
        if (!this.isUserWritten()) {
            this.setAppServerDC((DeployedComponent)oServer);
        }
    }

    public void dispose() {
        if (this.m_appServer != null) {
            this.m_appServer.dispose();
            this.m_appServer = null;
        }
    }

    private String getFileSource(String filename) throws MdException, RemoteException {
        WsAppServer appServer = this.getAppServer();
        if (appServer == null) {
            return "";
        }
        try {
            return appServer.readFile(filename).toString();
        }
        catch (GenericError e) {
            throw new MdException(e.getLocalizedMessage());
        }
        catch (WsAppServerFailException e) {
            throw new MdException(e.getLocalizedMessage());
        }
    }

    public Text getUserWrittenSourceCodeText() {
        return this.m_userWrittenText;
    }

    private ClassifierMap buildUserWrittenSourceCodeCM(String MdName) throws MdException, RemoteException {
        ClassifierMap effCM = (ClassifierMap)Workspace.getMdFactory().createComplexMetadataObject(this.m_store, this.getFilename(), "ClassifierMap", this.m_fqid);
        effCM.setName(MdName);
        effCM.setTransformRole(USERWRITTENSOURCECODE);
        effCM.getTransformationTargets().add((Object)this.getExternalTable());
        return effCM;
    }

    public static boolean isLegacyEFIObject(ExternalTable table) throws MdException, RemoteException {
        AssociationList classMapList = table.getSourceClassifierMaps();
        if (classMapList != null && !classMapList.isEmpty()) {
            for (int i = 0; i < classMapList.size(); ++i) {
                ClassifierMap classMap = (ClassifierMap)classMapList.get(i);
                if (!classMap.getName().equals("EFIClassifierMap")) continue;
                return true;
            }
        }
        return false;
    }

    public void setOverlapColumns(boolean bool) throws MdException, RemoteException {
        this.m_overlapColumns = bool;
        this.setOverlapProperty(this.m_overlapColumns);
    }

    private void setOverlapProperty(boolean overlap) throws MdException, RemoteException {
        Property overlapProp = this.getOverlapProp();
        if (overlap) {
            if (overlapProp == null) {
                overlapProp = this.buildPropertyHandler(OVERLAP, null, this.getFixedWidthProperty());
                this.setOverlapProp(overlapProp);
            }
        } else if (overlapProp != null) {
            this.deleteObject((CMetadata)overlapProp);
            this.setOverlapProp(null);
        }
    }

    private void setOverlapProp(Property overlapProp) {
        this.m_overlapProperty = overlapProp;
    }

    private Property getOverlapProp() {
        return this.m_overlapProperty;
    }

    public boolean isOverlappingColumns() {
        return this.m_overlapColumns;
    }

    public void setPreInfileStatementOverride(boolean override, String overrideText) throws MdException, RemoteException {
        this.m_preInfile = override;
        Property prop = this.getPreInfileStatementProperty();
        TextStore text = this.getPreInfileStatementTextStore();
        if (!this.m_preInfile) {
            if (overrideText.length() == 0) {
                this.deleteObject((CMetadata)text);
                this.deleteObject((CMetadata)prop);
                this.setPreInfileStatementProperty(null);
                this.m_preInfileStatement = null;
            } else {
                prop.setDefaultValue(NO);
            }
        } else {
            if (prop != null && text != null) {
                if (text.getStoredText() != overrideText) {
                    text.setStoredText(overrideText);
                }
            } else {
                prop = this.buildPropertyHandler(PREINFILE, this.getGeneralPropSet(), null);
                this.setPreInfileStatementProperty(prop);
                this.setPreInfileStatementText(overrideText, prop);
            }
            this.m_preInfileStatement = overrideText;
            prop.setDefaultValue(YES);
        }
    }

    private void setPreInfileStatementProperty(Property preInfileStatementProp) {
        this.m_preInfileProperty = preInfileStatementProp;
    }

    private Property getPreInfileStatementProperty() {
        return this.m_preInfileProperty;
    }

    public boolean isPreInfileStatementOverridden() {
        return this.m_preInfile;
    }

    private void setPreInfileStatementText(String textString, Property property) throws MdException, RemoteException {
        TextStore textSt = this.getPreInfileStatementTextStore();
        if (textSt == null) {
            this.setPreInfileStatementTextStore(textString, property);
        } else {
            textSt.setStoredText(textString);
        }
        this.m_preInfileStatement = textString;
    }

    public String getPreInfileStatementText() {
        return this.m_preInfileStatement;
    }

    private void setPreInfileStatementTextStore(String text, Property property) throws MdException, RemoteException {
        this.m_preInfileText = this.buildPropertyText(PREINFILE, text, property);
    }

    private TextStore getPreInfileStatementTextStore() {
        return this.m_preInfileText;
    }

    public void setPreAttribInputStatementOverride(boolean override, String overrideText) throws MdException, RemoteException {
        this.m_preAttribInput = override;
        Property prop = this.getPreAttribInputStatementProperty();
        TextStore text = this.getPreAttribInputStatementTextStore();
        if (!this.m_preAttribInput) {
            if (overrideText.length() == 0) {
                this.deleteObject((CMetadata)text);
                this.deleteObject((CMetadata)prop);
                this.setPreAttribInputStatementProperty(null);
                this.m_preAttribInputStatement = null;
            } else {
                prop.setDefaultValue(NO);
            }
        } else {
            if (prop != null && text != null) {
                if (text.getStoredText() != overrideText) {
                    text.setStoredText(overrideText);
                }
            } else {
                prop = this.buildPropertyHandler(PREATTRIBINPUTSTATEMENT, this.getGeneralPropSet(), null);
                this.setPreAttribInputStatementProperty(prop);
                this.setPreAttribInputStatementText(overrideText, prop);
            }
            this.m_preAttribInputStatement = overrideText;
            prop.setDefaultValue(YES);
        }
    }

    private void setPreAttribInputStatementProperty(Property preAttribInputStatementProp) {
        this.m_preAttribInputProperty = preAttribInputStatementProp;
    }

    private Property getPreAttribInputStatementProperty() {
        return this.m_preAttribInputProperty;
    }

    public boolean isPreAttribInputStatementOverridden() {
        return this.m_preAttribInput;
    }

    private void setPreAttribInputStatementText(String textString, Property property) throws MdException, RemoteException {
        TextStore textSt = this.getPreAttribInputStatementTextStore();
        if (textSt == null) {
            this.setPreAttribInputStatementTextStore(textString, property);
        } else {
            textSt.setStoredText(textString);
        }
        this.m_preAttribInputStatement = textString;
    }

    public String getpreAttribInputStatementText() {
        return this.m_preAttribInputStatement;
    }

    private void setPreAttribInputStatementTextStore(String text, Property property) throws MdException, RemoteException {
        this.m_preAttribInputText = this.buildPropertyText(PREATTRIBINPUTSTATEMENT, text, property);
    }

    private TextStore getPreAttribInputStatementTextStore() {
        return this.m_preAttribInputText;
    }

    public void setAttribInputStatementOverride(boolean override, String overrideText) throws MdException, RemoteException {
        this.m_attribInput = override;
        Property prop = this.getAttribInputStatementProperty();
        TextStore text = this.getAttribInputStatementTextStore();
        if (!this.m_attribInput) {
            if (overrideText.length() == 0) {
                this.deleteObject((CMetadata)text);
                this.deleteObject((CMetadata)prop);
                this.setAttribInputStatementProperty(null);
                this.m_attribInputStatement = null;
            } else {
                prop.setDefaultValue(NO);
            }
        } else {
            if (prop != null && text != null) {
                if (text.getStoredText() != overrideText) {
                    text.setStoredText(overrideText);
                }
            } else {
                prop = this.buildPropertyHandler(ATTRIBINPUTSTATEMENT, this.getGeneralPropSet(), null);
                this.setAttribInputStatementProperty(prop);
                this.setAttribInputStatementText(overrideText, prop);
            }
            this.m_attribInputStatement = overrideText;
            prop.setDefaultValue(YES);
        }
    }

    private void setAttribInputStatementProperty(Property attribInputStatementProp) {
        this.m_attribInputProperty = attribInputStatementProp;
    }

    private Property getAttribInputStatementProperty() {
        return this.m_attribInputProperty;
    }

    public boolean isAttribInputStatementOverridden() {
        return this.m_attribInput;
    }

    private void setAttribInputStatementText(String textString, Property property) throws MdException, RemoteException {
        TextStore textSt = this.getAttribInputStatementTextStore();
        if (textSt == null) {
            this.setAttribInputStatementTextStore(textString, property);
        } else {
            textSt.setStoredText(textString);
        }
        this.m_attribInputStatement = textString;
    }

    public String getAttribInputStatementText() {
        return this.m_attribInputStatement;
    }

    private void setAttribInputStatementTextStore(String text, Property property) throws MdException, RemoteException {
        this.m_attribInputText = this.buildPropertyText(ATTRIBINPUTSTATEMENT, text, property);
    }

    private TextStore getAttribInputStatementTextStore() {
        return this.m_attribInputText;
    }

    public void setPostAttribInputStatementOverride(boolean override, String overrideText) throws MdException, RemoteException {
        this.m_postAttribInput = override;
        Property prop = this.getPostAttribInputStatementProperty();
        TextStore text = this.getPostAttribInputStatementTextStore();
        if (!this.m_postAttribInput) {
            if (overrideText.length() == 0) {
                this.deleteObject((CMetadata)text);
                this.deleteObject((CMetadata)prop);
                this.setPostAttribInputStatementProperty(null);
                this.m_postAttribInputStatement = null;
            } else {
                prop.setDefaultValue(NO);
            }
        } else {
            if (prop != null && text != null) {
                if (text.getStoredText() != overrideText) {
                    text.setStoredText(overrideText);
                }
            } else {
                prop = this.buildPropertyHandler(POSTATTRIBINPUTSTATEMENT, this.getGeneralPropSet(), null);
                this.setPostAttribInputStatementProperty(prop);
                this.setPostAttribInputStatementText(overrideText, prop);
            }
            this.m_postAttribInputStatement = overrideText;
            prop.setDefaultValue(YES);
        }
    }

    private void setPostAttribInputStatementProperty(Property postAttribInputStatementProp) {
        this.m_postAttribInputProperty = postAttribInputStatementProp;
    }

    private Property getPostAttribInputStatementProperty() {
        return this.m_postAttribInputProperty;
    }

    public boolean isPostAttribInputStatementOverridden() {
        return this.m_postAttribInput;
    }

    private void setPostAttribInputStatementText(String textString, Property property) throws MdException, RemoteException {
        TextStore textSt = this.getPostAttribInputStatementTextStore();
        if (textSt == null) {
            this.setPostAttribInputStatementTextStore(textString, property);
        } else {
            textSt.setStoredText(textString);
        }
        this.m_postAttribInputStatement = textString;
    }

    public String getPostAttribInputStatementText() {
        return this.m_postAttribInputStatement;
    }

    private void setPostAttribInputStatementTextStore(String text, Property property) throws MdException, RemoteException {
        this.m_postAttribInputText = this.buildPropertyText(POSTATTRIBINPUTSTATEMENT, text, property);
    }

    private TextStore getPostAttribInputStatementTextStore() {
        return this.m_postAttribInputText;
    }

    public void setOverrideDelimiter(String overrideVal) throws MdException, RemoteException {
        this.m_overrideDelimiterVal = overrideVal;
        this.m_overrideDelimiter = this.m_overrideDelimiterVal == null ? false : this.m_overrideDelimiterVal.length() != 0;
        this.setOverrideDelimiterProperty(this.m_overrideDelimiter);
    }

    public String getOverrideDelimiter() {
        return this.m_overrideDelimiterVal;
    }

    private void setOverrideDelimiterProperty(boolean override) throws MdException, RemoteException {
        Property overrideDelimiterProp = this.getOverrideDelimiterProp();
        if (override) {
            if (overrideDelimiterProp == null) {
                overrideDelimiterProp = this.buildPropertyHandler(OVERRIDEDELIMITER, null, this.getDelimitedProperty());
                this.setOverrideDelimiterProp(overrideDelimiterProp);
            }
            overrideDelimiterProp.setDefaultValue(this.getOverrideDelimiter());
        } else if (overrideDelimiterProp != null) {
            this.deleteObject((CMetadata)overrideDelimiterProp);
            this.setOverrideDelimiterProp(null);
        }
    }

    private void setOverrideDelimiterProp(Property overrideDelimiterProp) {
        this.m_overrideDelimiterProp = overrideDelimiterProp;
    }

    private Property getOverrideDelimiterProp() {
        return this.m_overrideDelimiterProp;
    }

    public boolean isDelimiterOverridden() {
        return this.m_overrideDelimiter;
    }
}

