/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.metadata;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.AuthenticationDomain;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Connection;
import com.sas.metadata.remote.Login;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.TCPIPConnection;
import com.sas.util.SasPasswordEncodingException;
import com.sas.util.SasPasswordString;
import com.sas.workspace.LibraryUtil;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAppServer;
import java.net.PasswordAuthentication;
import java.rmi.RemoteException;
import java.util.List;

public class AccessMethodUtil {
    private MdObjectStore m_objectStore;
    private String m_fqid;
    private String m_httpServerProxy;
    private String m_httpServerUserPass;
    private String m_httpServerApplicationProtocal;
    private String m_httpServerHostName;
    private String m_httpServerPortNumber;
    private String m_ftpHost;
    private String m_ftpPort;
    private String m_ftpUserPass;
    private String m_hadoopUserPass;

    public AccessMethodUtil() {
        this.m_httpServerPortNumber = "";
        this.m_httpServerHostName = "";
        this.m_httpServerApplicationProtocal = "";
        this.m_httpServerProxy = "";
        this.m_httpServerUserPass = "";
        this.m_ftpHost = "";
        this.m_ftpPort = "";
        this.m_ftpUserPass = "";
        this.m_hadoopUserPass = "";
    }

    public AccessMethodUtil(MdObjectStore objectStore, String fqid) {
        this.setStore(objectStore);
        this.setFQID(fqid);
    }

    public void setStore(MdObjectStore store) {
        this.m_objectStore = store;
    }

    public void setFQID(String fqid) {
        this.m_fqid = "A0000001." + fqid;
    }

    protected List getFtpServers() throws MdException, RemoteException {
        return this.getServers("Ftp Server");
    }

    protected List getHttpServers() throws MdException, RemoteException {
        return this.getServers("Http Server");
    }

    protected List getHadoopServers() throws MdException, RemoteException {
        return this.getServers("HADOOP");
    }

    private List getServers(String serverType) throws MdException, RemoteException {
        String sOptions = "<XMLSELECT Search=\"@PRODUCTNAME='" + serverType + "'\"/>";
        List lDeployedComp = null;
        lDeployedComp = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)this.m_objectStore, this.m_fqid, "ServerComponent", 8588, sOptions);
        return lDeployedComp;
    }

    protected void populateHadoopServer(ServerComponent hadoopServer, boolean encodePassword) throws MdException, RemoteException {
        if (hadoopServer == null) {
            return;
        }
        this.m_hadoopUserPass = this.getUserPass((Connection)hadoopServer.getSourceConnections().get(0), encodePassword);
    }

    protected void populateFTPServer(ServerComponent ftpServer, boolean encodePassword) throws MdException, RemoteException {
        if (ftpServer == null) {
            return;
        }
        this.m_ftpHost = "";
        this.m_ftpPort = "";
        TCPIPConnection tcp = (TCPIPConnection)ftpServer.getSourceConnections().get(0);
        if (tcp.getHostName().length() > 0) {
            this.m_ftpHost = tcp.getHostName();
        }
        if (tcp.getPort() > 0) {
            this.m_ftpPort = String.valueOf(tcp.getPort());
        }
        this.m_ftpUserPass = this.getUserPass((Connection)tcp, encodePassword);
    }

    public String getFtpHost() {
        return this.m_ftpHost;
    }

    public String getFtpPort() {
        return this.m_ftpPort;
    }

    public String getFtpUserPass() {
        return this.m_ftpUserPass;
    }

    public String getFTPOptions() {
        return this.getFTPOptions(true);
    }

    public String getFTPOptions(boolean includeEngine) {
        String opts = " Host='" + this.getFtpHost() + "' Port=" + this.getFtpPort() + this.getFtpUserPass();
        if (includeEngine) {
            opts = " FTP " + opts;
        }
        return opts;
    }

    public String getHadoopUserPass() {
        return this.m_hadoopUserPass;
    }

    public String getHadoopOptions(boolean includeEngine, String fileref, boolean useConfigurationXML) {
        String opts = includeEngine ? " device=" + WsAppServer.FILE_ACCESS_METHOD_HADOOP : " ";
        opts = opts + this.getHadoopUserPass();
        return opts;
    }

    public String getHadoopOptions(boolean includeEngine, String fileref) {
        return this.getHadoopOptions(includeEngine, fileref, true);
    }

    public static String getFilenameAndDSCode(String fileref, String filelocation, String fileContent) {
        StringBuilder sb = new StringBuilder();
        sb.append("filename ").append(fileref).append(" ").append(filelocation).append(" ;\n\n");
        sb.append("data _null_;").append("\n").append("file ").append(fileref).append(";\n").append("input;").append("\n").append("put _infile_;").append("\n").append("datalines4;").append("\n").append(fileContent != null ? fileContent : "").append("\n").append(";;;;\n").append("run;\n\n");
        return sb.toString();
    }

    public void populateHTTPServer(ServerComponent httpServer, boolean encodePassword) throws MdException, RemoteException {
        CMetadata cm;
        if (httpServer == null) {
            return;
        }
        this.m_httpServerProxy = "";
        AssociationList httpList = httpServer.getSourceConnections();
        if (!httpList.isEmpty() && (cm = (CMetadata)httpList.get(0)).getCMetadataType().equals("TCPIPConnection")) {
            TCPIPConnection tcp = (TCPIPConnection)cm;
            this.m_httpServerApplicationProtocal = tcp.getApplicationProtocol();
            this.m_httpServerHostName = tcp.getHostName();
            this.m_httpServerPortNumber = Integer.toString(tcp.getPort());
            AssociationList propList = tcp.getProperties();
            if (!propList.isEmpty()) {
                for (int i = 0; i < propList.size(); ++i) {
                    Property prop = (Property)propList.get(i);
                    if (!prop.getPropertyName().equals("ProxyURL")) continue;
                    this.m_httpServerProxy = prop.getDefaultValue();
                }
            }
            this.m_httpServerUserPass = this.m_httpServerProxy.length() > 0 ? this.getUserPass((Connection)tcp, false) : this.getUserPass((Connection)tcp, encodePassword);
        }
    }

    public String getHttpServerProxy() {
        if (this.m_httpServerProxy.length() > 0) {
            return " proxy='" + this.m_httpServerProxy + "'";
        }
        return "";
    }

    public String getHttpServerUserPass() {
        return this.m_httpServerUserPass;
    }

    public String getHttpHostName() {
        return this.m_httpServerHostName;
    }

    public String getHttpApplicationProtocal() {
        return this.m_httpServerApplicationProtocal;
    }

    public String getHttpPortNumber() {
        return this.m_httpServerPortNumber;
    }

    public String getHttpOptions() {
        StringBuffer httpOptions = new StringBuffer();
        if (this.getHttpServerProxy().length() > 0) {
            httpOptions.append(this.getHttpServerProxy());
        }
        httpOptions.append(this.getHttpServerUserPass());
        return httpOptions.toString();
    }

    public String getHttpFilePath(String filename) {
        StringBuffer httpOptions = new StringBuffer();
        httpOptions.append(this.getHttpApplicationProtocal() + "://");
        String host = this.getHttpHostName();
        httpOptions.append(host);
        if (this.getHttpPortNumber().length() > 0) {
            httpOptions.append(":" + this.getHttpPortNumber());
        }
        if (!filename.startsWith("/") && !filename.startsWith("\\")) {
            httpOptions.append("/");
        }
        httpOptions.append(filename);
        return httpOptions.toString();
    }

    public String getHttpServerOptions(String filename) {
        StringBuffer httpOptions = new StringBuffer();
        httpOptions.append("'");
        httpOptions.append(this.getHttpApplicationProtocal() + "://");
        String host = this.getHttpHostName();
        httpOptions.append(host);
        if (this.getHttpPortNumber().length() > 0) {
            httpOptions.append(":" + this.getHttpPortNumber());
        }
        if (!filename.startsWith("/") && !filename.startsWith("\\")) {
            httpOptions.append("/");
        }
        httpOptions.append(filename).append("' URL ");
        if (this.getHttpServerProxy().length() > 0) {
            httpOptions.append(this.getHttpServerProxy());
        }
        httpOptions.append(this.getHttpServerUserPass());
        return httpOptions.toString();
    }

    public String getUserPass(Connection tcp, boolean encode) throws MdException, RemoteException {
        String authType = tcp.getAuthenticationType();
        if (authType != null && authType.equalsIgnoreCase("none")) {
            return "";
        }
        AuthenticationDomain domain = tcp.getDomain();
        if (domain == null) {
            return "";
        }
        if (!LibraryUtil.isApplicationUsingAuthDomainForPasswords()) {
            PasswordAuthentication pw = Workspace.getWorkspace().getConnectionManager().getLogin(domain.getName());
            if (pw != null) {
                return AccessMethodUtil.getBestLoginString(pw);
            }
        } else {
            return " AuthDomain=\"" + domain.getName() + "\"";
        }
        return "";
    }

    public static String getBestLoginString(PasswordAuthentication pw) {
        String strBestLogin = "";
        if (pw != null) {
            if (pw.getUserName() != null && pw.getUserName().length() != 0) {
                strBestLogin = " USER='" + pw.getUserName() + "' ";
            }
            if (pw.getPassword() != null && pw.getPassword().length != 0) {
                String pass = new String(pw.getPassword());
                try {
                    pass = SasPasswordString.encode((String)"sas002", (String)pass);
                }
                catch (SasPasswordEncodingException sasPasswordEncodingException) {
                    // empty catch block
                }
                strBestLogin = strBestLogin + " PASS='" + pass + "'";
            }
        }
        return strBestLogin;
    }

    public static String getBestLoginString(Login iLogin, boolean b_encodePassword) throws MdException, RemoteException {
        String strBestLogin = "";
        if (iLogin != null) {
            if (iLogin.getUserID() != null && iLogin.getUserID().length() != 0) {
                strBestLogin = " USER='" + iLogin.getUserID() + "' ";
            }
            if (iLogin.getPassword() != null && iLogin.getPassword().length() != 0) {
                String pw = iLogin.getPassword();
                if (b_encodePassword) {
                    try {
                        String tmpPwString;
                        pw = tmpPwString = SasPasswordString.encode((String)"sas002", (String)pw);
                    }
                    catch (SasPasswordEncodingException sasPasswordEncodingException) {
                        // empty catch block
                    }
                }
                strBestLogin = strBestLogin + " PASS='" + pw + "'";
            }
        }
        return strBestLogin;
    }
}

