/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.imsmc.visuals;

import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPasswordField;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import javax.swing.JLabel;
import javax.swing.JTextArea;

public class InternalLoginPasswordChangePanel
extends WAPropertyTab {
    private static final long serialVersionUID = 1L;
    private static final WAdminResource bundle = new WAdminResource(InternalLoginPasswordChangePanel.class);
    private String m_parentTitleString = "";
    private WATextField m_userIDField;
    private WAPasswordField m_oldPasswordField;
    private WAPasswordField m_passwordField;
    private WAPasswordField m_confirmPasswordField;
    private String m_internalUserID;
    private boolean m_isCreatingNewAccount;
    private boolean m_isUserChangingOwnPassword;

    public InternalLoginPasswordChangePanel(String internalUserID, boolean isCreatingNewAccount, boolean isUserChangingOwnPassword, String parentTitleString) {
        this.m_parentTitleString = parentTitleString;
        this.m_internalUserID = internalUserID;
        this.m_isCreatingNewAccount = isCreatingNewAccount;
        this.m_isUserChangingOwnPassword = isUserChangingOwnPassword;
        this._initialize();
        this._layoutWidgets();
    }

    protected void _initialize() {
        this.setHelpTopic(bundle.getString("InternalLoginPasswordChangePanel.HelpTopic.txt.notrans"));
        this.m_userIDField = new WATextField(this.m_internalUserID);
        this.m_userIDField.setMaxCharacters(128);
        this.m_userIDField.setEditable(false);
        this.m_userIDField.setEditable(false);
        this.m_userIDField.setToolTipText(bundle.getString("LoginPropertyView.m_userIDField.Tooltip.txt"));
        this.m_oldPasswordField = new WAPasswordField(22);
        this.m_oldPasswordField.setToolTipText(bundle.getString("InternalLoginPasswordChangePanel.m_oldPasswordField.Tooltip.txt"));
        this.m_passwordField = new WAPasswordField(22);
        this.m_passwordField.setToolTipText(bundle.getString("LoginPropertyView.m_passwordField.Tooltip.txt"));
        this.m_confirmPasswordField = new WAPasswordField(22);
        this.m_confirmPasswordField.setToolTipText(bundle.getString("LoginPropertyView.m_confirmPasswordField.Tooltip.txt"));
        this.listenForDataChangesTo(this.m_userIDField);
        this.listenForDataChangesTo(this.m_passwordField);
        this.listenForDataChangesTo(this.m_oldPasswordField);
        this.listenForDataChangesTo(this.m_confirmPasswordField);
    }

    protected void _layoutWidgets() {
        JLabel pwdLabel;
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        Insets labelInsets = new Insets(8, 7, 4, 7);
        Insets fieldInsets = new Insets(3, 12, 4, 7);
        int row = 0;
        JTextArea text = new JTextArea(bundle.getString("InternalLoginPasswordChangeExplanation.txt"));
        text.setEditable(false);
        text.setFocusable(false);
        text.setWrapStyleWord(true);
        text.setAutoscrolls(true);
        text.setBackground(SystemColor.control);
        text.setRows(2);
        JLabel tempLabel = new JLabel("");
        text.setFont(tempLabel.getFont());
        this.add((Component)text, new GridBagConstraints(0, row++, 2, 1, 1.0, 1.0, 18, 2, labelInsets, 0, 0));
        JLabel userIDLabel = new JLabel(bundle.getString("InternalLoginPropertyView.Label.m_userIDField.txt"));
        userIDLabel.setDisplayedMnemonic(bundle.getString("InternalLoginPropertyView.LoginPropertyView.Label.m_userIDField.mnem").charAt(0));
        userIDLabel.setLabelFor(this.m_userIDField);
        this.add((Component)userIDLabel, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 18, 0, labelInsets, 0, 0));
        this.add((Component)this.m_userIDField, new GridBagConstraints(1, row++, 2, 1, 1.0, 0.0, 18, 2, fieldInsets, 0, 0));
        if (this.m_isUserChangingOwnPassword) {
            pwdLabel = new JLabel(bundle.getString("InternalLoginPasswordChangePanel.Label.m_oldPasswordField.txt"));
            pwdLabel.setDisplayedMnemonic(bundle.getString("InternalLoginPasswordChangePanel.Label.m_oldPasswordField.txt").charAt(0));
            pwdLabel.setLabelFor(this.m_oldPasswordField);
            this.add((Component)pwdLabel, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 18, 0, labelInsets, 0, 0));
            this.add((Component)this.m_oldPasswordField, new GridBagConstraints(1, row++, 2, 1, 1.0, 0.0, 18, 2, fieldInsets, 0, 0));
        }
        pwdLabel = new JLabel(bundle.getString("InternalLoginPropertyView.Label.m_passwordField.txt"));
        pwdLabel.setDisplayedMnemonic(bundle.getString("LoginPropertyView.Label.m_passwordField.mnem").charAt(0));
        pwdLabel.setLabelFor(this.m_passwordField);
        this.add((Component)pwdLabel, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 18, 0, labelInsets, 0, 0));
        this.add((Component)this.m_passwordField, new GridBagConstraints(1, row++, 2, 1, 1.0, 0.0, 18, 2, fieldInsets, 0, 0));
        JLabel cpwdLabel = new JLabel(bundle.getString("LoginPropertyView.Label.m_confirmPasswordField.txt"));
        cpwdLabel.setDisplayedMnemonic(bundle.getString("LoginPropertyView.Label.m_confirmPasswordField.mnem").charAt(0));
        cpwdLabel.setLabelFor(this.m_confirmPasswordField);
        this.add((Component)cpwdLabel, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 18, 0, labelInsets, 0, 0));
        this.add((Component)this.m_confirmPasswordField, new GridBagConstraints(1, row, 2, 1, 1.0, 0.0, 18, 2, fieldInsets, 0, 0));
        this.add((Component)this.m_confirmPasswordField, new GridBagConstraints(1, row++, 2, 1, 1.0, 0.0, 18, 2, fieldInsets, 0, 0));
    }

    public String getNewPassword() {
        String ret = this.m_passwordField.getText();
        return ret;
    }

    public char[] getPasswordChars() {
        return this.m_passwordField.getPassword();
    }

    public String getOldPassword() {
        String ret = this.m_oldPasswordField.getText();
        return ret;
    }

    @Override
    public boolean validateData() {
        if (this.m_isCreatingNewAccount && this.m_passwordField.getText().trim().length() == 0) {
            String errMsg = bundle.getString("InternalLoginPropertyView.Password.Error.txt");
            MessageUtil.displayMessage(errMsg, this.m_parentTitleString, 0, -1);
            this.m_passwordField.requestFocus();
            return false;
        }
        if (!this.m_passwordField.getText().trim().equals(this.m_confirmPasswordField.getText().trim())) {
            String errMsg = bundle.getString("LoginPropertyView.confirmPassword.Error.txt");
            MessageUtil.displayMessage(errMsg, this.m_parentTitleString, 0, -1);
            this.m_passwordField.requestFocus();
            return false;
        }
        return true;
    }

    @Override
    public boolean doDataExchange(boolean saveToModel) {
        if (saveToModel) {
            // empty if block
        }
        return true;
    }
}

