/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.imsmc.visuals;

import com.sas.visuals.Resources;
import com.sas.workspace.imsmc.ApplicationResource;
import com.sas.workspace.imsmc.model.MessageHandler;
import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.net.URL;
import java.util.Hashtable;
import javax.swing.ImageIcon;
import javax.swing.UIManager;

public class ImageHandler {
    protected static Applet m_applet;
    protected static MessageHandler m_messages;
    protected static Hashtable m_imageCache;

    public ImageHandler() {
    }

    public ImageHandler(MessageHandler messages) {
        m_messages = messages;
    }

    public ImageHandler(Applet applet, MessageHandler messages) {
        m_applet = applet;
        m_messages = messages;
    }

    public static ImageIcon getImageIcon(ApplicationResource bundle, String strName) {
        URL url;
        ImageIcon returnValue = null;
        String strIconFileName = bundle.getString(strName);
        String strIconPath = bundle.getString("ImageLocation.notrans") + strIconFileName;
        if (m_imageCache == null) {
            m_imageCache = new Hashtable();
        } else {
            returnValue = (ImageIcon)m_imageCache.get(strIconPath);
            if (returnValue != null) {
                return returnValue;
            }
        }
        if (returnValue != null) {
            m_imageCache.put(strIconPath, returnValue);
            return returnValue;
        }
        Exception cacheException = null;
        try {
            url = ClassLoader.getSystemResource(strIconPath);
            returnValue = new ImageIcon(url);
        }
        catch (Exception e) {
            cacheException = e;
        }
        if (returnValue == null) {
            try {
                returnValue = Resources.getImageIcon((String)strIconFileName);
            }
            catch (Exception e) {
                cacheException = e;
            }
        }
        if (returnValue == null) {
            try {
                strIconPath = UIManager.getSystemLookAndFeelClassName();
                strIconPath = strIconPath.substring(0, strIconPath.lastIndexOf(46));
                strIconPath = strIconPath + ".icons.";
                strIconPath = strIconPath.replace('.', '/');
                url = ClassLoader.getSystemResource(strIconPath + strName);
                returnValue = new ImageIcon(url);
            }
            catch (Exception e) {
                if (cacheException != null) {
                    cacheException.printStackTrace();
                }
                cacheException = e;
            }
        }
        if (returnValue == null && cacheException != null) {
            System.out.println("exception " + cacheException);
            if (m_messages != null) {
                m_messages.addInternalError(bundle.messageString("ImageHandler.loadImage.fmt.txt", strIconPath, cacheException.toString()));
            }
        }
        if (returnValue != null) {
            m_imageCache.put(strIconPath, returnValue);
        }
        return returnValue;
    }

    public static Applet getApplet(Component source) {
        Container parent;
        for (parent = source.getParent(); parent != null && !(parent instanceof Applet); parent = parent.getParent()) {
        }
        return (Applet)parent;
    }
}

