/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.imsmc.model;

import com.sas.workspace.imsmc.model.PropertyChangeHandler;
import java.util.Vector;

public class ModelChangeEvent {
    private int m_structureAreasChanged = 0;
    private int m_structureTypesChanged = 0;
    private int m_dataAreasChanged = 0;
    private transient Vector m_structureChangeList = new Vector();
    private transient Vector m_dataChangeList = new Vector();
    protected Object m_value;

    public void addDataChanges(PropertyChangeHandler.DataChangeInfo info) {
        this.m_dataChangeList.addElement(info);
        this.m_dataAreasChanged |= info.area;
    }

    public void addStructureChanges(PropertyChangeHandler.StructureChangeInfo info) {
        this.m_structureChangeList.addElement(info);
        this.m_structureAreasChanged |= info.area;
        this.m_structureTypesChanged |= info.type;
        this.m_value = info.newValue;
    }

    public boolean isDataChange() {
        return this.m_dataChangeList.size() > 0;
    }

    public int getNumberOfDataChanges() {
        return this.m_dataChangeList.size();
    }

    public Object getDataChangedObject(int index) {
        return ((PropertyChangeHandler.DataChangeInfo)this.m_dataChangeList.elementAt((int)index)).oldValue;
    }

    public Object getDataChangedSource(int index) {
        return ((PropertyChangeHandler.DataChangeInfo)this.m_dataChangeList.elementAt((int)index)).source;
    }

    public boolean isStructureChange() {
        return this.m_structureChangeList.size() > 0;
    }

    public int getNumberOfStructureChanges() {
        return this.m_structureChangeList.size();
    }

    public Object getStructureChangeObject(int index) {
        return ((PropertyChangeHandler.StructureChangeInfo)this.m_structureChangeList.elementAt((int)index)).newValue;
    }

    public Object getStructureChangeSource(int index) {
        return ((PropertyChangeHandler.StructureChangeInfo)this.m_structureChangeList.elementAt((int)index)).source;
    }

    public boolean didThisStructureAreaChange(int area) {
        return (this.m_structureAreasChanged & area) != 0;
    }

    public boolean didThisDataAreaChange(int area) {
        return (this.m_dataAreasChanged & area) != 0;
    }

    public boolean didOnlyThisStructureAreaChange(int area) {
        return this.m_structureAreasChanged == area;
    }

    public boolean didOnlyThisDataAreaChange(int area) {
        return this.m_dataAreasChanged == area;
    }

    public boolean didThisStructureTypeChange(int type) {
        return (this.m_structureTypesChanged & type) != 0;
    }

    public boolean didOnlyThisStructureTypeChange(int type) {
        return this.m_structureTypesChanged == type;
    }

    public Object getObject(int area, int type) {
        return this.m_value;
    }

    public Object getOldValueForDataChangeObject(Object source) {
        for (int index = 0; index < this.m_dataChangeList.size(); ++index) {
            PropertyChangeHandler.DataChangeInfo info = (PropertyChangeHandler.DataChangeInfo)this.m_dataChangeList.elementAt(index);
            if (info.source != source) continue;
            return info.oldValue;
        }
        return null;
    }
}

