/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.changemanagement;

import com.sas.metadata.Util;
import com.sas.metadata.remote.MdException;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.Workspace;
import com.sas.workspace.changemanagement.CMEvent;
import com.sas.workspace.changemanagement.CMEventListener;
import com.sas.workspace.models.SimpleObject;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CMListenerManager {
    private static CMListenerManager s_instance;
    private Map m_mapPrimaryObjectsCreated = new LinkedHashMap(10);
    private Map m_mapPrimaryObjectsUpdated = new LinkedHashMap(10);
    private Map m_mapPrimaryObjectsDeleted = new LinkedHashMap(10);
    private Map m_mapProjectObjectsCreated = new LinkedHashMap(10);
    private Map m_mapProjectObjectsUpdated = new LinkedHashMap(10);
    private Map m_mapProjectObjectsDeleted = new LinkedHashMap(10);
    private Map m_mapPrimayToProjectOnCheckout = new LinkedHashMap(10);
    private List m_lListeners = new ArrayList();

    public static CMListenerManager getInstance() {
        if (s_instance == null) {
            s_instance = new CMListenerManager();
        }
        return s_instance;
    }

    private CMListenerManager() {
    }

    public void populateCheckOutMaps(Document iDoc) {
        this.clearAllMaps();
        this.m_mapPrimayToProjectOnCheckout.clear();
        Node newNode = iDoc.getFirstChild().getFirstChild();
        NodeList newNodeList = newNode.getChildNodes();
        int newNodeListLength = newNodeList.getLength();
        if (newNodeListLength == 0) {
            return;
        }
        NodeList tempNodeList = newNodeList;
        if (tempNodeList.item(0).getNodeName().equals("UpdatedObjects")) {
            newNodeList = tempNodeList.item(0).getChildNodes();
        } else if (tempNodeList.item(0).getNodeName().equals("DeletedObjects")) {
            return;
        }
        int length = newNodeList.getLength();
        for (int i = 0; i < length; ++i) {
            String strType = newNodeList.item(i).getNodeName();
            NamedNodeMap newNodeMap = newNodeList.item(i).getAttributes();
            if (newNodeMap.getNamedItem("Id") == null) continue;
            String strNewId = newNodeMap.getNamedItem("Id").getNodeValue();
            this.m_mapProjectObjectsCreated.put(strNewId, strType);
            String strChangeState = null;
            try {
                strChangeState = newNodeMap.getNamedItem("ChangeState").getNodeValue();
                if (!strChangeState.startsWith("Checkout")) continue;
                String strCSId = strChangeState.substring(strChangeState.indexOf(":") + 2);
                this.m_mapPrimaryObjectsUpdated.put(strCSId, strType);
                this.m_mapPrimayToProjectOnCheckout.put(strCSId, strNewId);
                this.m_mapPrimayToProjectOnCheckout.put(strNewId, strCSId);
                continue;
            }
            catch (Exception e) {
                Workspace.getDefaultLogger().error("Missing changestate on checkout");
            }
        }
    }

    public void populateCheckInMaps(Document iDoc, List l_ExistingObjects, String sCheckInObjectID, String sObjectType) {
        this.clearAllMaps();
        Node newNode = iDoc.getFirstChild().getFirstChild();
        NodeList newNodeList = newNode.getChildNodes();
        int newNodeListLength = newNodeList.getLength();
        if (newNodeListLength == 0) {
            return;
        }
        NodeList tempNodeList = newNodeList;
        if (tempNodeList.item(0).getNodeName().equals("UpdatedObjects")) {
            newNodeList = tempNodeList.item(0).getChildNodes();
        } else if (tempNodeList.item(0).getNodeName().equals("DeletedObjects")) {
            return;
        }
        int length = newNodeList.getLength();
        this.m_mapProjectObjectsDeleted.put(sCheckInObjectID, sObjectType);
        for (int i = 0; i < length; ++i) {
            String strType = newNodeList.item(i).getNodeName();
            NamedNodeMap newNodeMap = newNodeList.item(i).getAttributes();
            if (newNodeMap.getNamedItem("Id") == null) continue;
            String strNewId = newNodeMap.getNamedItem("Id").getNodeValue();
            if (l_ExistingObjects.contains(strNewId)) {
                this.m_mapPrimaryObjectsUpdated.put(strNewId, strType);
                continue;
            }
            this.m_mapPrimaryObjectsCreated.put(strNewId, strType);
        }
    }

    public void populateCheckInMaps(Document iDoc, List l_ExistingObjects, SimpleObject[] aObjects) {
        this.clearAllMaps();
        Node newNode = iDoc.getFirstChild().getFirstChild();
        NodeList newNodeList = newNode.getChildNodes();
        int newNodeListLength = newNodeList.getLength();
        if (newNodeListLength == 0) {
            return;
        }
        NodeList tempNodeList = newNodeList;
        if (tempNodeList.item(0).getNodeName().equals("UpdatedObjects")) {
            newNodeList = tempNodeList.item(0).getChildNodes();
        } else if (tempNodeList.item(0).getNodeName().equals("DeletedObjects")) {
            return;
        }
        int length = newNodeList.getLength();
        String sCheckInObjectID = "";
        String sObjectType = "";
        for (int iObject = 0; iObject < aObjects.length; ++iObject) {
            SimpleObject aObject = aObjects[iObject];
            sCheckInObjectID = aObject.getID();
            sObjectType = aObject.getMetadataType();
            this.m_mapProjectObjectsDeleted.put(sCheckInObjectID, sObjectType);
        }
        for (int i = 0; i < length; ++i) {
            String strType = newNodeList.item(i).getNodeName();
            NamedNodeMap newNodeMap = newNodeList.item(i).getAttributes();
            if (newNodeMap.getNamedItem("Id") == null) continue;
            String strNewId = newNodeMap.getNamedItem("Id").getNodeValue();
            if (l_ExistingObjects.contains(strNewId)) {
                this.m_mapPrimaryObjectsUpdated.put(strNewId, strType);
                continue;
            }
            this.m_mapPrimaryObjectsCreated.put(strNewId, strType);
        }
    }

    public void populateCheckInDeleteMaps(Document iDoc) {
        this.m_mapPrimaryObjectsDeleted.clear();
        Node newNode = iDoc.getFirstChild().getFirstChild();
        NodeList newNodeList = newNode.getChildNodes();
        int newNodeListLength = newNodeList.getLength();
        if (newNodeListLength == 0) {
            return;
        }
        NodeList tempNodeList = newNodeList;
        for (int j = 0; j < newNodeListLength; ++j) {
            if (!tempNodeList.item(j).getNodeName().equals("DeletedObjects")) continue;
            newNodeList = tempNodeList.item(j).getChildNodes();
            int length = newNodeList.getLength();
            for (int i = 0; i < length; ++i) {
                String strType = newNodeList.item(i).getNodeName();
                NamedNodeMap newNodeMap = newNodeList.item(i).getAttributes();
                if (newNodeMap.getNamedItem("Id") == null) continue;
                String strNewId = newNodeMap.getNamedItem("Id").getNodeValue();
                this.m_mapPrimaryObjectsDeleted.put(strNewId, strType);
            }
        }
    }

    public void populateUndoCheckOutMaps(Document iDoc) {
        this.clearAllMaps();
        Node newNode = iDoc.getFirstChild().getFirstChild();
        NodeList newNodeList = newNode.getChildNodes();
        int newNodeListLength = newNodeList.getLength();
        if (newNodeListLength == 0) {
            return;
        }
        NodeList tempNodeList = newNodeList;
        if (tempNodeList.item(0).getNodeName().equals("UpdatedObjects")) {
            newNodeList = tempNodeList.item(0).getChildNodes();
        } else if (tempNodeList.item(0).getNodeName().equals("DeletedObjects")) {
            return;
        }
        int length = newNodeList.getLength();
        for (int i = 0; i < length; ++i) {
            String strType = newNodeList.item(i).getNodeName();
            NamedNodeMap newNodeMap = newNodeList.item(i).getAttributes();
            if (newNodeMap.getNamedItem("Id") == null) continue;
            String strNewId = newNodeMap.getNamedItem("Id").getNodeValue();
            this.m_mapProjectObjectsDeleted.put(strNewId, strType);
            String strChangeState = null;
            try {
                strChangeState = newNodeMap.getNamedItem("ChangeState").getNodeValue();
                if (!strChangeState.startsWith("Checkout")) continue;
                String strCSId = strChangeState.substring(strChangeState.indexOf(":") + 2);
                this.m_mapPrimaryObjectsUpdated.put(strCSId, strType);
                continue;
            }
            catch (Exception e) {
                Workspace.getDefaultLogger().error("Missing changestate from undocheckout");
            }
        }
    }

    public void populateClearDeletedProjectMaps(Document iDoc) {
        this.clearAllMaps();
        Node newNode = iDoc.getFirstChild().getFirstChild();
        NodeList newNodeList = newNode.getChildNodes();
        int newNodeListLength = newNodeList.getLength();
        if (newNodeListLength == 0) {
            return;
        }
        NodeList tempNodeList = newNodeList;
        if (tempNodeList.item(0).getNodeName().equals("UpdatedObjects")) {
            newNodeList = tempNodeList.item(0).getChildNodes();
        } else if (tempNodeList.item(0).getNodeName().equals("DeletedObjects")) {
            return;
        }
        int length = newNodeList.getLength();
        for (int i = 0; i < length; ++i) {
            String strType = newNodeList.item(i).getNodeName();
            NamedNodeMap newNodeMap = newNodeList.item(i).getAttributes();
            if (newNodeMap.getNamedItem("Id") == null) continue;
            String strNewId = newNodeMap.getNamedItem("Id").getNodeValue();
            this.m_mapPrimaryObjectsUpdated.put(strNewId, strType);
        }
    }

    private void clearAllMaps() {
        this.m_mapPrimaryObjectsCreated.clear();
        this.m_mapPrimaryObjectsUpdated.clear();
        this.m_mapPrimaryObjectsDeleted.clear();
        this.m_mapProjectObjectsCreated.clear();
        this.m_mapProjectObjectsUpdated.clear();
        this.m_mapProjectObjectsDeleted.clear();
    }

    public Map getPrimaryObjectsCreated() {
        return this.m_mapPrimaryObjectsCreated;
    }

    public Map getPrimaryObjectsUpdated() {
        return this.m_mapPrimaryObjectsUpdated;
    }

    public Map getPrimaryObjectsDeleted() {
        return this.m_mapPrimaryObjectsDeleted;
    }

    public Map getProjectObjectsCreated() {
        return this.m_mapProjectObjectsCreated;
    }

    public Map getProjectObjectsUpdated() {
        return this.m_mapProjectObjectsUpdated;
    }

    public Map getProjectObjectsDeleted() {
        return this.m_mapProjectObjectsDeleted;
    }

    public Map getPrimaryToProjectMap() {
        return this.m_mapPrimayToProjectOnCheckout;
    }

    public void addChangeListener(CMEventListener listener) {
        this.m_lListeners.add(listener);
    }

    public void removeChangeListener(CMEventListener listener) {
        this.m_lListeners.remove(listener);
    }

    public void fireCMObjectsCreated(CMEvent event) {
        for (int iListener = this.m_lListeners.size() - 1; iListener >= 0; --iListener) {
            CMEventListener listener = (CMEventListener)this.m_lListeners.get(iListener);
            listener.CMObjectsCreated(event);
        }
    }

    public void fireCMObjectsUpdated(CMEvent event) {
        for (int iListener = this.m_lListeners.size() - 1; iListener >= 0; --iListener) {
            CMEventListener listener = (CMEventListener)this.m_lListeners.get(iListener);
            listener.CMObjectsUpdated(event);
        }
    }

    public void fireCMObjectsDeleted(CMEvent event) {
        for (int iListener = this.m_lListeners.size() - 1; iListener >= 0; --iListener) {
            CMEventListener listener = (CMEventListener)this.m_lListeners.get(iListener);
            listener.CMObjectsDeleted(event);
        }
    }

    public void checkInDeletedObject(String sID, String sType) {
        try {
            StringBuffer sbXML = new StringBuffer();
            int flags = 1032;
            sbXML.append("<CheckinLogical><Metadata>");
            sbXML.append("<").append(sType);
            sbXML.append(" ID=\"").append(sID).append("\"/>");
            sbXML.append("</Metadata>");
            sbXML.append("<ProjectReposid>").append(Workspace.getWorkspace().getProjectRepository().getFQID()).append("</ProjectReposid>");
            sbXML.append("<ChangeName>").append("CheckInDeleted").append("</ChangeName>");
            sbXML.append("<ChangeDesc>").append("").append("</ChangeDesc>");
            sbXML.append("<Ns>SAS</Ns>");
            sbXML.append("<Flags>").append(flags).append("</Flags>");
            sbXML.append("<Options/></CheckinLogical>");
            Util.printLogln((String)("Checkin XML: " + sbXML.toString()));
            try {
                Document ioutDoc = Workspace.getMdFactory().getOMIUtil().DoRequest(sbXML.toString(), false);
                this.populateCheckInDeleteMaps(ioutDoc);
                this.fireCMObjectsDeleted(new CMEvent(ioutDoc, this.getPrimaryObjectsDeleted(), null, "CHECKIN"));
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage(e, "Checkingin");
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
    }
}

