/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.workspace.MessageUtil;
import com.sas.workspace.WATextComponent;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsBasicCaret;
import com.sas.workspace.WsComponentPrinter;
import com.sas.workspace.WsComponentPrinterFactory;
import com.sas.workspace.WsLimitedPlainDocument;
import com.sas.workspace.WsPopupMenuRequestListener;
import com.sas.workspace.WsTitledPageFormat;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class WsTextComponentAdapter
implements FocusListener {
    private static final WAdminResource bundle = WAdminResource.getBundle(WsTextComponentAdapter.class);
    public static final int NORMAL_BEHAVIOR = 0;
    public static final int LABEL_BEHAVIOR = 1;
    public static final int NEVEREDITABLE_BEHAVIOR = 2;
    protected int m_eBehavior = 0;
    protected JTextComponent m_cmpText;
    protected WATextComponent m_cmpWAText;
    private WsPopupMenuRequestListener m_lsnrPopup;
    private boolean m_bPopupMenuEnabled;
    private boolean m_bPrintable;
    private String m_sPrintTitle;
    private WsAbstractAction m_actCut;
    private WsAbstractAction m_actCopy;
    private WsAbstractAction m_actPaste;
    private WsAbstractAction m_actSelectAll;
    private WsAbstractAction m_actPrint;
    private WsAbstractAction m_actPopupMenu;

    public WsTextComponentAdapter(JTextComponent cmpText) {
        this.m_cmpText = cmpText;
        this.m_cmpWAText = (WATextComponent)((Object)cmpText);
        this.m_cmpText.addFocusListener(this);
        this.m_cmpText.addCaretListener(new TextComponentSelectionListener());
        this.m_cmpText.addMouseListener(new PopupTriggerMouseListener());
        this.m_cmpText.addPropertyChangeListener(new TextComponentPropertyChangeListener());
        this.m_actCut = new cCutAction();
        this.m_actCopy = new cCopyAction();
        this.m_actPaste = new cPasteAction();
        this.m_actSelectAll = new cSelectAllAction();
        this.m_actPrint = new cPrintAction();
        this.m_actPopupMenu = new cPopupMenuAction();
        this.m_cmpText.getActionMap().put("contextmenu", this.m_actPopupMenu);
        this.m_cmpText.getActionMap().put("print", this.m_actPrint);
        this.m_cmpText.getInputMap().put(KeyStroke.getKeyStroke(121, 1), "contextmenu");
        this.m_cmpText.getInputMap().put(KeyStroke.getKeyStroke(80, 2), "print");
        this.setPopupMenuRequestListener(new DefaultPopupMenuRequestListener());
        this.setPopupMenuEnabled(true);
        this.setPrintable(false);
    }

    @Override
    public void focusLost(FocusEvent e) {
        Document doc = this.m_cmpText.getDocument();
        if (doc instanceof WsLimitedPlainDocument) {
            ((WsLimitedPlainDocument)doc).hideMessage();
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    public void setFocusViaKeyboard(boolean bFocusViaKeyboard) {
    }

    public void setBehavior(int eBehavior) {
        if (this.m_eBehavior == eBehavior) {
            return;
        }
        this.m_eBehavior = eBehavior;
        switch (eBehavior) {
            case 0: {
                this.m_cmpText.setEditable(true);
                this.m_cmpWAText.setFocusable(true);
                this.m_cmpText.setBackground(UIManager.getColor(this.m_cmpWAText.getPropertyPrefix() + ".background"));
                break;
            }
            case 2: {
                this.m_cmpText.setEditable(false);
                this.m_cmpWAText.setFocusable(true);
                this.m_cmpText.setBackground(null);
                break;
            }
            case 1: {
                this.m_cmpText.setEditable(false);
                this.m_cmpWAText.setFocusable(false);
                this.m_cmpText.setBackground(null);
            }
        }
    }

    public int getBehavior() {
        return this.m_eBehavior;
    }

    public boolean isSelectionVisibleWhenUnfocused() {
        Caret caret = this.m_cmpText.getCaret();
        if (caret instanceof WsBasicCaret) {
            return ((WsBasicCaret)caret).isSelectionVisibleWhenUnfocused();
        }
        return false;
    }

    public void setSelectionVisibleWhenUnfocused(boolean bVisible) {
        Caret caret = this.m_cmpText.getCaret();
        if (caret instanceof WsBasicCaret) {
            ((WsBasicCaret)caret).setSelectionVisibleWhenUnfocused(bVisible);
        }
    }

    public void setPopupMenuEnabled(boolean bEnabled) {
        this.m_bPopupMenuEnabled = bEnabled;
    }

    public boolean isPopupMenuEnabled() {
        return this.m_bPopupMenuEnabled;
    }

    public void setPrintable(boolean bPrintable) {
        this.m_bPrintable = bPrintable;
        this.m_actPrint.setEnabled(this.m_cmpText.isEnabled() && bPrintable);
    }

    public boolean isPrintable() {
        return this.m_bPrintable;
    }

    public void setPrintTitle(String sTitle) {
        this.m_sPrintTitle = sTitle;
    }

    public String getPrintTitle() {
        return this.m_sPrintTitle;
    }

    public void setPopupMenuRequestListener(WsPopupMenuRequestListener lsnrPopup) {
        this.m_lsnrPopup = lsnrPopup;
    }

    public WsPopupMenuRequestListener getPopupMenuListener() {
        return this.m_lsnrPopup;
    }

    public JPopupMenu createDefaultPopupMenu() {
        JPopupMenu menuPopup = new JPopupMenu();
        menuPopup.add(this.m_actCut);
        menuPopup.add(this.m_actCopy);
        menuPopup.add(this.m_actPaste);
        menuPopup.addSeparator();
        menuPopup.add(this.m_actSelectAll);
        if (this.m_bPrintable) {
            menuPopup.addSeparator();
            menuPopup.add(this.m_actPrint);
        }
        return menuPopup;
    }

    public void print() {
        this.print(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(PageFormat page) {
        try {
            String sTitle = this.getPrintTitle();
            if (sTitle == null) {
                sTitle = bundle.getString("WsTextComponentAdapter.DefaultPrintTitle.txt");
            }
            if (page == null) {
                page = new WsTitledPageFormat(sTitle);
            }
            JTextComponent txtPrint = (JTextComponent)this.m_cmpText.getClass().newInstance();
            txtPrint.setFont(this.m_cmpText.getFont());
            txtPrint.setDocument(this.m_cmpText.getDocument());
            WsComponentPrinter printer = WsComponentPrinterFactory.createComponentPrinter(txtPrint, page);
            try {
                PrinterJob pjob = PrinterJob.getPrinterJob();
                if (!Workspace.getWorkspace().isPrinterConnected(pjob)) {
                    return;
                }
                pjob.setJobName(sTitle);
                pjob.setPageable(printer);
                if (pjob.printDialog()) {
                    pjob.print();
                }
            }
            catch (PrinterException ex) {
                MessageUtil.displayMessage(ex.getLocalizedMessage(), bundle.getString("WsTextComponentAdapter.PrintErrorTitle.txt"), 0);
            }
            finally {
                printer.dispose();
            }
        }
        catch (IllegalAccessException ex) {
            MessageUtil.displayMessage(ex.getLocalizedMessage(), bundle.getString("WsTextComponentAdapter.PrintErrorTitle.txt"), 0);
        }
        catch (InstantiationException ex) {
            MessageUtil.displayMessage(ex.getLocalizedMessage(), bundle.getString("WsTextComponentAdapter.PrintErrorTitle.txt"), 0);
        }
    }

    private void updateActions() {
        boolean bSelectedText = this.m_cmpText.getSelectedText() != null;
        boolean bEditable = this.m_cmpText.isEditable();
        boolean bEnabled = this.m_cmpText.isEnabled();
        this.m_actCopy.setEnabled(bEnabled && bSelectedText);
        this.m_actCut.setEnabled(bEnabled && bEditable && bSelectedText);
        this.m_actPaste.setEnabled(bEnabled && bEditable);
        this.m_actSelectAll.setEnabled(bEnabled);
        this.m_actPrint.setEnabled(bEnabled && this.m_bPrintable);
        this.m_actPopupMenu.setEnabled(bEnabled && this.m_bPopupMenuEnabled);
    }

    private class TextComponentSelectionListener
    implements CaretListener {
        private TextComponentSelectionListener() {
        }

        @Override
        public void caretUpdate(CaretEvent ev) {
            WsTextComponentAdapter.this.updateActions();
        }
    }

    private class PopupTriggerMouseListener
    extends MouseAdapter {
        private PopupTriggerMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent ev) {
            if (ev.isPopupTrigger()) {
                this.triggerPopup(ev);
            }
        }

        @Override
        public void mouseReleased(MouseEvent ev) {
            if (ev.isPopupTrigger()) {
                this.triggerPopup(ev);
            }
        }

        private void triggerPopup(MouseEvent ev) {
            if (WsTextComponentAdapter.this.m_cmpText.isEnabled() && WsTextComponentAdapter.this.m_cmpText.isFocusable() && WsTextComponentAdapter.this.m_bPopupMenuEnabled && WsTextComponentAdapter.this.m_lsnrPopup != null) {
                WsTextComponentAdapter.this.m_lsnrPopup.popupMenuRequested(ev);
            }
        }
    }

    private class TextComponentPropertyChangeListener
    implements PropertyChangeListener {
        private TextComponentPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            if (ev.getPropertyName().equals("editable") || ev.getPropertyName().equals("enabled")) {
                WsTextComponentAdapter.this.updateActions();
            }
        }
    }

    protected class cCutAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public cCutAction() {
            super(bundle, "WsTextComponentAdapter.Action.Cut", 2);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(88, 2));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            WsTextComponentAdapter.this.m_cmpText.cut();
        }
    }

    protected class cCopyAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public cCopyAction() {
            super(bundle, "WsTextComponentAdapter.Action.Copy", 2);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, 2));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            WsTextComponentAdapter.this.m_cmpText.copy();
        }
    }

    protected class cPasteAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public cPasteAction() {
            super(bundle, "WsTextComponentAdapter.Action.Paste", 2);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(86, 2));
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            WsTextComponentAdapter.this.m_cmpText.paste();
        }
    }

    protected class cSelectAllAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public cSelectAllAction() {
            super(bundle, "WsTextComponentAdapter.Action.SelectAll", 1);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(65, 2));
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            WsTextComponentAdapter.this.m_cmpText.selectAll();
        }
    }

    protected class cPrintAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public cPrintAction() {
            super(bundle, "WsTextComponentAdapter.Action.Print", 2);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(80, 2));
            this.setMenuSupportId("print");
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            WsTextComponentAdapter.this.print();
        }
    }

    private class cPopupMenuAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        private cPopupMenuAction() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            if (WsTextComponentAdapter.this.m_lsnrPopup != null && WsTextComponentAdapter.this.m_bPopupMenuEnabled) {
                int yCaret;
                int xCaret;
                try {
                    Point ptCaret = WsTextComponentAdapter.this.m_cmpText.modelToView(WsTextComponentAdapter.this.m_cmpText.getCaretPosition()).getLocation();
                    xCaret = ptCaret.x;
                    yCaret = ptCaret.y;
                }
                catch (BadLocationException ex) {
                    xCaret = 0;
                    yCaret = 0;
                }
                WsTextComponentAdapter.this.m_lsnrPopup.popupMenuRequested(new MouseEvent(WsTextComponentAdapter.this.m_cmpText, 0, ev.getWhen(), 0, xCaret, yCaret, 0, true));
            }
        }
    }

    private class DefaultPopupMenuRequestListener
    implements WsPopupMenuRequestListener {
        private DefaultPopupMenuRequestListener() {
        }

        @Override
        public void popupMenuRequested(MouseEvent ev) {
            WsTextComponentAdapter.this.createDefaultPopupMenu().show(WsTextComponentAdapter.this.m_cmpText, ev.getX(), ev.getY());
        }
    }
}

