/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.swing.visuals.tableview.BasicTableViewUI;
import com.sas.swing.visuals.tableview.NavigationalAction;
import com.sas.swing.visuals.tableview.TableView;
import com.sas.workspace.WsTable;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;

public class WsTableUI
extends BasicTableViewUI {
    protected boolean m_bMouseBlockSelectionEnabled;
    protected boolean m_bMultipleSelectionDragEnabled;

    public static ComponentUI createUI(JComponent h) {
        return new WsTableUI();
    }

    protected MouseInputListener createMouseInputListener() {
        return new cMouseInputHandlerExt();
    }

    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    protected void installKeyboardActions() {
        super.installKeyboardActions();
        ActionMap mapActions = this.table.getActionMap();
        mapActions.put("selectNextColumnCell", (Action)((Object)new cNoWrapNavigationalAction(1, 0, true, false, true)));
        mapActions.put("selectPreviousColumnCell", (Action)((Object)new cNoWrapNavigationalAction(-1, 0, true, false, true)));
        mapActions.put("selectNextRowCell", (Action)((Object)new cNoWrapNavigationalAction(0, 1, true, false, true)));
        mapActions.put("selectPreviousRowCell", (Action)((Object)new cNoWrapNavigationalAction(0, -1, true, false, true)));
        mapActions.put("delete", new DeleteAction());
        mapActions.put("enter", new EnterAction());
        InputMap mapKeys = this.table.getInputMap();
        mapKeys.put(KeyStroke.getKeyStroke(10, 0), "enter");
        mapKeys.put(KeyStroke.getKeyStroke(127, 0), "delete");
    }

    protected void installDefaults() {
        super.installDefaults();
        this.m_bMouseBlockSelectionEnabled = true;
    }

    public void setMouseBlockSelectionEnabled(boolean bEnabled) {
        this.m_bMouseBlockSelectionEnabled = bEnabled;
    }

    public boolean isMouseBlockSelectionEnabled() {
        return this.m_bMouseBlockSelectionEnabled;
    }

    public void setMultipleSelectionDragEnabled(boolean bEnabled) {
        this.m_bMultipleSelectionDragEnabled = bEnabled;
    }

    public boolean isMultipleSelectionDragEnabled() {
        return this.m_bMultipleSelectionDragEnabled;
    }

    protected class cMouseInputHandlerExt
    extends BasicTableViewUI.MouseInputHandler {
        protected boolean m_bPossibleEditRequest;
        protected int m_iPressedOnColumn;
        protected int m_iPressedOnRow;

        protected cMouseInputHandlerExt() {
            super((BasicTableViewUI)WsTableUI.this);
        }

        public void mousePressed(MouseEvent e) {
            WsTable tbl;
            Action act;
            if (e.getClickCount() == 2 && (act = (tbl = (WsTable)WsTableUI.this.table).getDefaultAction()) != null) {
                act.actionPerformed(new ActionEvent(e.getSource(), 1001, "default"));
                return;
            }
            if (!WsTableUI.this.table.isEnabled()) {
                return;
            }
            if (SwingUtilities.isLeftMouseButton(e)) {
                Point pt = e.getPoint();
                int iRow = WsTableUI.this.table.rowAtPoint(pt);
                int iCol = WsTableUI.this.table.columnAtPoint(pt);
                boolean bl = this.m_bPossibleEditRequest = iCol != -1 && iRow != -1 && WsTableUI.this.table.isCellSelected(iRow, iCol) && WsTableUI.this.table.getSelectedCellCount() == 1;
                if (this.m_bPossibleEditRequest) {
                    this.m_iPressedOnColumn = iCol;
                    this.m_iPressedOnRow = iRow;
                }
            }
            if (WsTableUI.this.isMultipleSelectionDragEnabled() && e.getClickCount() == 1 && this.isMoreThanOneSelected() && !e.isControlDown() && !e.isShiftDown() && this.isPointSelected(e.getPoint())) {
                WsTableUI.this.table.requestFocus();
            } else {
                if (!WsTableUI.this.table.getCellAreaRect().contains(e.getPoint())) {
                    if (!((WsTable)WsTableUI.this.table).stopCellEditing()) {
                        return;
                    }
                    WsTableUI.this.table.clearSelection();
                }
                super.mousePressed(e);
            }
        }

        public void mouseDragged(MouseEvent e) {
            if (this.m_bPossibleEditRequest) {
                Point pt = e.getPoint();
                int iRow = WsTableUI.this.table.rowAtPoint(pt);
                int iCol = WsTableUI.this.table.columnAtPoint(pt);
                if (iCol != this.m_iPressedOnColumn || iRow != this.m_iPressedOnRow) {
                    this.m_bPossibleEditRequest = false;
                }
            }
            if (WsTableUI.this.m_bMouseBlockSelectionEnabled) {
                super.mouseDragged(e);
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (this.m_bPossibleEditRequest) {
                this.m_bPossibleEditRequest = false;
                if (!e.isConsumed() && SwingUtilities.isLeftMouseButton(e) && WsTableUI.this.table.isEnabled()) {
                    Point pt = e.getPoint();
                    int iRow = WsTableUI.this.table.rowAtPoint(pt);
                    int iCol = WsTableUI.this.table.columnAtPoint(pt);
                    if (iCol == this.m_iPressedOnColumn && iRow == this.m_iPressedOnRow) {
                        WsTableUI.this.table.editCellAt(iRow, iCol);
                    }
                }
            }
            if (WsTableUI.this.isMultipleSelectionDragEnabled() && this.isMoreThanOneSelected() && !e.isControlDown() && !e.isShiftDown() && this.isPointSelected(e.getPoint())) {
                MouseEvent ePressed = new MouseEvent((Component)e.getSource(), 501, e.getWhen(), e.getModifiers(), e.getX(), e.getY(), e.getClickCount(), false, e.getButton());
                super.mousePressed(ePressed);
            }
            super.mouseReleased(e);
        }

        protected boolean isMoreThanOneSelected() {
            WsTable tbl = (WsTable)WsTableUI.this.table;
            return tbl.getSelectedCellCount() > 1 || tbl.getSelectedRowCount() > 1 || tbl.getSelectedColumnCount() > 1;
        }

        protected boolean isPointSelected(Point pt) {
            WsTable tbl = (WsTable)WsTableUI.this.table;
            int iRow = tbl.rowAtPoint(pt);
            int iCol = tbl.columnAtPoint(pt);
            if (iRow == -1 || iCol == -1) {
                return false;
            }
            return tbl.isCellSelected(iRow, iCol) || tbl.isRowSelected(iRow) || tbl.isColumnSelected(iCol);
        }
    }

    protected class FocusHandler
    implements FocusListener {
        protected FocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent ev) {
            WsTableUI.this.table.repaint();
            WsTableUI.this.table.getRowHeader().repaint();
            WsTableUI.this.table.getColumnHeader().repaint();
        }

        @Override
        public void focusLost(FocusEvent ev) {
            WsTableUI.this.table.repaint();
            WsTableUI.this.table.getRowHeader().repaint();
            WsTableUI.this.table.getColumnHeader().repaint();
        }
    }

    protected class cNoWrapNavigationalAction
    extends NavigationalAction {
        private static final long serialVersionUID = 1L;

        public cNoWrapNavigationalAction(int iDX, int iDY, boolean bToggle, boolean bExtend, boolean bInSelection) {
            super(iDX, iDY, bToggle, bExtend, bInSelection);
        }

        public void actionPerformed(ActionEvent e) {
            TableView oTable = (TableView)e.getSource();
            if (oTable.getCellSelectionEnabled() && oTable.getSelectedCellCount() > 1 || oTable.getColumnSelectionAllowed() && oTable.getSelectedColumnCount() > 0 || oTable.getRowSelectionAllowed() && oTable.getSelectedRowCount() > 0) {
                super.actionPerformed(e);
                return;
            }
            int nRows = oTable.getRowCount();
            int nColumns = oTable.getColumnCount();
            int iAnchorRow = oTable.getCurrentRow();
            int iAnchorColumn = oTable.getCurrentColumn();
            if (this.dx == -1 && this.dy == 0 && iAnchorRow == 0 && iAnchorColumn == 0) {
                return;
            }
            if (this.dx == 1 && this.dy == 0 && iAnchorRow == nRows - 1 && iAnchorColumn == nColumns - 1) {
                return;
            }
            if (this.dx == 0 && this.dy == 1 && iAnchorRow == nRows - 1) {
                return;
            }
            if (this.dx == 0 && this.dy == -1 && iAnchorRow == 0) {
                return;
            }
            super.actionPerformed(e);
        }
    }

    private class DeleteAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private DeleteAction() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            WsTable tbl = (WsTable)WsTableUI.this.table;
            Action act = tbl.getDeleteKeyAction();
            if (act != null && act.isEnabled()) {
                act.actionPerformed(ev);
            }
        }
    }

    private class EnterAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private EnterAction() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            WsTable tbl = (WsTable)WsTableUI.this.table;
            Action act = tbl.getDefaultAction();
            if (act != null) {
                act.actionPerformed(ev);
            } else {
                act = tbl.getActionMap().get("selectNextRowCell");
                if (act != null) {
                    act.actionPerformed(ev);
                }
            }
        }
    }
}

