/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.workspace.DNDObject;
import com.sas.workspace.WATable;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsDefaultObjectListModel;
import com.sas.workspace.WsDefaultObjectsSelectionModel;
import com.sas.workspace.WsObjectListModel;
import com.sas.workspace.WsObjectListModelEvent;
import com.sas.workspace.WsObjectListModelListener;
import com.sas.workspace.WsObjectSelectionEvent;
import com.sas.workspace.WsObjectSelectionListener;
import com.sas.workspace.WsObjectsSelectionModel;
import com.sas.workspace.WsPopupMenuRequestListener;
import com.sas.workspace.WsSliderPane;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.EventListener;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.UIResource;
import javax.swing.table.JTableHeader;

public class WsTablePairingsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected Color m_clrLines;
    protected Color m_clrSelectedLines;
    protected int m_cxShaftLength = 6;
    protected int m_cxArrowHeadSize = 4;
    protected boolean m_bAutoSelect = true;
    protected boolean m_bDraggingFromSourceTableEnabled = true;
    protected boolean m_bDraggingFromTargetTableEnabled = true;
    protected boolean m_bDragging;
    protected WsPopupMenuRequestListener m_lsnrPopupMenuRequest = null;
    protected WsSliderPane m_sldrSource;
    protected WsSliderPane m_sldrTarget;
    protected cPairingLinesPanel m_pnlPairingLines;
    protected JSplitPane m_splInner;
    protected JSplitPane m_splOuter;
    protected int m_iSourceTable;
    protected int m_iTargetTable;
    protected WATable m_tblSource;
    protected WATable m_tblTarget;
    protected WsObjectListModel m_mdlPairings;
    protected WsObjectsSelectionModel m_mdlSelection;
    protected ArrayList m_alTableLinks;
    protected WsSliderPane m_sldrDragSource;
    protected WATable m_tblDragSource;
    protected int m_iDragSource;
    protected WATable m_tblDragTarget;
    protected int m_iDragTarget;
    protected boolean m_bDragFromSourceToTarget;
    protected AdjustmentListener m_lsnrScrollAdjustment;
    protected TableModelListener m_lsnrTableModel;
    protected MouseListener m_lsnrTableMouse;
    protected DragSourceListener m_lsnrDragSource;
    protected DropTargetListener m_lsnrDropTarget;
    protected DragGestureListener m_lsnrDragGesture;
    protected ListSelectionListener m_lsnrSourceTableRowSelection;
    protected ListSelectionListener m_lsnrTargetTableRowSelection;
    protected WsObjectSelectionListener m_lsnrPairingSelection;
    protected boolean m_bIgnoreSelectionEvents;
    private static WAdminResource bundle = WAdminResource.getBundle(WsTablePairingsPanel.class);

    public WsTablePairingsPanel() {
        this.initialize();
        this.layoutWidgets();
    }

    public void addSourceTable(String sTitle, WATable tblSource) {
        int iSource = this.m_sldrSource.getPanelCount();
        int nTargets = this.m_sldrTarget.getPanelCount();
        for (int iTarget = 0; iTarget < nTargets; ++iTarget) {
            this.m_alTableLinks.add(new cTableLink(iSource, iTarget));
        }
        tblSource.getSelectionModel().addListSelectionListener(this.m_lsnrSourceTableRowSelection);
        tblSource.setAutoscrolls(false);
        this.m_sldrSource.addPanel(sTitle, this.initializeTable(tblSource));
    }

    public void addTargetTable(String sTitle, WATable tblTarget) {
        int iTarget = this.m_sldrTarget.getPanelCount();
        int nSources = this.m_sldrSource.getPanelCount();
        for (int iSource = 0; iSource < nSources; ++iSource) {
            this.m_alTableLinks.add(new cTableLink(iSource, iTarget));
        }
        tblTarget.getSelectionModel().addListSelectionListener(this.m_lsnrTargetTableRowSelection);
        tblTarget.setAutoscrolls(false);
        this.m_sldrTarget.addPanel(sTitle, this.initializeTable(tblTarget));
    }

    public int getSourceTablesCount() {
        return this.m_sldrSource.getPanelCount();
    }

    public int getTargetTablesCount() {
        return this.m_sldrTarget.getPanelCount();
    }

    public int getSourceTableIndex() {
        return this.m_iSourceTable;
    }

    public void setSourceTableIndex(int iSourceTable) {
        this.m_sldrSource.setSelectedIndex(iSourceTable);
    }

    public WATable getSourceTable() {
        return this.m_tblSource;
    }

    public WATable getSourceTable(int iSourceTable) {
        JScrollPane scrSource = (JScrollPane)this.m_sldrSource.getPanelAt(iSourceTable);
        return (WATable)scrSource.getViewport().getView();
    }

    public int getTargetTableIndex() {
        return this.m_iTargetTable;
    }

    public void setTargetTableIndex(int iTargetTable) {
        this.m_sldrTarget.setSelectedIndex(iTargetTable);
    }

    public WATable getTargetTable() {
        return this.m_tblTarget;
    }

    public WATable getTargetTable(int iTargetTable) {
        JScrollPane scrTarget = (JScrollPane)this.m_sldrTarget.getPanelAt(iTargetTable);
        return (WATable)scrTarget.getViewport().getView();
    }

    public void removeSourceTable(int iSource) {
        JScrollPane scrSource = (JScrollPane)this.m_sldrSource.getPanelAt(iSource);
        WATable tblSource = (WATable)scrSource.getViewport().getView();
        this.removeTableListeners(scrSource, tblSource);
        tblSource.getSelectionModel().removeListSelectionListener(this.m_lsnrSourceTableRowSelection);
        this.m_sldrSource.removePanelAt(iSource);
        int nTargets = this.m_sldrTarget.getPanelCount();
        for (int iTarget = 0; iTarget < nTargets; ++iTarget) {
            int iLink = this.indexOfTableLink(iSource, iTarget);
            this.m_alTableLinks.remove(iLink);
        }
    }

    public void removeTargetTable(int iTarget) {
        JScrollPane scrTarget = (JScrollPane)this.m_sldrTarget.getPanelAt(iTarget);
        WATable tblTarget = (WATable)scrTarget.getViewport().getView();
        this.removeTableListeners(scrTarget, tblTarget);
        tblTarget.getSelectionModel().removeListSelectionListener(this.m_lsnrTargetTableRowSelection);
        this.m_sldrTarget.removePanelAt(iTarget);
        int nSources = this.m_sldrSource.getPanelCount();
        for (int iSource = 0; iSource < nSources; ++iSource) {
            int iLink = this.indexOfTableLink(iSource, iTarget);
            this.m_alTableLinks.remove(iLink);
        }
    }

    public void removeAllTables() {
        this.m_sldrSource.removeAllPanels();
        this.m_sldrTarget.removeAllPanels();
        this.m_alTableLinks.clear();
    }

    protected void removeTableListeners(JScrollPane scr, WATable tbl) {
        scr.getVerticalScrollBar().removeAdjustmentListener(this.m_lsnrScrollAdjustment);
        tbl.getModel().removeTableModelListener(this.m_lsnrTableModel);
        tbl.getSorter().removeTableModelListener(this.m_lsnrTableModel);
        tbl.removeMouseListener(this.m_lsnrTableMouse);
    }

    protected JScrollPane initializeTable(WATable tbl) {
        tbl.getModel().addTableModelListener(this.m_lsnrTableModel);
        tbl.getSorter().addTableModelListener(this.m_lsnrTableModel);
        tbl.addMouseListener(this.m_lsnrTableMouse);
        DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(tbl, 2, this.m_lsnrDragGesture);
        this.createTableDropTarget(tbl);
        JScrollPane scr = new JScrollPane(tbl);
        scr.getVerticalScrollBar().addAdjustmentListener(this.m_lsnrScrollAdjustment);
        scr.setAutoscrolls(false);
        return scr;
    }

    protected void initialize() {
        Color clr;
        this.setBackground(UIManager.getColor("control"));
        this.m_clrLines = UIManager.getColor("controlText");
        this.m_clrSelectedLines = UIManager.getColor("textHighlight");
        float[] hsbLines = Color.RGBtoHSB(this.m_clrLines.getRed(), this.m_clrLines.getGreen(), this.m_clrLines.getBlue(), null);
        float[] hsbSelectedLines = Color.RGBtoHSB(this.m_clrSelectedLines.getRed(), this.m_clrSelectedLines.getGreen(), this.m_clrSelectedLines.getBlue(), null);
        while ((double)Math.abs(hsbLines[2] - hsbSelectedLines[2]) < 0.6 && !(clr = this.m_clrSelectedLines.brighter()).equals(this.m_clrSelectedLines)) {
            this.m_clrSelectedLines = clr;
            Color.RGBtoHSB(this.m_clrSelectedLines.getRed(), this.m_clrSelectedLines.getGreen(), this.m_clrSelectedLines.getBlue(), hsbSelectedLines);
        }
        this.m_pnlPairingLines = new cPairingLinesPanel();
        this.m_sldrSource = new WsSliderPane();
        this.m_sldrTarget = new WsSliderPane();
        this.m_sldrSource.addChangeListener(this.createSourceChangeListener());
        this.m_sldrTarget.addChangeListener(this.createTargetChangeListener());
        this.m_lsnrScrollAdjustment = this.createScrollAdjustmentListener();
        this.m_lsnrTableModel = this.createTableModelListener();
        this.m_lsnrTableMouse = this.createTableMouseListener();
        this.m_lsnrDragSource = this.createTableDragSourceListener();
        this.m_lsnrDropTarget = this.createTableDropTargetListener();
        this.m_lsnrSourceTableRowSelection = this.createSourceTableRowSelectionListener();
        this.m_lsnrTargetTableRowSelection = this.createTargetTableRowSelectionListener();
        this.m_lsnrPairingSelection = this.createPairingSelectionListener();
        this.m_lsnrDragGesture = this.createTableDragGestureListener();
        this.m_alTableLinks = new ArrayList();
        this.m_iSourceTable = -1;
        this.m_iTargetTable = -1;
    }

    protected void layoutWidgets() {
        this.m_sldrTarget.setMinimumSize(new Dimension(0, 100));
        this.m_pnlPairingLines.setMinimumSize(new Dimension(0, 100));
        this.m_sldrSource.setMinimumSize(new Dimension(0, 100));
        this.m_sldrTarget.setPreferredSize(new Dimension(200, 100));
        this.m_pnlPairingLines.setPreferredSize(new Dimension(100, 100));
        this.m_sldrSource.setPreferredSize(new Dimension(200, 100));
        this.m_splInner = new JSplitPane(1, this.m_sldrSource, this.m_pnlPairingLines);
        this.m_splOuter = new JSplitPane(1, this.m_splInner, this.m_sldrTarget);
        this.m_splOuter.setDividerLocation(0.6);
        this.m_splInner.setDividerLocation(0.6667);
        this.m_splOuter.setResizeWeight(0.6);
        this.m_splInner.setResizeWeight(0.6667);
        this.m_splInner.setBorder(null);
        this.m_splOuter.setBorder(new cMultiPanelSplitPaneBorder(UIManager.getColor("controlLtHighlight"), UIManager.getColor("controlDkShadow")));
        this.m_splInner.addPropertyChangeListener("dividerLocation", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                WsTablePairingsPanel.this.m_splOuter.repaint();
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_splOuter, "Center");
    }

    protected static WsObjectListModel createPairingsModel() {
        return new WsDefaultObjectListModel();
    }

    protected static WsObjectsSelectionModel createSelectionModel() {
        WsDefaultObjectsSelectionModel mdlSelection = new WsDefaultObjectsSelectionModel();
        mdlSelection.setSelectionMode(0);
        return mdlSelection;
    }

    protected AdjustmentListener createScrollAdjustmentListener() {
        return new cScrollAdjustmentListener();
    }

    protected TableModelListener createTableModelListener() {
        return new cTableModelListener();
    }

    protected MouseListener createTableMouseListener() {
        return new cTableMouseListener();
    }

    protected ChangeListener createSourceChangeListener() {
        return new cSourceChangeListener();
    }

    protected ChangeListener createTargetChangeListener() {
        return new cTargetChangeListener();
    }

    protected ListSelectionListener createSourceTableRowSelectionListener() {
        return new cTableRowSelectionListener(true);
    }

    protected ListSelectionListener createTargetTableRowSelectionListener() {
        return new cTableRowSelectionListener(false);
    }

    protected WsObjectSelectionListener createPairingSelectionListener() {
        return new cPairingSelectionListener();
    }

    protected DragGestureListener createTableDragGestureListener() {
        return new cTableDragGestureListener();
    }

    protected DragSourceListener createTableDragSourceListener() {
        return new cTableDragSourceListener();
    }

    protected DropTargetListener createTableDropTargetListener() {
        return new cTableDropTargetListener();
    }

    protected void createTableDropTarget(WATable tbl) {
        DropTarget target = new DropTarget(tbl, this.m_lsnrDropTarget);
        target.setActive(false);
        target.setDefaultActions(2);
    }

    public void setLinesColor(Color clrLines) {
        if (clrLines != this.m_clrLines) {
            this.m_clrLines = clrLines;
            this.m_pnlPairingLines.repaint();
        }
    }

    public Color getLinesColor() {
        return this.m_clrLines;
    }

    public void setSelectedLinesColor(Color clrSelectedLines) {
        if (clrSelectedLines != this.m_clrSelectedLines) {
            this.m_clrSelectedLines = clrSelectedLines;
            this.m_pnlPairingLines.repaint();
        }
    }

    public Color getSelectedLinesColor() {
        return this.m_clrSelectedLines;
    }

    public void setArrowHeadSize(int cxArrowHeadSize) {
        if (cxArrowHeadSize != this.m_cxArrowHeadSize) {
            this.m_cxArrowHeadSize = cxArrowHeadSize;
            this.m_pnlPairingLines.layoutPairings();
            this.m_pnlPairingLines.repaint();
        }
    }

    public int getArrowHeadSize() {
        return this.m_cxArrowHeadSize;
    }

    public void setShaftLength(int cxShaftLength) {
        if (cxShaftLength != this.m_cxShaftLength) {
            this.m_cxShaftLength = cxShaftLength;
            this.m_pnlPairingLines.layoutPairings();
            this.m_pnlPairingLines.repaint();
        }
    }

    public int getShaftLength() {
        return this.m_cxShaftLength;
    }

    public boolean isAutoSelectEnabled() {
        return this.m_bAutoSelect;
    }

    public void setAutoSelectEnabled(boolean bAutoSelect) {
        this.m_bAutoSelect = bAutoSelect;
    }

    public boolean isDragging() {
        return this.m_bDragging;
    }

    protected int indexOfTableLink(int iSourceTable, int iTargetTable) {
        int nTableLinks = this.m_alTableLinks.size();
        for (int iTableLink = 0; iTableLink < nTableLinks; ++iTableLink) {
            cTableLink link = (cTableLink)this.m_alTableLinks.get(iTableLink);
            if (!link.equals(iSourceTable, iTargetTable)) continue;
            return iTableLink;
        }
        return -1;
    }

    public WsObjectListModel getPairingsModel(int iSourceTable, int iTargetTable) {
        int iTableLink = this.indexOfTableLink(iSourceTable, iTargetTable);
        return ((cTableLink)this.m_alTableLinks.get(iTableLink)).getPairingsModel();
    }

    public void setPairingsModel(int iSourceTable, int iTargetTable, WsObjectListModel mdlPairings) {
        int iTableLink = this.indexOfTableLink(iSourceTable, iTargetTable);
        ((cTableLink)this.m_alTableLinks.get(iTableLink)).setPairingsModel(mdlPairings);
        if (this.m_iSourceTable == iSourceTable && this.m_iTargetTable == iTargetTable) {
            this.setPairingsModelImpl(mdlPairings);
        }
    }

    public WsObjectListModel getPairingsModel() {
        return this.m_mdlPairings;
    }

    public void setPairingsModel(WsObjectListModel mdlPairings) {
        this.setPairingsModel(this.m_iSourceTable, this.m_iTargetTable, mdlPairings);
    }

    protected void setPairingsModelImpl(WsObjectListModel mdlPairings) {
        if (this.m_mdlPairings != null) {
            this.m_mdlPairings.removeObjectListModelListener(this.m_pnlPairingLines);
        }
        this.m_mdlPairings = mdlPairings;
        this.m_pnlPairingLines.modelChanged();
        if (this.m_mdlPairings != null) {
            this.m_mdlPairings.addObjectListModelListener(this.m_pnlPairingLines);
        }
    }

    public WsObjectsSelectionModel getSelectionModel(int iSourceTable, int iTargetTable) {
        int iTableLink = this.indexOfTableLink(iSourceTable, iTargetTable);
        return ((cTableLink)this.m_alTableLinks.get(iTableLink)).getSelectionModel();
    }

    public void setSelectionModel(int iSourceTable, int iTargetTable, WsObjectsSelectionModel mdlSelection) {
        int iTableLink = this.indexOfTableLink(iSourceTable, iTargetTable);
        ((cTableLink)this.m_alTableLinks.get(iTableLink)).setSelectionModel(mdlSelection);
        if (this.m_iSourceTable == iSourceTable && this.m_iTargetTable == iTargetTable) {
            this.setSelectionModelImpl(mdlSelection);
        }
    }

    public WsObjectsSelectionModel getSelectionModel() {
        return this.m_mdlSelection;
    }

    public void setSelectionModel(WsObjectsSelectionModel mdlSelection) {
        this.setSelectionModel(this.m_iSourceTable, this.m_iTargetTable, mdlSelection);
    }

    protected void setSelectionModelImpl(WsObjectsSelectionModel mdlSelection) {
        if (this.m_mdlSelection != null) {
            this.m_mdlSelection.removeObjectSelectionListener(this.m_pnlPairingLines);
            this.m_mdlSelection.removeObjectSelectionListener(this.m_lsnrPairingSelection);
        }
        this.m_mdlSelection = mdlSelection;
        this.m_pnlPairingLines.repaint();
        if (this.m_mdlSelection != null) {
            this.m_mdlSelection.addObjectSelectionListener(this.m_pnlPairingLines);
            this.m_mdlSelection.addObjectSelectionListener(this.m_lsnrPairingSelection);
        }
    }

    public void setPopupMenuRequestListener(WsPopupMenuRequestListener lsnrPopupMenuRequest) {
        this.m_lsnrPopupMenuRequest = lsnrPopupMenuRequest;
    }

    public WsPopupMenuRequestListener getPopupMenuRequestListener() {
        return this.m_lsnrPopupMenuRequest;
    }

    protected void firePopupMenuRequestEvent(MouseEvent e) {
        if (this.m_lsnrPopupMenuRequest != null) {
            this.m_lsnrPopupMenuRequest.popupMenuRequested(e);
        }
    }

    public void setDraggingFromTargetTableEnabled(boolean bDraggingFromTargetTableEnabled) {
        this.m_bDraggingFromTargetTableEnabled = bDraggingFromTargetTableEnabled;
    }

    public boolean isDraggingFromTargetTableEnabled() {
        return this.m_bDraggingFromTargetTableEnabled;
    }

    public void setDraggingFromSourceTableEnabled(boolean bDraggingFromSourceTableEnabled) {
        this.m_bDraggingFromSourceTableEnabled = bDraggingFromSourceTableEnabled;
    }

    public boolean isDraggingFromSourceTableEnabled() {
        return this.m_bDraggingFromSourceTableEnabled;
    }

    protected int calculateRowY(WATable tbl, JPanel pnl, int iRow, int yMin, int yMax) {
        int iViewRow = tbl.convertRowIndexToView(iRow);
        Rectangle rect = tbl.getCellRect(iViewRow, 0, false);
        Point pt = new Point(0, rect.y);
        SwingUtilities.convertPointToScreen(pt, tbl);
        SwingUtilities.convertPointFromScreen(pt, pnl);
        int y = pt.y + rect.height / 2;
        return Math.min(Math.max(y, yMin), yMax);
    }

    public void addPairing(int iSourceTable, int iSourceRow, int iTargetTable, int iTargetRow) {
        this.addPairing(iSourceTable, iTargetTable, new cPairing(iSourceRow, iTargetRow));
    }

    public void addPairing(int iSourceTable, int iTargetTable, cPairing pairing) {
        this.getPairingsModel(iSourceTable, iTargetTable).add(pairing);
    }

    public void addPairings(int iSourceTable, int iTargetTable, ArrayList alPairings) {
        WsObjectListModel mdl = this.getPairingsModel(iSourceTable, iTargetTable);
        int nPairings = alPairings.size();
        for (int iPairing = 0; iPairing < nPairings; ++iPairing) {
            mdl.add(alPairings.get(iPairing));
        }
    }

    public boolean pairingExists(int iSourceTable, int iSourceRow, int iTargetTable, int iTargetRow) {
        return this.pairingExists(iSourceTable, iTargetTable, new cPairing(iSourceRow, iTargetRow));
    }

    public boolean pairingExists(int iSourceTable, int iSourceRow, cPairing testee) {
        return this.getRealPairing(iSourceTable, iSourceRow, testee) != null;
    }

    public cPairing getRealPairing(int iSourceTable, int iSourceRow, int iTargetTable, int iTargetRow) {
        return this.getRealPairing(iSourceTable, iTargetTable, new cPairing(iSourceRow, iTargetRow));
    }

    public cPairing getRealPairing(int iSourceTable, int iTargetTable, cPairing testee) {
        WsObjectListModel mdl = this.getPairingsModel(iSourceTable, iTargetTable);
        int nPairings = mdl.size();
        for (int iPairing = 0; iPairing < nPairings; ++iPairing) {
            cPairing tester = (cPairing)mdl.get(iPairing);
            if (!tester.equals(testee)) continue;
            return tester;
        }
        return null;
    }

    public int getPairingsCount(int iSourceTable, int iTargetTable) {
        return this.getPairingsModel(iSourceTable, iTargetTable).size();
    }

    public ArrayList getPairings(int iSourceTable, int iTargetTable) {
        WsObjectListModel mdl = this.getPairingsModel(iSourceTable, iTargetTable);
        int nPairings = mdl.size();
        ArrayList<Object> alPairings = new ArrayList<Object>(nPairings);
        for (int iPairing = 0; iPairing < nPairings; ++iPairing) {
            alPairings.add(mdl.get(iPairing));
        }
        return alPairings;
    }

    public void removePairing(int iSourceTable, int iSourceRow, int iTargetTable, int iTargetRow) {
        this.removePairing(iSourceTable, iTargetTable, new cPairing(iSourceRow, iTargetRow));
    }

    public void removePairing(int iSourceTable, int iTargetTable, cPairing pairing) {
        cPairing real = this.getRealPairing(iSourceTable, iTargetTable, pairing);
        if (this.m_iSourceTable == iSourceTable && this.m_iTargetTable == iTargetTable && this.m_mdlSelection.isObjectSelected(real)) {
            this.m_mdlSelection.deselectObject(real);
        }
        this.getPairingsModel(iSourceTable, iTargetTable).remove(real);
    }

    public void removeAllPairings(int iSourceTable, int iTargetTable) {
        if (this.m_iSourceTable == iSourceTable && this.m_iTargetTable == iTargetTable) {
            this.m_mdlSelection.deselectAllObjects();
        }
        this.getPairingsModel(iSourceTable, iTargetTable).removeAll();
    }

    public void addPairing(int iSource, int iTarget) {
        this.addPairing(new cPairing(iSource, iTarget));
    }

    public void addPairing(cPairing pairing) {
        this.m_mdlPairings.add(pairing);
    }

    public void addPairings(ArrayList alPairings) {
        int nPairings = alPairings.size();
        for (int iPairing = 0; iPairing < nPairings; ++iPairing) {
            this.m_mdlPairings.add(alPairings.get(iPairing));
        }
    }

    public boolean pairingExists(int iSource, int iTarget) {
        return this.pairingExists(new cPairing(iSource, iTarget));
    }

    public boolean pairingExists(cPairing testee) {
        return this.getRealPairing(testee) != null;
    }

    public cPairing getRealPairing(int iSource, int iTarget) {
        return this.getRealPairing(new cPairing(iSource, iTarget));
    }

    public cPairing getRealPairing(cPairing testee) {
        int nPairings = this.m_mdlPairings.size();
        for (int iPairing = 0; iPairing < nPairings; ++iPairing) {
            cPairing tester = (cPairing)this.m_mdlPairings.get(iPairing);
            if (!tester.equals(testee)) continue;
            return tester;
        }
        return null;
    }

    public int getPairingsCount() {
        if (this.m_mdlPairings == null) {
            return 0;
        }
        return this.m_mdlPairings.size();
    }

    public ArrayList getPairings() {
        if (this.m_mdlPairings == null) {
            return new ArrayList();
        }
        int nPairings = this.m_mdlPairings.size();
        ArrayList<Object> alPairings = new ArrayList<Object>(nPairings);
        for (int iPairing = 0; iPairing < nPairings; ++iPairing) {
            alPairings.add(this.m_mdlPairings.get(iPairing));
        }
        return alPairings;
    }

    public void removePairing(int iSource, int iTarget) {
        this.removePairing(new cPairing(iSource, iTarget));
    }

    public void removePairing(cPairing pairing) {
        cPairing real = this.getRealPairing(pairing);
        if (this.m_mdlSelection.isObjectSelected(real)) {
            this.m_mdlSelection.deselectObject(real);
        }
        this.m_mdlPairings.remove(real);
    }

    public void removeAllPairings() {
        this.m_mdlSelection.deselectAllObjects();
        this.m_mdlPairings.removeAll();
    }

    public boolean isPairingSelected(int iSource, int iTarget) {
        return this.isPairingSelected(new cPairing(iSource, iTarget));
    }

    public boolean isPairingSelected(cPairing pairing) {
        if (this.m_mdlSelection == null) {
            return false;
        }
        cPairing real = this.getRealPairing(pairing);
        if (real == null) {
            return false;
        }
        return this.m_mdlSelection.isObjectSelected(real);
    }

    public void selectPairing(int iSource, int iTarget) {
        this.selectPairing(new cPairing(iSource, iTarget));
    }

    public void selectPairing(cPairing pairing) {
        cPairing real = this.getRealPairing(pairing);
        if (real != null) {
            this.m_mdlSelection.selectObject(real);
        }
    }

    public ArrayList getSelectedPairings() {
        if (this.m_mdlSelection == null) {
            return new ArrayList();
        }
        return this.m_mdlSelection.getSelectedObjects();
    }

    public void deselectPairing(int iSource, int iTarget) {
        this.deselectPairing(new cPairing(iSource, iTarget));
    }

    public void deselectPairing(cPairing pairing) {
        if (this.m_mdlSelection == null) {
            return;
        }
        cPairing real = this.getRealPairing(pairing);
        if (real != null) {
            this.m_mdlSelection.deselectObject(real);
        }
    }

    public void deselectAllPairings() {
        if (this.m_mdlSelection == null) {
            return;
        }
        this.m_mdlSelection.deselectAllObjects();
    }

    public ArrayList findPairingsForRow(int iRow, boolean bSource) {
        return this.findPairingsForRow(this.m_iSourceTable, this.m_iTargetTable, iRow, bSource);
    }

    public ArrayList findPairingsForRow(int iSourceTable, int iTargetTable, int iRow, boolean bSource) {
        int iTableLink = this.indexOfTableLink(iSourceTable, iTargetTable);
        WsObjectListModel mdlPairings = ((cTableLink)this.m_alTableLinks.get(iTableLink)).getPairingsModel();
        ArrayList<cPairing> alPairings = new ArrayList<cPairing>();
        int nPairings = this.m_mdlPairings.size();
        for (int iPairing = 0; iPairing < nPairings; ++iPairing) {
            cPairing pairing = (cPairing)mdlPairings.get(iPairing);
            if (pairing.getValue(bSource) != iRow) continue;
            alPairings.add(pairing);
        }
        return alPairings;
    }

    public void addPairingEventListener(iPairingEventListener l) {
        this.listenerList.add(iPairingEventListener.class, l);
    }

    public void removePairingEventListener(iPairingEventListener l) {
        this.listenerList.add(iPairingEventListener.class, l);
    }

    protected void firePairingAddedEvent(cPairing pairing) {
        Object[] alListeners = this.listenerList.getListenerList();
        cPairingEvent e = null;
        for (int iListener = alListeners.length - 2; iListener >= 0; iListener -= 2) {
            if (alListeners[iListener] != iPairingEventListener.class) continue;
            if (e == null) {
                e = new cPairingEvent(this, 1, pairing);
            }
            ((iPairingEventListener)alListeners[iListener + 1]).pairingAdded(e);
        }
    }

    protected void firePairingRemovedEvent(cPairing pairing) {
        Object[] alListeners = this.listenerList.getListenerList();
        cPairingEvent e = null;
        for (int iListener = alListeners.length - 2; iListener >= 0; iListener -= 2) {
            if (alListeners[iListener] != iPairingEventListener.class) continue;
            if (e == null) {
                e = new cPairingEvent(this, 2, pairing);
            }
            ((iPairingEventListener)alListeners[iListener + 1]).pairingRemoved(e);
        }
    }

    public void addTableSelectionListener(iTableSelectionListener l) {
        this.listenerList.add(iTableSelectionListener.class, l);
    }

    public void removeTableSelectionListener(iTableSelectionListener l) {
        this.listenerList.add(iTableSelectionListener.class, l);
    }

    protected void fireTableSelectionEvent(boolean bSourceTable) {
        Object[] alListeners = this.listenerList.getListenerList();
        cTableSelectionEvent e = null;
        for (int iListener = alListeners.length - 2; iListener >= 0; iListener -= 2) {
            if (alListeners[iListener] != iTableSelectionListener.class) continue;
            if (e == null) {
                e = new cTableSelectionEvent(this, bSourceTable);
            }
            ((iTableSelectionListener)alListeners[iListener + 1]).tableSelected(e);
        }
    }

    protected static class cTableLink {
        protected int m_iSource;
        protected int m_iTarget;
        protected WsObjectListModel m_mdlPairings;
        protected WsObjectsSelectionModel m_mdlSelection;

        public cTableLink(int iSource, int iTarget) {
            this.m_iSource = iSource;
            this.m_iTarget = iTarget;
            this.m_mdlPairings = WsTablePairingsPanel.createPairingsModel();
            this.m_mdlSelection = WsTablePairingsPanel.createSelectionModel();
        }

        public boolean equals(int iSource, int iTarget) {
            return this.m_iSource == iSource && this.m_iTarget == iTarget;
        }

        public int hashcode() {
            return super.hashCode();
        }

        public WsObjectListModel getPairingsModel() {
            return this.m_mdlPairings;
        }

        public void setPairingsModel(WsObjectListModel mdlPairings) {
            this.m_mdlPairings = mdlPairings;
        }

        public WsObjectsSelectionModel getSelectionModel() {
            return this.m_mdlSelection;
        }

        public void setSelectionModel(WsObjectsSelectionModel mdlSelection) {
            this.m_mdlSelection = mdlSelection;
        }
    }

    protected class cPairingLinesPanel
    extends JPanel
    implements WsObjectSelectionListener,
    WsObjectListModelListener,
    DropTargetListener {
        private static final long serialVersionUID = 1L;
        protected ArrayList m_alPairingLines = new ArrayList();
        protected boolean m_bNeedToLayoutPairings = false;
        protected Point m_ptStart;
        protected Point m_ptCurrent;
        protected boolean m_bEraseRubberbandLine;
        protected boolean m_bFirstDragOver;

        public cPairingLinesPanel() {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    cPairingLinesPanel.this.selectPairings(e);
                    if (e.isPopupTrigger()) {
                        WsTablePairingsPanel.this.firePopupMenuRequestEvent(e);
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        WsTablePairingsPanel.this.firePopupMenuRequestEvent(e);
                    }
                }
            });
            DropTarget target = new DropTarget(this, this);
            target.setActive(false);
            target.setDefaultActions(2);
        }

        public void modelChanged() {
            this.m_alPairingLines.clear();
            WsObjectListModel mdlPairings = WsTablePairingsPanel.this.m_mdlPairings;
            int nPairings = mdlPairings.size();
            for (int iPairing = 0; iPairing < nPairings; ++iPairing) {
                this.m_alPairingLines.add(new cPairingLine((cPairing)mdlPairings.get(iPairing)));
            }
            this.layoutPairings();
            this.repaint();
        }

        @Override
        public void objectChangedSelection(WsObjectSelectionEvent e) {
            this.repaint();
        }

        @Override
        public void objectAdded(WsObjectListModelEvent e) {
            cPairingLine line = new cPairingLine((cPairing)e.getObject());
            this.m_alPairingLines.add(line);
            this.layoutPairing(line);
            this.repaint();
        }

        @Override
        public void objectRemoved(WsObjectListModelEvent e) {
            cPairingLine line = this.getPairingLine((cPairing)e.getObject());
            this.m_alPairingLines.remove(line);
            this.repaint();
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dim = new Dimension();
            dim.width = 2 * (WsTablePairingsPanel.this.m_cxShaftLength + WsTablePairingsPanel.this.m_cxArrowHeadSize) + 130;
            dim.height = 150;
            return dim;
        }

        @Override
        public void setBounds(int x, int y, int width, int height) {
            super.setBounds(x, y, width, height);
            this.m_bNeedToLayoutPairings = true;
        }

        @Override
        public void setBounds(Rectangle r) {
            super.setBounds(r);
            this.m_bNeedToLayoutPairings = true;
        }

        public void selectPairings(MouseEvent e) {
            if ((e.getModifiers() & 3) == 0) {
                WsTablePairingsPanel.this.m_mdlSelection.deselectAllObjects();
            }
            int nLines = this.m_alPairingLines.size();
            for (int iLine = 0; iLine < nLines; ++iLine) {
                cPairingLine line = (cPairingLine)this.m_alPairingLines.get(iLine);
                if (!line.hitTest(e.getPoint())) continue;
                if (!WsTablePairingsPanel.this.m_mdlSelection.isObjectSelected(line.getPairing())) {
                    WsTablePairingsPanel.this.m_mdlSelection.selectObject(line.getPairing());
                }
                if (WsTablePairingsPanel.this.m_mdlSelection.getSelectionMode() == 0) break;
            }
        }

        public void layoutPairings() {
            if (WsTablePairingsPanel.this.m_iSourceTable == -1 || WsTablePairingsPanel.this.m_iTargetTable == -1) {
                return;
            }
            int[] ysSource = this.calculateYMinMax(WsTablePairingsPanel.this.m_sldrSource, WsTablePairingsPanel.this.m_iSourceTable);
            int[] ysTarget = this.calculateYMinMax(WsTablePairingsPanel.this.m_sldrTarget, WsTablePairingsPanel.this.m_iTargetTable);
            int nLines = this.m_alPairingLines.size();
            for (int iLine = 0; iLine < nLines; ++iLine) {
                cPairingLine line = (cPairingLine)this.m_alPairingLines.get(iLine);
                line.layout(ysSource[0], ysSource[1], ysTarget[0], ysTarget[1]);
            }
            this.m_bNeedToLayoutPairings = false;
        }

        public void layoutPairing(cPairingLine line) {
            if (WsTablePairingsPanel.this.m_iSourceTable == -1 || WsTablePairingsPanel.this.m_iTargetTable == -1) {
                return;
            }
            int[] ysSource = this.calculateYMinMax(WsTablePairingsPanel.this.m_sldrSource, WsTablePairingsPanel.this.m_iSourceTable);
            int[] ysTarget = this.calculateYMinMax(WsTablePairingsPanel.this.m_sldrTarget, WsTablePairingsPanel.this.m_iTargetTable);
            line.layout(ysSource[0], ysSource[1], ysTarget[0], ysTarget[1]);
        }

        @Override
        public void paintComponent(Graphics g) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(WsTablePairingsPanel.this.m_clrLines);
            this.m_bEraseRubberbandLine = false;
            if (this.m_bNeedToLayoutPairings) {
                this.layoutPairings();
                this.m_bNeedToLayoutPairings = false;
            }
            if (WsTablePairingsPanel.this.m_iSourceTable == -1 || WsTablePairingsPanel.this.m_iTargetTable == -1) {
                return;
            }
            g.setColor(WsTablePairingsPanel.this.m_clrLines);
            int nLines = this.m_alPairingLines.size();
            for (int iLine = 0; iLine < nLines; ++iLine) {
                cPairingLine pairingInfo = (cPairingLine)this.m_alPairingLines.get(iLine);
                if (WsTablePairingsPanel.this.m_mdlSelection.isObjectSelected(pairingInfo.getPairing())) continue;
                pairingInfo.paint(g);
            }
            if (WsTablePairingsPanel.this.m_mdlSelection != null) {
                g.setColor(WsTablePairingsPanel.this.m_clrSelectedLines);
                ArrayList alSelectedPairings = WsTablePairingsPanel.this.m_mdlSelection.getSelectedObjects();
                int nPairings = alSelectedPairings.size();
                for (int iPairing = 0; iPairing < nPairings; ++iPairing) {
                    cPairing pairing = (cPairing)alSelectedPairings.get(iPairing);
                    this.getPairingLine(pairing).paint(g);
                }
            }
        }

        public cPairingLine getPairingLine(cPairing testee) {
            int nLines = this.m_alPairingLines.size();
            for (int iLine = 0; iLine < nLines; ++iLine) {
                cPairingLine line = (cPairingLine)this.m_alPairingLines.get(iLine);
                if (!line.getPairing().equals(testee)) continue;
                return line;
            }
            return null;
        }

        protected int[] calculateYMinMax(WsSliderPane sldrPanel, int iPanel) {
            int[] ys = new int[2];
            if (iPanel == -1) {
                Exception e = new Exception(bundle.getString("WsTablePairingsPanel.BadPanelNumber.msg.txt"));
                e.printStackTrace();
            }
            JScrollPane scr = (JScrollPane)sldrPanel.getPanelAt(iPanel);
            JScrollBar sbr = scr.getHorizontalScrollBar();
            WATable tbl = (WATable)scr.getViewport().getView();
            JTableHeader hdr = tbl.getTableHeader();
            Rectangle r = sldrPanel.getPanelBoundsAt(iPanel);
            int off = hdr != null ? hdr.getHeight() : WsTablePairingsPanel.this.m_cxArrowHeadSize - 1;
            ys[0] = r.y + off;
            off = sbr.isVisible() ? sbr.getHeight() + scr.getInsets().bottom : WsTablePairingsPanel.this.m_cxArrowHeadSize;
            ys[1] = r.y + r.height - off - 1;
            return ys;
        }

        @Override
        public void dragEnter(DropTargetDragEvent e) {
            if (WsTablePairingsPanel.this.m_iSourceTable == -1 || WsTablePairingsPanel.this.m_iTargetTable == -1) {
                return;
            }
            int[] ys = this.calculateYMinMax(WsTablePairingsPanel.this.m_sldrDragSource, WsTablePairingsPanel.this.m_iDragSource);
            int iRow = WsTablePairingsPanel.this.m_tblDragSource.getSelectedRow();
            int xStart = WsTablePairingsPanel.this.m_bDragFromSourceToTarget ? 0 : this.getWidth() - 1;
            int yStart = WsTablePairingsPanel.this.calculateRowY(WsTablePairingsPanel.this.m_tblDragSource, this, iRow, ys[0], ys[1]);
            this.m_ptStart = new Point(xStart, yStart);
            this.updateRubberbandLine(false, true, e.getLocation());
            e.acceptDrag(e.getSourceActions());
            this.m_bFirstDragOver = true;
        }

        @Override
        public void dragExit(DropTargetEvent e) {
            this.updateRubberbandLine(true, false, null);
        }

        @Override
        public void dragOver(DropTargetDragEvent e) {
            this.updateRubberbandLine(true, true, e.getLocation());
            if (this.m_bFirstDragOver) {
                e.acceptDrag(e.getSourceActions());
                this.m_bFirstDragOver = false;
            } else {
                e.rejectDrag();
            }
        }

        @Override
        public void drop(DropTargetDropEvent e) {
            this.updateRubberbandLine(true, false, null);
            e.rejectDrop();
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent e) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateRubberbandLine(boolean bErase, boolean bDraw, Point ptNewCurrent) {
            if (!bDraw && !this.m_bEraseRubberbandLine) {
                return;
            }
            Graphics g = this.getGraphics();
            try {
                g.setXORMode(this.getBackground());
                if (bErase && this.m_bEraseRubberbandLine) {
                    g.drawLine(this.m_ptStart.x, this.m_ptStart.y, this.m_ptCurrent.x, this.m_ptCurrent.y);
                }
                if (bDraw) {
                    this.m_ptCurrent = ptNewCurrent;
                    g.drawLine(this.m_ptStart.x, this.m_ptStart.y, this.m_ptCurrent.x, this.m_ptCurrent.y);
                    this.m_bEraseRubberbandLine = true;
                }
            }
            finally {
                g.dispose();
            }
        }
    }

    public static class cMultiPanelSplitPaneBorder
    implements Border,
    UIResource {
        protected Color highlight;
        protected Color shadow;

        public cMultiPanelSplitPaneBorder(Color clrHighlight, Color clrShadow) {
            this.highlight = clrHighlight;
            this.shadow = clrShadow;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            JSplitPane splitPane = (JSplitPane)c;
            g.setColor(c.getBackground());
            g.drawRect(x, y, width - 1, height - 1);
            if (splitPane.getOrientation() == 1) {
                Rectangle cBounds;
                ArrayList<Component> alSplits = new ArrayList<Component>();
                Component child = splitPane.getLeftComponent();
                while (child != null && child instanceof JSplitPane) {
                    alSplits.add(child);
                    child = ((JSplitPane)child).getLeftComponent();
                }
                if (child != null) {
                    cBounds = child.getBounds();
                    g.setColor(this.shadow);
                    g.drawLine(0, 0, cBounds.width + 1, 0);
                    g.drawLine(0, 1, 0, cBounds.height + 2);
                    g.setColor(this.highlight);
                    g.drawLine(1, cBounds.height + 1, cBounds.width + 1, cBounds.height + 1);
                }
                int nSplits = alSplits.size();
                for (int iSplit = 0; iSplit < nSplits; ++iSplit) {
                    JSplitPane split = (JSplitPane)alSplits.get(iSplit);
                    child = split.getRightComponent();
                    if (child == null) continue;
                    cBounds = child.getBounds();
                    g.setColor(this.shadow);
                    g.drawLine(cBounds.x, 0, cBounds.x + cBounds.width + 1, 0);
                    g.drawLine(cBounds.x, cBounds.height + 1, cBounds.x + 1, cBounds.height + 1);
                    g.setColor(this.highlight);
                    g.drawLine(cBounds.x + 1, cBounds.height + 1, cBounds.x + cBounds.width + 1, cBounds.height + 1);
                }
                child = splitPane.getRightComponent();
                if (child != null) {
                    cBounds = child.getBounds();
                    int maxX = cBounds.x + cBounds.width;
                    int maxY = cBounds.y + cBounds.height;
                    g.setColor(this.shadow);
                    g.drawLine(cBounds.x - 1, 0, maxX, 0);
                    g.drawLine(cBounds.x - 1, maxY, cBounds.x, maxY);
                    g.setColor(this.highlight);
                    g.drawLine(cBounds.x, maxY, maxX, maxY);
                    g.drawLine(maxX, 0, maxX, maxY + 1);
                }
            }
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(1, 1, 1, 1);
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }
    }

    protected class cScrollAdjustmentListener
    implements AdjustmentListener {
        protected cScrollAdjustmentListener() {
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent e) {
            WsTablePairingsPanel.this.m_pnlPairingLines.layoutPairings();
            WsTablePairingsPanel.this.m_pnlPairingLines.repaint();
        }
    }

    protected class cTableModelListener
    implements TableModelListener {
        protected cTableModelListener() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            WsTablePairingsPanel.this.m_pnlPairingLines.layoutPairings();
            WsTablePairingsPanel.this.m_pnlPairingLines.repaint();
        }
    }

    protected class cTableMouseListener
    extends MouseAdapter {
        protected cTableMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.selectCell(e);
                WsTablePairingsPanel.this.firePopupMenuRequestEvent(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.selectCell(e);
                WsTablePairingsPanel.this.firePopupMenuRequestEvent(e);
            }
        }

        protected void selectCell(MouseEvent e) {
            WATable tblSource = (WATable)e.getSource();
            int iRow = tblSource.rowAtPoint(e.getPoint());
            int iCol = tblSource.columnAtPoint(e.getPoint());
            if (iRow == -1 || iCol == -1) {
                return;
            }
            tblSource.changeSelection(iRow, iCol, e.isControlDown(), e.isShiftDown());
        }
    }

    protected class cSourceChangeListener
    implements ChangeListener {
        protected cSourceChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            JScrollPane scrSource = (JScrollPane)WsTablePairingsPanel.this.m_sldrSource.getSelectedPanel();
            WsTablePairingsPanel.this.m_tblSource = (WATable)scrSource.getViewport().getView();
            WsTablePairingsPanel.this.m_iSourceTable = WsTablePairingsPanel.this.m_sldrSource.getSelectedIndex();
            if (WsTablePairingsPanel.this.m_iSourceTable != -1 && WsTablePairingsPanel.this.m_iTargetTable != -1) {
                WsTablePairingsPanel.this.setPairingsModelImpl(WsTablePairingsPanel.this.getPairingsModel(WsTablePairingsPanel.this.m_iSourceTable, WsTablePairingsPanel.this.m_iTargetTable));
                WsTablePairingsPanel.this.setSelectionModelImpl(WsTablePairingsPanel.this.getSelectionModel(WsTablePairingsPanel.this.m_iSourceTable, WsTablePairingsPanel.this.m_iTargetTable));
                WsTablePairingsPanel.this.m_pnlPairingLines.layoutPairings();
                WsTablePairingsPanel.this.m_pnlPairingLines.repaint();
            }
            WsTablePairingsPanel.this.fireTableSelectionEvent(true);
        }
    }

    protected class cTargetChangeListener
    implements ChangeListener {
        protected cTargetChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            JScrollPane scrTarget = (JScrollPane)WsTablePairingsPanel.this.m_sldrTarget.getSelectedPanel();
            WsTablePairingsPanel.this.m_tblTarget = (WATable)scrTarget.getViewport().getView();
            WsTablePairingsPanel.this.m_iTargetTable = WsTablePairingsPanel.this.m_sldrTarget.getSelectedIndex();
            if (WsTablePairingsPanel.this.m_iSourceTable != -1 && WsTablePairingsPanel.this.m_iTargetTable != -1) {
                WsTablePairingsPanel.this.setPairingsModelImpl(WsTablePairingsPanel.this.getPairingsModel(WsTablePairingsPanel.this.m_iSourceTable, WsTablePairingsPanel.this.m_iTargetTable));
                WsTablePairingsPanel.this.setSelectionModelImpl(WsTablePairingsPanel.this.getSelectionModel(WsTablePairingsPanel.this.m_iSourceTable, WsTablePairingsPanel.this.m_iTargetTable));
                WsTablePairingsPanel.this.m_pnlPairingLines.layoutPairings();
                WsTablePairingsPanel.this.m_pnlPairingLines.repaint();
            }
            WsTablePairingsPanel.this.fireTableSelectionEvent(false);
        }
    }

    protected class cTableRowSelectionListener
    implements ListSelectionListener {
        protected boolean m_bSource;

        public cTableRowSelectionListener(boolean bSource) {
            this.m_bSource = bSource;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            WATable tblEventTarget;
            WATable tblEventSource;
            if (!WsTablePairingsPanel.this.m_bAutoSelect) {
                return;
            }
            if (WsTablePairingsPanel.this.m_bIgnoreSelectionEvents) {
                return;
            }
            WsTablePairingsPanel.this.m_bIgnoreSelectionEvents = true;
            if (this.m_bSource) {
                tblEventSource = WsTablePairingsPanel.this.m_tblSource;
                tblEventTarget = WsTablePairingsPanel.this.m_tblTarget;
            } else {
                tblEventSource = WsTablePairingsPanel.this.m_tblTarget;
                tblEventTarget = WsTablePairingsPanel.this.m_tblSource;
            }
            WsTablePairingsPanel.this.m_mdlSelection.deselectAllObjects();
            int[] aSelectedRows = tblEventSource.getSelectedRows();
            int nSelectedRows = aSelectedRows.length;
            for (int iSelectedRow = 0; iSelectedRow < nSelectedRows; ++iSelectedRow) {
                ArrayList alPairings = WsTablePairingsPanel.this.findPairingsForRow(aSelectedRows[iSelectedRow], this.m_bSource);
                int nPairings = alPairings.size();
                for (int iPairing = 0; iPairing < nPairings; ++iPairing) {
                    cPairing pairing = (cPairing)alPairings.get(iPairing);
                    int iEventTargetRow = tblEventTarget.convertRowIndexToView(pairing.getValue(!this.m_bSource));
                    if (!tblEventTarget.isRowSelected(iEventTargetRow)) continue;
                    WsTablePairingsPanel.this.m_mdlSelection.selectObject(pairing);
                }
            }
            WsTablePairingsPanel.this.m_bIgnoreSelectionEvents = false;
        }
    }

    protected class cPairingSelectionListener
    implements WsObjectSelectionListener {
        protected cPairingSelectionListener() {
        }

        @Override
        public void objectChangedSelection(WsObjectSelectionEvent e) {
            if (!WsTablePairingsPanel.this.m_bAutoSelect) {
                return;
            }
            if (WsTablePairingsPanel.this.m_bIgnoreSelectionEvents) {
                return;
            }
            WsTablePairingsPanel.this.m_bIgnoreSelectionEvents = true;
            cPairing pairing = (cPairing)e.getObject();
            int iSourceRow = WsTablePairingsPanel.this.m_tblSource.convertRowIndexToView(pairing.getSource());
            int iTargetRow = WsTablePairingsPanel.this.m_tblTarget.convertRowIndexToView(pairing.getTarget());
            if (e.isObjectSelected()) {
                WsTablePairingsPanel.this.m_tblSource.addRowSelectionInterval(iSourceRow, iSourceRow);
                WsTablePairingsPanel.this.m_tblTarget.addRowSelectionInterval(iTargetRow, iTargetRow);
            } else {
                WsTablePairingsPanel.this.m_tblSource.removeRowSelectionInterval(iSourceRow, iSourceRow);
                WsTablePairingsPanel.this.m_tblTarget.removeRowSelectionInterval(iTargetRow, iTargetRow);
            }
            WsTablePairingsPanel.this.m_bIgnoreSelectionEvents = false;
        }
    }

    protected class cTableDragGestureListener
    implements DragGestureListener {
        protected cTableDragGestureListener() {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent e) {
            WsTablePairingsPanel.this.m_tblDragSource = (WATable)e.getComponent();
            if (WsTablePairingsPanel.this.m_tblDragSource.getSelectedRow() == -1) {
                return;
            }
            if (WsTablePairingsPanel.this.m_tblDragSource.isEditing()) {
                return;
            }
            if (WsTablePairingsPanel.this.m_tblDragSource == WsTablePairingsPanel.this.m_tblSource) {
                if (!WsTablePairingsPanel.this.m_bDraggingFromSourceTableEnabled) {
                    return;
                }
                WsTablePairingsPanel.this.m_sldrDragSource = WsTablePairingsPanel.this.m_sldrSource;
                WsTablePairingsPanel.this.m_iDragSource = WsTablePairingsPanel.this.m_iSourceTable;
                WsTablePairingsPanel.this.m_iDragTarget = WsTablePairingsPanel.this.m_iTargetTable;
                WsTablePairingsPanel.this.m_tblDragTarget = WsTablePairingsPanel.this.m_tblTarget;
                WsTablePairingsPanel.this.m_bDragFromSourceToTarget = true;
            } else {
                if (!WsTablePairingsPanel.this.m_bDraggingFromTargetTableEnabled) {
                    return;
                }
                WsTablePairingsPanel.this.m_sldrDragSource = WsTablePairingsPanel.this.m_sldrTarget;
                WsTablePairingsPanel.this.m_iDragSource = WsTablePairingsPanel.this.m_iTargetTable;
                WsTablePairingsPanel.this.m_iDragTarget = WsTablePairingsPanel.this.m_iSourceTable;
                WsTablePairingsPanel.this.m_tblDragTarget = WsTablePairingsPanel.this.m_tblSource;
                WsTablePairingsPanel.this.m_bDragFromSourceToTarget = false;
            }
            WsTablePairingsPanel.this.m_pnlPairingLines.getDropTarget().setActive(true);
            WsTablePairingsPanel.this.m_tblDragTarget.getDropTarget().setActive(true);
            WsTablePairingsPanel.this.m_bDragging = true;
            e.getDragSource().startDrag(e, null, new DNDObject(), WsTablePairingsPanel.this.m_lsnrDragSource);
        }
    }

    protected class cTableDragSourceListener
    implements DragSourceListener {
        protected cTableDragSourceListener() {
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent e) {
            WsTablePairingsPanel.this.m_pnlPairingLines.getDropTarget().setActive(false);
            WsTablePairingsPanel.this.m_tblDragTarget.getDropTarget().setActive(false);
            WsTablePairingsPanel.this.m_bDragging = false;
        }

        @Override
        public void dragEnter(DragSourceDragEvent e) {
        }

        @Override
        public void dragExit(DragSourceEvent e) {
        }

        @Override
        public void dragOver(DragSourceDragEvent e) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent e) {
        }
    }

    protected class cTableDropTargetListener
    implements DropTargetListener {
        protected int m_iSourceRow;
        protected int m_iTargetRow;
        protected cPairing m_pairing;
        protected boolean m_bFirstDragOver;

        protected cTableDropTargetListener() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent e) {
            this.m_iSourceRow = WsTablePairingsPanel.this.m_tblDragSource.getSelectedRow();
            this.m_iTargetRow = WsTablePairingsPanel.this.m_tblDragTarget.convertRowIndexToModel(WsTablePairingsPanel.this.m_tblDragTarget.rowAtPoint(e.getLocation()));
            this.createDragPairing();
            if (this.m_pairing == null) {
                e.rejectDrag();
            } else {
                e.acceptDrag(e.getSourceActions());
            }
            this.m_bFirstDragOver = true;
        }

        @Override
        public void dragExit(DropTargetEvent e) {
            this.removeDragPairing();
            this.m_iTargetRow = -1;
        }

        @Override
        public void dragOver(DropTargetDragEvent e) {
            int iTargetRow = WsTablePairingsPanel.this.m_tblDragTarget.convertRowIndexToModel(WsTablePairingsPanel.this.m_tblDragTarget.rowAtPoint(e.getLocation()));
            if (iTargetRow != this.m_iTargetRow) {
                this.removeDragPairing();
                this.m_iTargetRow = iTargetRow;
                this.createDragPairing();
            }
            if (this.m_pairing == null && !this.m_bFirstDragOver) {
                e.rejectDrag();
            } else {
                e.acceptDrag(e.getSourceActions());
                this.m_bFirstDragOver = false;
            }
        }

        @Override
        public void drop(DropTargetDropEvent e) {
            int iTargetRow = WsTablePairingsPanel.this.m_tblDragTarget.convertRowIndexToModel(WsTablePairingsPanel.this.m_tblDragTarget.rowAtPoint(e.getLocation()));
            if (iTargetRow != this.m_iTargetRow) {
                this.removeDragPairing();
                this.m_iTargetRow = iTargetRow;
                this.createDragPairing();
            }
            if (this.m_pairing == null) {
                e.rejectDrop();
            } else {
                e.acceptDrop(e.getSourceActions());
                e.dropComplete(true);
                WsTablePairingsPanel.this.firePairingAddedEvent(this.m_pairing);
            }
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent e) {
        }

        protected void createDragPairing() {
            if (WsTablePairingsPanel.this.m_iDragTarget == -1) {
                return;
            }
            this.m_pairing = WsTablePairingsPanel.this.m_bDragFromSourceToTarget ? new cPairing(this.m_iSourceRow, this.m_iTargetRow) : new cPairing(this.m_iTargetRow, this.m_iSourceRow);
            if (!WsTablePairingsPanel.this.pairingExists(this.m_pairing)) {
                WsTablePairingsPanel.this.addPairing(this.m_pairing);
            } else {
                this.m_pairing = null;
            }
        }

        protected void removeDragPairing() {
            if (this.m_pairing != null) {
                WsTablePairingsPanel.this.removePairing(this.m_pairing);
                this.m_pairing = null;
            }
        }
    }

    public class cPairing {
        protected int m_iSource;
        protected int m_iTarget;

        public cPairing(int iSource, int iTarget) {
            this.m_iSource = iSource;
            this.m_iTarget = iTarget;
        }

        public boolean equals(cPairing other) {
            return this.m_iSource == other.m_iSource && this.m_iTarget == other.m_iTarget;
        }

        public int hashcode() {
            return super.hashCode();
        }

        public String toString() {
            return "cPairing(" + this.m_iSource + "," + this.m_iTarget + ")";
        }

        public int getSource() {
            return this.m_iSource;
        }

        public void setSource(int iSource) {
            this.m_iSource = iSource;
        }

        public int getTarget() {
            return this.m_iTarget;
        }

        public void setTarget(int iTarget) {
            this.m_iTarget = iTarget;
        }

        public int getValue(boolean bSource) {
            return bSource ? this.m_iSource : this.m_iTarget;
        }
    }

    public static interface iPairingEventListener
    extends EventListener {
        public void pairingAdded(cPairingEvent var1);

        public void pairingRemoved(cPairingEvent var1);
    }

    public class cPairingEvent
    extends AWTEvent {
        private static final long serialVersionUID = 1L;
        public static final int PAIRING_ADDED = 1;
        public static final int PAIRING_REMOVED = 2;
        protected cPairing m_pairing;

        public cPairingEvent(WsTablePairingsPanel src, int iEvent, cPairing pairing) {
            super(src, iEvent);
            this.m_pairing = pairing;
        }

        public cPairing getPairing() {
            return this.m_pairing;
        }
    }

    public static interface iTableSelectionListener
    extends EventListener {
        public void tableSelected(cTableSelectionEvent var1);
    }

    public class cTableSelectionEvent
    extends AWTEvent {
        private static final long serialVersionUID = 1L;
        public static final int TABLE_SELECTED = 1;
        protected boolean m_bSourceTable;

        public cTableSelectionEvent(WsTablePairingsPanel src, boolean bSourceTable) {
            super(src, 1);
            this.m_bSourceTable = bSourceTable;
        }

        public boolean isSourceTable() {
            return this.m_bSourceTable;
        }
    }

    protected class cPairingLine {
        protected cPairing m_pairing;
        protected int m_ySource;
        protected int m_yTarget;
        protected Polygon m_pgnHitTest = new Polygon();
        protected int[] m_xsSourceArrow = new int[4];
        protected int[] m_ysSourceArrow = new int[4];
        protected int[] m_xsSourceShaft = new int[4];
        protected int[] m_ysSourceShaft = new int[4];
        protected int[] m_xsTargetArrow = new int[4];
        protected int[] m_ysTargetArrow = new int[4];
        protected int[] m_ysTargetShaft = new int[4];
        protected int[] m_xsTargetShaft = new int[4];
        protected int[] m_xsConnector = new int[4];
        protected int[] m_ysConnector = new int[4];

        public cPairingLine(cPairing pairing) {
            this.m_pairing = pairing;
        }

        public cPairing getPairing() {
            return this.m_pairing;
        }

        public void layout(int ySourceMin, int ySourceMax, int yTargetMin, int yTargetMax) {
            this.m_ySource = WsTablePairingsPanel.this.calculateRowY(WsTablePairingsPanel.this.m_tblSource, WsTablePairingsPanel.this.m_pnlPairingLines, this.m_pairing.getSource(), ySourceMin, ySourceMax);
            this.m_yTarget = WsTablePairingsPanel.this.calculateRowY(WsTablePairingsPanel.this.m_tblTarget, WsTablePairingsPanel.this.m_pnlPairingLines, this.m_pairing.getTarget(), yTargetMin, yTargetMax);
            int xPanelTarget = WsTablePairingsPanel.this.m_pnlPairingLines.getWidth() - 1;
            int cxArrowOff = WsTablePairingsPanel.this.m_cxArrowHeadSize - 1;
            int cxShaftOff = WsTablePairingsPanel.this.m_cxShaftLength - 1;
            int[] xs = this.m_xsSourceArrow;
            int[] ys = this.m_ysSourceArrow;
            xs[0] = 0;
            ys[0] = this.m_ySource;
            xs[1] = cxArrowOff;
            ys[1] = this.m_ySource - cxArrowOff;
            xs[2] = cxArrowOff;
            ys[2] = this.m_ySource + cxArrowOff + 1;
            xs[3] = 0;
            ys[3] = this.m_ySource + 1;
            xs = this.m_xsSourceShaft;
            ys = this.m_ysSourceShaft;
            xs[0] = WsTablePairingsPanel.this.m_cxArrowHeadSize;
            ys[0] = this.m_ySource;
            xs[1] = WsTablePairingsPanel.this.m_cxArrowHeadSize + cxShaftOff;
            ys[1] = this.m_ySource;
            xs[2] = WsTablePairingsPanel.this.m_cxArrowHeadSize;
            ys[2] = this.m_ySource + 1;
            xs[3] = WsTablePairingsPanel.this.m_cxArrowHeadSize + cxShaftOff;
            ys[3] = this.m_ySource + 1;
            xs = this.m_xsTargetArrow;
            ys = this.m_ysTargetArrow;
            xs[0] = xPanelTarget;
            ys[0] = this.m_yTarget;
            xs[1] = xPanelTarget - cxArrowOff;
            ys[1] = this.m_yTarget - cxArrowOff;
            xs[2] = xPanelTarget - cxArrowOff;
            ys[2] = this.m_yTarget + cxArrowOff + 1;
            xs[3] = xPanelTarget;
            ys[3] = this.m_yTarget + 1;
            xs = this.m_xsTargetShaft;
            ys = this.m_ysTargetShaft;
            xs[0] = xPanelTarget - WsTablePairingsPanel.this.m_cxArrowHeadSize;
            ys[0] = this.m_yTarget;
            xs[1] = xPanelTarget - WsTablePairingsPanel.this.m_cxArrowHeadSize - cxShaftOff;
            ys[1] = this.m_yTarget;
            xs[2] = xPanelTarget - WsTablePairingsPanel.this.m_cxArrowHeadSize;
            ys[2] = this.m_yTarget + 1;
            xs[3] = xPanelTarget - WsTablePairingsPanel.this.m_cxArrowHeadSize - cxShaftOff;
            ys[3] = this.m_yTarget + 1;
            xs = this.m_xsConnector;
            ys = this.m_ysConnector;
            xs[0] = WsTablePairingsPanel.this.m_cxArrowHeadSize + WsTablePairingsPanel.this.m_cxShaftLength;
            ys[0] = this.m_ySource;
            xs[1] = xPanelTarget - WsTablePairingsPanel.this.m_cxArrowHeadSize - WsTablePairingsPanel.this.m_cxShaftLength;
            ys[1] = this.m_yTarget;
            xs[2] = WsTablePairingsPanel.this.m_cxArrowHeadSize + WsTablePairingsPanel.this.m_cxShaftLength;
            ys[2] = this.m_ySource + 1;
            xs[3] = xPanelTarget - WsTablePairingsPanel.this.m_cxArrowHeadSize - WsTablePairingsPanel.this.m_cxShaftLength;
            ys[3] = this.m_yTarget + 1;
            xs = new int[16];
            ys = new int[16];
            xs[0] = this.m_xsSourceArrow[0];
            ys[0] = this.m_ysSourceArrow[1];
            xs[1] = this.m_xsSourceShaft[1];
            ys[1] = this.m_ysSourceArrow[1];
            xs[2] = this.m_xsTargetShaft[1];
            ys[2] = this.m_ysTargetArrow[1];
            xs[3] = this.m_xsTargetArrow[0];
            ys[3] = this.m_ysTargetArrow[1];
            xs[4] = this.m_xsTargetArrow[3];
            ys[4] = this.m_ysTargetArrow[2];
            xs[5] = this.m_xsTargetShaft[3];
            ys[5] = this.m_ysTargetArrow[2];
            xs[6] = this.m_xsSourceShaft[3];
            ys[6] = this.m_ysSourceArrow[2];
            xs[7] = this.m_xsSourceArrow[3];
            ys[7] = this.m_ysSourceArrow[2];
            this.m_pgnHitTest = new Polygon(xs, ys, 8);
        }

        public void paint(Graphics g) {
            g.drawPolygon(this.m_xsSourceArrow, this.m_ysSourceArrow, 4);
            g.fillPolygon(this.m_xsSourceArrow, this.m_ysSourceArrow, 4);
            g.drawPolygon(this.m_xsTargetArrow, this.m_ysTargetArrow, 4);
            g.fillPolygon(this.m_xsTargetArrow, this.m_ysTargetArrow, 4);
            g.drawLine(this.m_xsSourceShaft[0], this.m_ysSourceShaft[0], this.m_xsSourceShaft[1], this.m_ysSourceShaft[1]);
            g.drawLine(this.m_xsSourceShaft[2], this.m_ysSourceShaft[2], this.m_xsSourceShaft[3], this.m_ysSourceShaft[3]);
            g.drawLine(this.m_xsTargetShaft[0], this.m_ysTargetShaft[0], this.m_xsTargetShaft[1], this.m_ysTargetShaft[1]);
            g.drawLine(this.m_xsTargetShaft[2], this.m_ysTargetShaft[2], this.m_xsTargetShaft[3], this.m_ysTargetShaft[3]);
            g.drawLine(this.m_xsConnector[0], this.m_ysConnector[0], this.m_xsConnector[1], this.m_ysConnector[1]);
            g.drawLine(this.m_xsConnector[2], this.m_ysConnector[2], this.m_xsConnector[3], this.m_ysConnector[3]);
        }

        public boolean hitTest(Point pt) {
            return this.m_pgnHitTest.contains(pt);
        }
    }
}

