/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.workspace.WsOverlayableTabbedPaneUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.swing.JTabbedPane;
import javax.swing.SwingConstants;
import javax.swing.plaf.basic.BasicTabbedPaneUI;

public class WsTabbedPaneOverlayLayout
implements LayoutManager2 {
    protected JTabbedPane m_pnlTabs;
    protected WsOverlayableTabbedPaneUI m_uiTabs;
    protected ArrayList m_alLabels;

    public WsTabbedPaneOverlayLayout(JTabbedPane pnlTabs) {
        this.m_pnlTabs = pnlTabs;
        this.m_uiTabs = (WsOverlayableTabbedPaneUI)pnlTabs.getUI();
        this.m_uiTabs.setParentOverlayLayout(this);
        this.m_alLabels = new ArrayList();
    }

    public void setTabbedPaneUI(WsOverlayableTabbedPaneUI uiTabs) {
        this.m_uiTabs = uiTabs;
    }

    public WsOverlayableTabbedPaneUI getTabbedPaneUI() {
        return this.m_uiTabs;
    }

    @Override
    public void addLayoutComponent(String sPosition, Component cmp) {
    }

    @Override
    public void addLayoutComponent(Component cmp, Object constraints) {
        if (constraints instanceof Constraints) {
            Constraints cons = (Constraints)constraints;
            cons.cmpLabel = cmp;
            this.m_alLabels.add(cons);
        }
    }

    @Override
    public void removeLayoutComponent(Component cmp) {
        if (cmp == this.m_pnlTabs) {
            this.m_pnlTabs = null;
        } else {
            int iLabel = this.findLabel(cmp);
            if (iLabel != -1) {
                this.m_alLabels.remove(iLabel);
            }
        }
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        if (this.m_pnlTabs != null) {
            return this.m_pnlTabs.getPreferredSize();
        }
        return new Dimension();
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        if (this.m_pnlTabs != null) {
            return this.m_pnlTabs.getMinimumSize();
        }
        return new Dimension();
    }

    @Override
    public Dimension maximumLayoutSize(Container parent) {
        if (this.m_pnlTabs != null) {
            return this.m_pnlTabs.getMaximumSize();
        }
        return new Dimension();
    }

    @Override
    public float getLayoutAlignmentX(Container parent) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container parent) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container parent) {
    }

    @Override
    public void layoutContainer(Container parent) {
        if (this.m_pnlTabs != null) {
            Insets insets = parent.getInsets();
            Rectangle rParent = parent.getBounds();
            this.m_pnlTabs.setBounds(insets.left, insets.top, rParent.width - (insets.left + insets.right), rParent.height - (insets.top + insets.bottom));
        }
        Rectangle rLabel = new Rectangle();
        int nLabels = this.m_alLabels.size();
        for (int iLabel = 0; iLabel < nLabels; ++iLabel) {
            Constraints cons = (Constraints)this.m_alLabels.get(iLabel);
            int iPage = this.m_pnlTabs.indexOfComponent(cons.m_cmpPage);
            if (iPage < 0) continue;
            Rectangle rTabLabel = this.m_uiTabs.getTabBounds(this.m_pnlTabs, iPage);
            Insets inTabLabel = this.m_uiTabs.getTabLabelInsets(this.m_pnlTabs.getTabPlacement(), iPage);
            rTabLabel.x += inTabLabel.left;
            rTabLabel.y += inTabLabel.top;
            rTabLabel.width -= inTabLabel.left + inTabLabel.right;
            rTabLabel.height -= inTabLabel.top + inTabLabel.bottom;
            rLabel.width = rTabLabel.width;
            Dimension dimLabel = cons.cmpLabel.getPreferredSize();
            rLabel.height = Math.min(rTabLabel.height, dimLabel.height);
            rLabel.x = rTabLabel.x;
            switch (cons.m_xAlignment) {
                case 2: {
                    rLabel.x += 0;
                    break;
                }
                case 4: {
                    rLabel.x += rTabLabel.width - rLabel.width;
                    break;
                }
                default: {
                    rLabel.x += (rTabLabel.width - rLabel.width) / 2;
                }
            }
            rLabel.y = rTabLabel.y;
            switch (cons.m_yAlignment) {
                case 1: {
                    rLabel.y += 0;
                    break;
                }
                case 3: {
                    rLabel.y += rTabLabel.height - rLabel.height;
                    break;
                }
                default: {
                    rLabel.y += (rTabLabel.height - rLabel.height) / 2;
                }
            }
            cons.cmpLabel.setBounds(rLabel);
        }
    }

    public Component getLabelComponentAt(int iPage) {
        Component cmpPage = this.m_pnlTabs.getComponentAt(iPage);
        int iLabel = this.findPage(cmpPage);
        if (iLabel == -1) {
            return null;
        }
        Constraints cons = (Constraints)this.m_alLabels.get(iLabel);
        return cons.cmpLabel;
    }

    protected int findLabel(Component cmpLabel) {
        int nLabels = this.m_alLabels.size();
        for (int iLabel = 0; iLabel < nLabels; ++iLabel) {
            if (((Constraints)this.m_alLabels.get((int)iLabel)).cmpLabel != cmpLabel) continue;
            return iLabel;
        }
        return -1;
    }

    protected int findPage(Component cmpPage) {
        int nLabels = this.m_alLabels.size();
        for (int iLabel = 0; iLabel < nLabels; ++iLabel) {
            if (((Constraints)this.m_alLabels.get((int)iLabel)).m_cmpPage != cmpPage) continue;
            return iLabel;
        }
        return -1;
    }

    protected cTabbedPaneUI createTabbedPaneUI() {
        return new cTabbedPaneUI(this);
    }

    public static class Constraints
    implements SwingConstants {
        public int m_xAlignment;
        public int m_yAlignment;
        public Component m_cmpPage;
        protected Component cmpLabel;

        public Constraints(Component cmpoPage) {
            this.m_xAlignment = 0;
            this.m_yAlignment = 0;
            this.m_cmpPage = null;
        }

        public Constraints(int xAlignment, int yAlignment, Component cmpPage) {
            this.m_xAlignment = xAlignment;
            this.m_yAlignment = yAlignment;
            this.m_cmpPage = cmpPage;
        }
    }

    protected class cTabbedPaneUI
    extends BasicTabbedPaneUI {
        protected WsTabbedPaneOverlayLayout m_layout;

        public cTabbedPaneUI(WsTabbedPaneOverlayLayout layout) {
            this.m_layout = layout;
        }

        @Override
        protected int calculateTabWidth(int tabPlacement, int tabIndex, FontMetrics metrics) {
            Component cmpLabel = this.m_layout.getLabelComponentAt(tabIndex);
            if (cmpLabel == null) {
                return super.calculateTabWidth(tabPlacement, tabIndex, metrics);
            }
            int width = cmpLabel.getPreferredSize().width;
            Insets insets = this.getTabLabelInsets(tabPlacement, tabIndex);
            return width += insets.left + insets.right;
        }

        @Override
        protected int calculateTabHeight(int tabPlacement, int tabIndex, int fontHeight) {
            Component cmpLabel = this.m_layout.getLabelComponentAt(tabIndex);
            if (cmpLabel == null) {
                return super.calculateTabHeight(tabPlacement, tabIndex, fontHeight);
            }
            int height = cmpLabel.getPreferredSize().height;
            if (height == 0) {
                height = fontHeight;
            }
            Insets insets = this.getTabLabelInsets(tabPlacement, tabIndex);
            return height += insets.top + insets.bottom;
        }

        protected Insets getTabLabelInsets(int tabPlacement, int tabIndex) {
            Insets inTabBorder = this.getTabBorderInsets(tabPlacement);
            Insets inSelTab = this.getSelectedTabPadInsets(tabPlacement);
            Insets inTabLabel = inTabBorder;
            switch (tabPlacement) {
                default: {
                    inTabLabel.bottom += inSelTab.top;
                }
                case 2: {
                    inTabLabel.right += inSelTab.left;
                }
                case 3: {
                    inTabLabel.top += inSelTab.bottom;
                }
                case 4: 
            }
            inTabLabel.left += inSelTab.right;
            return inTabLabel;
        }

        @Override
        protected int getTabRunOverlay(int tabPlacement) {
            return 0;
        }

        protected Insets getTabBorderInsets(int tabPlacement) {
            Insets insets = new Insets(1, 1, 2, 2);
            switch (tabPlacement) {
                default: {
                    insets.bottom = 0;
                    break;
                }
                case 2: {
                    insets.right = 0;
                    break;
                }
                case 3: {
                    insets.top = 0;
                    break;
                }
                case 4: {
                    insets.left = 0;
                }
            }
            return insets;
        }
    }
}

