/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.services.ServiceException;
import com.sas.services.information.metadata.IdentityInterface;
import com.sas.services.information.metadata.PersonInterface;
import com.sas.workspace.IdentityUtil;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.WsStatusBar;
import com.sas.workspace.visuals.WsAppServerPanel;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.rmi.RemoteException;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class WsStatusBarUtilities {
    public static final String APPSERVER = "Appserver";
    public static final String USER = "User";
    public static final String SERVER = "Server";
    private static WAdminResource bundle = WAdminResource.getBundle(WsStatusBarUtilities.class);
    private static boolean bServerConnectionBroken;

    private WsStatusBarUtilities() {
    }

    private static WsStatusBar getStatusBar() {
        return Workspace.getWorkspace().getStatusBar();
    }

    private static WorkspaceFile getProfile() {
        return Workspace.getWorkspace().getWorkspaceFile();
    }

    public static void addAppserverPanel() {
        JLabel lblAppserver = new JLabel();
        WsStatusBarUtilities.populateAppserverPanel(lblAppserver);
        cAppserverPanelMouseListener mouseListener = new cAppserverPanelMouseListener();
        lblAppserver.addMouseListener(mouseListener);
        Dimension dim = lblAppserver.getPreferredSize();
        dim.width = 150;
        lblAppserver.setPreferredSize(dim);
        WsStatusBarUtilities.getStatusBar().addPanel(APPSERVER, lblAppserver, 0.0);
    }

    public static void updateAppserverPanel() {
        JLabel lblAppserver = (JLabel)WsStatusBarUtilities.getStatusBar().getPanel(APPSERVER);
        if (lblAppserver != null) {
            WsStatusBarUtilities.populateAppserverPanel(lblAppserver);
        }
    }

    public static boolean isAppserverPanelShown() {
        WsStatusBar statusBar = WsStatusBarUtilities.getStatusBar();
        return statusBar == null ? false : statusBar.isPanelShown(APPSERVER);
    }

    public static void removeAppserverPanel() {
        WsStatusBarUtilities.getStatusBar().removePanel(APPSERVER);
    }

    protected static void populateAppserverPanel(JLabel lblAppserver) {
        String strAppserver = Workspace.getAppServerName();
        lblAppserver.setIcon(bundle.getImageIcon("WsStatusBarUtilities.AppserverPanel.image"));
        lblAppserver.setText(strAppserver);
        lblAppserver.setToolTipText(bundle.formatString("WsStatusBarUtilities.AppserverPanel.ToolTip.fmt", strAppserver));
    }

    public static void addUserPanel() {
        JLabel lblUser = new JLabel();
        WsStatusBarUtilities.populateUserPanel(lblUser);
        Dimension dim = lblUser.getPreferredSize();
        dim.width = 200;
        lblUser.setPreferredSize(dim);
        WsStatusBarUtilities.getStatusBar().addPanel(USER, lblUser, 0.0);
    }

    public static void updateUserPanel() {
        JLabel lblUser = (JLabel)WsStatusBarUtilities.getStatusBar().getPanel(USER);
        if (lblUser != null) {
            WsStatusBarUtilities.populateUserPanel(lblUser);
        }
    }

    public static boolean isUserPanelShown() {
        WsStatusBar statusBar = WsStatusBarUtilities.getStatusBar();
        return statusBar == null ? false : statusBar.isPanelShown(USER);
    }

    public static void removeUserPanel() {
        WsStatusBarUtilities.getStatusBar().removePanel(USER);
    }

    protected static void populateUserPanel(JLabel lblUser) {
        String strIdentity;
        String strUser;
        block8: {
            strUser = Workspace.getWorkspace().getUsername();
            strIdentity = null;
            lblUser.setIcon(bundle.getImageIcon("WsStatusBarUtilities.UserPanel.User.image"));
            lblUser.setText(strUser);
            boolean bIsUserUnrestricted = IdentityUtil.checkSpecialAuthorization(1);
            if (!bIsUserUnrestricted) {
                try {
                    IdentityInterface identity = Workspace.getWorkspace().getConnectionManager().getUserContext().getPerson();
                    if (identity == null) {
                        strIdentity = "PUBLIC";
                        lblUser.setIcon(bundle.getImageIcon("WsStatusBarUtilities.UserPanel.Group.image"));
                        break block8;
                    }
                    strIdentity = identity.getEffectiveDispayName();
                    if (identity instanceof PersonInterface) {
                        lblUser.setIcon(bundle.getImageIcon("WsStatusBarUtilities.UserPanel.User.image"));
                        break block8;
                    }
                    lblUser.setIcon(bundle.getImageIcon("WsStatusBarUtilities.UserPanel.Group.image"));
                }
                catch (RemoteException e) {
                    Workspace.getDefaultLogger().error("Failed trying to get Identity of " + strUser + "\n" + e.getMessage());
                }
                catch (ServiceException e) {
                    MessageUtil.displayServiceExceptionMessage(e);
                }
            } else {
                strIdentity = bundle.getString("WsStatusBarUtilities.UserPanel.Unrestricted.txt");
            }
        }
        if (strUser != null && strIdentity != null) {
            String shortIdentityName = strIdentity.length() > 24 ? strIdentity.substring(0, 24) : strIdentity;
            lblUser.setText(bundle.formatString("WsStatusBarUtilities.UserPanel.fmt", strUser, shortIdentityName));
            String strDisplay = bundle.formatString("WsStatusBarUtilities.UserPanel.fmt", strUser, strIdentity);
            lblUser.setToolTipText(strDisplay);
        }
        lblUser.setToolTipText(bundle.formatString("WsStatusBarUtilities.UserPanel.ToolTip.fmt", strUser, strIdentity));
    }

    public static void addServerPanel() {
        JLabel lblServer = new JLabel();
        WsStatusBarUtilities.populateServerPanel(lblServer);
        lblServer.addMouseListener(new cServerPanelMouseListener());
        Dimension dim = lblServer.getPreferredSize();
        dim.width = 120;
        lblServer.setPreferredSize(dim);
        WsStatusBarUtilities.getStatusBar().addPanel(SERVER, lblServer, 0.0);
    }

    public static void updateServerPanel() {
        JLabel lblServer = (JLabel)WsStatusBarUtilities.getStatusBar().getPanel(SERVER);
        if (lblServer != null) {
            WsStatusBarUtilities.populateServerPanel(lblServer);
        }
    }

    public static boolean isServerPanelShown() {
        WsStatusBar statusBar = WsStatusBarUtilities.getStatusBar();
        return statusBar == null ? false : statusBar.isPanelShown(SERVER);
    }

    public static void removeServerPanel() {
        WsStatusBarUtilities.getStatusBar().removePanel(SERVER);
    }

    protected static void populateServerPanel(JLabel lblServer) {
        String strServer = WsStatusBarUtilities.getProfile().getPropertyString("host");
        String strPort = WsStatusBarUtilities.getProfile().getPropertyString("port");
        lblServer.setIcon(bundle.getImageIcon("WsStatusBarUtilities.ServerPanel.image"));
        lblServer.setText(Workspace.getWorkspace().getServerDisplayName());
        lblServer.setToolTipText(bundle.formatString("WsStatusBarUtilities.ServerPanel.ToolTip.fmt", strServer, strPort));
    }

    public static void setServerConnectionBroken(boolean bBroken) {
        if (WsStatusBarUtilities.isServerPanelShown()) {
            if (bBroken) {
                if (!bServerConnectionBroken) {
                    JLabel lblServer = (JLabel)WsStatusBarUtilities.getStatusBar().getPanel(SERVER);
                    lblServer.setIcon(bundle.getImageIcon("WsStatusBarUtilities.ServerPanel.Disconnected.image"));
                    lblServer.setToolTipText(bundle.getString("WsStatusBarUtilities.ServerPanel.Disconnected.ToolTip.txt"));
                    bServerConnectionBroken = true;
                }
            } else if (bServerConnectionBroken) {
                JLabel lblServer = (JLabel)WsStatusBarUtilities.getStatusBar().getPanel(SERVER);
                WsStatusBarUtilities.populateServerPanel(lblServer);
                bServerConnectionBroken = false;
            }
        }
    }

    public static boolean getServerConnectionBroken() {
        return bServerConnectionBroken;
    }

    public static class cAppserverPanelMouseListener
    extends MouseAdapter {
        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                WsAppServerPanel pnlAppserver = new WsAppServerPanel();
                pnlAppserver.setUpdateDefault(true);
                pnlAppserver.setWillSetDataChanged(false);
                WAStandardDialog dlgAppserver = new WAStandardDialog((Frame)Workspace.getWorkspace(), bundle.getString("WsStatusBarUtilities.AppserverPanel.AppserverDialog.txt"), true, (WAPanel)pnlAppserver);
                dlgAppserver.show();
                if (dlgAppserver.getReturnValue() == 1) {
                    WsStatusBarUtilities.updateAppserverPanel();
                }
            }
        }
    }

    public static class cServerPanelMouseListener
    extends MouseAdapter {
        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                if (bServerConnectionBroken) {
                    String sHost = Workspace.getWorkspace().getConnectionManager().getHost();
                    String sMessage = bundle.formatString("WsStatusBarUtilities.ServerPanel.Reconnect.fmt", sHost);
                    String sTitle = bundle.getString("WsStatusBarUtilities.ServerPanel.ReconnectTitle.txt");
                    Object[] aButtons = new Object[]{bundle.getString("WsStatusBarUtilities.ServerPanel.ReconnectButton.txt"), bundle.getString("Common.Cancel.txt")};
                    boolean bCancel = false;
                    while (!bCancel) {
                        int iRC = JOptionPane.showOptionDialog(Workspace.getWorkspace(), sMessage, sTitle, 2, 3, null, aButtons, aButtons[0]);
                        if (iRC == 0) {
                            boolean bConnected = Workspace.getWorkspace().reconnectToMetadataServer(true);
                            if (!bConnected) continue;
                            JLabel lblServer = (JLabel)WsStatusBarUtilities.getStatusBar().getPanel(WsStatusBarUtilities.SERVER);
                            WsStatusBarUtilities.populateServerPanel(lblServer);
                            bServerConnectionBroken = false;
                            bCancel = true;
                            continue;
                        }
                        bCancel = true;
                    }
                } else {
                    int iRC = Workspace.getWorkspace().checkMetadataServerStatus(true);
                    if (iRC == Workspace.SERVERSTATUS_OK) {
                        StringBuffer sb = new StringBuffer();
                        sb.append(bundle.getString("WsStatusBarUtilities.ServerPanel.ServerOK.txt")).append("\n").append(Workspace.getWorkspace().getServerDisplayName());
                        MessageUtil.displayMessage(sb.toString(), 1);
                    }
                }
            }
        }
    }
}

