/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.workspace.WsAbstractSorter;
import java.util.Comparator;

public class WsShuttleSorter
extends WsAbstractSorter {
    protected int m_nColumns;
    protected Object[][] m_aaValues;

    @Override
    public int[] sort(Object[][] values) {
        this.m_aaValues = values;
        this.m_nColumns = this.m_aColumns.length;
        if (this.m_nColumns != this.m_aComparators.length || this.m_nColumns != this.m_aDirections.length) {
            throw new UnsupportedOperationException("Sort arrays of different length.");
        }
        int nRows = this.m_aaValues.length;
        int[] aSourceRows = new int[nRows];
        for (int iRow = 0; iRow < nRows; ++iRow) {
            aSourceRows[iRow] = iRow;
        }
        int[] aTargetRows = (int[])aSourceRows.clone();
        this.shuttlesort(aSourceRows, aTargetRows, 0, nRows);
        return aTargetRows;
    }

    protected void shuttlesort(int[] from, int[] to, int low, int high) {
        if (high - low < 2) {
            return;
        }
        int middle = (low + high) / 2;
        this.shuttlesort(to, from, low, middle);
        this.shuttlesort(to, from, middle, high);
        if (high - low >= 4 && this.compareRows(from[middle - 1], from[middle]) <= 0) {
            for (int i = low; i < high; ++i) {
                to[i] = from[i];
            }
            return;
        }
        int p = low;
        int q = middle;
        for (int i = low; i < high; ++i) {
            to[i] = q >= high || p < middle && this.compareRows(from[p], from[q]) <= 0 ? from[p++] : from[q++];
        }
    }

    protected int compareRows(int iRow1, int iRow2) {
        for (int iColumn = 0; iColumn < this.m_nColumns; ++iColumn) {
            Comparator comp = this.m_aComparators[iColumn];
            int iColumnIndex = this.m_aColumns[iColumn];
            Object o1 = this.m_aaValues[iRow1][iColumnIndex];
            Object o2 = this.m_aaValues[iRow2][iColumnIndex];
            int result = comp.compare(o1, o2);
            if (result == 0) continue;
            return this.m_aDirections[iColumn] == 1 ? result : -result;
        }
        return 0;
    }
}

