/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.iom.SAS.IFileService;
import com.sas.iom.SAS.IFileref;
import com.sas.iom.SAS.ITextStream;
import com.sas.iom.SAS.IWorkspace;
import com.sas.iom.SAS.StreamOpenMode;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.File;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.ServerContext;
import com.sas.swing.visuals.remotefileselector.IFileServiceSelectorPanel;
import com.sas.workspace.AppServer;
import com.sas.workspace.AppServerException;
import com.sas.workspace.IOMWorkspaceUtil;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.RemoteFileServices;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerFailException;
import java.awt.Frame;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.omg.CORBA.StringHolder;

public class WsRemoteFileServices
implements RemoteFileServices {
    private static WAdminResource bundle = WAdminResource.getBundle(WsRemoteFileServices.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String readFile(ServerContext oServer, Directory oDirectory, File oFile) throws MdException, RemoteException {
        WsAppServer iAppServer = WsAppServer.createAppServer(oServer);
        try {
            iAppServer.open();
            IWorkspace iworkspace = iAppServer.getWorkspace();
            String hostname = oServer.getName();
            String dirName = oDirectory.getDirectoryName();
            String fileName = oFile.getFileName();
            IFileService rio = iworkspace.FileService();
            String string = IOMWorkspaceUtil.readFromRemoteFile(rio, fileName, dirName, hostname).toString();
            return string;
        }
        catch (GenericError ex) {
            throw new MdException((Throwable)ex);
        }
        catch (AppServerException ex) {
            throw new MdException((Throwable)ex);
        }
        catch (WsAppServerFailException e) {
            MessageUtil.displayMessage(e.getLocalizedMessage(), 0);
        }
        finally {
            iAppServer.dispose();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean writeFile(String sData, ServerContext oServer, Directory oDirectory, File oFile) throws MdException, RemoteException {
        WsAppServer iAppServer = WsAppServer.createAppServer(oServer);
        try {
            iAppServer.open();
            IWorkspace iworkspace = iAppServer.getWorkspace();
            String hostname = oServer.getName();
            String dirName = oDirectory.getDirectoryName();
            String fileName = oFile.getFileName();
            IFileService rio = iworkspace.FileService();
            boolean bl = IOMWorkspaceUtil.saveToRemoteFile(rio, fileName, dirName, sData, hostname);
            return bl;
        }
        catch (GenericError ex) {
            throw new MdException((Throwable)ex);
        }
        catch (AppServerException ex) {
            throw new MdException((Throwable)ex);
        }
        catch (WsAppServerFailException e) {
            MessageUtil.displayMessage(e.getLocalizedMessage(), 0);
        }
        finally {
            iAppServer.dispose();
        }
        return false;
    }

    protected ServerContext findServerContext(LogicalServer oServer) throws MdException, RemoteException {
        AssociationList lComponents = oServer.getUsedByComponents();
        for (int i = 0; i < lComponents.size(); ++i) {
            Object cmp = lComponents.get(i);
            if (!(cmp instanceof ServerContext)) continue;
            return (ServerContext)cmp;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fileExists(String filename, WsAppServer appServer) throws GenericError {
        IFileService fs = null;
        IFileref fileRef = null;
        ITextStream textStream = null;
        String tempFileName = "TempRef";
        boolean fileRefAssigned = false;
        boolean textStreamOpened = false;
        try {
            try {
                appServer.open();
            }
            catch (WsAppServerFailException e) {
                MessageUtil.displayMessage(e.getLocalizedMessage(), 0);
            }
            IWorkspace iWorkspace = appServer.getWorkspace();
            fs = iWorkspace.FileService();
            fileRef = fs.AssignFileref(tempFileName, "DISK", filename, "", new StringHolder());
            fileRefAssigned = true;
            textStream = fileRef.OpenTextStream(StreamOpenMode.StreamOpenModeForReading, 0);
            textStreamOpened = true;
        }
        finally {
            try {
                if (textStream != null && textStreamOpened) {
                    textStream.Close();
                }
                if (fileRef != null && fileRefAssigned) {
                    fs.DeassignFileref(tempFileName);
                }
            }
            catch (GenericError e) {
                MessageUtil.displayMessage(e.getLocalizedMessage(), 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String promptForFilename(String title, String filename, HashMap fileTypes, AppServer appServer) throws GenericError {
        WsAppServer wsAppServer = WsAppServer.createAppServer(appServer.getServerContext());
        try {
            wsAppServer.open();
            if (!wsAppServer.isFileBrowseEnabled()) {
                String string = null;
                return string;
            }
        }
        catch (WsAppServerFailException e) {
            MessageUtil.displayMessage(bundle.getString("WsAppServer.Error.ConnectionFailed.txt"), 0);
            String string = null;
            return string;
        }
        finally {
            wsAppServer.dispose();
        }
        IWorkspace iWorkspace = appServer.makeConnection();
        IFileService iFileService = iWorkspace.FileService();
        StringHolder fileNameHolder = new StringHolder();
        StringHolder directoryNameHolder = new StringHolder();
        if (filename != null && filename.length() > 0) {
            iFileService.SplitName(filename, fileNameHolder, directoryNameHolder);
        }
        String directory = directoryNameHolder.value != null ? directoryNameHolder.value : "";
        IFileServiceSelectorPanel pnlSelector = new IFileServiceSelectorPanel(directory, iWorkspace, (Map)fileTypes, false);
        List lFiles = IFileServiceSelectorPanel.showDialog((Frame)Workspace.getWorkspace(), (String)title, (boolean)true, (int)2, (String)directory, (IWorkspace)iWorkspace, (boolean)false, (boolean)false, (IFileServiceSelectorPanel)pnlSelector);
        if (lFiles != null && lFiles.size() > 0) {
            return (String)lFiles.get(0);
        }
        return null;
    }
}

