/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.workspace.WsTabbedPaneOverlayLayout;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTabbedPaneUI;

public class WsOverlayableTabbedPaneUI
extends BasicTabbedPaneUI {
    private WsTabbedPaneOverlayLayout m_parentLayout;

    public static ComponentUI createUI(JComponent tabs) {
        return new WsOverlayableTabbedPaneUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        if (c.getParent() != null) {
            this.m_parentLayout = (WsTabbedPaneOverlayLayout)c.getParent().getLayout();
            this.m_parentLayout.setTabbedPaneUI(this);
        }
    }

    public void setParentOverlayLayout(WsTabbedPaneOverlayLayout layout) {
        this.m_parentLayout = layout;
    }

    public WsTabbedPaneOverlayLayout getParentOverlayLayout() {
        return this.m_parentLayout;
    }

    @Override
    protected int calculateTabWidth(int tabPlacement, int tabIndex, FontMetrics metrics) {
        Component cmpLabel = this.m_parentLayout.getLabelComponentAt(tabIndex);
        if (cmpLabel == null) {
            return super.calculateTabWidth(tabPlacement, tabIndex, metrics);
        }
        int width = cmpLabel.getPreferredSize().width;
        Insets insets = this.getTabLabelInsets(tabPlacement, tabIndex);
        return width += insets.left + insets.right;
    }

    @Override
    protected int calculateTabHeight(int tabPlacement, int tabIndex, int fontHeight) {
        Component cmpLabel = this.m_parentLayout.getLabelComponentAt(tabIndex);
        if (cmpLabel == null) {
            return super.calculateTabHeight(tabPlacement, tabIndex, fontHeight);
        }
        int height = cmpLabel.getPreferredSize().height;
        if (height == 0) {
            height = fontHeight;
        }
        Insets insets = this.getTabLabelInsets(tabPlacement, tabIndex);
        return height += insets.top + insets.bottom;
    }

    protected Insets getTabLabelInsets(int tabPlacement, int tabIndex) {
        Insets inTabBorder = this.getTabBorderInsets(tabPlacement);
        Insets inSelTab = this.getSelectedTabPadInsets(tabPlacement);
        Insets inTabLabel = inTabBorder;
        switch (tabPlacement) {
            default: {
                inTabLabel.bottom += inSelTab.top;
            }
            case 2: {
                inTabLabel.right += inSelTab.left;
            }
            case 3: {
                inTabLabel.top += inSelTab.bottom;
            }
            case 4: 
        }
        inTabLabel.left += inSelTab.right;
        return inTabLabel;
    }

    @Override
    protected int getTabRunOverlay(int tabPlacement) {
        return 0;
    }

    protected Insets getTabBorderInsets(int tabPlacement) {
        Insets insets = new Insets(1, 1, 2, 2);
        switch (tabPlacement) {
            default: {
                insets.bottom = 0;
                break;
            }
            case 2: {
                insets.right = 0;
                break;
            }
            case 3: {
                insets.top = 0;
                break;
            }
            case 4: {
                insets.left = 0;
            }
        }
        return insets;
    }
}

