/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

public class WsMapping {
    private int m_iSource;
    private int m_iTarget;
    private Object m_oData;
    private boolean m_bVisible;
    private boolean m_bTemporary;

    public WsMapping(int iSource, int iTarget) {
        this(iSource, iTarget, null);
    }

    public WsMapping(int iSource, int iTarget, boolean bTemporary) {
        this.m_iSource = iSource;
        this.m_iTarget = iTarget;
        this.m_bTemporary = bTemporary;
        this.m_oData = null;
        this.m_bVisible = true;
    }

    public WsMapping(int iSource, int iTarget, Object oData) {
        this.m_iSource = iSource;
        this.m_iTarget = iTarget;
        this.m_oData = oData;
        this.m_bTemporary = false;
        this.m_bVisible = true;
    }

    public boolean equals(Object other) {
        if (!(other instanceof WsMapping)) {
            return false;
        }
        WsMapping mapping = (WsMapping)other;
        return this.m_iSource == mapping.m_iSource && this.m_iTarget == mapping.m_iTarget;
    }

    public int hashcode() {
        return super.hashCode();
    }

    public String toString() {
        return "WsMapping(" + this.m_iSource + "," + this.m_iTarget + ":" + this.m_oData + ")";
    }

    public int getSource() {
        return this.m_iSource;
    }

    public void setSource(int iSource) {
        this.m_iSource = iSource;
    }

    public int getTarget() {
        return this.m_iTarget;
    }

    public void setTarget(int iTarget) {
        this.m_iTarget = iTarget;
    }

    public int getValue(boolean bSource) {
        return bSource ? this.m_iSource : this.m_iTarget;
    }

    public void setValue(boolean bSource, int iValue) {
        if (bSource) {
            this.m_iSource = iValue;
        } else {
            this.m_iTarget = iValue;
        }
    }

    public Object getDataObject() {
        return this.m_oData;
    }

    public void setDataObject(Object oData) {
        this.m_oData = oData;
    }

    public void setVisible(boolean bVisible) {
        this.m_bVisible = bVisible;
    }

    public boolean isVisible() {
        return this.m_bVisible;
    }

    public void setTemporary(boolean bTemporary) {
        this.m_bTemporary = bTemporary;
    }

    public boolean isTemporary() {
        return this.m_bTemporary;
    }
}

