/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.workspace.WsList;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicListUI;

public class WsListUI
extends BasicListUI {
    protected WsList m_list;

    public static ComponentUI createUI(JComponent list) {
        return new WsListUI();
    }

    @Override
    public void installUI(JComponent cmp) {
        super.installUI(cmp);
        this.m_list = (WsList)cmp;
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        ActionMap mapActions = this.list.getActionMap();
        mapActions.put("startEdit", new EditAction());
        InputMap mapInput = this.list.getInputMap(0);
        mapInput.put(KeyStroke.getKeyStroke(113, 0), "startEdit");
    }

    public int convertLocationToIndex(JList lList, Point p) {
        int iRow = this.locationToIndex(lList, p);
        if (iRow == -1) {
            return -1;
        }
        if (this.getCellBounds(lList, iRow, iRow).contains(p)) {
            return iRow;
        }
        return -1;
    }

    @Override
    public MouseInputListener createMouseInputListener() {
        return new MouseInputHandlerExt();
    }

    public class EditAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent ev) {
            int iRow = WsListUI.this.list.getSelectionModel().getAnchorSelectionIndex();
            if (iRow != -1) {
                WsListUI.this.m_list.editCellAt(iRow);
            }
        }
    }

    public class MouseInputHandlerExt
    extends BasicListUI.MouseInputHandler {
        private boolean m_bPossibleEditRequest;
        private int m_iPressedOnRow;
        private Component m_cmpTarget;

        public MouseInputHandlerExt() {
            super(WsListUI.this);
        }

        @Override
        public void mousePressed(MouseEvent ev) {
            if (WsListUI.this.m_list.isEditing() && !WsListUI.this.m_list.stopCellEditing()) {
                return;
            }
            if (SwingUtilities.isLeftMouseButton(ev) && !ev.isShiftDown() && !ev.isControlDown()) {
                int iRow = WsListUI.this.convertLocationToIndex(WsListUI.this.list, ev.getPoint());
                if (iRow != -1) {
                    if (WsListUI.this.m_list.editCellAt(iRow, ev)) {
                        Component cmpEditor = WsListUI.this.m_list.getEditorComponent();
                        Point ptEditor = SwingUtilities.convertPoint(WsListUI.this.m_list, ev.getPoint(), cmpEditor);
                        this.m_cmpTarget = SwingUtilities.getDeepestComponentAt(cmpEditor, ptEditor.x, ptEditor.y);
                        if (this.m_cmpTarget != null) {
                            this.repostEvent(ev);
                        }
                        WsListUI.this.m_list.setSelectedIndex(iRow);
                        return;
                    }
                    boolean bl = this.m_bPossibleEditRequest = WsListUI.this.list.isSelectedIndex(iRow) && WsListUI.this.list.getSelectedIndices().length == 1;
                    if (this.m_bPossibleEditRequest) {
                        this.m_iPressedOnRow = iRow;
                    }
                } else {
                    WsListUI.this.m_list.clearSelection();
                }
            } else if (SwingUtilities.isRightMouseButton(ev)) {
                int iRow = WsListUI.this.convertLocationToIndex(WsListUI.this.list, ev.getPoint());
                if (iRow != -1) {
                    WsListUI.this.m_list.setSelectedIndex(iRow);
                } else {
                    WsListUI.this.m_list.clearSelection();
                }
            }
            super.mousePressed(ev);
        }

        protected void repostEvent(MouseEvent ev) {
            MouseEvent ev2 = SwingUtilities.convertMouseEvent(WsListUI.this.m_list, ev, this.m_cmpTarget);
            this.m_cmpTarget.dispatchEvent(ev2);
        }

        @Override
        public void mouseReleased(MouseEvent ev) {
            if (this.m_cmpTarget != null) {
                if (WsListUI.this.m_list.isEditing()) {
                    this.repostEvent(ev);
                }
                this.m_cmpTarget = null;
                return;
            }
            if (this.m_bPossibleEditRequest) {
                int iRow;
                this.m_bPossibleEditRequest = false;
                if (!ev.isConsumed() && SwingUtilities.isLeftMouseButton(ev) && WsListUI.this.list.isEnabled() && (iRow = WsListUI.this.locationToIndex(WsListUI.this.list, ev.getPoint())) == this.m_iPressedOnRow) {
                    WsListUI.this.m_list.editCellAt(iRow);
                    return;
                }
            }
            super.mouseReleased(ev);
        }
    }
}

