/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.workspace.WAComboBox;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsDefaultCellEditor;
import com.sas.workspace.WsDefaultTableCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class WsEnumeratedTableColumn
extends WsAbstractTableColumn {
    protected String m_sDefault;
    protected String[] m_saValues;
    protected boolean m_bSorted;

    public WsEnumeratedTableColumn() {
        this(0);
    }

    public WsEnumeratedTableColumn(int iModelIndex) {
        this(iModelIndex, 75);
    }

    public WsEnumeratedTableColumn(int iModelIndex, int cxWidth) {
        this(iModelIndex, "", cxWidth);
    }

    public WsEnumeratedTableColumn(int iModelIndex, String sName, int cxWidth) {
        this(iModelIndex, sName, cxWidth, (String)null);
    }

    public WsEnumeratedTableColumn(int iModelIndex, String sName, int cxWidth, String sDefault) {
        this(iModelIndex, sName, cxWidth, null, sDefault);
    }

    public WsEnumeratedTableColumn(int iModelIndex, String sName, int cxWidth, String[] saValues) {
        this(iModelIndex, sName, cxWidth, saValues, saValues[0]);
    }

    public WsEnumeratedTableColumn(int iModelIndex, String sName, int cxWidth, String[] saValues, String sDefault) {
        super(iModelIndex, sName, cxWidth);
        this.m_saValues = saValues;
        this.m_sDefault = sDefault;
        this.setColumnClass(String.class);
    }

    @Override
    public Object createDefaultValue() {
        return this.m_sDefault;
    }

    @Override
    public TableCellEditor createCellEditor() {
        WAComboBox cmb = new WAComboBox(this.m_saValues, this.m_bSorted);
        cmb.setEditable(false);
        return new WsDefaultCellEditor(cmb);
    }

    @Override
    protected TableCellRenderer createCellRenderer() {
        return new WsDefaultTableCellRenderer();
    }

    public void setDefaultValue(String sDefault) {
        this.m_sDefault = sDefault;
    }

    public String getDefaultValue() {
        return this.m_sDefault;
    }

    public void setPossibleValues(String[] saValues) {
        this.m_saValues = saValues;
        if (this.m_sDefault == null) {
            this.m_sDefault = saValues[0];
        }
        if (this.m_edtCell != null) {
            WsDefaultCellEditor edt = (WsDefaultCellEditor)this.m_edtCell;
            JComboBox cmb = (JComboBox)edt.getComponent();
            cmb.removeAllItems();
            int nValues = saValues.length;
            for (int iValue = 0; iValue < nValues; ++iValue) {
                cmb.addItem(saValues[iValue]);
            }
        }
    }

    public String[] getPossibleValues() {
        return this.m_saValues;
    }

    public void setSorted(boolean bSorted) {
        WsDefaultCellEditor edt;
        JComponent cmp;
        this.m_bSorted = bSorted;
        if (this.m_edtCell != null && (cmp = (edt = (WsDefaultCellEditor)this.m_edtCell).getComponent()) instanceof WAComboBox) {
            WAComboBox cmb = (WAComboBox)cmp;
            cmb.setSorted(bSorted);
        }
    }

    public boolean isSorted() {
        return this.m_bSorted;
    }
}

