/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsTable;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class WsDefaultTableOrigin
extends JLabel {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = WAdminResource.getBundle(WsDefaultTableOrigin.class);
    protected WsTable m_tbl;
    protected boolean m_bSelectAllEnabled;
    protected boolean m_bSortOriginalEnabled;
    protected MouseListener m_lsnrMouse;

    public WsDefaultTableOrigin() {
        this((WsTable)null);
    }

    public WsDefaultTableOrigin(WsTable tbl) {
        this.setTable(tbl);
        this.initializeLocalVars();
    }

    protected void initializeLocalVars() {
        this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        this.setHorizontalAlignment(0);
        this.setText(bundle.getString("WsDefaultTableHeader.Origin.txt"));
        this.setSelectAllEnabled(false);
        this.setSortOriginalEnabled(true);
        this.createListeners();
        this.installListeners();
    }

    public void setSelectAllEnabled(boolean bSelectAllEnabled) {
        this.m_bSelectAllEnabled = bSelectAllEnabled;
    }

    public boolean isSelectAllEnabled() {
        return this.m_bSelectAllEnabled;
    }

    public void setSortOriginalEnabled(boolean bSortOriginalEnabled) {
        this.m_bSortOriginalEnabled = bSortOriginalEnabled;
    }

    public boolean isSortOriginalEnabled() {
        return this.m_bSortOriginalEnabled;
    }

    public void setTable(WsTable tbl) {
        if (this.m_tbl != tbl) {
            this.m_tbl = tbl;
            this.firePropertyChange("table", (Object)tbl, (Object)this.m_tbl);
        }
    }

    public WsTable getTable() {
        return this.m_tbl;
    }

    protected void createListeners() {
        this.m_lsnrMouse = this.createMouseListener();
    }

    protected void installListeners() {
        this.addMouseListener(this.m_lsnrMouse);
    }

    protected void uninstallListeners() {
        this.removeMouseListener(this.m_lsnrMouse);
    }

    protected MouseListener createMouseListener() {
        return new cMouseListener();
    }

    protected class cMouseListener
    extends MouseAdapter {
        protected cMouseListener() {
        }

        protected boolean shouldIgnore(MouseEvent e) {
            return !WsDefaultTableOrigin.this.isEnabled() || !WsDefaultTableOrigin.this.getTable().isEnabled();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!this.shouldIgnore(e) && SwingUtilities.isLeftMouseButton(e)) {
                if (WsDefaultTableOrigin.this.isSortOriginalEnabled() && WsDefaultTableOrigin.this.getTable().isSortingEnabled()) {
                    WsDefaultTableOrigin.this.getTable().sort(null, null);
                } else if (WsDefaultTableOrigin.this.isSelectAllEnabled()) {
                    WsDefaultTableOrigin.this.getTable().selectAll();
                }
            }
        }
    }
}

