/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsTable;
import java.awt.Color;
import java.awt.Component;
import java.text.DecimalFormat;
import java.text.Format;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class WsDefaultTableCellRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1L;
    private static DecimalFormat s_fmtDoubleHack;
    private Object m_oMissingValue;
    private Format m_fmt;

    public WsDefaultTableCellRenderer() {
        s_fmtDoubleHack = (DecimalFormat)DecimalFormat.getNumberInstance();
        s_fmtDoubleHack.setGroupingUsed(false);
        s_fmtDoubleHack.setMaximumFractionDigits(100);
    }

    public void setMissingValue(Object oMissingValue) {
        this.m_oMissingValue = oMissingValue;
    }

    public Object getMissingValue() {
        return this.m_oMissingValue;
    }

    public void setFormat(Format fmt) {
        this.m_fmt = fmt;
    }

    public Format getFormat() {
        return this.m_fmt;
    }

    @Override
    public Component getTableCellRendererComponent(JTable tbl, Object value, boolean bSelected, boolean bFocused, int iRow, int iCol) {
        super.getTableCellRendererComponent(tbl, value, bSelected, bFocused, iRow, iCol);
        Color clrNonEditableCellBackground = tbl.getBackground();
        Color clrEditableCellBackground = tbl.getBackground();
        Color clrNonFocusSelectionForeground = tbl.getSelectionForeground();
        Color clrNonFocusSelectionBackground = tbl.getSelectionBackground();
        if (tbl instanceof WsTable) {
            WsTable wstbl = (WsTable)((Object)tbl);
            clrNonEditableCellBackground = wstbl.getNonEditableCellBackground();
            clrEditableCellBackground = wstbl.getEditableCellBackground();
            clrNonFocusSelectionForeground = wstbl.getNonFocusSelectionForeground();
            clrNonFocusSelectionBackground = wstbl.getNonFocusSelectionBackground();
            WsAbstractTableModel model = (WsAbstractTableModel)tbl.getModel();
            this.setToolTipText(model.getToolTipAt(wstbl.convertRowIndexToModel(iRow), wstbl.convertColumnIndexToModel(iCol)));
        }
        if (bSelected) {
            if (tbl.isFocusOwner()) {
                super.setForeground(tbl.getSelectionForeground());
                super.setBackground(tbl.getSelectionBackground());
            } else {
                super.setForeground(clrNonFocusSelectionForeground);
                super.setBackground(clrNonFocusSelectionBackground);
            }
        } else if (tbl.isCellEditable(iRow, iCol)) {
            super.setForeground(tbl.getForeground());
            super.setBackground(clrEditableCellBackground);
        } else {
            super.setForeground(tbl.getForeground());
            super.setBackground(clrNonEditableCellBackground);
        }
        Color clrBack = this.getBackground();
        boolean bColorMatch = clrBack != null && clrBack.equals(tbl.getBackground()) && tbl.isOpaque();
        this.setOpaque(!bColorMatch);
        return this;
    }

    @Override
    protected void setValue(Object value) {
        String sValue = value == null || value.equals(this.m_oMissingValue) ? "" : (this.m_fmt != null ? this.m_fmt.format(value) : (value instanceof Double ? s_fmtDoubleHack.format((Double)value) : value.toString()));
        this.setText(sValue);
    }
}

