/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.workspace.MessageUtil;
import com.sas.workspace.WADecimalTextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsDefaultCellEditor;
import com.sas.workspace.WsDefaultTableCellRenderer;
import java.text.DecimalFormat;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class WsDecimalTableColumn
extends WsAbstractTableColumn {
    private static WAdminResource bundle = WAdminResource.getBundle(WsDecimalTableColumn.class);
    protected double m_dDefault;
    protected double m_dMinimum = 0.0;
    protected double m_dMaximum = Double.MAX_VALUE;
    private Double m_dMissing;
    private boolean m_bAllowNegative;
    private DecimalFormat m_fmt;

    public WsDecimalTableColumn() {
        this(0);
    }

    public WsDecimalTableColumn(int iModelIndex) {
        this(iModelIndex, 75);
    }

    public WsDecimalTableColumn(int iModelIndex, int cxWidth) {
        this(iModelIndex, "", cxWidth);
    }

    public WsDecimalTableColumn(int iModelIndex, String sName, int cxWidth) {
        this(iModelIndex, sName, cxWidth, 0.0);
    }

    public WsDecimalTableColumn(int iModelIndex, String sName, int cxWidth, double iDefault) {
        this(iModelIndex, sName, cxWidth, iDefault, 0.0, Double.MAX_VALUE);
    }

    public WsDecimalTableColumn(int iModelIndex, String sName, int cxWidth, double iDefault, double iMinimum, double iMaximum) {
        super(iModelIndex, sName, cxWidth);
        this.m_dDefault = iDefault;
        this.m_dMinimum = iMinimum;
        this.m_dMaximum = iMaximum;
        this.setColumnClass(Double.class);
    }

    @Override
    public Object createDefaultValue() {
        return new Double(this.m_dDefault);
    }

    @Override
    public TableCellEditor createCellEditor() {
        WADecimalTextField txtNumber = new WADecimalTextField(this.m_bAllowNegative);
        WsDefaultCellEditor editor = new WsDefaultCellEditor(txtNumber);
        editor.setMissingValue(this.m_dMissing);
        return editor;
    }

    @Override
    protected TableCellRenderer createCellRenderer() {
        WsDefaultTableCellRenderer rdr = new WsDefaultTableCellRenderer();
        rdr.setMissingValue(this.m_dMissing);
        rdr.setHorizontalAlignment(4);
        rdr.setFormat(this.m_fmt);
        return rdr;
    }

    @Override
    public boolean validateValue(Object oValue, WsAbstractTableModel mdlTable, int iRow) {
        double iValue = (Double)oValue;
        if (oValue.equals(this.m_dMissing)) {
            return true;
        }
        if (iValue < this.m_dMinimum) {
            String sMessage = bundle.formatString("WsDecimalTableColumn.TooSmallError.fmt", this.getName(), new Double(this.m_dMinimum));
            MessageUtil.displayMessage(sMessage, 0);
            return false;
        }
        if (iValue > this.m_dMaximum) {
            String sMessage = bundle.formatString("WsDecimalTableColumn.TooLargeError.fmt", this.getName(), new Double(this.m_dMaximum));
            MessageUtil.displayMessage(sMessage, 0);
            return false;
        }
        return true;
    }

    public void setDefaultValue(double iDefault) {
        this.m_dDefault = iDefault;
    }

    public double getDefaultValue() {
        return this.m_dDefault;
    }

    public void setMaximumValue(double iMaximum) {
        this.m_dMaximum = iMaximum;
    }

    public double getMaximumValue() {
        return this.m_dMaximum;
    }

    public void setMinimumValue(double iMinimum) {
        this.m_dMinimum = iMinimum;
    }

    public double getMinimumValue() {
        return this.m_dMinimum;
    }

    public void setMissingValue(Double dMissing) {
        this.m_dMissing = dMissing;
    }

    public Double getMissingValue() {
        return this.m_dMissing;
    }

    public void setAllowNegative(boolean bAllowNegative) {
        this.m_bAllowNegative = bAllowNegative;
    }

    public boolean isAllowNegative() {
        return this.m_bAllowNegative;
    }

    public void setFormat(DecimalFormat fmt) {
        this.m_fmt = fmt;
    }

    public DecimalFormat getFormat() {
        return this.m_fmt;
    }
}

