/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.workspace.MessageUtil;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsDefaultCellEditor;
import com.sas.workspace.WsDefaultTableCellRenderer;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class WsDateTableColumn
extends WsAbstractTableColumn {
    private static WAdminResource bundle = WAdminResource.getBundle(WsDateTableColumn.class);
    private Date m_dDefault;
    private DateFormat m_df;
    private String m_sParseErrorMessage;
    private Date m_dShowAsBlank;

    public WsDateTableColumn() {
        this(0);
    }

    public WsDateTableColumn(int iModelIndex) {
        this(iModelIndex, 75);
    }

    public WsDateTableColumn(int iModelIndex, int cxWidth) {
        this(iModelIndex, "", cxWidth);
    }

    public WsDateTableColumn(int iModelIndex, String sName, int cxWidth) {
        this(iModelIndex, sName, cxWidth, new Date());
    }

    public WsDateTableColumn(int iModelIndex, String sName, int cxWidth, Date dDefault) {
        super(iModelIndex, sName, cxWidth);
        this.setColumnClass(Date.class);
        this.setDefaultDate(dDefault);
        this.setDateFormat(DateFormat.getDateTimeInstance(2, 2));
        this.setParseErrorMessage(bundle.getString("WsDateTableColumn.Error.DefaultParseError.txt"));
    }

    @Override
    public Object createDefaultValue() {
        if (this.m_dDefault == null) {
            return new Date();
        }
        return this.m_dDefault;
    }

    @Override
    public TableCellEditor createCellEditor() {
        return new cTableCellEditor(new WATextField());
    }

    @Override
    protected TableCellRenderer createCellRenderer() {
        return new cTableCellRenderer();
    }

    public void setDefaultDate(Date dDefault) {
        this.m_dDefault = dDefault;
    }

    public Date getDefaultDate() {
        return this.m_dDefault;
    }

    public void setDateFormat(DateFormat df) {
        this.m_df = df;
    }

    public DateFormat getDateFormat() {
        return this.m_df;
    }

    public void setParseErrorMessage(String sMessage) {
        this.m_sParseErrorMessage = sMessage;
    }

    public String getParseErrorMessage() {
        return this.m_sParseErrorMessage;
    }

    public void setShowAsBlankDate(Date dShowAsBlank) {
        this.m_dShowAsBlank = dShowAsBlank;
    }

    public Date getShowAsBlankDate(Date dShowAsBlank) {
        return this.m_dShowAsBlank;
    }

    public Date getShowAsBlankDate() {
        return this.m_dShowAsBlank;
    }

    protected class cTableCellEditor
    extends WsDefaultCellEditor {
        private static final long serialVersionUID = 1L;

        public cTableCellEditor(WATextField txt) {
            this.initialize(txt, (WsDefaultCellEditor.cEditorDelegate)new cDelegate((JTextField)txt));
        }

        protected class cDelegate
        extends WsDefaultCellEditor.cTextFieldDelegate {
            public cDelegate(JTextField txtEditor) {
                super(cTableCellEditor.this, txtEditor);
            }

            @Override
            public void setValue(Object value) {
                if (WsDateTableColumn.this.m_dShowAsBlank != null && value == WsDateTableColumn.this.m_dShowAsBlank) {
                    this.m_txtEditor.setText("");
                } else {
                    this.m_txtEditor.setText(WsDateTableColumn.this.m_df.format(value));
                }
                this.m_txtEditor.selectAll();
            }

            @Override
            public Object getValue() {
                String sText = this.m_txtEditor.getText();
                if (sText.length() == 0 && WsDateTableColumn.this.m_dShowAsBlank != null) {
                    return WsDateTableColumn.this.m_dShowAsBlank;
                }
                try {
                    return WsDateTableColumn.this.m_df.parse(sText);
                }
                catch (ParseException e) {
                    Workspace.getDefaultLogger().error(e);
                    return new Date();
                }
            }

            @Override
            public boolean stopCellEditing() {
                String sText = this.m_txtEditor.getText();
                if (sText.length() == 0 && WsDateTableColumn.this.m_dShowAsBlank != null) {
                    return super.stopCellEditing();
                }
                try {
                    WsDateTableColumn.this.m_df.parse(sText);
                }
                catch (ParseException e) {
                    MessageUtil.displayMessage(WsDateTableColumn.this.m_sParseErrorMessage, 0);
                    return false;
                }
                return super.stopCellEditing();
            }
        }
    }

    protected class cTableCellRenderer
    extends WsDefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        protected cTableCellRenderer() {
        }

        @Override
        protected void setValue(Object value) {
            if (value == null) {
                return;
            }
            if (value.equals(WsDateTableColumn.this.m_dShowAsBlank)) {
                this.setText("");
            } else {
                this.setText(WsDateTableColumn.this.m_df.format(value));
            }
        }
    }
}

