/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Root;
import com.sas.plugins.PluginLoader;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsOMAView;
import com.sas.workspace.WsTreeNode;
import com.sas.workspace.WsViewFactory;
import com.sas.workspace.metadata.WsMetadataUtil;
import com.sas.workspace.plugins.MetadataVisualsPluginInterface;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WsDataTreeNode
extends WsTreeNode {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = WAdminResource.getBundle(WsDataTreeNode.class);
    protected String m_sTemplate;
    protected String m_sViewPrefix;
    protected String m_sViewPostfix;
    protected WsAbstractAction m_actProperties;
    protected CMetadata m_oMetadata;
    private String m_sType;
    private String m_sFQID;
    private Class m_clsPropertiewView;

    public WsDataTreeNode(CMetadata oMetadata) {
        super("");
        try {
            this.m_sName = oMetadata.getName();
            this.m_sType = oMetadata.getCMetadataType();
            this.m_sFQID = oMetadata.getFQID();
        }
        catch (RemoteException ex) {
            ex.printStackTrace();
        }
        this.m_oMetadata = oMetadata;
        this.m_sTemplate = null;
        this.setRenameable(true);
        this.setDeleteable(true);
        this.setDragObject(oMetadata);
        this.setIcon(WAdminResource.getTypeIcon(oMetadata, false));
        String sClass = this.getClass().getName();
        this.m_sViewPrefix = sClass.substring(0, sClass.lastIndexOf(46) + 1);
        this.m_sViewPostfix = "View";
        this.m_actProperties = this.createPropertiesAction();
    }

    public void setTemplate(String sTemplate) {
        this.m_sTemplate = sTemplate;
        this.setAllowsChildren(sTemplate != null);
    }

    public String getTemplate() {
        return this.m_sTemplate;
    }

    public void setPropertiesViewClass(Class clsPropertiesView) {
        this.m_clsPropertiewView = clsPropertiesView;
    }

    public Class getPropertiesViewClass() {
        return this.m_clsPropertiewView;
    }

    @Override
    public String getToolTip() {
        try {
            return this.m_oMetadata.getCMetadataType() + ", FQID:" + this.m_oMetadata.getFQID();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateName(String sName) {
        try {
            if (this.m_oMetadata.getName().equals(sName)) {
                return;
            }
            MdFactory factory = Workspace.getWorkspace().getMdObjectFactory();
            MdObjectStore store = factory.createObjectStore();
            try {
                Root oDetail = (Root)factory.createComplexMetadataObject(store, this.m_oMetadata.getName(), this.m_oMetadata.getCMetadataType(), this.m_oMetadata.getId());
                oDetail.setName(sName);
                WsMetadataUtil.updateModifiedByFor(oDetail);
                oDetail.updateMetadataAll();
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage(e, "Writing");
            }
            finally {
                store.dispose();
                factory.dumpDetailHashMap();
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
    }

    @Override
    public void rename(String sName) {
        this.updateName(sName);
    }

    @Override
    public CMetadata getMetadata() {
        return this.m_oMetadata;
    }

    @Override
    public void delete() {
        try {
            CMetadata object = this.getMetadata();
            WAdminResource metabundle = new WAdminResource(MdFactory.class);
            String sRemoveTemplate = metabundle.getRawString("RemoveTemplate." + object.getCMetadataType() + ".notrans.txt");
            if (sRemoveTemplate == null) {
                Workspace.getMdFactory().deleteMetadataObject(object);
            } else {
                Workspace.getMdFactory().deleteMetadataObjects(object, sRemoveTemplate);
            }
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage(e, "Deleting");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException(re);
        }
    }

    private void setChangeState(String sChangeState) throws RemoteException {
        Root mdo = (Root)this.m_oMetadata;
        if (mdo.getChangeState().equals(sChangeState)) {
            return;
        }
        mdo.setChangeState(sChangeState);
        if (this.getTreeModel() != null) {
            this.getTreeModel().nodeChanged(this);
        }
    }

    private void setLockedBy(String sLockedBy) throws RemoteException {
        Root mdo = (Root)this.m_oMetadata;
        if (mdo.getLockedBy().equals(sLockedBy)) {
            return;
        }
        mdo.setLockedBy(sLockedBy);
        if (this.getTreeModel() != null) {
            this.getTreeModel().nodeChanged(this);
        }
    }

    @Override
    public void updateMetadata(CMetadata oMetadata) {
        try {
            String sName = oMetadata.getName();
            this.m_oMetadata.setName(sName);
            this.setName(sName);
            this.setChangeState(((Root)oMetadata).getChangeState());
            this.setLockedBy(((Root)oMetadata).getLockedBy());
            if (this.m_sTemplate == null || !this.hasExpanded() && this.children != null) {
                return;
            }
            ArrayList alAssociations = this.getAssociations();
            int nAssociations = alAssociations.size();
            block2: for (int iAssociation = 0; iAssociation < nAssociations; iAssociation += 2) {
                String sAssociation = (String)alAssociations.get(iAssociation);
                int nChildren = this.getChildCount();
                for (int iChild = 0; iChild < nChildren; ++iChild) {
                    WsTreeNode nodeAssociation = (WsTreeNode)this.getChildAt(iChild);
                    if (!nodeAssociation.getName().equals(sAssociation)) continue;
                    this.updateAssociatedObjects(nodeAssociation, (ArrayList)alAssociations.get(iAssociation + 1));
                    continue block2;
                }
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
    }

    protected void updateAssociatedObjects(WsTreeNode nodeAssociation, ArrayList alObjects) throws RemoteException {
        int iChild;
        int iObject;
        int nObjects = alObjects.size();
        if (nObjects == 0) {
            this.getTreeModel().removeAllChildren(nodeAssociation);
            nodeAssociation.setAllowsChildren(false);
            return;
        }
        nodeAssociation.setAllowsChildren(true);
        ArrayList alNodesToRemove = new ArrayList();
        boolean[] baCreateNodeForObjects = new boolean[nObjects];
        for (iObject = 0; iObject < nObjects; ++iObject) {
            baCreateNodeForObjects[iObject] = true;
        }
        int nChildren = nodeAssociation.getChildCount();
        for (iChild = 0; iChild < nChildren; ++iChild) {
            WsTreeNode nodeChild = (WsTreeNode)nodeAssociation.getChildAt(iChild);
            String sChildFQID = nodeChild.getFQID();
            for (iObject = 0; iObject < nObjects && !sChildFQID.equals(((CMetadata)alObjects.get(iObject)).getFQID()); ++iObject) {
            }
            if (iObject < nObjects) {
                baCreateNodeForObjects[iObject] = false;
                continue;
            }
            alNodesToRemove.remove(nodeChild);
        }
        nChildren = alNodesToRemove.size();
        for (iChild = 0; iChild < nChildren; ++iChild) {
            this.getTreeModel().removeChild((WsTreeNode)alNodesToRemove.get(iChild));
        }
        for (iObject = 0; iObject < nObjects; ++iObject) {
            if (!baCreateNodeForObjects[iObject]) continue;
            WsDataTreeNode nodeObject = this.createAssociatedObjectNode((CMetadata)alObjects.get(iObject));
            this.getTreeModel().addChild(nodeObject, nodeAssociation);
        }
    }

    @Override
    public String getFQID() {
        return this.m_sFQID;
    }

    public String getType() {
        return this.m_sType;
    }

    @Override
    public boolean equals(WsTreeNode oNode) {
        return this.m_sFQID.equals(oNode.getFQID());
    }

    @Override
    public int hashcode() {
        return super.hashCode();
    }

    @Override
    public void updateWorkspaceUIComponents(boolean bActive) {
        this.m_actProperties.setActive(bActive);
    }

    @Override
    public JPopupMenu getPopupMenu(WAdminResource aBundle) {
        JPopupMenu menuPopup = super.getPopupMenu(aBundle);
        menuPopup.add(this.m_actProperties);
        return menuPopup;
    }

    public void addPluginMenuItems(JPopupMenu menuPopup) {
        PluginLoader pluginLoader = Workspace.getWorkspace().getPluginLoader();
        if (pluginLoader == null) {
            return;
        }
        boolean bFirst = true;
        ArrayList alPlugins = pluginLoader.getPlugins("com.sas.workspace.plugins.MetadataVisualsPluginInterface", true);
        int nPlugins = alPlugins.size();
        for (int iPlugin = 0; iPlugin < nPlugins; ++iPlugin) {
            MetadataVisualsPluginInterface plugin = (MetadataVisualsPluginInterface)alPlugins.get(iPlugin);
            ArrayList alMenuItems = plugin.getMenuItems(this.m_oMetadata);
            if (alMenuItems == null) continue;
            int nMenuItems = alMenuItems.size();
            for (int iMenuItem = 0; iMenuItem < nMenuItems; ++iMenuItem) {
                JMenuItem pluginItem;
                if (bFirst) {
                    menuPopup.addSeparator();
                    bFirst = false;
                }
                if ((pluginItem = (JMenuItem)alMenuItems.get(iMenuItem)).getIcon() == null) {
                    pluginItem.setIcon(bundle.getImageIcon("Common.EmptyIcon.image"));
                }
                menuPopup.add(pluginItem);
            }
        }
    }

    @Override
    public void doDefaultAction() {
        this.onProperties();
    }

    public WsOMAView onProperties() {
        if (this.m_clsPropertiewView != null) {
            return WsViewFactory.showView(this.m_oMetadata, this.m_clsPropertiewView);
        }
        try {
            MdFactory factory = Workspace.getWorkspace().getMdObjectFactory();
            MdObjectStore store = factory.createObjectStore();
            CMetadata oDetail = factory.createComplexMetadataObject(store, null, this.m_oMetadata.getName(), this.m_oMetadata.getCMetadataType(), this.m_oMetadata.getId(), null);
            return WsViewFactory.showPropertyView(oDetail, this.m_sViewPrefix, this.m_sViewPostfix, this.getClass().getClassLoader());
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
            return null;
        }
    }

    @Override
    public void addChildren() {
        if (this.m_sTemplate == null) {
            return;
        }
        ArrayList alAssociations = this.getAssociations();
        int nAssociations = alAssociations.size();
        for (int iAssociation = 0; iAssociation < nAssociations; iAssociation += 2) {
            WsTreeNode nodeAssociation = this.createAssociationNode((String)alAssociations.get(iAssociation));
            this.getTreeModel().addChild(nodeAssociation, this);
            ArrayList alObjects = (ArrayList)alAssociations.get(iAssociation + 1);
            int nObjects = alObjects.size();
            if (nObjects == 0) {
                nodeAssociation.setAllowsChildren(false);
            }
            for (int iObject = 0; iObject < nObjects; ++iObject) {
                WsDataTreeNode nodeObject = this.createAssociatedObjectNode((CMetadata)alObjects.get(iObject));
                this.getTreeModel().addChild(nodeObject, nodeAssociation);
            }
        }
    }

    protected WsTreeNode createAssociationNode(String sAssociation) {
        return new WsTreeNode(sAssociation);
    }

    protected WsDataTreeNode createAssociatedObjectNode(CMetadata oObject) {
        return new WsDataTreeNode(oObject);
    }

    protected ArrayList getAssociations() {
        Document doc = null;
        try {
            String sFQID = this.m_oMetadata.getFQID();
            String sType = this.m_oMetadata.getCMetadataType();
            String sInXML = "<" + sType + " ID=\"" + sFQID + "\">" + this.m_sTemplate + "</" + sType + ">";
            doc = Workspace.getMdFactory().getOMIUtil().getMetadata(sInXML, 0);
            NodeList lAssociations = doc.getFirstChild().getChildNodes();
            int nAssociations = lAssociations.getLength();
            ArrayList<Object> alAssociations = new ArrayList<Object>(nAssociations * 2);
            for (int iAssociation = 0; iAssociation < nAssociations; ++iAssociation) {
                Node domAssociation = lAssociations.item(iAssociation);
                alAssociations.add(domAssociation.getNodeName());
                NodeList lObjects = domAssociation.getChildNodes();
                int nObjects = lObjects.getLength();
                ArrayList<CMetadata> alObjects = new ArrayList<CMetadata>(nObjects);
                alAssociations.add(alObjects);
                for (int iObject = 0; iObject < nObjects; ++iObject) {
                    Node domObject = lObjects.item(iObject);
                    String sObjectType = domObject.getNodeName();
                    NamedNodeMap mapObject = domObject.getAttributes();
                    String sObjectFQID = mapObject.getNamedItem("Id").getNodeValue();
                    String sObjectName = mapObject.getNamedItem("Name").getNodeValue();
                    CMetadata oObject = Workspace.getMdFactory().createSimpleMetadataObject(sObjectName, sObjectType, sObjectFQID);
                    alObjects.add(oObject);
                }
            }
            return alAssociations;
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage(ex, "Reading");
            return new ArrayList();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
            return new ArrayList();
        }
    }

    protected WsAbstractAction createPropertiesAction() {
        return new cPropertiesAction();
    }

    protected class cPropertiesAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public cPropertiesAction() {
            super(bundle, "Tree.PopupMenu.Properties", true);
            this.setMenuSupportId("properties");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WsDataTreeNode.this.onProperties();
        }
    }
}

