/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import java.awt.Component;
import java.awt.Graphics;
import java.util.ArrayList;
import javax.swing.Icon;

public class WsCompoundIcon
implements Icon {
    protected ArrayList m_alIcons = new ArrayList();
    protected int m_cpIconGap = 3;
    protected int m_eOrientation = 0;
    protected boolean m_bReverseOrder = false;

    public WsCompoundIcon() {
    }

    public WsCompoundIcon(Icon icon) {
        this();
        this.m_alIcons.add(icon);
    }

    public WsCompoundIcon(Icon[] aIcons) {
        this();
        int nIcons = aIcons.length;
        for (int iIcon = 0; iIcon < nIcons; ++iIcon) {
            this.m_alIcons.add(aIcons[iIcon]);
        }
    }

    public WsCompoundIcon(ArrayList alIcons) {
        this();
        int nIcons = alIcons.size();
        for (int iIcon = 0; iIcon < nIcons; ++iIcon) {
            this.m_alIcons.add(alIcons.get(iIcon));
        }
    }

    public int getIconCount() {
        return this.m_alIcons.size();
    }

    public void addIcon(Icon icon) {
        this.m_alIcons.add(icon);
    }

    public void addIcon(Icon icon, int iIcon) {
        this.m_alIcons.add(iIcon, icon);
    }

    public Icon removeIcon(int iIcon) {
        return (Icon)this.m_alIcons.remove(iIcon);
    }

    public void setOrientation(int eOrientation) {
        this.m_eOrientation = eOrientation;
    }

    public int getOrientation() {
        return this.m_eOrientation;
    }

    public void setIconGap(int cpIconGap) {
        this.m_cpIconGap = cpIconGap;
    }

    public int getIconGap() {
        return this.m_cpIconGap;
    }

    public void setReverseOrder(boolean bReverseOrder) {
        this.m_bReverseOrder = bReverseOrder;
    }

    public boolean isReverseOrder() {
        return this.m_bReverseOrder;
    }

    @Override
    public int getIconHeight() {
        int cyIcon = 0;
        int nIcons = this.m_alIcons.size();
        if (this.m_eOrientation == 0) {
            for (int iIcon = 0; iIcon < nIcons; ++iIcon) {
                cyIcon = Math.max(cyIcon, ((Icon)this.m_alIcons.get(iIcon)).getIconHeight());
            }
        } else {
            for (int iIcon = 0; iIcon < nIcons; ++iIcon) {
                cyIcon += ((Icon)this.m_alIcons.get(iIcon)).getIconHeight() + this.m_cpIconGap;
            }
            cyIcon -= this.m_cpIconGap;
        }
        return cyIcon;
    }

    @Override
    public int getIconWidth() {
        int cxIcon = 0;
        int nIcons = this.m_alIcons.size();
        if (this.m_eOrientation == 1) {
            for (int iIcon = 0; iIcon < nIcons; ++iIcon) {
                cxIcon = Math.max(cxIcon, ((Icon)this.m_alIcons.get(iIcon)).getIconWidth());
            }
        } else {
            for (int iIcon = 0; iIcon < nIcons; ++iIcon) {
                cxIcon += ((Icon)this.m_alIcons.get(iIcon)).getIconWidth() + this.m_cpIconGap;
            }
            cxIcon -= this.m_cpIconGap;
        }
        return cxIcon;
    }

    @Override
    public synchronized void paintIcon(Component cmp, Graphics g, int x, int y) {
        if (this.m_bReverseOrder) {
            if (this.m_eOrientation == 0) {
                x += this.getIconWidth();
            } else {
                y += this.getIconHeight();
            }
            for (int iIcon = this.m_alIcons.size() - 1; iIcon >= 0; --iIcon) {
                Icon icon = (Icon)this.m_alIcons.get(iIcon);
                if (this.m_eOrientation == 0) {
                    x -= icon.getIconWidth();
                } else {
                    y -= icon.getIconHeight();
                }
                icon.paintIcon(cmp, g, x, y);
                if (this.m_eOrientation == 0) {
                    x -= this.m_cpIconGap;
                    continue;
                }
                y -= this.m_cpIconGap;
            }
        } else {
            int nIcons = this.m_alIcons.size();
            for (int iIcon = 0; iIcon < nIcons; ++iIcon) {
                Icon icon = (Icon)this.m_alIcons.get(iIcon);
                icon.paintIcon(cmp, g, x, y);
                if (this.m_eOrientation == 0) {
                    x += icon.getIconWidth() + this.m_cpIconGap;
                    continue;
                }
                y += icon.getIconHeight() + this.m_cpIconGap;
            }
        }
    }
}

