/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JButton;
import javax.swing.SwingConstants;

public class WsButtonsLayout
implements LayoutManager,
SwingConstants {
    protected int m_eOrientation;
    protected int m_eAlignment;
    protected int m_cSpacing;

    public WsButtonsLayout() {
        this(0, 4, 5);
    }

    public WsButtonsLayout(int eOrientation) {
        this(eOrientation, eOrientation == 0 ? 4 : 1, 5);
    }

    public WsButtonsLayout(int eOrientation, int eAlignment) {
        this(eOrientation, eAlignment, 5);
    }

    public WsButtonsLayout(int eOrientation, int eAlignment, int cSpacing) {
        if (eOrientation != 0 && eOrientation != 1) {
            throw new UnsupportedOperationException("Invalid orientation in WsButtonsLayout");
        }
        this.m_eOrientation = eOrientation;
        if (eOrientation == 0 && eAlignment != 2 && eAlignment != 0 && eAlignment != 4 || eOrientation == 1 && eAlignment != 1 && eAlignment != 0 && eAlignment != 3) {
            throw new UnsupportedOperationException("Invalid alignment in WsButtonsLayout");
        }
        this.m_eAlignment = eAlignment;
        this.m_cSpacing = cSpacing;
    }

    @Override
    public void addLayoutComponent(String sName, Component cmp) {
        if (!(cmp instanceof JButton)) {
            throw new UnsupportedOperationException("WsButtonsLayout requires child components to be instances of JButton");
        }
    }

    @Override
    public void layoutContainer(Container cnt) {
        int cButtonIncr;
        Insets insContainer = cnt.getInsets();
        int nButtons = cnt.getComponentCount();
        int xButton = insContainer.left;
        int yButton = insContainer.top;
        Dimension dimButton = this.getPreferredButtonSize(cnt);
        Dimension dimLayout = this.calculatePreferredSize(nButtons, dimButton);
        if (this.m_eOrientation == 0) {
            switch (this.m_eAlignment) {
                case 2: {
                    xButton = insContainer.left;
                    break;
                }
                case 0: {
                    int cxWhite = cnt.getWidth() - dimLayout.width - insContainer.left - insContainer.right;
                    xButton = insContainer.left + cxWhite / 2;
                    break;
                }
                case 4: {
                    xButton = cnt.getWidth() - insContainer.right - dimLayout.width;
                }
            }
            cButtonIncr = dimButton.width + this.m_cSpacing;
            if (!cnt.getComponentOrientation().isLeftToRight()) {
                xButton = cnt.getWidth() - xButton - dimButton.width;
                cButtonIncr = -cButtonIncr;
            }
        } else {
            switch (this.m_eAlignment) {
                case 1: {
                    yButton = insContainer.top;
                    break;
                }
                case 0: {
                    int cyWhite = cnt.getHeight() - dimLayout.height - insContainer.top - insContainer.bottom;
                    yButton = insContainer.top + cyWhite / 2;
                    break;
                }
                case 3: {
                    yButton = cnt.getHeight() - insContainer.bottom - dimLayout.height;
                }
            }
            cButtonIncr = dimButton.height + this.m_cSpacing;
        }
        for (int iButton = 0; iButton < nButtons; ++iButton) {
            cnt.getComponent(iButton).setBounds(xButton, yButton, dimButton.width, dimButton.height);
            if (this.m_eOrientation == 0) {
                xButton += cButtonIncr;
                continue;
            }
            yButton += cButtonIncr;
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container cnt) {
        return this.preferredLayoutSize(cnt);
    }

    @Override
    public Dimension preferredLayoutSize(Container cnt) {
        Dimension dimLayout = this.calculatePreferredSize(cnt.getComponentCount(), this.getPreferredButtonSize(cnt));
        Insets insContainer = cnt.getInsets();
        dimLayout.width += insContainer.left + insContainer.right;
        dimLayout.height += insContainer.top + insContainer.bottom;
        return dimLayout;
    }

    @Override
    public void removeLayoutComponent(Component cmp) {
    }

    protected Dimension getPreferredButtonSize(Container cnt) {
        cMaxDimension dim = new cMaxDimension(0, 0);
        int nCmps = cnt.getComponentCount();
        for (int iCmp = 0; iCmp < nCmps; ++iCmp) {
            dim.max(cnt.getComponent(iCmp).getPreferredSize());
        }
        return dim;
    }

    protected Dimension calculatePreferredSize(int nButtons, Dimension dimButtons) {
        Dimension dimLayout = new Dimension();
        if (this.m_eOrientation == 0) {
            dimLayout.width = (dimButtons.width + this.m_cSpacing) * nButtons - this.m_cSpacing;
            dimLayout.height = dimButtons.height;
        } else {
            dimLayout.width = dimButtons.width;
            dimLayout.height = (dimButtons.height + this.m_cSpacing) * nButtons - this.m_cSpacing;
        }
        return dimLayout;
    }

    protected class cMaxDimension
    extends Dimension {
        private static final long serialVersionUID = 1L;

        public cMaxDimension(int mWidth, int mHeight) {
            super(mWidth, mHeight);
        }

        public void max(Dimension dim) {
            this.width = Math.max(this.width, dim.width);
            this.height = Math.max(this.height, dim.height);
        }
    }
}

