/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.editor.CodeEditorDefaults;
import com.sas.iom.SAS.IWorkspace;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.meta.SASOMI.IOMI;
import com.sas.meta.SASOMI.ISecurityPackage.InvalidCredHandle;
import com.sas.meta.SASOMI.ISecurityPackage.InvalidResourceSpec;
import com.sas.meta.SASOMI.ISecurityPackage.NotTrustedUser;
import com.sas.meta.SASOMI.ISecurity_1_1;
import com.sas.meta.SASOMI.IServer;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdFactoryImpl;
import com.sas.metadata.remote.MdOMRConnection;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Root;
import com.sas.plugins.PluginLoader;
import com.sas.services.ServiceException;
import com.sas.services.connection.HostPortSet;
import com.sas.services.deployment.CorePlatformServices;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.information.MetadataConnectionEvent;
import com.sas.services.information.MetadataConnectionListener;
import com.sas.services.information.OMIServer;
import com.sas.services.information.RepositoryDef;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.ApplicationInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.security.ExpiredPasswordLoginServiceException;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.SimpleUserIdentity;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserInitializationException;
import com.sas.services.user.UserServiceInterface;
import com.sas.visuals.util.XMLMenu;
import com.sas.visuals.util.XMLMenuBar;
import com.sas.visuals.util.XMLMenuItem;
import com.sas.visuals.util.XMLToolBar;
import com.sas.visuals.util.XMLToolItem;
import com.sas.workspace.AppServer;
import com.sas.workspace.AppServerDialog;
import com.sas.workspace.AppServerException;
import com.sas.workspace.ChangeProfileActionInterface;
import com.sas.workspace.CustomDesktop;
import com.sas.workspace.CustomLayoutFocusTraversalPolicy;
import com.sas.workspace.DesktopUtil;
import com.sas.workspace.HelpClassLoader;
import com.sas.workspace.ILogger;
import com.sas.workspace.IdentityUtil;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OpRequestUI;
import com.sas.workspace.PasteBuffer;
import com.sas.workspace.SplitManager;
import com.sas.workspace.WAConnectDialog;
import com.sas.workspace.WAConnectWizard;
import com.sas.workspace.WALoginDialog;
import com.sas.workspace.WATitledPane;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.WorkspaceInitializationCallback;
import com.sas.workspace.WorkspaceMenuSupport;
import com.sas.workspace.WorkspaceShortcutBar;
import com.sas.workspace.WorkspaceTree;
import com.sas.workspace.WorkspaceTreeObject;
import com.sas.workspace.WorkspaceUtil;
import com.sas.workspace.WsCheckToIgnoreDialog;
import com.sas.workspace.WsCompoundIcon;
import com.sas.workspace.WsFocusListenerPropagator;
import com.sas.workspace.WsLimitedPlainDocument;
import com.sas.workspace.WsLogger;
import com.sas.workspace.WsMessagesWindow;
import com.sas.workspace.WsMouseListenerPropagator;
import com.sas.workspace.WsRepositoryUtil;
import com.sas.workspace.WsStatusBar;
import com.sas.workspace.WsStatusBarUtilities;
import com.sas.workspace.WsWorkspaceComponent;
import com.sas.workspace.connection.ConnectionChangeAdapter;
import com.sas.workspace.connection.ConnectionChangeListener;
import com.sas.workspace.connection.ConnectionException;
import com.sas.workspace.connection.ConnectionManager;
import com.sas.workspace.metadata.WsMetadataUtil;
import com.sas.workspace.models.SimpleObject;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PrinterJob;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.apache.commons.io.FileUtils;
import org.omg.CORBA.BooleanHolder;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.INV_OBJREF;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.StringHolder;

public class Workspace
extends JFrame {
    private static final long serialVersionUID = 1L;
    protected static MdFactory s_metadataFactory;
    protected static Workspace m_workspace;
    private static WorkspaceInitializationCallback m_workspaceInitializer;
    public static final String METADATA_PROFILE_FILENAME_PROPERTY = "MetadataProfile";
    public static final String DI_STUDIO_SOFTWARE_COMPONENT_CLASSID = "databuildata";
    private static WAdminResource bundle;
    protected static String m_sInstallDir;
    protected WorkspaceMenuSupport m_appSupportObject;
    protected WorkspaceFile m_workspaceFile;
    protected WorkspaceFile m_appDefaultsFile;
    protected HashMap m_workspaceData;
    protected List m_vecSelectedReps;
    private List m_selectedRepositoryNames;
    protected WsMessagesWindow m_messagesWindow;
    protected WorkspaceShortcutBar m_ShortcutBar;
    protected CustomDesktop m_Desktop;
    protected WsStatusBar m_StatusBar;
    protected WATitledPane m_overviewWindow;
    protected WATitledPane m_quickProperties;
    protected WsWorkspaceComponent m_cmpActive;
    protected SplitManager m_splitManager;
    protected JPanel m_splitManagerPanel;
    protected boolean m_bIsOverviewShowing;
    protected IOMI m_pIOMI;
    protected IServer m_pIServer;
    protected String m_strServerName;
    protected IWorkspace m_pWorkspace;
    protected Class m_cBrowseTree;
    protected MdOMRConnection m_MetadataWorkspace;
    protected static int m_MetadataServerVersion;
    protected boolean m_bCheckJobCompatibility = false;
    protected CodeEditorDefaults m_CodeEditorDefaults;
    protected static boolean m_bDebug;
    protected static boolean m_bDemoMode;
    protected static boolean m_bDebugFocus;
    private static boolean m_bLogCredentials;
    protected static boolean m_bLog;
    protected static boolean m_bConsoleLog;
    protected static boolean m_bDebugLogFile;
    protected static boolean m_bKeepLog;
    protected static boolean m_bLoggingDebugMessages;
    protected static String m_LogFileName;
    protected static String m_DefaultLoggingContext;
    protected static List m_LoggingContexts;
    protected static boolean m_bSCDChange;
    protected static boolean m_bSetMetaOptions;
    protected static int m_DefaultLoggingLevel;
    protected static String m_errorLogFileName;
    protected static Level m_messageLevel;
    protected static String m_pluginsDir;
    protected static Integer m_promptThreshold;
    protected static boolean m_bUseMetalibChanges;
    protected static boolean m_bUseMetalibDebug;
    protected static String m_roadmapsDir;
    protected WorkspaceTreeObject m_treeObject;
    protected PasteBuffer m_pasteBuffer;
    protected boolean m_errorLogStarted = false;
    private boolean m_bSkipInitializeDesktopLayout = false;
    private boolean m_singleSignOnEnabled = false;
    private boolean m_foundationServicesConnection = false;
    private boolean m_singleSignOn = true;
    private UserContextInterface m_userContext;
    private SessionContextInterface m_sessionContext;
    private InformationServiceInterface m_informationService;
    private ConnectionManager m_connectionManager;
    private long m_reconnectTimer;
    private static long RECONNECT_TIMER_INTERVAL;
    private ConnectionChangeListener m_connectionChangeListener;
    private MetadataConnectionListener m_metadataConnectionListener;
    private boolean m_connected;
    private static boolean bUseNewStartupReturnValues;
    private ChangeProfileActionInterface m_profileAction;
    public static final String DIS_VERSION_PROPERTY_NAME = "DISVersion";
    public int SERVER_VERSION_940 = 9400;
    private static HelpClassLoader m_WorkspaceHelpClassLoader;
    public String m_sMasterHelp;
    public String m_sCurrentHelp;
    public String m_previousHelpProduct;
    protected String m_strUsername = "";
    protected String m_strPassword = "";
    protected String m_strAppTitle;
    protected String m_strAppShortName;
    protected String m_strApplicationName;
    private String m_strAppLogName;
    protected PluginLoader m_pluginLoader = null;
    protected CMetadata m_projectRepository = null;
    protected CMetadata m_defaultRepository = null;
    protected CMetadata m_checkinRepository = null;
    protected boolean m_bApplicationWantsChangeManagement = false;
    protected boolean m_bCheckForExistingProjectObjects = false;
    private HashMap m_AppServerCredentials = new HashMap();
    private double m_versionNumber = 0.0;
    public static int CHANGEMANAGEMENT_ON;
    public static int CHANGEMANAGEMENT_READONLY;
    public static int CHANGEMANAGEMENT_OFF;
    protected int m_eChangeManagementState = CHANGEMANAGEMENT_OFF;
    protected static final int SHORTCUT_BAR_MIN_WIDTH = 110;
    protected static final int TREE_VIEW_MIN_WIDTH = 30;
    protected static final int TREE_VIEW_MIN_HEIGHT = 200;
    protected static final int OVERVIEW_WINDOW_MIN_HEIGHT = 150;
    protected static final int MESSAGE_WINDOW_MIN_HEIGHT = 80;
    protected static final int DIVIDER_DEFAULT_WIDTH = 5;
    private static final int DESKTOP_MIN_HEIGHT = 150;
    private boolean m_bServerStatusCheckEnabled = false;
    public static int SERVERSTATUS_ERROR;
    public static int SERVERSTATUS_OK;
    public static int SERVERSTATUS_PAUSED;
    public static int SERVERSTATUS_RECONNECTED;
    protected boolean m_bUnrestrictedUser;
    private static String s_sAppPathName;
    private static String[] s_versions;
    private boolean m_bSupportsDefaultAppServer = false;
    private boolean m_bSupportsAuthDomainSetting = false;
    private static String m_applicationSoftwareComponentClassId;
    public static final int CONNECT_OK = 0;
    public static final int CONNECT_CANCEL = 1;
    public static final int CONNECT_ERROR = 2;
    public static final int CONNECT_EXPIRED_PASSWORD = 3;

    public static MdFactory getMdFactory() {
        return s_metadataFactory;
    }

    public Workspace() {
        m_workspace = this;
        MessageUtil.setMainWindow(this);
        this.m_connectionManager = new ConnectionManager();
        this.m_connectionChangeListener = new WorkspaceConnectionChangeListener();
        this.m_connectionManager.addConnectionChangeListener(this.m_connectionChangeListener);
        this.m_connected = false;
    }

    public Workspace(SessionContextInterface session) {
        m_workspace = this;
        MessageUtil.setMainWindow(this);
        try {
            this.m_connectionManager = new ConnectionManager();
            this.m_connectionManager.updateSessionContext(session);
            this.m_connectionChangeListener = new WorkspaceConnectionChangeListener();
            this.m_connectionManager.addConnectionChangeListener(this.m_connectionChangeListener);
            this.m_connected = false;
            this.m_sessionContext = session;
            this.m_userContext = this.m_connectionManager.getUserContext();
            this.updateFactory();
            this.updateUser();
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().fatal((Object)"Workspace constructor", e);
        }
    }

    public Workspace(String Title) {
        super(Title);
        this.m_strAppTitle = Title;
        this.startLog();
        this.getContentPane().setLayout(new BorderLayout());
        m_workspace = this;
        MessageUtil.setMainWindow(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Workspace.this.onWindowClosing(e);
            }

            @Override
            public void windowClosed(WindowEvent e) {
                Workspace.this.onWindowClosed(e);
            }
        });
        this.setDefaultCloseOperation(0);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            SwingUtilities.updateComponentTreeUI(this);
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        KeyboardFocusManager.getCurrentKeyboardFocusManager().setDefaultFocusTraversalPolicy(CustomLayoutFocusTraversalPolicy.getInstance());
        try {
            this.m_connectionManager = new ConnectionManager();
            this.m_connectionChangeListener = new WorkspaceConnectionChangeListener();
            this.m_connectionManager.addConnectionChangeListener(this.m_connectionChangeListener);
            s_metadataFactory = new MdFactoryImpl();
            s_metadataFactory.setRemoveDependentObjects(true);
            this.m_MetadataWorkspace = s_metadataFactory.getConnection();
            this.m_CodeEditorDefaults = new CodeEditorDefaults();
            this.m_messagesWindow = new WsMessagesWindow();
            this.m_messagesWindow.setPreferredSize(new Dimension(1, 80));
            boolean bUseExternalLogConfig = false;
            String loggingConfigURL = System.getProperty("com.sas.services.logging.configurationURL");
            if (loggingConfigURL != null && loggingConfigURL.length() > 0) {
                bUseExternalLogConfig = true;
            }
            if (!bUseExternalLogConfig) {
                if (!m_bConsoleLog) {
                    if (m_bLoggingDebugMessages) {
                        System.out.println("Workspace (init): Removing console output for com.sas.");
                    }
                    WsLogger.setConsoleLogging("com.sas", false);
                }
                if (m_bDebug) {
                    OutputStream jOMAOutput;
                    Workspace.getMdFactory().setDebug(true);
                    WsLogger.setLoggerPriority("com.sas.metadata", ILogger.DEBUG);
                    WsLogger.setLoggerPriority("com.sas.metadata.perf", ILogger.WARN);
                    WsLogger.setLoggerPriority("com.sas.services.connection", ILogger.DEBUG);
                    WsLogger.setLoggerPriority("com.sas.services.connection.trace", ILogger.DEBUG);
                    if (!m_bDebugLogFile && (jOMAOutput = Workspace.getMdFactory().getUtil().getOutputStream()) == null) {
                        Workspace.getMdFactory().getUtil().setOutputStream((OutputStream)System.out);
                        if (m_bLoggingDebugMessages) {
                            System.out.println("Workspace (init): Setting jOMA logging to System.out");
                        }
                    }
                }
                if (m_bDemoMode) {
                    s_metadataFactory.getUtil().setLogToNull();
                    s_metadataFactory.getUtil().setOutputToNull();
                    Workspace.getMdFactory().getInstance().setLoggingEnabled(false);
                    Workspace.getMdFactory().getInstance().setDebug(false);
                }
                if (m_bLog) {
                    Workspace.getMdFactory().setLoggingEnabled(true);
                    WsLogger.setLoggerPriority("com.sas.metadata.xml", ILogger.DEBUG);
                    if (m_bDebugLogFile) {
                        WsLogger.setLoggerFile("com.sas.metadata.xml", m_LogFileName);
                        if (m_bLoggingDebugMessages) {
                            System.out.println("Workspace (init): Setting com.sas.metadata.xml logging to use file: " + m_LogFileName);
                            System.out.println("Workspace (init): Defer additivity for com.sas.metadata.xml until connection.");
                        }
                    }
                }
                WsLogger.setLoggerFormat("com.sas", "%d [%t] %-5p %c - %m%n");
                WsLogger.setLoggerFile("com.sas", m_errorLogFileName);
                if (m_bLoggingDebugMessages) {
                    System.out.println("Workspace (init): Setting logging of com.sas to file: " + m_errorLogFileName);
                }
                s_metadataFactory.getConnection().setMessageLevel(m_messageLevel);
            } else {
                System.err.println("Workspace init:Ignoring all command line logging options, user specified logging file \"" + loggingConfigURL + "\" used");
            }
        }
        catch (MdException ex) {
            Workspace.getDefaultLogger().fatal((Object)"Workspace constructor", ex);
        }
        catch (RemoteException ex) {
            // empty catch block
        }
        this.m_workspaceData = new HashMap(20);
        this.m_workspaceFile = new WorkspaceFile();
        this.m_StatusBar = this.createStatusBar();
        this.getContentPane().add((Component)this.m_StatusBar, "South");
        WsLimitedPlainDocument.setMessageDisplayer(this.m_StatusBar);
        this.m_pasteBuffer = new PasteBuffer();
        if (m_bDebugFocus) {
            WsFocusListenerPropagator flp = new WsFocusListenerPropagator(new cFocusDebugger());
            flp.startListeningTo(this);
            WsMouseListenerPropagator mlp = new WsMouseListenerPropagator(new cComponentFinder());
            mlp.startListeningTo(this);
        }
    }

    protected WsStatusBar createStatusBar() {
        return new WsStatusBar();
    }

    public void setDebug(boolean debug) {
        if (debug && s_metadataFactory != null) {
            try {
                s_metadataFactory.setDebug(true);
                WsLogger.setLoggerPriority("com.sas.metadata", ILogger.DEBUG);
                if (m_bLog) {
                    s_metadataFactory.setLoggingEnabled(true);
                    WsLogger.setLoggerPriority("com.sas.metadata.xml", ILogger.DEBUG);
                } else {
                    s_metadataFactory.setLoggingEnabled(false);
                }
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException(re);
            }
        }
    }

    public void setXMLLogging(boolean logging) {
        if (logging && s_metadataFactory != null) {
            try {
                WsLogger.setLoggerPriority("com.sas.metadata.xml", ILogger.DEBUG);
                s_metadataFactory.setLoggingEnabled(true);
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException(re);
            }
        }
    }

    public void resetLoggingLevels() throws RemoteException {
        if (m_bDebug) {
            Workspace.getMdFactory().setDebug(true);
            if (!m_bDebugLogFile) {
                try {
                    WsLogger.addFileOutput((WsLogger)Workspace.getDefaultLogger(), m_errorLogFileName);
                }
                catch (SecurityException e) {
                    if (m_bLoggingDebugMessages) {
                        System.out.println("resetLoggingLevels: Error setting logging to file: " + m_errorLogFileName);
                    }
                    e.printStackTrace();
                }
            }
            if (m_bLog) {
                if (m_bDebugLogFile) {
                    try {
                        FileOutputStream mylogFile = new FileOutputStream(m_LogFileName);
                        Workspace.getMdFactory().getUtil().setLogStream((OutputStream)mylogFile);
                        if (m_bLoggingDebugMessages) {
                            System.out.println("resetLoggingLevels: Setting logging of jOMA to file: " + m_LogFileName);
                        }
                    }
                    catch (FileNotFoundException e) {
                        if (m_bLoggingDebugMessages) {
                            System.out.println("resetLoggingLevels: Error setting jOMA logging to file: " + m_LogFileName);
                        }
                        e.printStackTrace();
                    }
                    catch (SecurityException e) {
                        if (m_bLoggingDebugMessages) {
                            System.out.println("resetLoggingLevels: Error setting jOMA logging to file: " + m_LogFileName);
                        }
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        if (m_bLoggingDebugMessages) {
                            System.out.println("resetLoggingLevels: Error setting jOMA logging to file: " + m_LogFileName);
                        }
                        e.printStackTrace();
                    }
                }
            } else {
                Workspace.getMdFactory().setLoggingEnabled(false);
            }
        } else if (m_bDemoMode) {
            Workspace.getMdFactory().getInstance().getUtil().setLogToNull();
            Workspace.getMdFactory().getInstance().getUtil().setOutputToNull();
            Workspace.getMdFactory().getInstance().setLoggingEnabled(false);
            Workspace.getMdFactory().getInstance().setDebug(false);
        } else if (m_bLog) {
            WsLogger.setLoggerPriority("com.sas.metadata.xml", ILogger.DEBUG);
            if (m_bDebugLogFile) {
                WsLogger.setLoggerFile("com.sas.metadata.xml", m_LogFileName);
                WsLogger.setAdditivityAppenders("com.sas.metadata.xml", false);
                if (m_bLoggingDebugMessages) {
                    System.out.println("resetLoggingLevels: Setting logging of com.sas.metadata.xml to file: " + m_LogFileName);
                    System.out.println("resetLoggingLevels: Setting additivity of com.sas.metadata.xml to false");
                }
            }
        } else {
            Workspace.getMdFactory().getInstance().setLoggingEnabled(false);
            if (m_bLoggingDebugMessages) {
                System.out.println("resetLoggingLevels: Setting logging of jOMA false");
            }
        }
        Workspace.getMdFactory().getInstance().getConnection().setMessageLevel(m_messageLevel);
    }

    public static boolean processCommandLineArguments(String[] saArgs) {
        String loggingDebug;
        int nArgs = saArgs.length;
        for (int iArg = 0; iArg < nArgs; ++iArg) {
            int index;
            if (saArgs[iArg].equalsIgnoreCase("-debug")) {
                m_bDebug = true;
            }
            if (saArgs[iArg].equalsIgnoreCase("-debugFocus")) {
                m_bDebugFocus = true;
            }
            if (saArgs[iArg].equalsIgnoreCase("-logCredentials")) {
                m_bLogCredentials = true;
            }
            if (saArgs[iArg].equalsIgnoreCase("-pluginsDir")) {
                m_pluginsDir = saArgs[++iArg];
                if (iArg >= nArgs) break;
            }
            if (saArgs[iArg].equalsIgnoreCase("-promptThreshold")) {
                if (saArgs.length > ++iArg) {
                    index = saArgs[iArg].indexOf("-");
                    if (index == 0) {
                        --iArg;
                    } else {
                        m_promptThreshold = new Integer(saArgs[iArg]);
                    }
                }
                if (iArg >= nArgs) break;
            }
            if (saArgs[iArg].equalsIgnoreCase("-demoMode")) {
                m_bDemoMode = true;
            }
            if (saArgs[iArg].equalsIgnoreCase("-serverLog")) {
                m_bLog = true;
            }
            if (saArgs[iArg].equalsIgnoreCase("-consoleLog")) {
                m_bConsoleLog = true;
            }
            if (saArgs[iArg].equalsIgnoreCase("-keepLog")) {
                m_bKeepLog = true;
            }
            if (saArgs[iArg].equalsIgnoreCase("-scdupdate")) {
                m_bSCDChange = true;
            }
            if (saArgs[iArg].equalsIgnoreCase("-ignoremetalib")) {
                m_bUseMetalibChanges = false;
            }
            if (saArgs[iArg].equalsIgnoreCase("-metalibdebug")) {
                m_bUseMetalibDebug = true;
            }
            if (saArgs[iArg].equalsIgnoreCase("-setmetaoptions")) {
                m_bSetMetaOptions = true;
            }
            if (saArgs[iArg].equalsIgnoreCase("-logFile")) {
                m_bDebugLogFile = true;
                if (saArgs.length > ++iArg) {
                    index = saArgs[iArg].indexOf("-");
                    if (index == 0) {
                        --iArg;
                    } else {
                        m_errorLogFileName = Workspace.getAppDataPath() + System.getProperty("file.separator") + saArgs[iArg];
                    }
                }
                if (iArg >= nArgs) break;
            }
            if (!saArgs[iArg].equalsIgnoreCase("-MessageLevel")) continue;
            if (saArgs.length > ++iArg) {
                index = saArgs[iArg].indexOf("-");
                if (index == 0) {
                    --iArg;
                } else {
                    try {
                        m_messageLevel = Level.parse(saArgs[iArg].toUpperCase());
                    }
                    catch (IllegalArgumentException e) {
                        m_messageLevel = Level.OFF;
                    }
                }
            }
            if (iArg >= nArgs) break;
        }
        if ((loggingDebug = System.getProperty("com.sas.workspace.logging.debug")) != null && "true".equalsIgnoreCase(loggingDebug)) {
            m_bLoggingDebugMessages = true;
        }
        return true;
    }

    public static void setDeferredWorkspaceInitializer(WorkspaceInitializationCallback initializer) {
        m_workspaceInitializer = initializer;
    }

    public static ILogger getDefaultLogger() {
        return WsLogger.getRootLogger();
    }

    public static ILogger getLogger(String sContext) {
        return WsLogger.getLogger(sContext);
    }

    public static void handleRemoteException(RemoteException ex) {
        throw new RuntimeException(ex);
    }

    public static void handleServiceException(ServiceException ex) {
        MessageUtil.displayServiceExceptionMessage(ex);
    }

    public void initializeHelp() {
    }

    public PasteBuffer getPasteBuffer() {
        return this.m_pasteBuffer;
    }

    public void setAppDefaultsFile(WorkspaceFile file) {
        this.m_appDefaultsFile = file;
    }

    public void setCustomDesktop(CustomDesktop desk) {
        this.m_Desktop = desk;
    }

    public CustomDesktop getCustomDesktop() {
        return this.m_Desktop;
    }

    public void setTreeObject(WorkspaceTreeObject treeObject) {
        this.m_treeObject = treeObject;
    }

    public WorkspaceTreeObject getTreeObject() {
        return this.m_treeObject;
    }

    public SplitManager getSplitManager() {
        return this.m_splitManager;
    }

    public boolean getCheckJobCompatibility() {
        return this.m_bCheckJobCompatibility;
    }

    public void setCheckJobCompatibility(boolean checkjobs) {
        this.m_bCheckJobCompatibility = checkjobs;
    }

    public boolean isApplicationWantsChangeManagement() {
        return this.m_bApplicationWantsChangeManagement;
    }

    public void setApplicationWantsChangeManagement(boolean bApplicationWantsChangeManagement) {
        this.m_bApplicationWantsChangeManagement = bApplicationWantsChangeManagement;
    }

    public int getChangeManagementState() {
        return this.m_eChangeManagementState;
    }

    public boolean isChangeManagementOn() {
        return this.m_eChangeManagementState == CHANGEMANAGEMENT_ON;
    }

    public boolean isChangeManagementReadOnly() {
        return this.m_eChangeManagementState == CHANGEMANAGEMENT_READONLY;
    }

    public void setApplicationShortName(String name) {
        this.m_strAppShortName = name;
    }

    public String getApplicationShortName() {
        return this.m_strAppShortName;
    }

    public static boolean isObjectEditable(SimpleObject obj) {
        if (obj.isNew()) {
            return true;
        }
        try {
            String sChangeState = WsMetadataUtil.getSimpleAttribute(obj.getMetadataType(), obj.getID(), "ChangeState");
            if (sChangeState.startsWith("Checked")) {
                return false;
            }
            MdOMRConnection omr = Workspace.getMdFactory().getConnection();
            ISecurity_1_1 security = omr.MakeISecurityConnection(omr.getCMRHandle());
            String resource = "OMSOBJ:" + obj.getMetadataType() + "/" + obj.getID();
            String permission = "WriteMetadata";
            StringHolder permissionCondition = new StringHolder();
            BooleanHolder authorized = new BooleanHolder();
            security.IsAuthorized("", resource, permission, permissionCondition, authorized);
            return authorized.value;
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage(ex, "Reading");
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
        catch (NotTrustedUser ex) {
            Workspace.getDefaultLogger().error((Object)"isObjectEditable exception", ex);
        }
        catch (InvalidCredHandle ex) {
            Workspace.getDefaultLogger().error((Object)"isObjectEditable exception", ex);
        }
        catch (InvalidResourceSpec ex) {
            Workspace.getDefaultLogger().error((Object)"isObjectEditable exception", ex);
        }
        catch (GenericError ex) {
            Workspace.getDefaultLogger().error((Object)"isObjectEditable exception", ex);
        }
        return false;
    }

    public boolean isObjectEditable(CMetadata object) {
        try {
            if (object.isNewObject()) {
                return true;
            }
            if (object instanceof Job && !Workspace.isJobReadableByApplicationVersion((Job)object)) {
                return false;
            }
            String sChangeState = WsMetadataUtil.getSimpleAttribute(object.getCMetadataType(), object.getFQID(), "ChangeState");
            if (sChangeState.startsWith("Checked")) {
                return false;
            }
            MdOMRConnection omr = Workspace.getMdFactory().getConnection();
            ISecurity_1_1 security = omr.MakeISecurityConnection(omr.getCMRHandle());
            String resource = "OMSOBJ:" + object.getCMetadataType() + "/" + object.getFQID();
            String permission = "WriteMetadata";
            StringHolder permissionCondition = new StringHolder();
            BooleanHolder authorized = new BooleanHolder();
            security.IsAuthorized("", resource, permission, permissionCondition, authorized);
            return authorized.value;
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage(ex, "Accessing");
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
        catch (NotTrustedUser ex) {
            Workspace.getDefaultLogger().error((Object)"", ex);
        }
        catch (InvalidCredHandle ex) {
            Workspace.getDefaultLogger().error((Object)"", ex);
        }
        catch (InvalidResourceSpec ex) {
            Workspace.getDefaultLogger().error((Object)"", ex);
        }
        catch (GenericError ex) {
            Workspace.getDefaultLogger().error((Object)"", ex);
        }
        return false;
    }

    public static boolean isJobReadableByApplicationVersion(Job job) throws MdException, RemoteException {
        return Workspace.isJobReadableByApplicationVersion(job, true);
    }

    public static boolean isJobReadableByApplicationVersion(Job job, boolean prompt) throws MdException, RemoteException {
        boolean editable = true;
        if (!Workspace.getWorkspace().getCheckJobCompatibility()) {
            return true;
        }
        double jobVersion = Workspace.getJobApplicationVersion(job);
        double applicationVersion = Workspace.getWorkspace().getApplicationVersionNumber();
        String appVersion = Double.toString(Workspace.getWorkspace().getApplicationVersionNumber());
        String string = appVersion = appVersion.equals("4.91") ? "4.910" : appVersion;
        if (jobVersion > applicationVersion) {
            editable = false;
            String appName = Workspace.getWorkspace().getApplicationName();
            appName = appName == null ? "" : appName.replaceAll(appVersion, "");
            if (prompt) {
                MessageUtil.displayMessage(bundle.formatString("Workspace.JobVersionNewerThanApplicationVersion.txt", job.getName(), appName, Double.toString(Workspace.getJobApplicationVersion(job)), appVersion), 0);
            }
        }
        return editable;
    }

    public static double getJobApplicationVersion(Job job) throws MdException, RemoteException {
        double jobVersion = 3.3;
        int propSize = job.getProperties().size();
        for (int i = 0; i < propSize; ++i) {
            Property prop = (Property)job.getProperties().get(i);
            if (!prop.getPropertyName().equals(DIS_VERSION_PROPERTY_NAME)) continue;
            try {
                jobVersion = Double.parseDouble(prop.getDefaultValue());
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return jobVersion;
    }

    public Icon createCheckoutIcon(Icon icon) {
        Icon[] aIcons = new Icon[]{bundle.getImageIcon("Common.CheckedOutCheck.image"), icon};
        WsCompoundIcon iconCompound = new WsCompoundIcon(aIcons);
        iconCompound.setIconGap(-8);
        iconCompound.setReverseOrder(true);
        return iconCompound;
    }

    public void setShortcutBar(WorkspaceShortcutBar bar) {
        this.m_ShortcutBar = bar;
        bar.setMinimumSize(new Dimension(110, 1));
    }

    public WorkspaceShortcutBar getShortcutBar() {
        return this.m_ShortcutBar;
    }

    public void addMessagesWindow() {
        this.m_messagesWindow.setVisible(true);
        this.m_messagesWindow.getCloseButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Workspace.this.hideMessagesWindow();
            }
        });
    }

    public WsMessagesWindow getMessagesWindow() {
        return this.m_messagesWindow;
    }

    public boolean addWorkspaceData(String key, Object value) {
        if (this.m_workspaceData.containsKey(key)) {
            return false;
        }
        this.m_workspaceData.put(key, value);
        return true;
    }

    public Object getWorkspaceData(String key) {
        return this.m_workspaceData.get(key);
    }

    public void initialize() {
        if (this.m_appDefaultsFile != null) {
            if (this.m_appDefaultsFile.getPropertyBoolean("Workspace.maximized", true)) {
                this.setExtendedState(6);
            }
            Dimension dimScreenSize = Toolkit.getDefaultToolkit().getScreenSize();
            int iScreenWidth = dimScreenSize.width;
            int iScreenHeight = dimScreenSize.height;
            int iDefaultWidth = Math.max(iScreenWidth - 100, 800);
            int iDefaultHeight = Math.max(iScreenHeight - 100, 600);
            int iDefaultX = iScreenWidth > iDefaultWidth ? (iScreenWidth - iDefaultWidth) / 2 : 0;
            int iDefaultY = iScreenHeight > iDefaultHeight ? (iScreenHeight - iDefaultHeight) / 2 : 0;
            this.setLocation(this.m_appDefaultsFile.getPropertyInt("Workspace.x", iDefaultX), this.m_appDefaultsFile.getPropertyInt("Workspace.y", iDefaultY));
            this.setSize(this.m_appDefaultsFile.getPropertyInt("Workspace.cx", iDefaultWidth), this.m_appDefaultsFile.getPropertyInt("Workspace.cy", iDefaultHeight));
        }
        this.setVisible(true);
        this.displayErrorLogStatus();
    }

    public void startLog() {
        this.m_errorLogStarted = true;
        String title = this.getTitle();
        title = title.replaceAll(" ", "_");
        if (m_errorLogFileName == null) {
            m_errorLogFileName = Workspace.getAppDataPath() + System.getProperty("file.separator");
            m_errorLogFileName = m_errorLogFileName + "errorLog_" + title + ".txt";
        }
        if (m_LogFileName == null) {
            m_LogFileName = Workspace.getAppDataPath() + System.getProperty("file.separator");
            m_LogFileName = m_LogFileName + "OMRServerXML_" + title + ".log";
        }
        if (m_bLoggingDebugMessages) {
            System.out.println("startLog: Application logging to file: " + m_errorLogFileName);
            System.out.println("startLog: Metadata XML logging to file: " + m_LogFileName);
        }
        boolean bUseExternalLogConfig = false;
        String loggingConfigURL = System.getProperty("com.sas.services.logging.configurationURL");
        if (loggingConfigURL != null && loggingConfigURL.length() > 0) {
            bUseExternalLogConfig = true;
        }
        if (!bUseExternalLogConfig) {
            File dMfile;
            boolean isDeleted;
            File dfile;
            if (m_errorLogFileName != null && (dfile = new File(m_errorLogFileName)).exists() && !m_bKeepLog && (isDeleted = dfile.delete())) {
                try {
                    dfile.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (m_LogFileName != null && (dMfile = new File(m_LogFileName)).exists() && !m_bKeepLog && (isDeleted = dMfile.delete())) {
                try {
                    dMfile.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (!m_bDebug) {
                File file = new File(m_errorLogFileName);
                try {
                    if (!file.exists()) {
                        file.getParentFile().mkdirs();
                    }
                    FileOutputStream logFile = new FileOutputStream(file);
                    PrintStream printStream = new PrintStream(logFile);
                    System.setOut(printStream);
                    System.setErr(printStream);
                }
                catch (FileNotFoundException e) {
                    this.m_errorLogStarted = false;
                }
            } else {
                this.m_errorLogStarted = false;
            }
        } else {
            System.out.println("startLog: Ignoring all command line logging options, user specified logging file \"" + loggingConfigURL + "\" used");
        }
    }

    protected void displayErrorLogStatus() {
        if (!this.m_errorLogStarted && !m_bDebug) {
            File file = new File(m_errorLogFileName);
            MessageUtil.displayMessage(bundle.formatString("Workspace.LogError.Message.fmt.txt", file.getAbsolutePath()), bundle.getString("Workspace.LogError.Title.txt"), 0);
        }
    }

    public void connect() {
        this.connect(true);
    }

    public void connect(boolean bAddRepositoryEnabled) {
        String strReload = this.m_appDefaultsFile.getPropertyString("ReloadLastWorkspace");
        if (strReload.length() == 0) {
            this.m_appDefaultsFile.setPropertyString("ReloadLastWorkspace", "false");
        }
        this.getConnected(strReload.equals("true"), false, bAddRepositoryEnabled);
    }

    public void getConnected(boolean bReload, boolean bForceWizard) {
        this.getConnected(bReload, bForceWizard, true);
    }

    public void getConnected(boolean bReload, boolean bForceWizard, boolean bAddRepositoryEnabled) {
        File workspaceDir;
        boolean bConnect = false;
        boolean bStartWizard = false;
        boolean bWorkspacesExist = false;
        this.m_eChangeManagementState = CHANGEMANAGEMENT_OFF;
        String strWorkspacePath = this.m_appDefaultsFile.getPropertyString("WorkspacePath");
        if (strWorkspacePath.length() == 0 || strWorkspacePath.indexOf("MetadataServerProfiles") == -1) {
            strWorkspacePath = Workspace.getMetadataProfilePath();
            this.m_appDefaultsFile.setPropertyString("WorkspacePath", strWorkspacePath);
        }
        if (!(workspaceDir = new File(strWorkspacePath)).exists()) {
            workspaceDir.mkdir();
        }
        if (workspaceDir.list().length > 0) {
            bWorkspacesExist = true;
        } else {
            String separator = System.getProperty("file.separator");
            String potentialPath = Workspace.getSeededProfilePath() + separator + "SAS.swa";
            File potentialWorkspace = new File(potentialPath);
            if (potentialWorkspace.exists()) {
                String strNewProfilePath = Workspace.getMetadataProfilePath() + separator + "SAS.swa";
                File oWorkspaceProfile = new File(strNewProfilePath);
                if (!oWorkspaceProfile.exists()) {
                    oWorkspaceProfile.mkdir();
                }
                bWorkspacesExist = true;
            }
        }
        if (!bWorkspacesExist || bForceWizard) {
            bStartWizard = true;
        }
        if (!bReload) {
            if (!bStartWizard) {
                WAConnectDialog pConnectDialog = new WAConnectDialog((Frame)this, false, bAddRepositoryEnabled);
                WorkspaceUtil.centerFourth(pConnectDialog);
                pConnectDialog.show();
                if (pConnectDialog.getReturnValue() == 1) {
                    bStartWizard = pConnectDialog.getCreateNewWorkspace();
                    boolean bl = bConnect = !bStartWizard;
                }
            }
            if (bStartWizard) {
                WAConnectWizard pConnectWizard = new WAConnectWizard((Frame)this, false, false, bAddRepositoryEnabled);
                WorkspaceUtil.centerFourth(pConnectWizard);
                pConnectWizard.show();
                if (pConnectWizard.getReturnValue() == 3 || pConnectWizard.getReturnValue() == 1) {
                    bConnect = true;
                } else if (bWorkspacesExist) {
                    new ConnectLater();
                    return;
                }
            }
        }
        if (bReload || bConnect) {
            OpRequestUI OpRequestUI2 = new OpRequestUI(MessageUtil.getMainWindow(), bundle.getString("ConnectProgressIndicator.Msg.Message.txt"), bundle.getString("ConnectProgressIndicator.Msg.Title"));
            OpRequestUI2.setDelayBeforeProgressCancelDialog(0);
            Runnable startupDesktop = new Runnable(){

                @Override
                public void run() {
                    Workspace.this.startupDesktop();
                }
            };
            OpRequestUI2.execute(startupDesktop);
        }
    }

    public int startConnection(Frame parent, boolean showProjectPanel) {
        return this.startConnection(parent, this.m_appDefaultsFile.getPropertyBoolean("ReloadLastWorkspace", false), showProjectPanel);
    }

    public static void setUseNewStartupReturnValues(boolean val) {
        bUseNewStartupReturnValues = val;
    }

    public static boolean isUsingNewStartupReturnValues() {
        return bUseNewStartupReturnValues;
    }

    public int startup(Frame parent, boolean showProjectPanel) {
        boolean loadLastProfile = this.m_appDefaultsFile.getPropertyBoolean("ReloadLastWorkspace", false);
        return this.startup(parent, loadLastProfile, showProjectPanel);
    }

    public int startConnection(Frame parent, boolean loadLastProfile, boolean showProjectPanel) {
        int status = this.startup(parent, loadLastProfile, showProjectPanel);
        while (status == 2) {
            status = this.startup(parent, false, showProjectPanel);
        }
        if (status == 0 && !this.checkForMetadataServerInstall()) {
            return 1;
        }
        return status;
    }

    public int startup(Frame parent, boolean loadLastProfile, boolean showProjectPanel) {
        String securityPackageList;
        String servicePrincipalName;
        String lastWorkspace;
        File workspaceDir;
        this.m_eChangeManagementState = CHANGEMANAGEMENT_OFF;
        this.m_bUnrestrictedUser = false;
        String workspacePath = this.m_appDefaultsFile.getPropertyString("WorkspacePath");
        if (workspacePath.length() == 0 || workspacePath.indexOf("MetadataServerProfiles") == -1) {
            workspacePath = Workspace.getMetadataProfilePath();
            this.m_appDefaultsFile.setPropertyString("WorkspacePath", workspacePath);
        }
        if (!(workspaceDir = new File(workspacePath)).exists()) {
            workspaceDir.mkdir();
        }
        if (workspaceDir == null || workspaceDir.list() == null || workspaceDir.list().length <= 0) {
            loadLastProfile = false;
            String separator = System.getProperty("file.separator");
            String sSeededPath = Workspace.getSeededProfilePath() + separator + "SAS.swa";
            File fPotentialWorkspace = new File(sSeededPath);
            if (fPotentialWorkspace.exists()) {
                WorkspaceFile wfSeededProfile = new WorkspaceFile();
                wfSeededProfile.openExisting(sSeededPath);
                String strNewProfilePath = Workspace.getMetadataProfilePath() + separator + "My Server.swa";
                File fNewWorkspaceProfile = new File(strNewProfilePath);
                try {
                    if (!fNewWorkspaceProfile.exists()) {
                        fNewWorkspaceProfile.createNewFile();
                    }
                    workspaceDir = fNewWorkspaceProfile;
                    WorkspaceFile wfNewProfile = new WorkspaceFile();
                    wfNewProfile.openExisting(strNewProfilePath);
                    String strWorkspaceName = wfSeededProfile.getPropertyString("Name");
                    String hostname = wfSeededProfile.getPropertyString("host");
                    String port = wfSeededProfile.getPropertyString("port");
                    String domain = wfSeededProfile.getPropertyString("authenticationdomain", "DefaultAuth");
                    boolean fSingleSignon = wfSeededProfile.getPropertyBoolean("SingleSignOn", false);
                    wfNewProfile.setPropertyString("Name", strWorkspaceName);
                    wfNewProfile.setPropertyString("host", hostname);
                    wfNewProfile.setPropertyString("port", port);
                    wfNewProfile.setPropertyString("authenticationdomain", domain);
                    wfNewProfile.setPropertyBoolean("SingleSignOn", fSingleSignon);
                    wfNewProfile.saveExisting();
                    this.m_workspaceFile = wfNewProfile;
                }
                catch (IOException ex) {
                    Workspace.getDefaultLogger().debug("Problem attempting to initialize from default profile");
                }
            } else if (!this.showProfileWizard(parent, showProjectPanel)) {
                return 1;
            }
        } else if (loadLastProfile && !this.m_workspaceFile.isOpen() && this.m_appDefaultsFile.isOpen() && (lastWorkspace = this.m_appDefaultsFile.getPropertyString("LastWorkspace")) != null && lastWorkspace.length() > 0) {
            File workspaceFile = new File(lastWorkspace);
            if (workspaceFile.exists()) {
                this.m_workspaceFile.openExisting(lastWorkspace);
            } else {
                this.m_appDefaultsFile.setPropertyString("ReloadLastWorkspace", "false");
                loadLastProfile = false;
            }
        }
        if (!loadLastProfile && !this.showProfileDialog(parent, showProjectPanel)) {
            return 1;
        }
        String hostname = this.m_workspaceFile.getPropertyString("host");
        String port = this.m_workspaceFile.getPropertyString("port");
        String username = this.m_workspaceFile.getPropertyString("userid");
        String password = this.m_workspaceFile.getPropertyString("password");
        String domain = this.m_workspaceFile.getPropertyString("authenticationdomain");
        boolean internalAccount = this.m_workspaceFile.getPropertyBoolean("InternalAccount", false);
        String securityPackage = this.m_workspaceFile.getPropertyString("SecurityPackage");
        if (securityPackage == null) {
            securityPackage = "Negotiate";
        }
        if ((servicePrincipalName = this.m_workspaceFile.getPropertyString("ServicePrincipalName")) == null) {
            servicePrincipalName = "";
        }
        if ((securityPackageList = this.m_workspaceFile.getPropertyString("SecurityPackageList")) == null) {
            securityPackageList = "Kerberos,NTLM";
        }
        if (this.isSingleSignOnEnabled()) {
            this.setSingleSignOn(this.m_workspaceFile.getPropertyBoolean("SingleSignOn", false));
        }
        if (hostname == null || hostname.length() == 0) {
            MessageUtil.displayMessage(bundle.getString("Workspace.EmptyHostname.txt"), 0);
            return 2;
        }
        if (port == null || port.length() == 0) {
            MessageUtil.displayMessage(bundle.getString("Workspace.EmptyPortNumber.txt"), 0);
            return 2;
        }
        OpRequestUI request = new OpRequestUI(MessageUtil.getMainWindow(), bundle.getString("ConnectProgressIndicator.Msg.Message.txt"), bundle.getString("ConnectProgressIndicator.Msg.Title"));
        request.setDelayBeforeProgressCancelDialog(0);
        StartupDesktopRunnable startupDesktop = new StartupDesktopRunnable(parent, hostname, port, domain, username, password);
        this.m_connectionManager.setSecurityPackage(securityPackage);
        this.m_connectionManager.setServicePrincipalName(servicePrincipalName);
        this.m_connectionManager.setSecurityPackageList(securityPackageList);
        this.m_connectionManager.setInternalAccount(internalAccount);
        request.execute(startupDesktop);
        return startupDesktop.getStatus();
    }

    public boolean showProfileDialog(Frame parent, boolean showProjectPanel) {
        boolean done = false;
        while (!done) {
            WAConnectDialog profileDialog = new WAConnectDialog(parent, false, false, showProjectPanel);
            profileDialog.center();
            profileDialog.show();
            boolean bl = done = profileDialog.getReturnValue() == 1;
            if (!done) {
                return false;
            }
            if (!profileDialog.getCreateNewWorkspace()) continue;
            done = this.showProfileWizard(parent, showProjectPanel);
        }
        return done;
    }

    public boolean showProfileWizard(Frame parent, boolean showProjectPanel) {
        WAConnectWizard profileWizard = new WAConnectWizard(parent, false, false, false, showProjectPanel);
        profileWizard.center();
        profileWizard.show();
        return profileWizard.getReturnValue() == 3 || profileWizard.getReturnValue() == 1;
    }

    public void showCheckedOutObjectsWarning() {
        if (this.m_defaultRepository != null && this.isChangeManagementOn() && this.getApplicationChecksProjectRepository() && Workspace.getMetadataServerVersionNumber() > 0) {
            try {
                if (this.doesProjectHaveCheckedOutOrFetchedObjects()) {
                    StringBuffer sbPropertyString = new StringBuffer().append("Workspace.CMProjectWarningDialog.").append(this.getDefaultRepository().getFQID()).append(".show");
                    WsCheckToIgnoreDialog.showCheckToIgnoreDialog(false, bundle.getString("Workspace.CMProjectWarning.Title.txt"), bundle.getString("Workspace.CMProjectWarning.txt"), sbPropertyString.toString());
                }
            }
            catch (MdException mde) {
                mde.printStackTrace();
            }
            catch (RemoteException ex) {
                ex.printStackTrace();
            }
        }
    }

    public boolean doesProjectHaveCheckedOutOrFetchedObjects() throws MdException, RemoteException {
        return Workspace.doesRepositoryHaveCheckedOutOrFetchedObjects(this.getProjectRepository().getFQID());
    }

    public static boolean doesRepositoryHaveCheckedOutOrFetchedObjects(String projectReposID) throws MdException, RemoteException {
        String sOptions = "<XMLSELECT Search=\"*[@ChangeState ? '.']\"/>";
        List lObjects = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)Workspace.getMdFactory().getStore(), projectReposID, "Root", 408, sOptions);
        for (int i = 0; i < lObjects.size(); ++i) {
            if (((Root)lObjects.get(i)).getCMetadataType().equals("Login")) continue;
            return true;
        }
        return false;
    }

    public ApplicationInterface getApplicationInterface(ServerInterface server, String componentName) throws MdException, RemoteException, ServiceException {
        Filter filter = new Filter("ClassIdentifier", 0, componentName);
        filter.setType("SoftwareComponent");
        List listObjects = server.search((FilterInterface)filter);
        if (listObjects.size() > 0 && listObjects.get(0) instanceof ApplicationInterface) {
            return (ApplicationInterface)listObjects.get(0);
        }
        return null;
    }

    public String getApplicationName(ServerInterface server, String componentName) throws MdException, RemoteException, ServiceException {
        FolderInterface parentFolder;
        FolderInterface folder;
        String applicationName = this.getApplicationName();
        ApplicationInterface app = this.getApplicationInterface(server, componentName);
        if (app != null && (folder = app.getParent()) != null && (parentFolder = folder.getParent()) != null) {
            applicationName = parentFolder.getName();
        }
        return applicationName;
    }

    public boolean checkForMetadataServerInstall() {
        String DI_STUDIO_SOFTWARE_COMPONENT_NAME = "DI Studio Server Data 4.7";
        try {
            ApplicationInterface sc = this.getApplicationInterface(Workspace.getWorkspace().getUserContext().getAuthServer(), DI_STUDIO_SOFTWARE_COMPONENT_CLASSID);
            if (sc != null) {
                Workspace.getDefaultLogger().info("SoftwareVersion is: " + sc.getSoftwareVersion());
                if ("DI Studio Server Data 4.7".equals(sc.getName())) {
                    return true;
                }
            }
            String msg = bundle.getString("Workspace.CheckMetadataServerInstallWarning.txt");
            MessageUtil.displayMessage(msg, 0);
            return true;
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage(e, "Reading");
            return false;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
            return false;
        }
        catch (ServiceException ex) {
            Workspace.handleServiceException(ex);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void startupDesktop() {
        if (!this.m_workspaceFile.isOpen()) {
            if (!this.m_appDefaultsFile.isOpen()) return;
            String strLastWorkspace = this.m_appDefaultsFile.getPropertyString("LastWorkspace");
            if (strLastWorkspace.length() == 0) {
                new ConnectLater();
                return;
            }
            File workspaceFile = new File(strLastWorkspace);
            if (!workspaceFile.exists()) {
                this.m_appDefaultsFile.setPropertyString("ReloadLastWorkspace", "false");
                new ConnectLater();
                return;
            }
            this.m_workspaceFile.openExisting(strLastWorkspace);
        }
        String strHost = this.m_workspaceFile.getPropertyString("host");
        String strPort = this.m_workspaceFile.getPropertyString("port");
        String strUser = this.m_workspaceFile.getPropertyString("userid");
        String strPass = this.m_workspaceFile.getPropertyString("password");
        String strDomain = this.m_workspaceFile.getPropertyString("authenticationdomain");
        if (this.isSingleSignOnEnabled()) {
            this.setSingleSignOn(this.m_workspaceFile.getPropertyBoolean("SingleSignOn", false));
        }
        if (strHost.length() == 0 || strPort.length() == 0) {
            new ConnectLater();
            return;
        }
        if (!this.isFoundationServicesConnection() || !this.isSingleSignOn()) {
            if (strUser.length() == 0 || strPass.length() == 0) {
                strUser = this.m_strUsername;
                strPass = this.m_strPassword;
                this.m_strUsername = "";
                this.m_strPassword = "";
            }
            if (strUser.length() == 0 || strPass.length() == 0) {
                final WALoginDialog pLoginDialog = new WALoginDialog((Frame)this, bundle.getString("LoginDialog.Title.txt"));
                if (SwingUtilities.isEventDispatchThread()) {
                    pLoginDialog.show();
                } else {
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                pLoginDialog.show();
                            }
                        });
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (pLoginDialog.getReturnValue() != 1) {
                    new ConnectLater();
                    return;
                }
                strUser = pLoginDialog.getUsername();
                strPass = pLoginDialog.getPassword();
            }
        }
        boolean brc = false;
        try {
            if (this.isFoundationServicesConnection()) {
                if (this.isSingleSignOn()) {
                    this.m_connectionManager.connectToOMRServer(strHost, strPort, strDomain, null, null);
                } else {
                    this.m_connectionManager.connectToOMRServer(strHost, strPort, strDomain, strUser, strPass);
                }
                brc = true;
            } else {
                brc = this.makeOMRConnection(strHost, strPort, strUser, strPass, true);
            }
        }
        catch (ConnectionException ex) {
            MessageUtil.displayMessage(ex.getLocalizedMessage(), 0);
            brc = false;
        }
        catch (RemoteException ex) {
            MessageUtil.displayMessage(ex.getLocalizedMessage(), 0);
            brc = false;
        }
        catch (ServiceException ex) {
            MessageUtil.displayServiceExceptionMessage(ex);
            brc = false;
        }
        catch (InterruptedException ex) {
            MessageUtil.displayMessage(bundle.getString("Workspace.ConnectError.txt"), 0);
            brc = false;
        }
        catch (Exception ex) {
            Workspace.getDefaultLogger().error((Object)"", ex);
            MessageUtil.displayMessage(ex.getLocalizedMessage(), 0);
            brc = false;
        }
        if (!brc) {
            new ConnectLater();
            return;
        }
        if (this.isServerStatusCheckEnabled()) {
            this.checkMetadataServerStatus(true);
        }
        this.setSelectedRepositories();
        if (this.m_defaultRepository == null) {
            Workspace.getWorkspace().setStatusText(bundle.getString("Workspace.NoReposError.txt"));
            return;
        }
        this.m_splitManagerPanel = new JPanel();
        this.m_splitManager = new SplitManager(this.m_splitManagerPanel);
        this.getContentPane().add((Component)this.m_splitManagerPanel, "Center");
        this.firePropertyChange(METADATA_PROFILE_FILENAME_PROPERTY, "", this.m_workspaceFile.getFileName());
        if (this.m_treeObject != null) {
            this.m_treeObject.initialize();
            cFocusListener flTree = new cFocusListener(this.m_treeObject);
            WsFocusListenerPropagator flpTree = new WsFocusListenerPropagator(flTree);
            flpTree.startListeningTo(this.m_treeObject.getTreeComponent());
        }
        if (!this.m_bSkipInitializeDesktopLayout) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Workspace.this.initializeDesktop();
                }
            });
        }
        try {
            if (this.isFoundationServicesConnection()) return;
            this.setMetadataDomain();
            return;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
    }

    public String getAuthenticationDomain() {
        String strDomain = this.getWorkspaceFile().getPropertyString("authenticationdomain");
        if (strDomain.length() == 0) {
            strDomain = "DefaultAuth";
        }
        return strDomain;
    }

    public void setMetadataDomain() throws RemoteException {
    }

    public void validateAndInstantiateUser(String strUserID) {
        List m_metaQuery = new Vector();
        try {
            MdObjectStore store = s_metadataFactory.createObjectStore();
            try {
                String sOptions = "<Templates><Person><Logins/></Person><Login UserID=\"\"/></Templates><XMLSelect search=\"*[Logins/*[@UserID='" + strUserID + "']]\"/>";
                m_metaQuery = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)store, this.getDefaultRepository().getFQID(), "Person", 8580, sOptions);
                if (m_metaQuery.size() == 0) {
                    String updateXML = "<AddMetadata><METADATA><Person  Name=\"" + strUserID + "\"><Logins><Login Name=\"" + strUserID + "\" Userid=\"" + strUserID + "\" Password=\"dummy\"/></Logins></Person></METADATA><reposid>" + this.getDefaultRepository().getFQID() + "</reposid> <ns>SAS</ns><flags>268435456</flags><options></options></AddMetadata>";
                    Workspace.getMdFactory().getOMIUtil().DoRequest(updateXML);
                }
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage(e, "Reading");
            }
            store.dispose();
        }
        catch (RemoteException ex) {
            ex.printStackTrace();
        }
    }

    protected void setMdFactoryForIMS(MdFactory factory) {
        try {
            s_metadataFactory = factory;
            this.m_MetadataWorkspace = factory.getConnection();
            this.m_pIOMI = this.m_MetadataWorkspace.getCMRHandle();
            this.m_pIServer = this.m_MetadataWorkspace.MakeIServerConnection(this.m_pIOMI);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
        catch (MdException ex) {
            Workspace.getDefaultLogger().error((Object)"", ex);
        }
    }

    public boolean makeOMRConnection(String strHost, String strPort, String strUsername, String strEncryptedPassword, boolean bAllowLoginDialog) {
        String strErrMsg;
        while (true) {
            strErrMsg = null;
            try {
                if (this.m_MetadataWorkspace == null) {
                    this.m_MetadataWorkspace = Workspace.getMdFactory().getConnection();
                }
                this.m_pIOMI = this.m_MetadataWorkspace.makeOMRConnection(strHost, strPort, strUsername, s_metadataFactory.getUtil().decrypt(strEncryptedPassword));
                this.m_pIServer = this.m_MetadataWorkspace.MakeIServerConnection(this.m_pIOMI);
                m_MetadataServerVersion = this.m_MetadataWorkspace.getPlatformVersion();
                this.m_strServerName = strHost;
                this.m_strUsername = strUsername;
                return true;
            }
            catch (MdException ex) {
                Throwable t = ex.getCause();
                if (t != null) {
                    String strErrType = ex.getSASMessageSeverity();
                    if (strErrType != null) {
                        Workspace.getDefaultLogger().error(strErrType + ": " + ex.getSASMessage());
                    }
                    if (t instanceof COMM_FAILURE) {
                        MessageUtil.displayMessage(bundle.getString("Workspace.ConnectError.txt"), 0);
                        break;
                    }
                    if (t instanceof NO_PERMISSION) {
                        WALoginDialog dlgLogin;
                        block19: {
                            MessageUtil.displayMessage(bundle.getString("Workspace.LoginError.txt"), 0);
                            if (!bAllowLoginDialog) break;
                            dlgLogin = new WALoginDialog((Frame)this, bundle.getString("LoginDialog.Title.txt"));
                            if (SwingUtilities.isEventDispatchThread()) {
                                dlgLogin.show();
                            } else {
                                try {
                                    SwingUtilities.invokeAndWait(new Runnable(){

                                        @Override
                                        public void run() {
                                            dlgLogin.show();
                                        }
                                    });
                                }
                                catch (InvocationTargetException e) {
                                    if (m_bDebug) {
                                        e.printStackTrace();
                                    }
                                }
                                catch (InterruptedException e) {
                                    if (!m_bDebug) break block19;
                                    e.printStackTrace();
                                }
                            }
                        }
                        if (dlgLogin.getReturnValue() != 1) break;
                        strUsername = dlgLogin.getUsername();
                        strEncryptedPassword = dlgLogin.getPassword();
                        continue;
                    }
                    if (t instanceof INV_OBJREF) {
                        MessageUtil.displayMessage(bundle.getString("Workspace.InvalidServerError.txt"), 0);
                        break;
                    }
                    strErrMsg = t.getLocalizedMessage();
                    if (!m_bDebug) break;
                    t.printStackTrace();
                    break;
                }
                strErrMsg = ex.getLocalizedMessage();
                if (!m_bDebug) break;
                ex.printStackTrace();
            }
            catch (RemoteException e) {
                strErrMsg = e.getLocalizedMessage();
                if (!m_bDebug) break;
                e.printStackTrace();
            }
            break;
        }
        if (strErrMsg != null) {
            if (strErrMsg.compareTo("") == 0) {
                MessageUtil.displayMessage(bundle.getString("Workspace.UnknownError.NoMessage.txt"), 0);
            } else {
                MessageUtil.displayMessage(bundle.formatString("Workspace.UnknownError.Message.txt", strErrMsg), 0);
            }
        }
        return false;
    }

    public IServer getIServer() {
        return this.m_pIServer;
    }

    public String getServerName() {
        OMIServer server = this.m_connectionManager.getMetadataServer();
        if (server != null) {
            try {
                return server.getHost();
            }
            catch (RemoteException remoteException) {
            }
            catch (ServiceException serviceException) {
                // empty catch block
            }
        }
        return this.m_strServerName;
    }

    public String getServerPort() {
        OMIServer server = this.m_connectionManager.getMetadataServer();
        if (server != null) {
            try {
                return Integer.toString(server.getPort());
            }
            catch (RemoteException remoteException) {
            }
            catch (ServiceException serviceException) {
                // empty catch block
            }
        }
        return this.getWorkspaceFile().getPropertyString("port");
    }

    public String getServerDisplayName() {
        String serverName = this.getServerName();
        int index = serverName.indexOf(46);
        if (index > 0) {
            serverName = serverName.substring(0, index);
        }
        return serverName + " : " + this.getServerPort();
    }

    protected String getServerToolTip() {
        try {
            return HostPortSet.newInstance((String)this.getWorkspaceFile().getPropertyString("host"), (String)this.getWorkspaceFile().getPropertyString("port")).toString();
        }
        catch (Exception e) {
            return this.getServerDisplayName();
        }
    }

    public void closeOMRConnection() {
        try {
            if (this.m_pIServer != null) {
                this.m_MetadataWorkspace.closeIServerConnection(this.m_pIServer);
                this.m_pIServer = null;
            }
            if (this.getCMRHandle() != null) {
                this.m_pIOMI = null;
                this.m_MetadataWorkspace.closeOMRConnection();
                this.m_MetadataWorkspace.setCMRHandle(null);
            }
            this.m_strServerName = null;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
        catch (MdException ex) {
            Workspace.getDefaultLogger().error((Object)"closing connection to metadata server", ex);
        }
    }

    public void initializeDesktop() {
        try {
            JComponent m_treeComponent = null;
            if (this.m_Desktop != null) {
                this.m_splitManager.add(this.m_Desktop);
            }
            if (this.m_treeObject != null && this.m_Desktop != null) {
                m_treeComponent = (JComponent)this.m_treeObject.getTreeComponent();
                m_treeComponent.setMinimumSize(new Dimension(30, 200));
                int treeWidth = this.m_appDefaultsFile.getPropertyInt("Workspace.TreeSplit", 200);
                m_treeComponent.setPreferredSize(new Dimension(treeWidth, m_treeComponent.getHeight()));
                int nShowShortcutBar = this.m_appDefaultsFile.getPropertyInt("Workspace.ShortcutBar", 1);
                if (this.m_ShortcutBar != null && nShowShortcutBar == 1) {
                    this.m_ShortcutBar.setMinimumSize(new Dimension(110, 1));
                    int shortcutWidth = this.m_appDefaultsFile.getPropertyInt("Workspace.ActionSplit", 110);
                    int dividerLocation = treeWidth + shortcutWidth + 5;
                    this.m_appDefaultsFile.setPropertyInt("Workspace.TreeSplit", dividerLocation);
                    this.m_splitManager.add(1, m_treeComponent, this.m_Desktop, dividerLocation, 0.0);
                    this.showShortcutBar();
                    cFocusListener flShortcutBar = new cFocusListener(this.m_ShortcutBar);
                    WsFocusListenerPropagator flpShortcutBar = new WsFocusListenerPropagator(flShortcutBar);
                    flpShortcutBar.startListeningTo(this.m_ShortcutBar);
                } else {
                    int dividerLocation = treeWidth;
                    this.m_splitManager.add(1, m_treeComponent, this.m_Desktop, dividerLocation, 0.0);
                }
            }
            if (null != this.m_messagesWindow) {
                this.m_messagesWindow.setPreferredSize(new Dimension(1, 80));
                int nShowMessagesWindow = this.m_appDefaultsFile.getPropertyInt("Workspace.MessagesWindow", 0);
                if (nShowMessagesWindow == 1) {
                    this.showMessagesWindow();
                }
                cFocusListener flMessagesWindow = new cFocusListener(this.m_messagesWindow);
                WsFocusListenerPropagator flpMessagesWindow = new WsFocusListenerPropagator(flMessagesWindow);
                flpMessagesWindow.startListeningTo(this.m_messagesWindow);
            }
            if (null != this.m_overviewWindow) {
                this.m_overviewWindow.setPreferredSize(new Dimension(30, 150));
                if (this.m_appDefaultsFile.getPropertyBoolean("Workspace.OverviewWindow", true)) {
                    this.showOverviewWindow();
                }
            }
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().error((Object)"", e);
        }
        this.setTitle(this.m_strAppTitle + " - " + this.getWorkspaceFile().getPropertyString("Name"));
        WsStatusBarUtilities.addAppserverPanel();
        WsStatusBarUtilities.addUserPanel();
        WsStatusBarUtilities.addServerPanel();
        this.updateMenuOnConnect(true);
        this.repaint();
    }

    public void shutdownDesktop() {
        try {
            this.shutdownDesktop2();
        }
        catch (PropertyVetoException ex) {
            Workspace.getDefaultLogger().debug((Object)"Workspace.getWorkspace().shutdownDesktop() should not be used!  Use shutdownDesktop2", ex);
        }
    }

    public void shutdownDesktop2() throws PropertyVetoException {
        this.saveComponentSizes();
        if (this.m_Desktop != null) {
            this.m_Desktop.closeAll();
        }
        if (this.m_treeObject != null) {
            this.m_treeObject.removeAll();
            this.m_treeObject = null;
        }
        this.disconnectFromOMRServer();
        this.m_strUsername = "";
        this.setTitle(this.m_strAppTitle);
        if (WsStatusBarUtilities.isAppserverPanelShown()) {
            WsStatusBarUtilities.removeAppserverPanel();
        }
        if (WsStatusBarUtilities.isUserPanelShown()) {
            WsStatusBarUtilities.removeUserPanel();
        }
        if (WsStatusBarUtilities.isServerPanelShown()) {
            WsStatusBarUtilities.removeServerPanel();
        }
        if (this.m_splitManagerPanel != null) {
            this.getContentPane().remove(this.m_splitManagerPanel);
            this.getContentPane().repaint();
        }
        this.updateMenuOnConnect(false);
        this.m_projectRepository = null;
        this.m_defaultRepository = null;
        this.m_checkinRepository = null;
        this.m_eChangeManagementState = CHANGEMANAGEMENT_OFF;
    }

    protected void updateMenuOnConnect(boolean bConnected) {
        XMLToolBar toolBar;
        int i;
        String strSetVisible;
        String strSetEnabled;
        if (this.m_appSupportObject == null) {
            return;
        }
        XMLMenuBar menuBar = this.m_appSupportObject.getMenuBar();
        if (menuBar != null) {
            ArrayList alMenus = menuBar.getMenus();
            for (int i2 = alMenus.size() - 1; i2 >= 0; --i2) {
                XMLMenu menu = (XMLMenu)alMenus.get(i2);
                strSetEnabled = menu.getXMLTag("enabledonconnect");
                strSetVisible = menu.getXMLTag("visibleonconnect");
                if (strSetEnabled != null && strSetEnabled.compareToIgnoreCase("true") == 0) {
                    menu.setEnabled(bConnected);
                }
                if (strSetVisible == null || strSetVisible.compareToIgnoreCase("true") != 0) continue;
                menu.setVisible(bConnected);
            }
            ArrayList alMenuItems = menuBar.getMenuItems();
            for (i = alMenuItems.size() - 1; i >= 0; --i) {
                XMLMenuItem menuItem = (XMLMenuItem)alMenuItems.get(i);
                strSetEnabled = menuItem.getXMLTag("enabledonconnect");
                strSetVisible = menuItem.getXMLTag("visibleonconnect");
                if (strSetEnabled != null && strSetEnabled.compareToIgnoreCase("true") == 0) {
                    menuItem.setEnabled(bConnected);
                }
                if (strSetVisible == null || strSetVisible.compareToIgnoreCase("true") != 0) continue;
                menuItem.setVisible(bConnected);
            }
        }
        if ((toolBar = this.m_appSupportObject.getToolBar()) != null) {
            ArrayList alToolItems = toolBar.getToolItems();
            for (i = alToolItems.size() - 1; i >= 0; --i) {
                XMLToolItem toolItem = (XMLToolItem)alToolItems.get(i);
                strSetEnabled = toolItem.getXMLTag("enabledonconnect");
                strSetVisible = toolItem.getXMLTag("visibleonconnect");
                if (strSetEnabled != null && strSetEnabled.compareToIgnoreCase("true") == 0) {
                    toolItem.setEnabled(bConnected);
                }
                if (strSetVisible == null || strSetVisible.compareToIgnoreCase("true") != 0) continue;
                toolItem.setVisible(bConnected);
            }
        }
    }

    protected void updateDebugMenuItems() {
    }

    public InformationServiceInterface getInformationService() {
        return this.m_connectionManager.getInformationService();
    }

    public UserServiceInterface getUserService() {
        return this.m_connectionManager.getUserService();
    }

    public SessionContextInterface getSessionContext() {
        return this.m_connectionManager.getSessionContext();
    }

    public UserContextInterface getUserContext() {
        return this.m_connectionManager.getUserContext();
    }

    public OMIServer getMetadataServer() {
        return this.m_connectionManager.getMetadataServer();
    }

    public ConnectionManager getConnectionManager() {
        return this.m_connectionManager;
    }

    public void setDeploymentURL(URL url) {
        this.m_connectionManager.setDeploymentURL(url);
    }

    public void startFoundationServices() throws ServiceException {
        try {
            this.m_connectionManager.startFoundationServices();
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException(e);
        }
    }

    public void validateFoundationServices() throws ServiceException {
        this.m_connectionManager.validateFoundationServices();
    }

    public boolean connectToOMRServer(String host, String port, String domain, String user, String password) {
        try {
            this.m_connectionManager.connectToOMRServer(host, port, domain, user, password);
        }
        catch (ConnectionException e) {
            return false;
        }
        catch (RemoteException e) {
            return false;
        }
        catch (ServiceException e) {
            MessageUtil.displayServiceExceptionMessage(e);
            return false;
        }
        catch (InterruptedException ex) {
            return false;
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().error((Object)"", e);
            return false;
        }
        return true;
    }

    public void disconnectFromOMRServer() {
        if (!this.isConnected()) {
            return;
        }
        try {
            this.getConnectionManager().disconnectFromOMRServer();
            this.m_strServerName = null;
            if (this.m_pIServer != null) {
                this.m_MetadataWorkspace.closeIServerConnection(this.m_pIServer);
                this.m_pIServer = null;
            }
            if (this.getCMRHandle() != null) {
                this.m_pIOMI = null;
                this.m_MetadataWorkspace.closeOMRConnection();
                this.m_MetadataWorkspace.setCMRHandle(null);
            }
            this.m_connected = false;
        }
        catch (MdException ex) {
            MessageUtil.displayMessage(ex.getLocalizedMessage(), 0);
        }
        catch (RemoteException ex) {
            MessageUtil.displayMessage(ex.getLocalizedMessage(), 0);
        }
    }

    public void updateFactoryConnection() {
        Workspace.getDefaultLogger().debug("Starting updateFactoryConnection");
        UserServiceInterface svcUser = CorePlatformServices.getUserService();
        InformationServiceInterface svcInformation = CorePlatformServices.getInformationService();
        if (svcUser == null || svcInformation == null) {
            MessageUtil.displayMessage("CorePlatformServices are not available.  Your etlstudio.ini file may not have the required security definitions.", 0);
            Workspace.getDefaultLogger().debug("Skipping updateFactoryConnection");
            return;
        }
        try {
            svcInformation.getReposDefs();
            String strHost = this.getConnectionManager().getHost();
            String strPort = this.getConnectionManager().getPort();
            String strDomain = this.getConnectionManager().getDomain();
            String strUser = this.getConnectionManager().getUser();
            String strPass = this.getConnectionManager().getPassword();
            List lReposDefs = svcInformation.getReposDefs();
            for (int iReposDef = 0; iReposDef < lReposDefs.size(); ++iReposDef) {
                svcInformation.removeRepositoryDef((RepositoryDef)lReposDefs.get(iReposDef));
            }
            if (this.m_userContext != null) {
                this.m_userContext.destroy();
                this.m_userContext = null;
            }
            if (this.m_sessionContext != null) {
                this.m_sessionContext.destroy();
                this.m_sessionContext = null;
            }
            List lRepositories = Workspace.getWorkspace().getSelectedRepositories();
            for (int iRepository = 0; iRepository < lRepositories.size(); ++iRepository) {
                Root mdoRepository = (Root)lRepositories.get(iRepository);
                String strRepositoryName = mdoRepository.getName();
                RepositoryDef def = new RepositoryDef(strHost, strPort, strDomain, strRepositoryName, "omi", strRepositoryName);
                def.setAuto(true);
                svcInformation.addRepositoryDef(def);
            }
            try {
                this.m_userContext = CorePlatformServices.getUserService().newUser(strUser, strPass, strDomain, null, this.getApplicationNameForLogging());
            }
            catch (UserInitializationException ex) {
                this.m_userContext = ex.getUser();
            }
            this.m_sessionContext = CorePlatformServices.getSessionService().newSessionContext(this.m_userContext);
            Workspace.getDefaultLogger().debug("calling setConnection");
        }
        catch (ServiceException ex) {
            MessageUtil.displayServiceExceptionMessage(ex);
        }
        catch (RemoteException ex) {
            MessageUtil.displayMessage(ex.getLocalizedMessage(), 0);
        }
        Workspace.getDefaultLogger().debug("Finishing updateFactoryConnection");
    }

    public void updateFactory() {
        try {
            s_metadataFactory = this.m_connectionManager.getFactory();
            s_metadataFactory.setRemoveDependentObjects(true);
            this.m_MetadataWorkspace = s_metadataFactory.getConnection();
            this.m_pIOMI = this.m_MetadataWorkspace.getCMRHandle();
            this.m_pIServer = this.m_MetadataWorkspace.MakeIServerConnection(this.m_pIOMI);
            m_MetadataServerVersion = this.m_MetadataWorkspace.getPlatformVersion();
            boolean bUseExternalLogConfig = false;
            String loggingConfigURL = System.getProperty("com.sas.services.logging.configurationURL");
            if (loggingConfigURL != null && loggingConfigURL.length() > 0) {
                bUseExternalLogConfig = true;
            }
            if (!bUseExternalLogConfig) {
                if (m_bDemoMode) {
                    Workspace.getMdFactory().getInstance().getUtil().setLogToNull();
                    Workspace.getMdFactory().getInstance().getUtil().setOutputToNull();
                    Workspace.getMdFactory().getInstance().setLoggingEnabled(false);
                    Workspace.getMdFactory().getInstance().setDebug(false);
                } else {
                    WsLogger.setLoggerPriority("com.sas.metadata", ILogger.WARN);
                    WsLogger.setLoggerPriority("com.sas.metadata.xml", ILogger.WARN);
                    if (m_bDebug) {
                        Workspace.getMdFactory().getInstance().setDebug(true);
                        for (String context : m_LoggingContexts) {
                            WsLogger.setLoggerPriority(context, ILogger.DEBUG);
                            if (!m_bLoggingDebugMessages) continue;
                            System.out.println("updateFactory: Setting logger priority of DEBUG on logger " + context);
                        }
                        WsLogger.setLoggerPriority("com.sas.metadata", ILogger.DEBUG);
                        if (m_bLoggingDebugMessages) {
                            System.out.println("updateFactory: Setting logger priority of DEBUG on logger com.sas.metadata");
                        }
                    } else {
                        for (String context : m_LoggingContexts) {
                            WsLogger.setLoggerPriority(context, m_DefaultLoggingLevel);
                            if (!m_bLoggingDebugMessages) continue;
                            System.out.println("updateFactory: Setting logger priority of WARN on logger " + context);
                        }
                    }
                    if (m_bLog) {
                        Workspace.getMdFactory().getInstance().setLoggingEnabled(true);
                        WsLogger.setLoggerPriority("com.sas.metadata.xml", ILogger.DEBUG);
                        if (m_bLoggingDebugMessages) {
                            System.out.println("updateFactory: Setting logger priority of DEBUG on logger com.sas.metadata.xml");
                        }
                        if (m_bDebugLogFile) {
                            WsLogger.setLoggerFile("com.sas.metadata.xml", m_LogFileName);
                            WsLogger.setAdditivityAppenders("com.sas.metadata.xml", false);
                            if (m_bLoggingDebugMessages) {
                                System.out.println("updateFactory: Setting logger file for com.sas.metadata.xml to " + m_LogFileName);
                                System.out.println("updateFactory: Setting additivity of com.sas.metadata.xml to false");
                            }
                        }
                    }
                    if (m_bConsoleLog) {
                        WsLogger.setConsoleLogging("com.sas", true);
                        if (m_bLoggingDebugMessages) {
                            System.out.println("updateFactory: Enable console logging for com.sas");
                        }
                    }
                }
                Workspace.getMdFactory().getInstance().getConnection().setMessageLevel(m_messageLevel);
            } else {
                System.out.println("updateFactory: Ignoring all command line logging options, user specified logging file \"" + loggingConfigURL + "\" used");
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage(ex, "Accessing");
        }
    }

    public void updateUser() {
        if (this.m_userContext == null) {
            return;
        }
        try {
            List identities = this.m_userContext.getIdentities();
            for (int index = 0; index < identities.size(); ++index) {
                SimpleUserIdentity identity = (SimpleUserIdentity)identities.get(index);
                if (!identity.isPrimary()) continue;
                this.m_strUsername = identity.getPrincipal().toString();
                return;
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
    }

    protected void setSelectedRepositories() {
        block7: {
            this.m_vecSelectedReps = new Vector();
            this.m_selectedRepositoryNames = new ArrayList();
            this.m_defaultRepository = null;
            this.m_projectRepository = null;
            this.m_checkinRepository = null;
            try {
                List vecRepositories = Workspace.getMdFactory().getOMIUtil().getRepositories();
                String strSelectedReps = this.m_workspaceFile.getPropertyString("SelectedReps");
                if (strSelectedReps.length() > 0) {
                    this.m_projectRepository = null;
                    for (int i = 0; i < vecRepositories.size(); ++i) {
                        String strRepType;
                        CMetadata mdRepObject = (CMetadata)vecRepositories.get(i);
                        String strFQID = mdRepObject.getFQID();
                        if (strSelectedReps.indexOf(strFQID) == -1) continue;
                        this.m_vecSelectedReps.add(mdRepObject);
                        this.m_selectedRepositoryNames.add(mdRepObject.getName());
                        if (strSelectedReps.startsWith(strFQID)) {
                            this.m_defaultRepository = mdRepObject;
                            this.m_checkinRepository = mdRepObject;
                        }
                        if (!this.m_bApplicationWantsChangeManagement || (strRepType = WsRepositoryUtil.getRepositoryType(this.getCMRHandle(), mdRepObject.getFQID())).compareTo("PROJECT") != 0) continue;
                        this.m_projectRepository = mdRepObject;
                        this.m_defaultRepository = mdRepObject;
                        this.m_checkinRepository = Workspace.getMdFactory().getOMIUtil().getFoundationRepository();
                        this.m_eChangeManagementState = CHANGEMANAGEMENT_ON;
                    }
                }
                if (this.m_defaultRepository != null) break block7;
                Workspace.getDefaultLogger().debug("Warning!!!!  NO DEFAULT REPOS SELECTED! Setting to the first in the list.");
                if (vecRepositories.size() > 0) {
                    this.m_checkinRepository = this.m_defaultRepository = (CMetadata)vecRepositories.get(0);
                    this.m_vecSelectedReps.clear();
                    this.m_selectedRepositoryNames.clear();
                    this.m_vecSelectedReps.add(this.m_defaultRepository);
                    this.m_selectedRepositoryNames.add(this.m_defaultRepository.getName());
                    break block7;
                }
                MessageUtil.displayMessage(bundle.getString("Workspace.NoReposError.txt"));
                return;
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage(e, "Accessing");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException(re);
            }
        }
    }

    protected RepositoryDef getSelectedRepositories2() {
        try {
            String defaultRepositories = this.m_workspaceFile.getPropertyString("SelectedReps");
            List repositories = this.m_informationService.getReposDefs();
            if (repositories == null || repositories.size() == 0) {
                return null;
            }
            if (defaultRepositories == null || defaultRepositories.length() == 0) {
                return (RepositoryDef)repositories.get(0);
            }
            for (int index = 0; index < repositories.size(); ++index) {
                RepositoryDef repository = (RepositoryDef)repositories.get(index);
                repository.getName();
            }
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException(e);
        }
        return null;
    }

    public AppServer makeAppServer() {
        String strDeplCompId = this.m_appDefaultsFile.getPropertyString("AppServer.Default");
        return this.makeAppServer(strDeplCompId);
    }

    public AppServer makeAppServer(boolean testIt) {
        String strDeplCompId = this.m_appDefaultsFile.getPropertyString("AppServer.Default");
        return this.makeAppServer(strDeplCompId, testIt);
    }

    public AppServer makeAppServer(String ServerContextID) {
        return this.makeAppServer(ServerContextID, true);
    }

    public AppServer makeAppServer(String ServerContextID, boolean testIt) {
        ShowAppServerDialog rShowAppServerDialog = new ShowAppServerDialog();
        rShowAppServerDialog.setTestIt(testIt);
        rShowAppServerDialog.setServerId(ServerContextID);
        if (SwingUtilities.isEventDispatchThread()) {
            rShowAppServerDialog.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(rShowAppServerDialog);
            }
            catch (Exception e) {
                Workspace.getDefaultLogger().error((Object)"", e);
            }
        }
        return rShowAppServerDialog.getAppServer();
    }

    public static String getAppServerName() {
        WorkspaceFile ws = Workspace.getWorkspace().getWorkspaceFile();
        String AppServerID = ws.getPropertyString("AppServer.Default");
        if (AppServerID != null && AppServerID.length() > 0) {
            try {
                ArrayList<String> lAttrs = new ArrayList<String>();
                lAttrs.add("Name");
                List lValues = Workspace.getMdFactory().getOMIUtil().getMetadataSimple("ServerContext", AppServerID, lAttrs);
                return (String)lValues.get(0);
            }
            catch (MdException ex) {
                Workspace.getDefaultLogger().debug((Object)"Workspace.getAppServerName", ex);
            }
            catch (RemoteException ex) {
                Workspace.getDefaultLogger().debug((Object)"Workspace.getAppServerName", ex);
            }
        }
        ws.setPropertyString("AppServer.Default", "");
        return bundle.getString("Workspace.NoAppServerTitle.txt");
    }

    public void setDefaultAppServerSupported(boolean bSupportsDefaultAppServer) {
        this.m_bSupportsDefaultAppServer = bSupportsDefaultAppServer;
    }

    public boolean isDefaultAppServerSupported() {
        return this.m_bSupportsDefaultAppServer;
    }

    public void setGlobalAuthDomainSupported(boolean bGlobalAuthDomain) {
        this.m_bSupportsAuthDomainSetting = bGlobalAuthDomain;
    }

    public boolean isGlobalAuthDomainSupport() {
        return this.m_bSupportsAuthDomainSetting;
    }

    public void setAppServerUserID(String userid, String AppServerID) {
        String key = "AppServerUser." + AppServerID;
        this.m_AppServerCredentials.put(key, userid);
    }

    public void setAppServerPassword(String password, String AppServerPW) {
        String key = "AppServerPassword." + AppServerPW;
        this.m_AppServerCredentials.put(key, password);
    }

    public String getAppServerUserID(String AppServerID) {
        String key = "AppServerUser." + AppServerID;
        return (String)this.m_AppServerCredentials.get(key);
    }

    public String getAppServerPassword(String AppServerPW) {
        String key = "AppServerPassword." + AppServerPW;
        return (String)this.m_AppServerCredentials.get(key);
    }

    public void saveAppServerCredentials(String sAppServerFQID, String sUserName, String sPassword) {
        this.setAppServerPassword(sPassword, sAppServerFQID);
        this.setAppServerUserID(sUserName, sAppServerFQID);
    }

    public void removeAppServerCredentials(String sAppServerFQID) {
        this.m_AppServerCredentials.remove("AppServerUser." + sAppServerFQID);
        this.m_AppServerCredentials.remove("AppServerPassword." + sAppServerFQID);
    }

    public String getMyIdentity() {
        try {
            ISecurity_1_1 me = Workspace.getMdFactory().getConnection().MakeISecurityConnection(Workspace.getMdFactory().getConnection().getCMRHandle());
            StringHolder holdmyID = new StringHolder();
            me.GetIdentity("", holdmyID);
            return holdmyID.value;
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage(e, "Reading");
            return null;
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().error((Object)"", e);
            return null;
        }
    }

    public String getMyIdentityType() {
        String myID = this.getMyIdentity();
        if (myID == null) {
            return null;
        }
        int index1 = myID.indexOf(58);
        int index2 = myID.indexOf(47);
        if (index1 >= myID.length() - 1 || index2 > myID.length() - 1 || index1 < 0 || index2 < 0) {
            return null;
        }
        return myID.substring(index1 + 1, index2);
    }

    public String getMyIdentityID() {
        String myID = this.getMyIdentity();
        if (myID == null) {
            return null;
        }
        int index = myID.indexOf(47);
        return myID.substring(index + 1);
    }

    public CMetadata getProjectRepository() {
        return this.m_projectRepository;
    }

    public String getProjectRepositoryId() throws RemoteException {
        if (this.m_projectRepository == null) {
            return null;
        }
        if (this.m_projectRepository.getFQID() == null) {
            return null;
        }
        return this.m_projectRepository.getFQID().substring(9);
    }

    public CMetadata getCheckinRepository() {
        return this.m_checkinRepository;
    }

    public String getCheckinRepositoryId() throws RemoteException {
        return this.getCheckinRepository().getFQID().substring(9);
    }

    public void setDefaultRepository(CMetadata defaultRepository) {
        this.m_defaultRepository = defaultRepository;
    }

    public CMetadata getDefaultRepository() {
        return this.m_defaultRepository;
    }

    public String getDefaultRepositoryId() throws RemoteException {
        return this.getDefaultRepository().getFQID().substring(9);
    }

    public void setSelectedRepositories(List lSelectedRepositories) {
        this.m_vecSelectedReps = new Vector(lSelectedRepositories);
    }

    public List getSelectedRepositories() {
        if (this.m_vecSelectedReps instanceof Vector) {
            return (List)((Vector)this.m_vecSelectedReps).clone();
        }
        if (this.m_vecSelectedReps instanceof ArrayList) {
            return (List)((ArrayList)this.m_vecSelectedReps).clone();
        }
        return this.m_vecSelectedReps;
    }

    public List getSelectedRepositoryNames() {
        return this.m_selectedRepositoryNames;
    }

    public void setDefaultPath(String strPath) {
        this.m_appDefaultsFile.setPropertyString("DefaultPath", strPath);
    }

    public static void setDefaultLogFileName(String strFileName) {
        m_LogFileName = strFileName;
    }

    public static void setMainLoggingContext(String newLoggingContext) {
        if (newLoggingContext != null && newLoggingContext.startsWith("com.sas.")) {
            m_DefaultLoggingContext = newLoggingContext;
            if (!m_LoggingContexts.contains(newLoggingContext)) {
                m_LoggingContexts.add(newLoggingContext);
            }
        }
    }

    public static void setLoggingPriorities(List loggingContexts, int priority) {
        WsLogger.setLoggerPriority(loggingContexts, priority);
    }

    public static String getMainLoggingContext() {
        return m_DefaultLoggingContext;
    }

    public static void addLoggingContexts(List applicationLoggingContexts) {
        if (applicationLoggingContexts != null) {
            for (String loggingContext : applicationLoggingContexts) {
                if (m_LoggingContexts.contains(loggingContext)) continue;
                m_LoggingContexts.add(loggingContext);
            }
        }
    }

    public static String getDefaultLogFileName(String strFileName) {
        return m_LogFileName;
    }

    public static String getDefaultLogFileName() {
        return m_LogFileName;
    }

    public static void setDefaultErrorLogFileName(String strFileName) {
        m_errorLogFileName = strFileName;
    }

    public static String getDefaultErrorLogFileName() {
        return m_errorLogFileName;
    }

    public String getDefaultPath() {
        return this.m_appDefaultsFile.getPropertyString("DefaultPath", System.getProperty("user.home"));
    }

    public void setUsername(String strUsername) {
        this.m_strUsername = strUsername;
    }

    public String getUsername() {
        return this.m_connectionManager.getUsername();
    }

    public void setPassword(String strPassword) {
        this.m_strPassword = strPassword;
    }

    public void setMenuObject(WorkspaceMenuSupport menuObject) {
        this.m_appSupportObject = menuObject;
        this.updateDebugMenuItems();
    }

    public WorkspaceMenuSupport getMenuObject() {
        return this.m_appSupportObject;
    }

    public static Workspace getWorkspace() {
        if (m_workspace == null && m_workspaceInitializer != null) {
            m_workspace = m_workspaceInitializer.initializeWorkspace();
        }
        return m_workspace;
    }

    public static int getMetadataServerVersionNumber() {
        return m_MetadataServerVersion;
    }

    public void setServerStatusCheckEnabled(boolean bServerStatusCheckEnabled) {
        this.m_bServerStatusCheckEnabled = bServerStatusCheckEnabled;
    }

    public boolean isServerStatusCheckEnabled() {
        return this.m_bServerStatusCheckEnabled;
    }

    public int checkMetadataServerStatus(boolean bAllowDialogs) {
        int status = this.getMetadataServerStatus();
        if (!bAllowDialogs || status == SERVERSTATUS_OK) {
            if (status == SERVERSTATUS_ERROR) {
                WsStatusBarUtilities.setServerConnectionBroken(true);
            }
            return status;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.m_reconnectTimer < RECONNECT_TIMER_INTERVAL) {
            return status;
        }
        String hostname = this.getConnectionManager().getHost();
        String message = bundle.formatString("Workspace.ServerError.fmt", hostname);
        String title = bundle.getString("Common.Error.txt");
        Object[] buttons = new Object[]{bundle.getString("Workspace.TryNow.txt"), bundle.getString("Common.Cancel.txt")};
        if (status == SERVERSTATUS_PAUSED) {
            message = bundle.formatString("Workspace.ServerPaused.fmt", hostname);
        } else if (status == SERVERSTATUS_ERROR) {
            message = bundle.formatString("Workspace.ServerError.fmt", hostname);
        }
        while (status != SERVERSTATUS_OK && status != SERVERSTATUS_RECONNECTED) {
            boolean result;
            OptionDialog optionDialog = new OptionDialog(message, title, 2, 0, buttons);
            int response = optionDialog.showMessage();
            this.m_reconnectTimer = System.currentTimeMillis();
            if (response != 0) break;
            if (status == SERVERSTATUS_PAUSED) {
                status = this.checkMetadataServerStatus(false);
                if (status == SERVERSTATUS_PAUSED) {
                    message = bundle.getString("Workspace.ServerStillPaused.txt");
                    continue;
                }
                if (status == SERVERSTATUS_ERROR) {
                    message = bundle.formatString("Workspace.ServerError.fmt", hostname);
                    continue;
                }
                MessageUtil.displayMessage(bundle.getString("Workspace.ServerResumed.txt"), 1);
                status = SERVERSTATUS_RECONNECTED;
                continue;
            }
            if (status != SERVERSTATUS_ERROR || !(result = this.reconnectToMetadataServer(true))) continue;
            status = SERVERSTATUS_RECONNECTED;
        }
        if (status == SERVERSTATUS_ERROR) {
            WsStatusBarUtilities.setServerConnectionBroken(true);
        } else if (status == SERVERSTATUS_RECONNECTED) {
            WsStatusBarUtilities.updateServerPanel();
        }
        return status;
    }

    public int getMetadataServerStatus() {
        int status = SERVERSTATUS_OK;
        try {
            StringHolder outStatus = new StringHolder();
            this.m_pIServer.Status("<state/>", outStatus, "");
            String sStatus = outStatus.value;
            String s1 = "<state>";
            String s2 = "</state>";
            sStatus = sStatus.substring(sStatus.indexOf(s1) + s1.length(), sStatus.indexOf(s2));
            status = Integer.parseInt(sStatus);
        }
        catch (Exception ex) {
            Workspace.getDefaultLogger().error((Object)"", ex);
            status = SERVERSTATUS_ERROR;
        }
        return status;
    }

    public boolean isFoundationServicesConnection() {
        return this.m_foundationServicesConnection;
    }

    public void setFoundationServicesConnection(boolean value) {
        this.m_foundationServicesConnection = value;
    }

    public boolean isSingleSignOn() {
        return this.m_singleSignOn;
    }

    public void setSingleSignOn(boolean enabled) {
        this.m_singleSignOn = enabled;
    }

    public boolean isSingleSignOnEnabled() {
        return this.m_singleSignOnEnabled;
    }

    public void setSingleSignOnEnabled(boolean value) {
        this.m_singleSignOnEnabled = value;
        this.setFoundationServicesConnection(true);
    }

    public boolean isConnected() {
        return this.m_connected;
    }

    public boolean isPrinterConnected(PrinterJob job) {
        if (job.lookupPrintServices().length == 0) {
            MessageUtil.displayMessage(bundle.getString("Workspace.NoPrinterConnected.txt"), 2);
            return false;
        }
        return true;
    }

    public boolean isUnrestrictedUser() {
        return this.m_bUnrestrictedUser;
    }

    public void close() {
        this.dispatchEvent(new WindowEvent(this, 201));
    }

    public boolean reconnectToMetadataServer(boolean bAllowDialogs) {
        Reconnect reconnect = new Reconnect();
        OpRequestUI OpRequestUI2 = new OpRequestUI(MessageUtil.getMainWindow(), bundle.getString("Workspace.ReconnectProgressIndicator.Message.txt"), bundle.getString("Workspace.ReconnectProgressIndicator.Title.txt"));
        OpRequestUI2.setDelayBeforeProgressCancelDialog(0);
        OpRequestUI2.execute(reconnect);
        if (reconnect.getReturnCode()) {
            if (bAllowDialogs) {
                String sHost = this.getConnectionManager().getHost();
                String sMessage = bundle.formatString("Workspace.ReconnectSuccessful.fmt", sHost);
                MessageUtil.displayMessage(sMessage, 1);
            }
            this.firePropertyChange(METADATA_PROFILE_FILENAME_PROPERTY, "", this.m_workspaceFile.getFileName());
            WsStatusBarUtilities.setServerConnectionBroken(false);
            return true;
        }
        return false;
    }

    public static String getRepositoryName(String reposID) throws MdException, RemoteException {
        if (reposID.length() <= 0) {
            return "";
        }
        if (reposID.length() < 10) {
            reposID = "A0000001." + reposID;
        }
        String repositoryName = "";
        for (CMetadata repos : Workspace.getMdFactory().getOMIUtil().getRepositories()) {
            if (!repos.getFQID().equals(reposID)) continue;
            repositoryName = repos.getName();
            break;
        }
        return repositoryName;
    }

    public MdFactory getMdObjectFactory() {
        return s_metadataFactory;
    }

    public CodeEditorDefaults getCodeEditorDefaults() {
        return this.m_CodeEditorDefaults;
    }

    public IOMI getCMRHandle() {
        return this.m_pIOMI;
    }

    public void setCMRHandle(IOMI pCMR) throws RemoteException {
        this.m_MetadataWorkspace.setCMRHandle(pCMR);
        this.m_pIOMI = pCMR;
    }

    public IWorkspace getIWorkspace() {
        return this.m_pWorkspace;
    }

    public WorkspaceFile getWorkspaceFile() {
        return this.m_workspaceFile;
    }

    public void setWorkspaceFile(WorkspaceFile wsFile) {
        this.m_workspaceFile = wsFile;
    }

    public WorkspaceFile getAppDefaultsFile() {
        return this.m_appDefaultsFile;
    }

    public PluginLoader getPluginLoader() {
        return this.m_pluginLoader;
    }

    public void setPluginLoader(PluginLoader pluginLoader) {
        this.m_pluginLoader = pluginLoader;
    }

    public WorkspaceTree getBrowseTree() {
        WorkspaceTree tree;
        try {
            tree = (WorkspaceTree)this.m_cBrowseTree.newInstance();
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().error((Object)"", e);
            if (m_bDebug) {
                e.printStackTrace();
            }
            return null;
        }
        tree.setAddingMemberNodes(false);
        tree.setEditable(false);
        tree.setPopupMenusEnabled(false);
        tree.setDefaultActionEnabled(false);
        return tree;
    }

    public void setBrowseTreeClass(Class cBrowseTree) {
        this.m_cBrowseTree = cBrowseTree;
        if (!WorkspaceTree.class.isAssignableFrom(cBrowseTree)) {
            throw new ClassCastException(bundle.formatString("Workspace.ClassCastException.msg.txt", cBrowseTree.getName()));
        }
    }

    public WsStatusBar getStatusBar() {
        return this.m_StatusBar;
    }

    public void setStatusText(String strMessage) {
        if (this.m_StatusBar != null) {
            this.m_StatusBar.setText(strMessage);
        }
    }

    public void clearStatusText() {
        if (this.m_StatusBar != null) {
            this.m_StatusBar.clear();
        }
    }

    public void refresh() {
        if (this.m_treeObject != null && this.m_treeObject.hasFocus()) {
            this.m_treeObject.refresh();
        } else {
            this.m_Desktop.refresh();
        }
    }

    public void refreshAll() {
        if (this.m_treeObject != null) {
            this.m_treeObject.refreshAll();
        }
        this.m_Desktop.refreshAll();
    }

    public CustomDesktop getDesktopWindowHandle() {
        return this.m_Desktop;
    }

    public static boolean isDebug() {
        return m_bDebug;
    }

    public boolean getDebug() {
        return m_bDebug;
    }

    public static boolean isSCDChangeUsed() {
        return m_bSCDChange;
    }

    public static boolean useProcMetalibChanges() {
        return m_bUseMetalibChanges;
    }

    public static boolean useMetalibDebug() {
        return m_bUseMetalibDebug;
    }

    public static boolean isSetMetaOptionSet() {
        return m_bSetMetaOptions;
    }

    public static boolean isLogCredentials() {
        return m_bLogCredentials;
    }

    public static void setLogCredentials(boolean logCredentials) {
        m_bLogCredentials = logCredentials;
    }

    public String getPluginsDir() {
        return m_pluginsDir;
    }

    public Integer getPromptThreshold() {
        return m_promptThreshold;
    }

    public String getRoadmapsDir() {
        return m_roadmapsDir;
    }

    public String getInstallDir() {
        return m_sInstallDir;
    }

    protected void saveComponentSizes() {
        int treeViewWidth = 0;
        int treeViewHeight = 0;
        int shortcutBarWidth = 0;
        int desktopHeight = 0;
        if (this.m_treeObject != null && this.m_treeObject.getTreeComponent().isVisible()) {
            treeViewWidth = ((JComponent)this.m_treeObject.getTreeComponent()).getWidth();
            treeViewHeight = ((JComponent)this.m_treeObject.getTreeComponent()).getHeight();
        }
        if (this.m_ShortcutBar != null && this.m_ShortcutBar.isVisible()) {
            shortcutBarWidth = this.m_ShortcutBar.getWidth();
        }
        if (this.m_Desktop != null && this.m_Desktop.isVisible()) {
            desktopHeight = this.m_Desktop.getHeight();
        }
        if (this.m_splitManager != null) {
            if (this.m_treeObject != null && this.m_treeObject.getTreeComponent() != null && this.m_splitManager.contains((JComponent)this.m_treeObject.getTreeComponent())) {
                this.m_appDefaultsFile.setPropertyInt("Workspace.TreeSplit", treeViewWidth);
            }
            if (this.m_splitManager.contains(this.m_ShortcutBar) && this.m_ShortcutBar != null) {
                this.m_appDefaultsFile.setPropertyInt("Workspace.ActionSplit", shortcutBarWidth);
            }
            if (this.m_splitManager.contains(this.m_messagesWindow) && this.m_Desktop != null) {
                this.m_appDefaultsFile.setPropertyInt("Workspace.MessageSplit", desktopHeight);
            }
            if (this.m_splitManager.contains(this.m_overviewWindow) && this.m_overviewWindow != null) {
                this.m_appDefaultsFile.setPropertyInt("Workspace.OverviewSplit", treeViewHeight);
            }
        }
    }

    protected void onWindowClosing(WindowEvent e) {
        if (this.m_Desktop != null) {
            try {
                this.m_Desktop.closeAll();
            }
            catch (PropertyVetoException ex) {
                return;
            }
        }
        boolean maximized = this.getExtendedState() == 6;
        this.m_appDefaultsFile.setPropertyBoolean("Workspace.maximized", maximized);
        if (maximized) {
            this.setExtendedState(0);
        }
        this.m_appDefaultsFile.setPropertyInt("Workspace.x", this.getX());
        this.m_appDefaultsFile.setPropertyInt("Workspace.y", this.getY());
        this.m_appDefaultsFile.setPropertyInt("Workspace.cx", this.getWidth());
        this.m_appDefaultsFile.setPropertyInt("Workspace.cy", this.getHeight());
        if (this.m_treeObject != null) {
            this.m_treeObject.saveState();
        }
        this.saveComponentSizes();
        this.m_appDefaultsFile.saveExisting();
        this.m_appDefaultsFile.closeExisting();
        this.disconnectFromOMRServer();
        this.m_pasteBuffer = null;
        this.dispose();
    }

    protected void onWindowClosed(WindowEvent e) {
        System.exit(0);
    }

    public void showMessagesWindow() {
        this.m_appDefaultsFile.setPropertyInt("Workspace.MessagesWindow", 1);
        if (this.m_messagesWindow == null) {
            return;
        }
        try {
            int cyDesktop = this.m_Desktop.getHeight();
            int messageDivider = this.m_appDefaultsFile.getPropertyInt("Workspace.MessageSplit", 500);
            if (cyDesktop > 0) {
                if (messageDivider > cyDesktop - 80) {
                    messageDivider = cyDesktop - 80;
                }
                if (messageDivider < 150) {
                    messageDivider = 150;
                }
            }
            this.m_splitManager.add(0, this.m_Desktop, this.m_messagesWindow, messageDivider, 1.0);
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().error((Object)"", e);
        }
        this.repaint();
    }

    public void hideMessagesWindow() {
        this.m_appDefaultsFile.setPropertyInt("Workspace.MessagesWindow", 0);
        if (this.m_messagesWindow == null) {
            return;
        }
        try {
            this.saveComponentSizes();
            this.m_splitManager.remove(this.m_messagesWindow);
        }
        catch (SplitManager.ComponentNotFoundException e) {
            return;
        }
    }

    public void showShortcutBar() {
        this.m_appDefaultsFile.setPropertyInt("Workspace.ShortcutBar", 1);
        boolean needToFixOverview = false;
        if (this.m_ShortcutBar == null) {
            return;
        }
        if (this.m_splitManager.contains(this.m_ShortcutBar)) {
            return;
        }
        try {
            if (this.isOverviewWindowShowing()) {
                needToFixOverview = true;
                this.hideOverviewWindow();
            }
            JComponent m_treeComponent = (JComponent)this.m_treeObject.getTreeComponent();
            int shortcutDivider = this.m_appDefaultsFile.getPropertyInt("Workspace.ActionSplit", 125);
            int treeDivider = this.m_appDefaultsFile.getPropertyInt("Workspace.TreeSplit", 240);
            if (treeDivider < 145) {
                this.m_splitManager.setParentDividerLocation(m_treeComponent, 145);
                shortcutDivider = 110;
                treeDivider = 30;
            } else if (treeDivider < shortcutDivider + 30 + 5) {
                shortcutDivider = treeDivider - 35;
                treeDivider = 30;
            } else {
                treeDivider -= shortcutDivider + 5;
            }
            this.m_ShortcutBar.setPreferredSize(new Dimension(shortcutDivider, this.m_ShortcutBar.getHeight()));
            m_treeComponent.setPreferredSize(new Dimension(treeDivider, m_treeComponent.getHeight()));
            this.m_splitManager.add(1, this.m_ShortcutBar, m_treeComponent, shortcutDivider, 0.0);
            if (needToFixOverview) {
                this.showOverviewWindow();
            }
        }
        catch (SplitManager.IllegalOrientationException ioe) {
            ioe.printStackTrace();
        }
        catch (SplitManager.IllegalAdditionException iae) {
            iae.printStackTrace();
        }
        catch (SplitManager.IllegalDirectionException ide) {
            ide.printStackTrace();
        }
        catch (SplitManager.ManagerNotEmptyException mnee) {
            mnee.printStackTrace();
        }
        catch (SplitManager.ComponentNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
    }

    public void hideShortcutBar() {
        this.m_appDefaultsFile.setPropertyInt("Workspace.ShortcutBar", 0);
        if (this.m_ShortcutBar == null) {
            return;
        }
        if (!this.m_splitManager.contains(this.m_ShortcutBar)) {
            return;
        }
        try {
            this.m_splitManager.remove(this.m_ShortcutBar);
            this.saveComponentSizes();
        }
        catch (SplitManager.ComponentNotFoundException cnfe) {
            return;
        }
    }

    public WATitledPane getOverviewWindow() {
        return this.m_overviewWindow;
    }

    public void setOverviewWindow(WATitledPane overviewWindow) {
        this.m_overviewWindow = overviewWindow;
        this.m_overviewWindow.setPreferredSize(new Dimension(30, 150));
    }

    public void showOverviewWindow() {
        if (this.m_overviewWindow == null || this.m_overviewWindow.getContents() == null) {
            return;
        }
        try {
            this.m_bIsOverviewShowing = true;
            Component overviewContents = this.m_overviewWindow.getContents();
            if (overviewContents != null) {
                overviewContents.setBackground(new Color(this.m_appDefaultsFile.getPropertyInt("pfd.color.Background", 16775388)));
            }
            int overviewSplit = this.m_appDefaultsFile.getPropertyInt("Workspace.OverviewSplit", m_workspace.getHeight() - 150);
            this.m_splitManager.add(0, (JComponent)this.m_treeObject.getTreeComponent(), this.m_overviewWindow, overviewSplit, 1.0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void hideOverviewWindow() {
        this.m_bIsOverviewShowing = false;
        if (this.m_overviewWindow == null) {
            return;
        }
        try {
            this.saveComponentSizes();
            this.m_splitManager.remove(this.m_overviewWindow);
        }
        catch (SplitManager.ComponentNotFoundException componentNotFoundException) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isOverviewWindowShowing() {
        return this.m_bIsOverviewShowing;
    }

    protected void setActiveComponent(WsWorkspaceComponent cmp) {
        if (this.m_cmpActive == cmp) {
            return;
        }
        if (this.m_cmpActive != null) {
            this.m_cmpActive.updateWorkspaceUIComponents(false);
        }
        this.m_cmpActive = cmp;
        if (this.m_cmpActive != null) {
            this.m_cmpActive.updateWorkspaceUIComponents(true);
        }
    }

    protected WsWorkspaceComponent getActiveComponent() {
        return this.m_cmpActive;
    }

    public void initializeHelp(String sMasterHelpProduct) {
        this.m_previousHelpProduct = "";
        this.m_sMasterHelp = sMasterHelpProduct;
    }

    public void showHelp(String sHelpProduct, String sHelpTopic, Window wnd, String docsetVersion) {
        this.showHelp(sHelpProduct, sHelpTopic, wnd, Workspace.getWorkspaceHelpClassLoader(), docsetVersion);
    }

    public void showHelp(String sHelpProduct, String sHelpTopic, Window wnd, ClassLoader helpLoader, String docsetVersion) {
        try {
            if (sHelpProduct == null) {
                sHelpProduct = this.m_sMasterHelp;
            }
            if (this.m_previousHelpProduct != sHelpProduct) {
                this.m_previousHelpProduct = sHelpProduct;
            }
            Workspace.getDefaultLogger().debug("Showing help: " + sHelpProduct + ":" + sHelpTopic);
            DesktopUtil.openHelpDoc(sHelpProduct, sHelpTopic, docsetVersion, bundle.getString("Workspace.HelpTopicNotFound.txt") + " " + sHelpProduct + ":" + sHelpTopic);
        }
        catch (IllegalArgumentException iae) {
            MessageUtil.displayMessage(bundle.getString("Workspace.HelpSetNotFound.txt") + " " + sHelpProduct + ":" + sHelpTopic, 0);
        }
    }

    public void showHelp(String sHelpTopic, String docsetVersion) {
        this.showHelp(null, sHelpTopic, this, Workspace.getWorkspaceHelpClassLoader(), docsetVersion);
    }

    public static void debugFocusOnDialog(JDialog dlg) {
        if (m_bDebugFocus) {
            WsFocusListenerPropagator flp = new WsFocusListenerPropagator(new cFocusDebugger());
            flp.startListeningTo(dlg);
            WsMouseListenerPropagator mlp = new WsMouseListenerPropagator(new cComponentFinder());
            mlp.startListeningTo(dlg);
        }
    }

    public void setTooltipDelay(int delay) {
        ToolTipManager ttm = ToolTipManager.sharedInstance();
        ToolTipManager.sharedInstance().setInitialDelay(delay);
        ttm.setEnabled(this.m_appDefaultsFile.getPropertyBoolean("Workspace.ShowTooltips", true));
    }

    public void setDismissDelay(int delay) {
        ToolTipManager.sharedInstance().setDismissDelay(delay);
    }

    public static List removeCheckouts(List listWithCheckouts) throws RemoteException {
        Root meta;
        int j;
        Vector<Root> listNoCheckouts = new Vector<Root>();
        if (listWithCheckouts.size() < 1) {
            return listNoCheckouts;
        }
        Vector<String> dupFQIDs = new Vector<String>();
        String deltaState = "";
        String fqid = "";
        for (j = 0; j < listWithCheckouts.size(); ++j) {
            meta = (Root)listWithCheckouts.get(j);
            deltaState = meta.getChangeState();
            if (!deltaState.startsWith("Checkout") && !deltaState.startsWith("Fetch")) continue;
            dupFQIDs.addElement(deltaState.substring(deltaState.indexOf(":") + 1));
        }
        if (dupFQIDs.size() > 0) {
            for (j = 0; j < listWithCheckouts.size(); ++j) {
                meta = (Root)listWithCheckouts.get(j);
                fqid = meta.getFQID().trim();
                boolean duplicate = false;
                for (int k = 0; k < dupFQIDs.size(); ++k) {
                    String temp = ((String)dupFQIDs.get(k)).trim();
                    if (temp.compareToIgnoreCase(fqid) != 0) continue;
                    duplicate = true;
                    break;
                }
                if (duplicate) continue;
                listNoCheckouts.add(0, meta);
            }
        } else {
            listNoCheckouts.addAll(listWithCheckouts);
        }
        return listNoCheckouts;
    }

    public void setApplicationChecksProjectRepository(boolean bCheckProjectRepository) {
        this.m_bCheckForExistingProjectObjects = bCheckProjectRepository;
    }

    public double getApplicationVersionNumber() {
        return this.m_versionNumber;
    }

    public String getApplicationName() {
        return this.m_strApplicationName;
    }

    public String getApplicationNameForLogging() {
        if (this.m_strAppLogName != null) {
            return this.m_strAppLogName;
        }
        String utilityName = this.getClass().getSimpleName();
        String version = this.getClass().getPackage().getSpecificationVersion();
        if (version == null) {
            version = IOMI.class.getPackage().getSpecificationVersion();
        }
        if (version == null) {
            return utilityName + " (unknown)";
        }
        return utilityName + " " + version;
    }

    public void setApplicationNameForLogging(String name) {
        this.m_strAppLogName = name;
    }

    public boolean getApplicationChecksProjectRepository() {
        return this.m_bCheckForExistingProjectObjects;
    }

    public void setApplicationVersionNumber(double version) {
        this.m_versionNumber = version;
    }

    public void setApplicationName(String name) {
        this.m_strApplicationName = name;
    }

    public void setSkipInitializeDesktopLayout(boolean bSkipLayout) {
        this.m_bSkipInitializeDesktopLayout = bSkipLayout;
    }

    public static String getMetadataProfilePath() {
        String separator = System.getProperty("file.separator");
        if (separator.equals("/")) {
            return Workspace.getAppDataPath() + "/.SASAppData/MetadataServerProfiles";
        }
        return Workspace.getAppDataPath() + separator + "SAS" + separator + "MetadataServerProfiles";
    }

    public static String getSeededProfilePath() {
        String separator = System.getProperty("file.separator");
        return System.getenv("ALLUSERSPROFILE") + separator + "Application Data" + separator + "SAS" + separator + "MetadataServerProfiles";
    }

    public static void setAppPathName(String name) {
        s_sAppPathName = name;
    }

    public static String getAppPathName() {
        return s_sAppPathName;
    }

    public static void setAppVersions(String[] versions) {
        s_versions = versions;
    }

    public static String[] getAppVersions() {
        return s_versions;
    }

    public static String createAppDataDirectory() {
        String path = Workspace.getAppDataDirectoryPath();
        File directory = new File(path);
        if (!directory.exists()) {
            directory.mkdirs();
        }
        return path;
    }

    public static String getAppDataDirectoryPath() {
        String[] versions = Workspace.getAppVersions();
        if (versions == null || versions.length < 1) {
            throw new IllegalStateException("AppPathVersions must be set before using this method");
        }
        return Workspace.getAppDataDirectoryPathForVersion(versions[0]);
    }

    private static String getAppDataDirectoryPathForVersion(String sVersion) {
        String sAppPathName = Workspace.getAppPathName();
        if (sAppPathName == null) {
            throw new IllegalStateException("AppPathName must be set before using this method");
        }
        String separator = System.getProperty("file.separator");
        return Workspace.getAppDataPath() + separator + "SAS" + separator + sAppPathName + separator + sVersion;
    }

    public static String getAppDataFilePath(String sFileName) {
        String separator = System.getProperty("file.separator");
        return Workspace.getAppDataDirectoryPath() + separator + sFileName;
    }

    private static String getAppDataFilePathForVersion(String sVersion, String sFileName) {
        String separator = System.getProperty("file.separator");
        return Workspace.getAppDataDirectoryPathForVersion(sVersion) + separator + sFileName;
    }

    public static String findAppDataFile(String sFileName) {
        for (String sVersion : Workspace.getAppVersions()) {
            String sPath = Workspace.getAppDataFilePathForVersion(sVersion, sFileName);
            File file = new File(sPath);
            if (!file.exists()) continue;
            return sPath;
        }
        return null;
    }

    public static boolean copyAppDataFileToCurrentAppDataDirectory(String sFileName) {
        String sFoundPath = Workspace.findAppDataFile(sFileName);
        if (sFoundPath == null) {
            return false;
        }
        String sCurrentPath = Workspace.getAppDataFilePathForVersion(Workspace.getAppVersions()[0], sFileName);
        if (sFoundPath.equals(sCurrentPath)) {
            return true;
        }
        try {
            FileUtils.copyFile((File)new File(sFoundPath), (File)new File(sCurrentPath));
            return true;
        }
        catch (IOException ex) {
            Workspace.getDefaultLogger().warn((Object)("Copy of application data file " + sFileName + "failed."), ex);
            return false;
        }
    }

    public static String getDataIntegrationStudioWorkspaceFilePath() {
        return Workspace.getAppDataFilePath("wadef.txt");
    }

    @Deprecated
    public static String getDataIntegrationStudioAppVersionDataPath(String sVersion) {
        String separator = System.getProperty("file.separator");
        String appData = Workspace.getAppDataPath();
        String sDIStudioAppVersionDataPath = appData + separator + "SAS" + separator + "SASDataIntegrationStudio" + separator + sVersion;
        return sDIStudioAppVersionDataPath;
    }

    @Deprecated
    public static String getApplicationIndependentWorkspaceFilePath(String sApplicationName, String sApplicationVersion, String sTextFileName) {
        String separator = System.getProperty("file.separator");
        String appData = Workspace.getAppDataPath();
        String sEnvironmentLocation = appData + separator + "SAS" + separator + sApplicationName + separator + sApplicationVersion;
        String strFileName = sEnvironmentLocation + separator + sTextFileName;
        return strFileName;
    }

    public static String getAppDataPath() {
        String appData = null;
        appData = System.getProperty("sas.appdatapath");
        if (appData != null) {
            File appDataFile = new File(appData);
            if (!appDataFile.exists() || !appDataFile.isDirectory()) {
                Workspace.getDefaultLogger().debug(bundle.getString("Workspace.IllegalAppDataPath.txt"));
                appData = null;
            } else {
                return appData;
            }
        }
        try {
            appData = System.getenv("APPDATA");
        }
        catch (SecurityException ex) {
            Workspace.getDefaultLogger().debug(ex.getMessage());
        }
        if (appData == null) {
            appData = System.getProperty("user.home");
        }
        return appData;
    }

    public ChangeProfileActionInterface getProfileAction() {
        return this.m_profileAction;
    }

    public void setProfileAction(ChangeProfileActionInterface action) {
        this.m_profileAction = action;
    }

    public static ClassLoader getWorkspaceHelpClassLoader() {
        if (m_WorkspaceHelpClassLoader == null) {
            m_WorkspaceHelpClassLoader = HelpClassLoader.getInstance(Workspace.class);
        }
        return m_WorkspaceHelpClassLoader;
    }

    public static String getApplicationSoftwareComponentClassId() {
        return m_applicationSoftwareComponentClassId;
    }

    public static void setApplicationSoftwareComponentClassId(String id) {
        m_applicationSoftwareComponentClassId = id;
    }

    static {
        bundle = WAdminResource.getBundle(Workspace.class);
        m_sInstallDir = System.getProperty("user.dir");
        m_bDebug = false;
        m_bDemoMode = false;
        m_bDebugFocus = false;
        m_bLogCredentials = false;
        m_bLog = false;
        m_bConsoleLog = false;
        m_bDebugLogFile = false;
        m_bKeepLog = false;
        m_bLoggingDebugMessages = false;
        m_LogFileName = null;
        m_DefaultLoggingContext = "com.sas.workspace";
        m_LoggingContexts = new ArrayList();
        m_bSCDChange = false;
        m_bSetMetaOptions = false;
        if (m_LoggingContexts.size() == 0) {
            m_LoggingContexts.add(m_DefaultLoggingContext);
            m_LoggingContexts.add("com.sas.metadata.promotion");
            m_LoggingContexts.add("com.sas.workspace.plugins");
        }
        m_DefaultLoggingLevel = ILogger.INFO;
        m_errorLogFileName = null;
        m_messageLevel = Level.OFF;
        m_promptThreshold = 10000;
        m_bUseMetalibChanges = true;
        m_bUseMetalibDebug = false;
        RECONNECT_TIMER_INTERVAL = 2000L;
        bUseNewStartupReturnValues = false;
        m_WorkspaceHelpClassLoader = null;
        CHANGEMANAGEMENT_ON = 1;
        CHANGEMANAGEMENT_READONLY = 2;
        CHANGEMANAGEMENT_OFF = 4;
        SERVERSTATUS_ERROR = -1;
        SERVERSTATUS_OK = 0;
        SERVERSTATUS_PAUSED = 1;
        SERVERSTATUS_RECONNECTED = 2;
    }

    class WorkspaceConnectionChangeListener
    extends ConnectionChangeAdapter {
        WorkspaceConnectionChangeListener() {
        }

        @Override
        public void connectionClosing(ConnectionManager connectionManager) {
        }

        @Override
        public void connectionOpened(ConnectionManager connectionManager) {
            Workspace.this.m_userContext = Workspace.this.m_connectionManager.getUserContext();
            Workspace.this.updateFactory();
            Workspace.this.updateUser();
            Workspace.this.m_bUnrestrictedUser = IdentityUtil.checkSpecialAuthorization(1);
        }
    }

    private static class cFocusDebugger
    implements FocusListener {
        private cFocusDebugger() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            System.out.println("focus gained=" + e.getSource());
        }

        @Override
        public void focusLost(FocusEvent e) {
            System.out.println("focus lost=" + e.getSource());
        }
    }

    private static class cComponentFinder
    extends MouseAdapter {
        private cComponentFinder() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.isAltDown() && e.isControlDown() && e.isShiftDown()) {
                System.out.println("-------------------------------------------");
                for (Component cmp = (Component)e.getSource(); cmp != null; cmp = cmp.getParent()) {
                    System.out.println("cmp=" + cmp);
                }
                System.out.println("-------------------------------------------");
            }
        }
    }

    class ConnectLater
    implements Runnable {
        public ConnectLater() {
            SwingUtilities.invokeLater(this);
        }

        @Override
        public void run() {
            Workspace.this.getConnected(false, false);
        }
    }

    class StartupDesktopRunnable
    implements Runnable {
        private int m_status = -1;
        private Frame m_parent = null;
        private String m_hostname = null;
        private String m_port = null;
        private String m_domain = null;
        private String m_userid = null;
        private String m_password = null;

        public StartupDesktopRunnable(Frame parent, String hostname, String port, String domain, String userid, String password) {
            this.m_parent = parent;
            this.m_hostname = hostname;
            this.m_port = port;
            this.m_domain = domain;
            this.m_userid = userid;
            this.m_password = password;
        }

        @Override
        public void run() {
            this.m_status = this.startupDesktop();
        }

        public int startupDesktop() {
            if (!Workspace.this.isSingleSignOn()) {
                if (this.m_userid == null || this.m_userid.length() == 0 || this.m_password == null || this.m_password.length() == 0) {
                    this.m_userid = Workspace.this.m_strUsername;
                    this.m_userid = Workspace.this.m_strPassword;
                    Workspace.this.m_strUsername = "";
                    Workspace.this.m_strPassword = "";
                }
                if (this.m_userid == null || this.m_userid.length() == 0 || this.m_password == null || this.m_password.length() == 0) {
                    final WALoginDialog loginDialog = new WALoginDialog(this.m_parent, bundle.getString("LoginDialog.Title.txt"));
                    if (SwingUtilities.isEventDispatchThread()) {
                        loginDialog.show();
                    } else {
                        try {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    loginDialog.show();
                                }
                            });
                        }
                        catch (InvocationTargetException e) {
                            e.printStackTrace();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    if (loginDialog.getReturnValue() == 1) {
                        this.m_userid = loginDialog.getUsername();
                        this.m_password = loginDialog.getPassword();
                    } else {
                        return 1;
                    }
                }
            }
            boolean success = false;
            try {
                if (Workspace.this.isSingleSignOn()) {
                    Workspace.this.m_connectionManager.connectToOMRServer(this.m_hostname, this.m_port, this.m_domain, null, null);
                } else {
                    Workspace.this.m_connectionManager.connectToOMRServer(this.m_hostname, this.m_port, this.m_domain, this.m_userid, this.m_password);
                }
                Workspace.this.m_connectionManager.updateProfile();
                if (Workspace.this.m_connectionManager.getMetadataServer().getServerVersion() >= Workspace.this.SERVER_VERSION_940) {
                    success = true;
                    Workspace.this.m_connected = true;
                    OMIServer server = Workspace.this.m_connectionManager.getMetadataServer();
                    if (server != null) {
                        Workspace.this.m_metadataConnectionListener = new WorkspaceMetadataConnectionListener();
                        server.addMetadataConnectionListener(Workspace.this.m_metadataConnectionListener);
                    }
                } else {
                    MessageUtil.displayMessage(bundle.formatString("Workspace.MetadataServerVersionError.txt", Workspace.this.m_connectionManager.getHost(), Workspace.this.m_connectionManager.getPort()), 0);
                    success = false;
                    Workspace.this.m_connected = true;
                    Workspace.this.disconnectFromOMRServer();
                }
            }
            catch (ConnectionException ex) {
                MessageUtil.displayChainedExceptionMessage(ex, bundle.getString("ConnectDialog.Title.txt"), 0);
                success = false;
            }
            catch (RemoteException ex) {
                MessageUtil.displayMessage(ex.getLocalizedMessage(), bundle.getString("ConnectDialog.Title.txt"), 0);
                success = false;
            }
            catch (ExpiredPasswordLoginServiceException ex) {
                if (!Workspace.isUsingNewStartupReturnValues()) {
                    MessageUtil.displayMessage(ex.getLocalizedMessage(), bundle.getString("ConnectDialog.Title.txt"), 0);
                    success = false;
                }
                return 3;
            }
            catch (ServiceException ex) {
                MessageUtil.displayServiceExceptionMessage(ex);
                success = false;
            }
            catch (InterruptedException ex) {
                MessageUtil.displayMessage(bundle.getString("Workspace.ConnectError.txt"), bundle.getString("ConnectDialog.Title.txt"), 0);
                success = false;
            }
            catch (Exception ex) {
                Workspace.getDefaultLogger().error((Object)"", ex);
                MessageUtil.displayMessage(ex.getLocalizedMessage(), bundle.getString("ConnectDialog.Title.txt"), 0);
                success = false;
            }
            if (!success) {
                this.m_password = null;
                return 2;
            }
            if (Workspace.this.isServerStatusCheckEnabled()) {
                Workspace.this.checkMetadataServerStatus(true);
            }
            Workspace.this.setSelectedRepositories();
            if (Workspace.this.m_defaultRepository == null) {
                Workspace.getWorkspace().setStatusText(bundle.getString("Workspace.NoReposError.txt"));
                this.m_password = null;
                return 2;
            }
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        Workspace.this.m_splitManagerPanel = new JPanel();
                        Workspace.this.m_splitManager = new SplitManager(Workspace.this.m_splitManagerPanel);
                        Workspace.this.getContentPane().add((Component)Workspace.this.m_splitManagerPanel, "Center");
                        Workspace.this.firePropertyChange(Workspace.METADATA_PROFILE_FILENAME_PROPERTY, "", Workspace.this.m_workspaceFile.getFileName());
                        if (Workspace.this.m_treeObject != null) {
                            Workspace.this.m_treeObject.initialize();
                            cFocusListener flTree = new cFocusListener(Workspace.this.m_treeObject);
                            WsFocusListenerPropagator flpTree = new WsFocusListenerPropagator(flTree);
                            flpTree.startListeningTo(Workspace.this.m_treeObject.getTreeComponent());
                        }
                        if (!Workspace.this.m_bSkipInitializeDesktopLayout) {
                            Workspace.this.initializeDesktop();
                        }
                        try {
                            if (!Workspace.this.isFoundationServicesConnection()) {
                                Workspace.this.setMetadataDomain();
                            }
                        }
                        catch (RemoteException ex) {
                            Workspace.handleRemoteException(ex);
                        }
                    }
                });
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            finally {
                this.m_password = null;
            }
            return 0;
        }

        public int getStatus() {
            return this.m_status;
        }
    }

    protected class cFocusListener
    implements FocusListener {
        protected WsWorkspaceComponent m_cmp;

        public cFocusListener(WsWorkspaceComponent cmp) {
            this.m_cmp = cmp;
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (!Workspace.this.isShowing()) {
                return;
            }
            JInternalFrame frame = Workspace.this.m_Desktop.getSelectedFrame();
            if (frame != null) {
                try {
                    frame.setSelected(false);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
            Workspace.this.setActiveComponent(this.m_cmp);
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    }

    protected class ShowAppServerDialog
    implements Runnable {
        private AppServer m_iAppServer;
        private boolean m_bTestIt;
        private String m_ServerId;

        protected ShowAppServerDialog() {
        }

        @Override
        public void run() {
            String sPanelTitle = bundle.getString("Workspace.AppServer.Info.txt");
            try {
                if (this.m_ServerId != null && this.m_ServerId.length() > 0) {
                    this.m_iAppServer = new AppServer(this.m_ServerId);
                    if (this.m_bTestIt) {
                        this.m_iAppServer.testConnection();
                    }
                    return;
                }
            }
            catch (AppServerException e) {
                sPanelTitle = bundle.getString("Workspace.AppServer.ConnectionError.txt");
                Workspace.this.getMessagesWindow().addMessage(bundle.formatString("Workspace.AppServer.MessageWindowConnectionError.txt", e.getMessage()));
                Workspace.this.getStatusBar().displayMessage(bundle.getString("Workspace.AppServer.StatusBarConnectionError.txt"));
            }
            if (this.m_iAppServer != null) {
                this.m_iAppServer.termAppServer();
                this.m_iAppServer = null;
            }
            boolean done = false;
            while (!done) {
                this.m_iAppServer = new AppServer();
                AppServerDialog dlgAppServer = new AppServerDialog((Frame)Workspace.getWorkspace(), this.m_iAppServer, sPanelTitle);
                dlgAppServer.show();
                Workspace.this.getStatusBar().displayMessage(" ");
                if (dlgAppServer.getReturnValue() != 1) {
                    this.m_iAppServer = null;
                    return;
                }
                try {
                    if (this.m_bTestIt) {
                        this.m_iAppServer.testConnection();
                    }
                    done = true;
                }
                catch (AppServerException e) {
                    Workspace.this.getMessagesWindow().addMessage(bundle.formatString("Workspace.AppServer.MessageWindowConnectionError.txt", e.getMessage()));
                    Workspace.this.getStatusBar().displayMessage(bundle.getString("Workspace.AppServer.StatusBarConnectionError.txt"));
                }
            }
        }

        public AppServer getAppServer() {
            return this.m_iAppServer;
        }

        public void setTestIt(boolean test) {
            this.m_bTestIt = test;
        }

        public void setServerId(String sServerId) {
            this.m_ServerId = sServerId;
        }
    }

    private class OptionDialog
    implements Runnable {
        private String m_sMessage;
        private String m_sTitle;
        private int m_iOptionType;
        private int m_iMessageType;
        private Object[] m_aButtons;
        private int m_iRC;

        public OptionDialog(String sMessage, String sTitle, int iOptionType, int iMessageType, Object[] aButtons) {
            this.m_sMessage = sMessage;
            this.m_sTitle = sTitle;
            this.m_iOptionType = iOptionType;
            this.m_iMessageType = iMessageType;
            this.m_aButtons = aButtons;
        }

        @Override
        public void run() {
            this.m_iRC = JOptionPane.showOptionDialog(Workspace.getWorkspace(), this.m_sMessage, this.m_sTitle, this.m_iOptionType, this.m_iMessageType, null, this.m_aButtons, this.m_aButtons[0]);
        }

        public int getReturnCode() {
            return this.m_iRC;
        }

        public int showMessage() {
            block6: {
                if (SwingUtilities.isEventDispatchThread()) {
                    this.run();
                } else {
                    try {
                        SwingUtilities.invokeAndWait(this);
                    }
                    catch (InvocationTargetException e) {
                        if (m_bDebug) {
                            e.printStackTrace();
                        }
                    }
                    catch (InterruptedException e) {
                        if (!m_bDebug) break block6;
                        e.printStackTrace();
                    }
                }
            }
            return this.m_iRC;
        }
    }

    private class Reconnect
    implements Runnable {
        private boolean bRC;

        private Reconnect() {
        }

        @Override
        public void run() {
            try {
                Workspace.this.getConnectionManager().getMetadataServer().reconnect();
                Workspace.this.m_pIOMI = Workspace.this.getConnectionManager().getMetadataServer().getMdFactory().getConnection().getCMRHandle();
                Workspace.this.m_pIServer = Workspace.this.m_MetadataWorkspace.MakeIServerConnection(Workspace.this.m_pIOMI);
                this.bRC = true;
            }
            catch (RemoteException e) {
                this.bRC = false;
            }
            catch (ServiceException e) {
                this.bRC = false;
            }
            catch (MdException ex) {
                this.bRC = false;
            }
            catch (Exception e) {
                Workspace.getDefaultLogger().error((Object)"", e);
                this.bRC = false;
            }
        }

        public boolean getReturnCode() {
            return this.bRC;
        }
    }

    class WorkspaceMetadataConnectionListener
    implements MetadataConnectionListener {
        WorkspaceMetadataConnectionListener() {
        }

        public void connectionNotification(MetadataConnectionEvent event) throws RemoteException {
            try {
                MdOMRConnection connection;
                if (s_metadataFactory != null && (connection = s_metadataFactory.getConnection()) != null) {
                    Workspace.this.m_pIOMI = connection.getCMRHandle();
                    Workspace.this.m_pIServer = connection.MakeIServerConnection(Workspace.this.m_pIOMI);
                    WsStatusBarUtilities.updateServerPanel();
                }
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException(ex);
            }
            catch (MdException ex) {
                Workspace.getDefaultLogger().error((Object)"", ex);
            }
        }
    }
}

