/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.metadata.remote.MdException;
import com.sas.workspace.CustomLayoutFocusTraversalPolicy;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OpRequestUI;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAUndoManager;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsTabbedInterface;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.rmi.RemoteException;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoManager;

public class WATabbedPanel
extends WAPanel {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = WAdminResource.getBundle(WATabbedPanel.class);
    protected WsTabbedInterface m_Tabs = this.createTabbedPane();
    protected WAPropertyTab m_cmpSelectedTab = null;
    protected boolean m_bInternalFrameParent = false;
    protected boolean m_bSkipMoveDataToView = false;
    private boolean m_bActive;
    private UndoManager m_mgrUndo;
    private boolean m_bUndoing;

    public WATabbedPanel() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_Tabs.getComponent(), "Center");
        this.m_Tabs.addChangeListener(this.createTabChangedListener());
    }

    protected WsTabbedInterface createTabbedPane() {
        return new cTabbedPane();
    }

    @Override
    public Component getDefaultFocusComponent() {
        Component cmp = CustomLayoutFocusTraversalPolicy.getDefaultFocusComponent(this.m_Tabs.getSelectedTab());
        if (cmp == null) {
            cmp = this.m_Tabs.getComponent();
        }
        return cmp;
    }

    @Override
    public void setNextFocusableComponentOnLastFocusableComponent(Component cmpNext) {
        int nTabs = this.m_Tabs.getTabCount();
        for (int iTab = 0; iTab < nTabs; ++iTab) {
            this.getTabAt(iTab).setNextFocusableComponentOnLastFocusableComponent(cmpNext);
        }
    }

    public void setUndoManager(UndoManager mgrUndo) {
        this.m_mgrUndo = mgrUndo;
    }

    public UndoManager getUndoManager() {
        return this.m_mgrUndo;
    }

    public void addTab(WAPropertyTab tab) {
        this.addTab(tab.getName(), null, tab, null);
    }

    public void addTab(String sTitle, WAPropertyTab tab) {
        this.addTab(sTitle, null, tab, null);
    }

    public void addTab(String sTitle, Icon icon, WAPropertyTab tab, String sToolTipText) {
        this.addBorderToTab(tab);
        tab.setEditable(this.m_bEditable);
        this.listenForDataChangesTo(tab);
        this.m_Tabs.addTab(sTitle, icon, tab, sToolTipText);
    }

    public WAPropertyTab getTabAt(int iTab) {
        return (WAPropertyTab)this.m_Tabs.getTabAt(iTab);
    }

    public WAPropertyTab getSelectedTab() {
        return (WAPropertyTab)this.m_Tabs.getSelectedTab();
    }

    public void setSelectedTab(WAPropertyTab tab) {
        this.m_Tabs.setSelectedTab(tab);
    }

    public void removeTabAt(int iTab) {
        this.removeTab((WAPropertyTab)this.m_Tabs.getTabAt(iTab));
    }

    public void removeTab(WAPropertyTab tab) {
        this.removeBorderFromTab(tab);
        this.stopListeningForDataChangesTo(tab);
        this.m_Tabs.removeTab(tab);
    }

    public void removeAllTabs() {
        for (int iTab = this.m_Tabs.getTabCount() - 1; iTab >= 0; --iTab) {
            this.m_Tabs.removeTabAt(iTab);
        }
    }

    public int getTabCount() {
        return this.m_Tabs.getTabCount();
    }

    protected void addBorderToTab(WAPropertyTab tab) {
        Border brdrOuter = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        Border brdrInner = tab.getBorder();
        tab.setBorder(BorderFactory.createCompoundBorder(brdrOuter, brdrInner));
    }

    protected void removeBorderFromTab(WAPropertyTab tab) {
        CompoundBorder brdrCompound = (CompoundBorder)tab.getBorder();
        tab.setBorder(brdrCompound.getOutsideBorder());
    }

    @Override
    public void setEditable(boolean bEditable) {
        if (this.m_bEditable != bEditable) {
            super.setEditable(bEditable);
            int nTabs = this.m_Tabs.getTabCount();
            for (int iTab = 0; iTab < nTabs; ++iTab) {
                WAPropertyTab tab = (WAPropertyTab)this.m_Tabs.getTabAt(iTab);
                tab.setEditable(bEditable);
            }
        }
    }

    @Override
    public ClassLoader getHelpClassLoader() {
        return ((WAPropertyTab)this.m_Tabs.getSelectedTab()).getHelpClassLoader();
    }

    @Override
    public String getHelpTopic() {
        return ((WAPropertyTab)this.m_Tabs.getSelectedTab()).getHelpTopic();
    }

    @Override
    public String getHelpProduct() {
        return ((WAPropertyTab)this.m_Tabs.getSelectedTab()).getHelpProduct();
    }

    @Override
    public void setStorePopulated(boolean bStorePopulated) {
        int nTabs = this.m_Tabs.getTabCount();
        for (int iTab = 0; iTab < nTabs; ++iTab) {
            WAPropertyTab tab = (WAPropertyTab)this.m_Tabs.getTabAt(iTab);
            tab.setStorePopulated(bStorePopulated);
        }
    }

    @Override
    public boolean validateData() {
        return ((WAPropertyTab)this.m_Tabs.getSelectedTab()).validateData();
    }

    @Override
    public void populateStore() {
        WAPropertyTab tab = (WAPropertyTab)this.m_Tabs.getSelectedTab();
        tab.setHasBeenShown(true);
        if (!tab.isStorePopulated()) {
            this.m_bSkipMoveDataToView = true;
            this.populateStoreWrapper(tab);
        }
        this.m_cmpSelectedTab = (WAPropertyTab)this.m_Tabs.getSelectedTab();
    }

    @Override
    public void moveDataToView() {
        if (this.m_bSkipMoveDataToView) {
            this.m_bSkipMoveDataToView = false;
            return;
        }
        this.moveTabDataToView((WAPropertyTab)this.m_Tabs.getSelectedTab());
    }

    @Override
    public void moveDataToStore() {
        WAPropertyTab tab = (WAPropertyTab)this.m_Tabs.getSelectedTab();
        this.moveTabDataToStore(tab);
        this.setDataChanged(false);
    }

    @Override
    public void updateWorkspaceUIComponents(boolean bActive) {
        this.m_bActive = bActive;
        ((WAPropertyTab)this.m_Tabs.getSelectedTab()).updateWorkspaceUIComponents(bActive);
    }

    @Override
    public void saveSettingsAndCleanUp() {
        int nTabs = this.m_Tabs.getTabCount();
        for (int iTab = 0; iTab < nTabs; ++iTab) {
            WAPropertyTab tab = (WAPropertyTab)this.m_Tabs.getTabAt(iTab);
            tab.saveSettingsAndCleanUp();
        }
    }

    @Override
    public WAUndoManager getWAUndoManager() {
        return ((WAPropertyTab)this.m_Tabs.getSelectedTab()).getWAUndoManager();
    }

    protected void populateStoreWrapper(WAPropertyTab tab) {
        SwingUtilities.getWindowAncestor(this).setCursor(Cursor.getPredefinedCursor(3));
        OpRequestUI opRequestUI = new OpRequestUI(Workspace.getWorkspace(), bundle.getString("WAPropertyTab.Label.Status"), bundle.getString("WAPropertyTab.Title"), bundle.getString("WAPropertyTab.Label.Cancel"));
        opRequestUI.setDelayBeforeProgressCancelDialog(1000);
        opRequestUI.execute(this.createPopulateStoreRunnable(tab), this.createMoveDataToViewRunnable(tab));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void moveTabDataToView(WAPropertyTab tab) {
        Window cmp = SwingUtilities.getWindowAncestor(this);
        if (cmp != null) {
            ((Component)cmp).setCursor(Cursor.getPredefinedCursor(3));
        }
        try {
            this.setListeningForChanges(false);
            tab.moveDataToView();
            this.setListeningForChanges(true);
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage(e, "Reading");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException(re);
        }
        finally {
            if (cmp != null) {
                ((Component)cmp).setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void moveTabDataToStore(WAPropertyTab tab) {
        Window cmp = SwingUtilities.getWindowAncestor(this);
        if (cmp != null) {
            ((Component)cmp).setCursor(Cursor.getPredefinedCursor(3));
        }
        try {
            tab.moveDataToStore();
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage(e, "Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException(re);
        }
        finally {
            if (cmp != null) {
                ((Component)cmp).setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    @Override
    public boolean canClose() {
        int nTabs = this.m_Tabs.getTabCount();
        for (int iTab = 0; iTab < nTabs; ++iTab) {
            WAPropertyTab tab = (WAPropertyTab)this.m_Tabs.getTabAt(iTab);
            if (tab.canClose()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void onParentOK() {
        for (int iTab = 0; iTab < this.m_Tabs.getTabCount(); ++iTab) {
            WAPropertyTab tab = (WAPropertyTab)this.m_Tabs.getTabAt(iTab);
            tab.onParentOK();
        }
    }

    @Override
    public void onParentApply() {
        for (int iTab = 0; iTab < this.m_Tabs.getTabCount(); ++iTab) {
            WAPropertyTab tab = (WAPropertyTab)this.m_Tabs.getTabAt(iTab);
            tab.onParentApply();
        }
    }

    @Override
    public void onParentCancel() {
        for (int iTab = 0; iTab < this.m_Tabs.getTabCount(); ++iTab) {
            WAPropertyTab tab = (WAPropertyTab)this.m_Tabs.getTabAt(iTab);
            tab.onParentCancel();
        }
    }

    protected PropertyChangeListener createDataChangedListener() {
        return new cDataChangedListener();
    }

    protected ChangeListener createTabChangedListener() {
        return new cTabChangedListener();
    }

    protected Runnable createPopulateStoreRunnable(WAPropertyTab tab) {
        return new cPopulateStoreRunnable(tab);
    }

    protected Runnable createMoveDataToViewRunnable(WAPropertyTab tab) {
        return new cMoveDataToViewRunnable(tab);
    }

    protected class cTabbedPane
    extends JTabbedPane
    implements WsTabbedInterface {
        private static final long serialVersionUID = 1L;

        protected cTabbedPane() {
        }

        @Override
        public JComponent getComponent() {
            return this;
        }

        @Override
        public Component getSelectedTab() {
            return this.getSelectedComponent();
        }

        @Override
        public void setSelectedTab(Component cmpTab) {
            this.setSelectedComponent(cmpTab);
        }

        @Override
        public Component getTabAt(int iTab) {
            return this.getComponentAt(iTab);
        }

        @Override
        public void removeTab(Component cmpTab) {
            this.remove(cmpTab);
        }
    }

    protected class cDataChangedListener
    implements PropertyChangeListener {
        protected cDataChangedListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (((Boolean)e.getNewValue()).booleanValue()) {
                WATabbedPanel.this.setDataChanged(true);
            }
        }
    }

    protected class cTabChangedListener
    implements ChangeListener {
        protected cTabChangedListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (WATabbedPanel.this.m_cmpSelectedTab == null) {
                return;
            }
            WAPropertyTab cmpNewSelectedTab = (WAPropertyTab)WATabbedPanel.this.m_Tabs.getSelectedTab();
            if (WATabbedPanel.this.m_cmpSelectedTab == cmpNewSelectedTab) {
                return;
            }
            if (cmpNewSelectedTab == null) {
                return;
            }
            if (!WATabbedPanel.this.m_bUndoing) {
                if (!WATabbedPanel.this.m_cmpSelectedTab.validateData()) {
                    WATabbedPanel.this.m_Tabs.setSelectedTab(WATabbedPanel.this.m_cmpSelectedTab);
                    return;
                }
                WATabbedPanel.this.moveTabDataToStore(WATabbedPanel.this.m_cmpSelectedTab);
            }
            if (WATabbedPanel.this.m_bActive) {
                WATabbedPanel.this.m_cmpSelectedTab.updateWorkspaceUIComponents(false);
            }
            if (WATabbedPanel.this.m_mgrUndo != null && !WATabbedPanel.this.m_bUndoing) {
                WATabbedPanel.this.m_mgrUndo.addEdit(new ChangeTabUndoable(WATabbedPanel.this.m_cmpSelectedTab, cmpNewSelectedTab));
            }
            WATabbedPanel.this.m_cmpSelectedTab = cmpNewSelectedTab;
            WATabbedPanel.this.m_cmpSelectedTab.setHasBeenShown(true);
            if (WATabbedPanel.this.m_bActive) {
                WATabbedPanel.this.m_cmpSelectedTab.updateWorkspaceUIComponents(true);
            }
            if (!WATabbedPanel.this.m_bUndoing) {
                if (!WATabbedPanel.this.m_cmpSelectedTab.isStorePopulated()) {
                    WATabbedPanel.this.populateStoreWrapper(WATabbedPanel.this.m_cmpSelectedTab);
                } else {
                    WATabbedPanel.this.moveTabDataToView(WATabbedPanel.this.m_cmpSelectedTab);
                }
            }
        }
    }

    protected class cPopulateStoreRunnable
    implements Runnable {
        WAPropertyTab m_tab;

        protected cPopulateStoreRunnable(WAPropertyTab tab) {
            this.m_tab = tab;
        }

        @Override
        public void run() {
            try {
                WATabbedPanel.this.setListeningForChanges(false);
                this.m_tab.populateStore();
                WATabbedPanel.this.setListeningForChanges(true);
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage(e, "Reading");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException(re);
            }
        }
    }

    protected class cMoveDataToViewRunnable
    implements Runnable {
        WAPropertyTab m_tab;

        protected cMoveDataToViewRunnable(WAPropertyTab tab) {
            this.m_tab = tab;
        }

        @Override
        public void run() {
            WATabbedPanel.this.moveTabDataToView(this.m_tab);
        }
    }

    private class ChangeTabUndoable
    extends AbstractUndoableEdit {
        private static final long serialVersionUID = 1L;
        private WAPropertyTab m_tabOld;
        private WAPropertyTab m_tabNew;

        public ChangeTabUndoable(WAPropertyTab tabOld, WAPropertyTab tabNew) {
            this.m_tabOld = tabOld;
            this.m_tabNew = tabNew;
        }

        @Override
        public void undo() {
            super.undo();
            WATabbedPanel.this.m_bUndoing = true;
            try {
                WATabbedPanel.this.setSelectedTab(this.m_tabOld);
            }
            finally {
                WATabbedPanel.this.m_bUndoing = false;
            }
        }

        @Override
        public void redo() {
            super.redo();
            WATabbedPanel.this.m_bUndoing = true;
            try {
                WATabbedPanel.this.setSelectedTab(this.m_tabNew);
            }
            finally {
                WATabbedPanel.this.m_bUndoing = false;
            }
        }

        @Override
        public boolean isSignificant() {
            return false;
        }
    }
}

