/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPasswordField;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import javax.swing.JCheckBox;
import javax.swing.JLabel;

public class WALoginDialog
extends WAStandardDialog {
    private static final long serialVersionUID = 1L;
    WorkspaceFile m_workspaceFile;
    JLabel m_lblHost;
    JLabel m_lblHostText;
    JLabel m_lblUsername;
    JLabel m_lblPassword;
    WATextField m_tfUsername;
    WAPasswordField m_pfPassword;
    JCheckBox m_cbSaveLogin;
    boolean m_bSaveLogin = true;
    private static WAdminResource bundle = WAdminResource.getBundle(WALoginDialog.class);

    public WALoginDialog(Frame frame, String title) {
        super(frame, title, true);
        this.setHelpProduct("newworkspace");
        this.setHelpTopic("logon");
    }

    public WALoginDialog(Frame frame, String title, boolean bSaveLogin) {
        this(frame, title);
        this.m_bSaveLogin = bSaveLogin;
        this.setHelpProduct("newworkspace");
        this.setHelpTopic("logon");
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_workspaceFile = Workspace.getWorkspace().getWorkspaceFile();
        this.m_lblHost = new JLabel(bundle.getString("LoginDialog.lblHost.txt"));
        this.m_lblHostText = new JLabel("");
        this.m_lblUsername = new JLabel(bundle.getString("LoginDialog.lblUsername.txt"));
        this.m_lblPassword = new JLabel(bundle.getString("LoginDialog.lblPassword.txt"));
        this.m_tfUsername = new WATextField();
        this.m_pfPassword = new WAPasswordField();
        if (this.m_bSaveLogin) {
            this.m_cbSaveLogin = new JCheckBox(bundle.getString("LoginDialog.cbSaveLogin.txt"));
            this.m_cbSaveLogin.setMnemonic(bundle.getString("LoginDialog.cbSaveLogin.mnem").charAt(0));
            this.m_cbSaveLogin.setSelected(false);
        }
        this.m_lblUsername.setLabelFor(this.m_tfUsername);
        this.m_lblPassword.setLabelFor(this.m_pfPassword);
        this.m_lblUsername.setDisplayedMnemonic(bundle.getString("LoginDialog.lblUsername.mnem").charAt(0));
        this.m_lblPassword.setDisplayedMnemonic(bundle.getString("LoginDialog.lblPassword.mnem").charAt(0));
    }

    @Override
    protected void layoutWidgets() {
        WAPanel pnlMain = new WAPanel();
        pnlMain.setLayout(new GridBagLayout());
        pnlMain.add((Component)this.m_lblHost, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        pnlMain.add((Component)this.m_lblHostText, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        pnlMain.add((Component)this.m_lblUsername, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 5), 0, 0));
        pnlMain.add((Component)this.m_tfUsername, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 5, 0, 5), 0, 0));
        pnlMain.add((Component)this.m_lblPassword, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        pnlMain.add((Component)this.m_pfPassword, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
        if (this.m_bSaveLogin) {
            pnlMain.add((Component)this.m_cbSaveLogin, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        }
        this.setMainPanel(pnlMain);
        super.layoutWidgets();
    }

    @Override
    public boolean doDataExchange(boolean bSaveToModel) {
        try {
            if (!bSaveToModel) {
                this.m_lblHostText.setText(this.m_workspaceFile.getPropertyString("host"));
                this.m_tfUsername.setText(this.m_workspaceFile.getPropertyString("userid"));
                this.m_pfPassword.setText(Workspace.getMdFactory().getUtil().decrypt(this.m_workspaceFile.getPropertyString("password")));
                boolean allowLocalPasswords = this.m_workspaceFile.getPropertyBoolean("AllowLocalPasswords", true);
                if (this.m_bSaveLogin) {
                    this.m_cbSaveLogin.setEnabled(allowLocalPasswords);
                }
            } else if (this.m_bSaveLogin && this.m_cbSaveLogin.isSelected()) {
                this.m_workspaceFile.setPropertyString("userid", this.m_tfUsername.getText().trim());
                this.m_workspaceFile.setPropertyString("password", Workspace.getMdFactory().getUtil().encrypt(String.valueOf(this.m_pfPassword.getPassword())));
                this.m_workspaceFile.saveExisting();
            }
            return true;
        }
        catch (RemoteException re) {
            Workspace.getDefaultLogger().error((Object)"", re);
            return false;
        }
    }

    @Override
    public boolean validateData() {
        if (this.m_tfUsername.getText().trim().length() == 0 || String.valueOf(this.m_pfPassword.getPassword()).trim().length() == 0 || String.valueOf(this.m_pfPassword.getPassword()).trim().toLowerCase().indexOf("{sas") == 0) {
            this.m_tfUsername.requestFocus();
            MessageUtil.displayMessage(bundle.getString("LoginDialog.LoginError.txt"), 0);
            return false;
        }
        return true;
    }

    public String getUsername() {
        return this.m_tfUsername.getText().trim();
    }

    public String getPassword() {
        try {
            return Workspace.getMdFactory().getUtil().encrypt(new String(this.m_pfPassword.getPassword()).trim());
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException(re);
            return "";
        }
    }
}

