/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.workspace.CustomDesktop;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsBaseView;
import com.sas.workspace.WsWorkspaceComponent;
import java.awt.Color;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.beans.PropertyVetoException;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.JInternalFrame;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class WAInternalFrame
extends JInternalFrame
implements WsWorkspaceComponent {
    private static final long serialVersionUID = 1L;
    public static final String EDITABLE_PROPERTY = "Editable";
    public static final int MIN_WIDTH = 150;
    public static final int MIN_HEIGHT = 150;
    protected WorkspaceFile m_appDefaults = Workspace.getWorkspace().getAppDefaultsFile();
    protected String m_sDefaultsName;
    private WsBaseView m_view;
    protected boolean m_bDisablePack = false;
    protected boolean m_bEditable = true;
    protected WsAbstractAction m_actClose;

    public WAInternalFrame() {
        this("", false, false, false, false);
    }

    public WAInternalFrame(String frameTitle) {
        this(frameTitle, false, false, false, false);
    }

    public WAInternalFrame(String frameTitle, boolean bResizable) {
        this(frameTitle, bResizable, false, false, false);
    }

    public WAInternalFrame(String frameTitle, boolean bResizable, boolean bClosable) {
        this(frameTitle, bResizable, bClosable, false, false);
    }

    public WAInternalFrame(String frameTitle, boolean bResizable, boolean bClosable, boolean bMaximizable) {
        this(frameTitle, bResizable, bClosable, bMaximizable, false);
    }

    public WAInternalFrame(String frameTitle, boolean bResizable, boolean bClosable, boolean bMaximizable, boolean bIconifiable) {
        super(frameTitle, bResizable, bClosable, bMaximizable, bIconifiable);
        this.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameActivated(InternalFrameEvent e) {
                Workspace.getWorkspace().setActiveComponent(WAInternalFrame.this);
            }

            @Override
            public void internalFrameClosed(InternalFrameEvent e) {
                if (Workspace.getWorkspace().getDesktopWindowHandle().getAllFrames().length == 0) {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().clearGlobalFocusOwner();
                }
            }
        });
        this.m_actClose = this.createCloseAction();
        this.getInputMap(1).put(KeyStroke.getKeyStroke(45, 8), "showSystemMenu");
    }

    public void setView(WsBaseView view) {
        this.m_view = view;
    }

    public WsBaseView getView() {
        return this.m_view;
    }

    public void setDefaultsName(String sDefaultsName) {
        this.m_sDefaultsName = sDefaultsName;
    }

    public String getDefaultsName() {
        return this.m_sDefaultsName;
    }

    public void useDefaultSize(boolean bPack) {
        int cxDefault = -1;
        int cyDefault = -1;
        if (this.m_sDefaultsName != null) {
            cxDefault = this.m_appDefaults.getPropertyInt(this.m_sDefaultsName + ".cx", -1);
            cyDefault = this.m_appDefaults.getPropertyInt(this.m_sDefaultsName + ".cy", -1);
        }
        if (cxDefault != -1 && cyDefault != -1) {
            cxDefault = Math.max(cxDefault, 150);
            cyDefault = Math.max(cyDefault, 150);
            this.setSize(cxDefault, cyDefault);
            this.m_bDisablePack = true;
        } else if (bPack) {
            this.pack();
            this.m_bDisablePack = true;
        }
        CustomDesktop desktop = Workspace.getWorkspace().getDesktopWindowHandle();
        int cxFrame = Math.min(this.getWidth(), desktop.getWidth() - desktop.getCascadeXOffset());
        int cyFrame = Math.min(this.getHeight(), desktop.getHeight() - desktop.getCascadeXOffset());
        this.setSize(cxFrame, cyFrame);
    }

    public void setEditable(boolean bEditable) {
        if (this.m_bEditable != bEditable) {
            boolean bOld = this.m_bEditable;
            this.m_bEditable = bEditable;
            this.firePropertyChange(EDITABLE_PROPERTY, bOld, bEditable);
        }
    }

    public boolean isEditable() {
        return this.m_bEditable;
    }

    public void close() {
        try {
            this.setClosed(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    @Override
    public void setResizable(boolean bResizable) {
        CompoundBorder bdrWhole;
        super.setResizable(bResizable);
        Color clrControl = UIManager.getColor("control");
        Color clrControlHighlight = UIManager.getColor("controlHighlight");
        Color clrControlLtHighlight = UIManager.getColor("controlLtHighlight");
        Color clrControlDkShadow = UIManager.getColor("controlDkShadow");
        Color clrControlShadow = UIManager.getColor("controlShadow");
        Border bdrOuter = BorderFactory.createBevelBorder(0, clrControlHighlight, clrControlLtHighlight, clrControlDkShadow, clrControlShadow);
        Border bdrMiddle = BorderFactory.createLineBorder(clrControl, bResizable ? 2 : 1);
        if (bResizable) {
            Border bdrInner = BorderFactory.createBevelBorder(1, clrControlLtHighlight, clrControlHighlight, clrControlDkShadow, clrControlShadow);
            CompoundBorder bdrPart = BorderFactory.createCompoundBorder(bdrOuter, bdrMiddle);
            bdrWhole = BorderFactory.createCompoundBorder(bdrPart, bdrInner);
        } else {
            bdrWhole = BorderFactory.createCompoundBorder(bdrOuter, bdrMiddle);
        }
        this.setBorder(bdrWhole);
    }

    @Override
    public void pack() {
        if (!this.m_bDisablePack) {
            super.pack();
        }
    }

    @Override
    public void dispose() {
        if (Workspace.getWorkspace().getActiveComponent() == this) {
            Workspace.getWorkspace().setActiveComponent(null);
        }
        if (this.m_sDefaultsName != null) {
            this.m_appDefaults.setPropertyInt(this.m_sDefaultsName + ".cx", Math.max(this.getWidth(), 150));
            this.m_appDefaults.setPropertyInt(this.m_sDefaultsName + ".cy", Math.max(this.getHeight(), 150));
        }
        if (this.m_view != null) {
            this.m_view.dispose();
        }
        ((ActionMap)UIManager.getLookAndFeelDefaults().get("InternalFrame.actionMap")).remove("showSystemMenu");
        super.dispose();
    }

    @Override
    public void updateWorkspaceUIComponents(boolean bActive) {
        this.m_actClose.setActive(bActive);
    }

    protected WsAbstractAction createCloseAction() {
        return new cCloseAction();
    }

    protected class cCloseAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public cCloseAction() {
            this.setMenuSupportId("close");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WAInternalFrame.this.close();
        }
    }
}

