/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsLimitedPlainDocument;
import java.awt.Font;
import java.awt.FontMetrics;
import java.text.DecimalFormatSymbols;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class WAIntTextField
extends WATextField {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = WAdminResource.getBundle(WAIntTextField.class);
    private int columnWidth = 0;

    public WAIntTextField() {
        this(false);
    }

    public WAIntTextField(boolean allowNegative) {
        ((IntDocument)this.getDocument()).setAllowNegatives(allowNegative);
        this.setHorizontalAlignment(4);
    }

    public void setAllowNegatives(boolean allowNegative) {
        ((IntDocument)this.getDocument()).setAllowNegatives(allowNegative);
    }

    public boolean getAllowNegatives() {
        return ((IntDocument)this.getDocument()).getAllowNegatives();
    }

    public int getValue() throws NumberFormatException {
        int iValue = -1;
        try {
            iValue = Integer.parseInt(this.getText());
        }
        catch (NumberFormatException e) {
            Workspace.getLogger("com.sas.workspace.components").error("Error in WAIntTextField");
        }
        return iValue;
    }

    public int getValue2() throws IllegalIntegerException {
        int iValue;
        try {
            iValue = Integer.parseInt(this.getText());
        }
        catch (NumberFormatException nfe) {
            String message = ((IntDocument)this.getDocument()).getAllowNegatives() ? bundle.formatString("WAIntTextField.IllegalIntegerException.Negative.fmt", this.getText()) : bundle.formatString("WAIntTextField.IllegalIntegerException.NoNegative.fmt", this.getText());
            throw new IllegalIntegerException(message);
        }
        return iValue;
    }

    public void setValue(int iValue) {
        this.setText(Integer.toString(iValue));
    }

    @Override
    protected Document createDefaultModel() {
        return new IntDocument();
    }

    @Override
    public int getColumnWidth() {
        if (this.columnWidth == 0) {
            FontMetrics metrics = this.getFontMetrics(this.getFont());
            this.columnWidth = metrics.charWidth('0');
        }
        return this.columnWidth;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.columnWidth = 0;
    }

    protected static class IntDocument
    extends WsLimitedPlainDocument {
        private static final long serialVersionUID = 1L;
        private boolean m_bAllowNegative;
        private static final char NEGATIVE_SIGN = new DecimalFormatSymbols().getMinusSign();

        protected IntDocument() {
        }

        public void setAllowNegatives(boolean allowNegative) {
            this.m_bAllowNegative = allowNegative;
        }

        public boolean getAllowNegatives() {
            return this.m_bAllowNegative;
        }

        @Override
        public void insertString(int iText, String sText, AttributeSet a) throws BadLocationException {
            if (sText == null || sText.length() == 0) {
                return;
            }
            if (this.m_bAllowNegative && this.getText(0, this.getLength()).indexOf(NEGATIVE_SIGN) == -1 && sText.indexOf(NEGATIVE_SIGN) == 0 && iText == 0) {
                super.insertString(0, String.valueOf(NEGATIVE_SIGN), a);
                this.insertString(1, sText.substring(1), a);
                return;
            }
            if (this.getText(0, this.getLength()).indexOf(NEGATIVE_SIGN) >= 0 && iText == 0) {
                if (s_msgDisplayer != null) {
                    s_msgDisplayer.displayMessage(bundle.getString("Common.InsertBeforeNegativeSignErrorMessage.txt"));
                    this.m_bMessage = true;
                }
                return;
            }
            char[] caSource = sText.toCharArray();
            char[] caResult = new char[caSource.length];
            boolean bError = false;
            int iResult = 0;
            for (int iSource = 0; iSource < caSource.length; ++iSource) {
                if (Character.isDigit(caSource[iSource])) {
                    caResult[iResult++] = caSource[iSource];
                    continue;
                }
                bError = true;
            }
            if (bError) {
                if (s_msgDisplayer != null) {
                    String sMessage = bundle.getString("Common.NumericCharactersOnlyErrorMessage.txt");
                    s_msgDisplayer.displayMessage(sMessage);
                    this.m_bMessage = true;
                }
            } else if (this.m_bMessage) {
                s_msgDisplayer.displayMessage("");
                this.m_bMessage = false;
            }
            super.insertString(iText, new String(caResult, 0, iResult), a);
        }
    }

    public class IllegalIntegerException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public IllegalIntegerException(String message) {
            super(message);
        }
    }
}

