/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.nls.collator.SASCollatorFactory;
import com.sas.workspace.WATextField;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;

public class WAComboBox
extends JComboBox
implements FocusListener {
    private static final long serialVersionUID = 1L;
    protected cComboBoxModel m_Model;
    protected boolean m_bFocusViaKeyboard = false;
    public static Object SEPARATOR = new Object();

    public WAComboBox() {
        this(false);
    }

    public WAComboBox(boolean bSorted) {
        this(bSorted, true);
    }

    public WAComboBox(boolean bSorted, boolean bAscending) {
        this.m_Model = new cComboBoxModel(bSorted, bAscending);
        this.setModel(this.m_Model);
    }

    public WAComboBox(Object[] oaItems) {
        this(oaItems, false);
    }

    public WAComboBox(Object[] oaItems, boolean bSorted) {
        this(oaItems, bSorted, true);
    }

    public WAComboBox(Object[] oaItems, boolean bSorted, boolean bAscending) {
        this.m_Model = new cComboBoxModel(oaItems, bSorted, bAscending);
        this.setModel(this.m_Model);
    }

    @Override
    public void updateUI() {
        LookAndFeel lnf = UIManager.getLookAndFeel();
        String lnfName = lnf.getName();
        BasicComboBoxUI uiCombo = lnfName.equals("Windows") ? new cWindowsComboBoxUI() : (lnfName.equals("CDE/Motif") ? new cMotifComboBoxUI() : new cBasicComboBoxUI());
        this.setUI(uiCombo);
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    public void setAutoSelect(boolean bAutoSelect) {
        Component cmp = this.getEditor().getEditorComponent();
        if (cmp instanceof WATextField) {
            ((WATextField)cmp).setAutoSelect(bAutoSelect);
        }
    }

    public boolean isAutoSelect() {
        Component cmp = this.getEditor().getEditorComponent();
        if (cmp instanceof WATextField) {
            return ((WATextField)cmp).isAutoSelect();
        }
        return false;
    }

    public int getIndexOf(Object item) {
        return this.m_Model.getIndexOf(item);
    }

    public boolean hasItems() {
        return this.getItemCount() > 0;
    }

    public void setSorted(boolean bSorted) {
        this.m_Model.setSorted(bSorted);
    }

    public boolean getSorted() {
        return this.m_Model.getSorted();
    }

    public void setOrder(boolean bAscending) {
        this.m_Model.setOrder(bAscending);
    }

    public boolean getOrder() {
        return this.m_Model.getOrder();
    }

    public void setSortComparator(Comparator sortComparator) {
        this.m_Model.setSortComparator(sortComparator);
    }

    public Comparator getSortComparator() {
        return this.m_Model.getSortComparator();
    }

    public JTextField getTextComponent() {
        return (JTextField)this.getEditor().getEditorComponent();
    }

    public String getText() {
        return this.getTextComponent().getText();
    }

    @Override
    public void removeAllItems() {
        super.removeAllItems();
        this.setSelectedIndex(-1);
    }

    public void addItems(List lItems) {
        this.m_Model.addElements(lItems.toArray());
    }

    public void addItems(Object[] aItems) {
        this.m_Model.addElements(aItems);
    }

    public void saveItems(String sKey, int nValues) {
        WorkspaceFile appDefaults = Workspace.getWorkspace().getAppDefaultsFile();
        Object selected = this.getSelectedItem();
        if (selected == null) {
            return;
        }
        String sSelected = selected.toString();
        if (sSelected.length() == 0) {
            return;
        }
        appDefaults.setPropertyString(sKey + 0, sSelected);
        int iValue = 1;
        for (int iItem = 0; iItem < this.getItemCount(); ++iItem) {
            Object item = this.getItemAt(iItem);
            if (selected.equals(item)) continue;
            appDefaults.setPropertyString(sKey + iValue, item.toString());
            if (++iValue >= nValues) break;
        }
    }

    public void loadItems(String sKey, int nValues) {
        String sItem;
        WorkspaceFile appDefaults = Workspace.getWorkspace().getAppDefaultsFile();
        for (int iItem = 0; iItem < nValues && (sItem = appDefaults.getPropertyString(sKey + iItem, "")).length() != 0; ++iItem) {
            this.addItem(sItem);
        }
    }

    @Override
    public void setSelectedItem(Object item) {
        if (item != SEPARATOR) {
            super.setSelectedItem(item);
        }
    }

    protected static ComboPopup createPopup(JComboBox cmb) {
        return new cComboPopup(cmb);
    }

    protected static BasicComboBoxRenderer createRenderer() {
        return new cComboBoxRenderer();
    }

    protected class cComboBoxModel
    extends DefaultComboBoxModel {
        private static final long serialVersionUID = 1L;
        protected boolean m_bSorted;
        protected boolean m_bAscending;
        private Comparator m_sortComparator;

        public cComboBoxModel(boolean bSorted, boolean bAscending) {
            this.m_bSorted = bSorted;
            this.m_bAscending = bAscending;
            this.m_sortComparator = new DefaultComparator();
        }

        public cComboBoxModel(Object[] oaItems, boolean bSorted, boolean bAscending) {
            this.m_bSorted = bSorted;
            this.m_bAscending = bAscending;
            this.m_sortComparator = new DefaultComparator();
            if (oaItems != null) {
                for (int iItem = 0; iItem < oaItems.length; ++iItem) {
                    this.addElement(oaItems[iItem]);
                }
                if (oaItems.length >= 1) {
                    this.setSelectedItem(oaItems[0]);
                }
            }
        }

        public void setSorted(boolean bSorted) {
            if (bSorted != this.m_bSorted) {
                this.m_bSorted = bSorted;
                if (bSorted && this.getSize() > 0) {
                    int iItem;
                    int nItems = this.getSize();
                    ArrayList lItems = new ArrayList(nItems);
                    for (iItem = 0; iItem < nItems; ++iItem) {
                        lItems.add(this.getElementAt(iItem));
                    }
                    WAComboBox.this.removeAllItems();
                    for (iItem = 0; iItem < nItems; ++iItem) {
                        this.addElement(lItems.get(iItem));
                    }
                }
            }
        }

        public boolean getSorted() {
            return this.m_bSorted;
        }

        public void setOrder(boolean bAscending) {
            if (bAscending != this.m_bAscending) {
                if (this.m_bSorted) {
                    throw new UnsupportedOperationException("Cannot change sort-order of a non-sorted combobox model.");
                }
                if (this.getSize() > 0) {
                    throw new UnsupportedOperationException("Cannot change sort-order of a non-empty combobox model.");
                }
                this.m_bAscending = bAscending;
            }
        }

        public boolean getOrder() {
            if (!this.m_bSorted) {
                throw new UnsupportedOperationException("Cannot get the sort order of an unsorted combobox.");
            }
            return this.m_bAscending;
        }

        public void setSortComparator(Comparator sortComparator) {
            if (this.getSize() > 0) {
                throw new UnsupportedOperationException("Cannot change sort-comparator of a non-empty combobox model.");
            }
            this.m_sortComparator = sortComparator;
        }

        public Comparator getSortComparator() {
            return this.m_sortComparator;
        }

        @Override
        public void addElement(Object object) {
            if (this.m_bSorted) {
                int rc;
                int iElement;
                for (iElement = 0; !(iElement >= this.getSize() || (rc = this.m_sortComparator.compare(object, this.getElementAt(iElement))) < 0 && this.m_bAscending); ++iElement) {
                }
                super.insertElementAt(object, iElement);
            } else {
                super.addElement(object);
            }
        }

        @Override
        public void insertElementAt(Object object, int index) {
            if (this.m_bSorted) {
                throw new UnsupportedOperationException("Cannot insert elements in a sorted combobox model");
            }
            super.insertElementAt(object, index);
        }

        public void addElements(Object[] aElements) {
            int nElements = aElements.length;
            for (int iElement = 0; iElement < nElements; ++iElement) {
                this.addElement(aElements[iElement]);
            }
        }
    }

    public static class cWindowsComboBoxUI
    extends BasicComboBoxUI {
        private boolean m_bTableEditor;

        @Override
        protected ComboBoxEditor createEditor() {
            return new cComboBoxEditor();
        }

        @Override
        protected ComboPopup createPopup() {
            return WAComboBox.createPopup(this.comboBox);
        }

        protected ListCellRenderer createRenderer() {
            return WAComboBox.createRenderer();
        }

        @Override
        public Dimension getMinimumSize(JComponent cmp) {
            Dimension dim = super.getMinimumSize(cmp);
            dim.width += 4;
            return dim;
        }

        @Override
        public void installUI(JComponent cmp) {
            super.installUI(cmp);
            Boolean bInTable = (Boolean)cmp.getClientProperty("JComboBox.isTableCellEditor");
            if (bInTable != null) {
                this.m_bTableEditor = bInTable;
            }
        }

        @Override
        protected void selectNextPossibleValue() {
            int iSelected = this.m_bTableEditor ? this.listBox.getSelectedIndex() : this.comboBox.getSelectedIndex();
            ++iSelected;
            int nItems = this.comboBox.getItemCount();
            while (iSelected < nItems && this.comboBox.getItemAt(iSelected) == SEPARATOR) {
                ++iSelected;
            }
            if (iSelected >= nItems) {
                return;
            }
            if (this.m_bTableEditor) {
                this.listBox.setSelectedIndex(iSelected);
                this.listBox.ensureIndexIsVisible(iSelected);
            } else {
                this.comboBox.setSelectedIndex(iSelected);
            }
            this.comboBox.repaint();
        }

        @Override
        protected void selectPreviousPossibleValue() {
            int iSelected = this.m_bTableEditor ? this.listBox.getSelectedIndex() : this.comboBox.getSelectedIndex();
            --iSelected;
            while (iSelected > 0 && this.comboBox.getItemAt(iSelected) == SEPARATOR) {
                --iSelected;
            }
            if (iSelected < 0) {
                return;
            }
            if (this.m_bTableEditor) {
                this.listBox.setSelectedIndex(iSelected);
                this.listBox.ensureIndexIsVisible(iSelected);
            } else {
                this.comboBox.setSelectedIndex(iSelected);
            }
            this.comboBox.repaint();
        }
    }

    public static class cMotifComboBoxUI
    extends BasicComboBoxUI {
        private static final long serialVersionUID = 1L;
        private boolean m_bTableEditor;

        @Override
        protected ComboBoxEditor createEditor() {
            return new cComboBoxEditor();
        }

        @Override
        protected ComboPopup createPopup() {
            return WAComboBox.createPopup(this.comboBox);
        }

        protected ListCellRenderer createRenderer() {
            return WAComboBox.createRenderer();
        }

        @Override
        public void installUI(JComponent cmp) {
            super.installUI(cmp);
            Boolean bInTable = (Boolean)cmp.getClientProperty("JComboBox.isTableCellEditor");
            if (bInTable != null) {
                this.m_bTableEditor = bInTable;
            }
        }

        @Override
        protected void selectNextPossibleValue() {
            int iSelected = this.m_bTableEditor ? this.listBox.getSelectedIndex() : this.comboBox.getSelectedIndex();
            ++iSelected;
            int nItems = this.comboBox.getItemCount();
            while (iSelected < nItems && this.comboBox.getItemAt(iSelected) == SEPARATOR) {
                ++iSelected;
            }
            if (iSelected >= nItems) {
                return;
            }
            if (this.m_bTableEditor) {
                this.listBox.setSelectedIndex(iSelected);
                this.listBox.ensureIndexIsVisible(iSelected);
            } else {
                this.comboBox.setSelectedIndex(iSelected);
            }
            this.comboBox.repaint();
        }

        @Override
        protected void selectPreviousPossibleValue() {
            int iSelected = this.m_bTableEditor ? this.listBox.getSelectedIndex() : this.comboBox.getSelectedIndex();
            --iSelected;
            while (iSelected > 0 && this.comboBox.getItemAt(iSelected) == SEPARATOR) {
                --iSelected;
            }
            if (iSelected < 0) {
                return;
            }
            if (this.m_bTableEditor) {
                this.listBox.setSelectedIndex(iSelected);
                this.listBox.ensureIndexIsVisible(iSelected);
            } else {
                this.comboBox.setSelectedIndex(iSelected);
            }
            this.comboBox.repaint();
        }
    }

    public static class cBasicComboBoxUI
    extends BasicComboBoxUI {
        private boolean m_bTableEditor;

        @Override
        protected ComboBoxEditor createEditor() {
            return new cComboBoxEditor();
        }

        @Override
        protected ComboPopup createPopup() {
            return WAComboBox.createPopup(this.comboBox);
        }

        protected ListCellRenderer createRenderer() {
            return WAComboBox.createRenderer();
        }

        @Override
        public void installUI(JComponent cmp) {
            super.installUI(cmp);
            Boolean bInTable = (Boolean)cmp.getClientProperty("JComboBox.isTableCellEditor");
            if (bInTable != null) {
                this.m_bTableEditor = bInTable;
            }
        }

        @Override
        protected void selectNextPossibleValue() {
            int iSelected = this.m_bTableEditor ? this.listBox.getSelectedIndex() : this.comboBox.getSelectedIndex();
            ++iSelected;
            int nItems = this.comboBox.getItemCount();
            while (iSelected < nItems && this.comboBox.getItemAt(iSelected) == SEPARATOR) {
                ++iSelected;
            }
            if (iSelected >= nItems) {
                return;
            }
            if (this.m_bTableEditor) {
                this.listBox.setSelectedIndex(iSelected);
                this.listBox.ensureIndexIsVisible(iSelected);
            } else {
                this.comboBox.setSelectedIndex(iSelected);
            }
            this.comboBox.repaint();
        }

        @Override
        protected void selectPreviousPossibleValue() {
            int iSelected = this.m_bTableEditor ? this.listBox.getSelectedIndex() : this.comboBox.getSelectedIndex();
            --iSelected;
            while (iSelected > 0 && this.comboBox.getItemAt(iSelected) == SEPARATOR) {
                --iSelected;
            }
            if (iSelected < 0) {
                return;
            }
            if (this.m_bTableEditor) {
                this.listBox.setSelectedIndex(iSelected);
                this.listBox.ensureIndexIsVisible(iSelected);
            } else {
                this.comboBox.setSelectedIndex(iSelected);
            }
            this.comboBox.repaint();
        }
    }

    protected static class cComboPopup
    extends BasicComboPopup {
        private static final long serialVersionUID = 1L;

        public cComboPopup(JComboBox cmb) {
            super(cmb);
        }

        @Override
        public void show() {
            Point ptPopup = this.getPopupLocation();
            this.show(this.comboBox, ptPopup.x, ptPopup.y);
        }

        private Point getPopupLocation() {
            Insets insPopup = this.getInsets();
            int xPopup = 0;
            int yPopup = this.comboBox.getHeight();
            int wPopup = this.comboBox.getWidth() - insPopup.left - insPopup.right;
            int hPopup = this.getPopupHeightForRowCount(this.comboBox.getMaximumRowCount());
            int wVertical = 0;
            if (this.comboBox.getItemCount() > this.comboBox.getMaximumRowCount()) {
                wVertical = this.scroller.getVerticalScrollBar().getPreferredSize().width;
            }
            if (this.list.getPreferredSize().width > wPopup - wVertical) {
                hPopup += this.scroller.getHorizontalScrollBar().getPreferredSize().height;
            }
            Rectangle rPopup = this.computePopupBounds(xPopup, yPopup, wPopup, hPopup);
            Dimension dimScroller = rPopup.getSize();
            this.scroller.setMaximumSize(dimScroller);
            this.scroller.setPreferredSize(dimScroller);
            this.scroller.setMinimumSize(dimScroller);
            this.list.revalidate();
            int iSelected = this.comboBox.getSelectedIndex();
            if (iSelected != -1) {
                this.list.ensureIndexIsVisible(iSelected);
            }
            return rPopup.getLocation();
        }

        @Override
        protected JScrollPane createScroller() {
            return new JScrollPane(this.list, 20, 30);
        }

        @Override
        protected void configureScroller() {
            super.configureScroller();
            this.scroller.getHorizontalScrollBar().setFocusable(false);
        }
    }

    private static class cComboBoxRenderer
    extends BasicComboBoxRenderer {
        private static final long serialVersionUID = 1L;
        JSeparator m_separator = new JSeparator(0);

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value == SEPARATOR) {
                return this.m_separator;
            }
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }

    public static class cComboBoxEditor
    extends BasicComboBoxEditor {
        public cComboBoxEditor() {
            this.editor = new WATextField();
            this.editor.setBorder(null);
        }
    }

    private static class DefaultComparator
    implements Comparator {
        private Comparator m_comparator = SASCollatorFactory.createCollator();

        private DefaultComparator() {
        }

        public int compare(Object o1, Object o2) {
            return this.m_comparator.compare(o1.toString(), o2.toString());
        }
    }
}

