/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ExternalTable;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Root;
import com.sas.workspace.ProjectEventListener;
import com.sas.workspace.ProjectEventListener2;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ProjectUtil {
    protected static EventListenerList listenerList = new EventListenerList();
    protected static String strETLockTemplateXML = "<LockTemplates><ExternalTable><Columns/><TargetTransformations/><OwningFile/><Extensions/><Notes/><Documents/><Properties/></ExternalTable><File><FileRefs/><PropertySets/></File><SASFileRef><PropertySets/></SASFileRef><PropertySet><SetProperties/></PropertySet><Property><Notes/></Property><Document><Documents/><Notes/><Extensions/></Document></LockTemplates>";
    protected static String strJobLockTemplateXML = "<LockTemplates><Job><JobActivities/><SourceCode/><Extensions/><Notes/><Documents/><Properties/><TransformationSources/><TransformationTargets/><TriggeredEvents/></Job><TransformationActivity><Steps/><TransformationTargets/><SourceCode/><Extensions/><Notes/><Documents/><Properties/></TransformationActivity><SyncStep><SuccessorDependencies/><PredecessorDependencies/><Transformations/><SourceCode/><Extensions/><Notes/><Documents/><Properties/><UsingPrototype/><PropertySets/><TriggeredEvents/></SyncStep><TransformationStep><SuccessorDependencies/><PredecessorDependencies/><Transformations/><SourceCode/><Extensions/><Notes/><Documents/><Properties/><UsingPrototype/><PropertySets/><TriggeredEvents/></TransformationStep><Select><ClassifierTargets/><ClassifierSources/><FeatureMaps/><AssociatedRowSelector/><HavingForSelect/><GroupByForSelect/><WhereForSelect/><OrderByForSelect/><SourceCode/><Extensions/><Notes/><Documents/><Properties/><PropertySets/><SubstitutionVariables/></Select><ClassifierMap><UsingPrototype/><FeatureMaps/><ClassifierTargets/><ClassifierSources/><AssociatedRowSelector/><SourceCode/><Extensions/><Notes/><Documents/><Properties/><PropertySets/><SubstitutionVariables/><TriggeredEvents/></ClassifierMap><RowSelector><SourceCode/></RowSelector><OrderByClause><Columns/></OrderByClause><FeatureMap><FeatureSources/><FeatureTargets/><SourceCode/><Extensions/><Notes/><Documents/><Properties/><SubstitutionVariables/><TransformationSources/></FeatureMap><ExternalTable><Columns/><TargetTransformations/><OwningFile/><Extensions/><Notes/><Documents/><Properties/></ExternalTable><File><FileRefs/><PropertySets/></File><SASFileRef><PropertySets/></SASFileRef><WorkTable><Columns/><PropertySets/><Indexes/></WorkTable><PhysicalTable><Columns/><UniqueKeys/><Properties/><Indexes/><Documents/><Notes/><Extensions/><Roles/><PropertySets/><ForeignKeys/></PhysicalTable><Column><Documents/><Notes/><Extensions/><PropertySets/><UniqueKeyAssociations/><Keys/></Column><Index><Documents/><Properties/><Notes/><Extensions/></Index><Property><SpecTargetTransformations/><StoredConfiguration/><TargetTransformations/><Properties/><Notes/></Property><Prototype><PrototypeProperties/><Properties/></Prototype><Transformation><SourceCode/><SourceSpecifications/><SubstitutionVariables/></Transformation><PropertySet><Properties/><SetProperties/></PropertySet><Variable><AssociatedObject/></Variable><UniqueKey><ForeignKeys/></UniqueKey><ForeignKey><KeyAssociations/></ForeignKey><Cube><TargetTransformations/><Aggregations/><AssociatedFile/><Dimensions/><Hierarchies/><Measures/><Properties/><PropertySets/><Documents/><Notes/><Extensions/></Cube><Aggregation><AggregateAssociations/><Levels/><AggregationTables/><Properties/></Aggregation><AggregateAssociation><AggregatedColumns/><MeasureOrLevel/></AggregateAssociation><Dimension><TargetTransformations/><Hierarchies/><Levels/><Measures/><DefaultMeasure/><Properties/><Notes/></Dimension><Hierarchy><Levels/><OLAPProperties/><Notes/><Properties/></Hierarchy><Measure><TargetTransformations/><DefaultForDimension/><MLAggregations/><Notes/></Measure><Level><MLAggregations/><Notes/><Properties/></Level><Document><Documents/><Notes/><Extensions/></Document><Event><PropertySets/><SourceTransformations/></Event><Key><PropertySets/><Properties/></Key></LockTemplates>";
    protected static String sCubeLockTemplate34 = "<Cube><Aggregations/><AssociatedFile/><Dimensions/><Hierarchies/><Measures/><Properties/><PropertySets/><Documents/><Notes/><Extensions/></Cube><Aggregation><AggregateAssociations/><Levels/><AggregationTables/><Properties/></Aggregation><AggregateAssociation><AggregatedColumns/><MeasureOrLevel/></AggregateAssociation><Dimension><Hierarchies/><Levels/><Measures/><DefaultMeasure/><Properties/><Notes/></Dimension><Hierarchy><Levels/><OLAPProperties/><Notes/><Properties/></Hierarchy><Measure><DefaultForDimension/><MLAggregations/><Notes/></Measure><Property><StoredConfiguration/></Property><Level><MLAggregations/><Notes/><Properties/></Level><PropertySet><Properties/></PropertySet>";
    protected static String sDocumentLockTemplate34 = "<Document><Documents/><Notes/><Extensions/><PropertySets/></Document><PropertySet><Properties/></PropertySet>";
    protected static String sExternalTableLockTemplate34 = "<ExternalTable><Columns/><PropertySets/><TargetTransformations/><OwningFile/><Extensions/><Notes/><Documents/><Properties/></ExternalTable><File><FileRefs/><PropertySets/></File><SASFileRef><PropertySets/></SASFileRef><PropertySet><Properties/><SetProperties/></PropertySet><Property><Notes/><ExternalIdentities/><OwningType/><PrimaryPropertyGroup/><Properties/><StoredConfiguration/></Property><PropertyGroup><Properties/><PropertySets/></PropertyGroup><Document><Documents/><Notes/><Extensions/></Document><ClassifierMap><TransformationSources/></ClassifierMap>";
    protected static String sJobLockTemplate34 = "<Job><JobActivities/><SourceTransformations/><SourceCode/><Extensions/><Notes/><Documents/><Properties/><PropertySets/><TransformationSources><WorkTable TemplateExpand=\"Yes\"/><DataTable TemplateExpand=\"No\"/></TransformationSources><TransformationTargets><WorkTable TemplateExpand=\"Yes\"/><DataTable TemplateExpand=\"No\"/></TransformationTargets><TriggeredEvents/></Job><TransformationActivity><Steps/><TransformationTargets><WorkTable TemplateExpand=\"Yes\"/><DataTable TemplateExpand=\"No\"/></TransformationTargets><SourceCode/><Extensions/><Notes/><Documents/><Properties/></TransformationActivity><SyncStep><SuccessorDependencies/><PredecessorDependencies/><Transformations><Job TemplateExpand=\"No\"/></Transformations><SourceCode/><Extensions/><Notes/><Documents/><Properties/><UsingPrototype/><PropertySets/><TriggeredEvents/></SyncStep><TransformationStep><SuccessorDependencies/><PredecessorDependencies/><Transformations><Job TemplateExpand=\"No\"/></Transformations><SourceCode/><Extensions/><Notes/><Documents/><Properties/><UsingPrototype/><PropertySets/><TriggeredEvents/></TransformationStep><Select><ClassifierTargets><WorkTable TemplateExpand=\"Yes\"/><QueryTable TemplateExpand=\"Yes\"/><DataTable TemplateExpand=\"No\"/></ClassifierTargets><ClassifierSources><WorkTable TemplateExpand=\"Yes\"/><QueryTable TemplateExpand=\"Yes\"/><DataTable TemplateExpand=\"No\"/></ClassifierSources><FeatureMaps/><AssociatedRowSelector/><HavingForSelect/><GroupByForSelect/><WhereForSelect/><OrderByForSelect/><SourceCode/><Extensions/><Notes/><Documents/><Properties/><PropertySets/><SubstitutionVariables/><TransformationSources/><TransformationTargets/><ComputeLocations/></Select><ClassifierMap><UsingPrototype/><FeatureMaps/><ClassifierTargets><WorkTable TemplateExpand=\"Yes\"/><QueryTable TemplateExpand=\"Yes\"/><DataTable TemplateExpand=\"No\"/></ClassifierTargets><ClassifierSources><WorkTable TemplateExpand=\"Yes\"/><DataTable TemplateExpand=\"No\"/></ClassifierSources><AssociatedRowSelector/><SourceCode/><Extensions/><Notes/><Documents/><Properties/><PropertySets/><SubstitutionVariables/><TriggeredEvents/><TransformationSources/><TransformationTargets/><ComputeLocations/></ClassifierMap><RowSelector><SourceCode/></RowSelector><OrderByClause><Columns/><PropertySets/><Properties/></OrderByClause><GroupByClause><Columns/><PropertySets/><Properties/></GroupByClause><FeatureMap><SourceCode/><Extensions/><Notes/><Documents/><Properties/><SubstitutionVariables/><TransformationSources/><TransformationTargets/><TriggeredEvents/><SourceTransformations/><TargetTransformations/></FeatureMap><WorkTable><Columns/><PropertySets/><Properties/><Indexes/><Documents/><Notes/><Extensions/><Roles/></WorkTable><QueryTable><Columns/><PropertySets/><Properties/><Roles/></QueryTable><Column><Documents/><Notes/><Extensions/><PropertySets/></Column><Index><Documents/><Notes/><Extensions/><Properties/></Index><Property><SpecTargetTransformations/><ExternalIdentities/><PrimaryPropertyGroup/><StoredConfiguration/><TargetTransformations/><Properties/></Property><Prototype><PrototypeProperties/><Properties/></Prototype><Transformation><SourceCode/><SourceSpecifications><Column TemplateExpand=\"No\"/><SASLibrary TemplateExpand=\"No\"/><MiningResult TemplateExpand=\"No\"/><JFJob TemplateExpand=\"No\"/><WorkTable TemplateExpand=\"Yes\"/><QueryTable TemplateExpand=\"Yes\"/><Classifier TemplateExpand=\"No\"/></SourceSpecifications><SubstitutionVariables/></Transformation><PropertySet><Properties/><SetProperties/></PropertySet><Variable><AssociatedObject><Column TemplateExpand=\"No\"/><DataTable TemplateExpand=\"No\"/></AssociatedObject></Variable><Cube><TargetTransformations/><Aggregations/><AssociatedFile/><Dimensions/><Hierarchies/><Measures/><Properties/><PropertySets/><Documents/><Notes/><Extensions/></Cube><Aggregation><AggregateAssociations/><Levels/><AggregationTables/><Properties/></Aggregation><AggregateAssociation><AggregatedColumns/><MeasureOrLevel/></AggregateAssociation><Dimension><TargetTransformations/><Hierarchies/><Levels/><Measures/><DefaultMeasure/><Properties/><Notes/></Dimension><Hierarchy><Levels/><OLAPProperties/><Notes/><Properties/></Hierarchy><Measure><TargetTransformations/><DefaultForDimension/><MLAggregations/><Notes/></Measure><Level><MLAggregations/><Notes/><Properties/></Level><Document><Documents/><Notes/><Extensions/></Document><Event><PropertySets/><SourceTransformations/></Event><PropertyGroup><Properties/><PropertySets/></PropertyGroup>";
    protected static String sPhysicalTableLockTemplate34 = "<PhysicalTable><Columns/><PropertySets/><UniqueKeys/><Properties/><Indexes/><Documents/><Notes/><Extensions/><Roles/></PhysicalTable><PropertyGroup><Properties/><PropertySets/></PropertyGroup><Column><Documents/><Notes/><Extensions/><UniqueKeyAssociations/><Keys/><PropertySets/></Column><Index><Documents/><Notes/><Extensions/><Properties/></Index><Property><ExternalIdentities/><PrimaryPropertyGroup/><StoredConfiguration/><Properties/></Property><PropertySet><Properties/><SetProperties/></PropertySet><UniqueKey><ForeignKeys/></UniqueKey><ForeignKey><KeyAssociations/></ForeignKey><Document><Documents/><Notes/><Extensions/></Document>";
    protected static String sReportLockTemplate34 = "<Report><ReportLocation/><FileRefs/><Documents/><Notes/><Extensions/><Properties/><PropertySets/></Report>";
    protected static String sSASLibraryLockTemplate34 = "<SASLibrary><UsingPackages/><Properties/><Documents/><Notes/><Extensions/><PropertySets/></SASLibrary><PropertySet><Properties/></PropertySet><DatabaseSchema><Documents/><Notes/><Extensions/></DatabaseSchema><Document><Documents/><Notes/><Extensions/></Document>";
    protected static String sServerComponentLockTemplate34 = "<ServerComponent><Properties/><ServiceTypes/><SourceConnections/><InitProcesses/><DescriptiveComponent/></ServerComponent><Connection><Properties/></Connection>";
    protected static String sServerContextLockTemplate34 = "<ServerContext><UsingComponents/></ServerContext><LogicalServer><UsingComponents/><InitProcesses/></LogicalServer><ServerComponent><Properties/><ServiceTypes/><SourceConnections/><InitProcesses/><DescriptiveComponent/></ServerComponent><Connection><Properties/></Connection>";
    protected static String sTextStoreLockTemplate34 = "<TextStore><Documents/><Notes/><Extensions/><PropertySets/></TextStore><PropertySet><Properties/></PropertySet><Document><Documents/><Notes/><Extensions/></Document>";
    protected static String sTreeLockTemplate34 = "<Tree><Documents/><Notes/><Extensions/><PropertySets/></Tree><PropertySet><Properties/><SetProperties/></PropertySet><Document><Documents/><Notes/><Extensions/></Document>";
    protected static String sPrototypeLockTemplate34 = "<Prototype> <PrototypeProperties/> <Properties/> <PropertySets/> <Documents/><Notes/><Extensions/></Prototype><Property> <ExternalIdentities/><PrimaryPropertyGroup/> <Properties/><SpecTargetTransformations/> <StoredConfiguration/> </Property><PropertyGroup> <Properties/> <PropertySets/> <SubpropertyGroups/> </PropertyGroup><Transformation> <SourceSpecifications/> </Transformation><PropertySet> <Properties/> <SetProperties/> </PropertySet><Document><Documents/><Notes/><Extensions/></Document>";

    public static Map checkOutMetadata(List metaObjects, CMetadata projectRepository) throws MdException, RemoteException {
        int iServerVersion = Workspace.getMetadataServerVersionNumber();
        if (iServerVersion >= 9134) {
            return ProjectUtil.checkOutUsingClientTemplates(metaObjects, projectRepository);
        }
        if (iServerVersion > 0) {
            return ProjectUtil.checkOutUsingServerTemplates(metaObjects, projectRepository);
        }
        return ProjectUtil.checkOutImpl(metaObjects, projectRepository);
    }

    public static void checkOut(List metaObjects, CMetadata projectRepository) throws MdException, RemoteException {
        ProjectUtil.checkOutMetadata(metaObjects, projectRepository);
    }

    private static Map checkOutImpl(List metaObjects, CMetadata projectRepository) throws MdException, RemoteException {
        String sProjectFQID;
        String sOriginalFQID;
        String sChangeState;
        Root mdo;
        int iObject;
        String strMoreXML;
        CMetadata object;
        int objIndex;
        String midXML;
        Document ioutDoc;
        int flags = 1032;
        String inXML = "<CheckoutMetadata><METADATA>";
        String endXML = "</METADATA><ProjectReposid>" + projectRepository.getFQID() + "</ProjectReposid><ns>SAS</ns><flags>" + flags + "</flags><options></options></CheckoutMetadata>";
        Vector<CMetadata> extTableObjects = new Vector<CMetadata>();
        MdObjectStore etStore = Workspace.getMdFactory().createObjectStore();
        Vector newETSimpleObjects = new Vector();
        Vector<CMetadata> jobObjects = new Vector<CMetadata>();
        MdObjectStore jobStore = Workspace.getMdFactory().createObjectStore();
        Vector newJobSimpleObjects = new Vector();
        for (int objIndex2 = 0; objIndex2 < metaObjects.size(); ++objIndex2) {
            CMetadata object2 = (CMetadata)metaObjects.get(objIndex2);
            if (object2 instanceof ExternalTable) {
                extTableObjects.add(object2);
                metaObjects.remove(object2);
                --objIndex2;
            }
            if (!(object2 instanceof Job)) continue;
            jobObjects.add(object2);
            metaObjects.remove(object2);
            --objIndex2;
        }
        for (int i = 0; i < metaObjects.size(); ++i) {
            CMetadata object3 = (CMetadata)metaObjects.get(i);
            String strMoreXML2 = "<" + object3.getCMetadataType() + " Id=\"" + object3.getFQID() + "\" />";
            inXML = inXML + strMoreXML2;
        }
        inXML = inXML + endXML;
        Workspace.getDefaultLogger().debug("Starting checkout");
        try {
            ioutDoc = Workspace.getMdFactory().getOMIUtil().DoRequest(inXML, false);
        }
        catch (Exception e) {
            throw new MdException(e.toString());
        }
        MdObjectStore store = Workspace.getMdFactory().createObjectStore();
        Vector newSimpleObjects = ProjectUtil.createAllObjects(store, ioutDoc);
        if (extTableObjects.size() > 0) {
            inXML = "<CheckoutMetadata><METADATA>";
            midXML = "</METADATA><ProjectReposid>" + projectRepository.getFQID() + "</ProjectReposid><ns>SAS</ns><flags>" + (flags |= 0x10000) + "</flags><options>";
            endXML = "</options></CheckoutMetadata>";
            for (objIndex = 0; objIndex < extTableObjects.size(); ++objIndex) {
                object = (CMetadata)extTableObjects.get(objIndex);
                strMoreXML = "<" + object.getCMetadataType() + " Id=\"" + object.getFQID() + "\" />";
                inXML = inXML + strMoreXML;
            }
            inXML = inXML + midXML + strETLockTemplateXML + endXML;
            try {
                ioutDoc = Workspace.getMdFactory().getOMIUtil().DoRequest(inXML, false);
            }
            catch (Exception e) {
                throw new MdException(e.toString());
            }
            newETSimpleObjects = ProjectUtil.createAllObjects(etStore, ioutDoc);
        }
        if (jobObjects.size() > 0) {
            inXML = "<CheckoutMetadata><METADATA>";
            midXML = "</METADATA><ProjectReposid>" + projectRepository.getFQID() + "</ProjectReposid><ns>SAS</ns><flags>" + (flags |= 0x10000) + "</flags><options>";
            endXML = "</options></CheckoutMetadata>";
            for (objIndex = 0; objIndex < jobObjects.size(); ++objIndex) {
                object = (CMetadata)jobObjects.get(objIndex);
                strMoreXML = "<" + object.getCMetadataType() + " Id=\"" + object.getFQID() + "\" />";
                inXML = inXML + strMoreXML;
            }
            inXML = inXML + midXML + strJobLockTemplateXML + endXML;
            try {
                ioutDoc = Workspace.getMdFactory().getOMIUtil().DoRequest(inXML, false);
            }
            catch (Exception e) {
                throw new MdException(e.toString());
            }
            newJobSimpleObjects = ProjectUtil.createAllObjects(jobStore, ioutDoc);
        }
        HashMap<String, String> map = new HashMap<String, String>(newSimpleObjects.size() * 2 + newETSimpleObjects.size() * 2 + newJobSimpleObjects.size() * 2);
        for (iObject = 0; iObject < newSimpleObjects.size(); ++iObject) {
            mdo = (Root)newSimpleObjects.get(iObject);
            sChangeState = mdo.getChangeState();
            sOriginalFQID = sChangeState.substring(sChangeState.indexOf(58) + 2);
            sProjectFQID = mdo.getFQID();
            map.put(sOriginalFQID, sProjectFQID);
            map.put(sProjectFQID, sOriginalFQID);
        }
        for (iObject = 0; iObject < newETSimpleObjects.size(); ++iObject) {
            mdo = (Root)newETSimpleObjects.get(iObject);
            sChangeState = mdo.getChangeState();
            sOriginalFQID = sChangeState.substring(sChangeState.indexOf(58) + 2);
            sProjectFQID = mdo.getFQID();
            map.put(sOriginalFQID, sProjectFQID);
            map.put(sProjectFQID, sOriginalFQID);
        }
        for (iObject = 0; iObject < newJobSimpleObjects.size(); ++iObject) {
            mdo = (Root)newJobSimpleObjects.get(iObject);
            sChangeState = mdo.getChangeState();
            sOriginalFQID = sChangeState.substring(sChangeState.indexOf(58) + 2);
            sProjectFQID = mdo.getFQID();
            map.put(sOriginalFQID, sProjectFQID);
            map.put(sProjectFQID, sOriginalFQID);
        }
        if (metaObjects.size() > 0) {
            ProjectUtil.fireMetadataCheckOut(new ChangeEvent(projectRepository), newSimpleObjects);
        }
        store.dispose();
        if (extTableObjects.size() > 0) {
            ProjectUtil.fireMetadataCheckOut(new ChangeEvent(projectRepository), newETSimpleObjects);
        }
        etStore.dispose();
        if (jobObjects.size() > 0) {
            ProjectUtil.fireMetadataCheckOut(new ChangeEvent(projectRepository), newJobSimpleObjects);
        }
        jobStore.dispose();
        Workspace.getDefaultLogger().debug("Ending checkout");
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map checkOutUsingServerTemplates(List metaObjects, CMetadata projectRepository) throws MdException, RemoteException {
        Document ioutDoc;
        int flags = 1032;
        String inXML = "<CheckoutMetadata><METADATA>";
        String endXML = "</METADATA><ProjectReposid>" + projectRepository.getFQID() + "</ProjectReposid><ns>SAS</ns><flags>" + flags + "</flags><options></options></CheckoutMetadata>";
        for (int i = 0; i < metaObjects.size(); ++i) {
            CMetadata object = (CMetadata)metaObjects.get(i);
            String strMoreXML = "<" + object.getCMetadataType() + " Id=\"" + object.getFQID() + "\" />";
            inXML = inXML + strMoreXML;
        }
        inXML = inXML + endXML;
        Workspace.getDefaultLogger().debug("Starting checkout");
        try {
            ioutDoc = Workspace.getMdFactory().getOMIUtil().DoRequest(inXML, false);
        }
        catch (Exception e) {
            throw new MdException(e.toString());
        }
        MdObjectStore store = Workspace.getMdFactory().createObjectStore();
        try {
            Vector newObjects = ProjectUtil.createAllObjects(store, ioutDoc);
            ProjectUtil.fireMetadataCheckOut(new ChangeEvent(projectRepository), newObjects);
            HashMap<String, String> map = new HashMap<String, String>(newObjects.size() * 2);
            for (int iObject = 0; iObject < newObjects.size(); ++iObject) {
                Root mdo = (Root)newObjects.get(iObject);
                String sChangeState = mdo.getChangeState();
                String sOriginalFQID = sChangeState.substring(sChangeState.indexOf(58) + 2);
                String sProjectFQID = mdo.getFQID();
                map.put(sOriginalFQID, sProjectFQID);
                map.put(sProjectFQID, sOriginalFQID);
            }
            Workspace.getDefaultLogger().debug("Ending checkout");
            HashMap<String, String> hashMap = map;
            return hashMap;
        }
        finally {
            store.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map checkOutUsingClientTemplates(List metaObjects, CMetadata projectRepository) throws MdException, RemoteException {
        Document ioutDoc;
        StringBuffer checkoutXML = new StringBuffer();
        int flags = 66568;
        checkoutXML.append("<CheckoutMetadata><METADATA>");
        for (int i = 0; i < metaObjects.size(); ++i) {
            CMetadata object = (CMetadata)metaObjects.get(i);
            checkoutXML.append("<").append(object.getCMetadataType()).append(" Id=\"").append(object.getFQID()).append("\" />");
        }
        checkoutXML.append("</METADATA><ProjectReposid>").append(projectRepository.getFQID()).append("</ProjectReposid>").append("<ns>SAS</ns><flags>").append(flags).append("</flags><options>");
        String typeXML = ProjectUtil.getLockTemplateXML(metaObjects);
        if (typeXML.length() > 0) {
            checkoutXML.append(typeXML);
        }
        checkoutXML.append("</options></CheckoutMetadata>");
        Workspace.getDefaultLogger().debug("Starting checkout");
        try {
            ioutDoc = Workspace.getMdFactory().getOMIUtil().DoRequest(checkoutXML.toString(), false);
        }
        catch (Exception e) {
            throw new MdException(e.toString());
        }
        MdObjectStore store = Workspace.getMdFactory().createObjectStore();
        try {
            Vector newObjects = ProjectUtil.createAllObjects(store, ioutDoc);
            ProjectUtil.fireMetadataCheckOut(new ChangeEvent(projectRepository), newObjects);
            HashMap<String, String> map = new HashMap<String, String>(newObjects.size() * 2);
            for (int iObject = 0; iObject < newObjects.size(); ++iObject) {
                Root mdo = (Root)newObjects.get(iObject);
                String sChangeState = mdo.getChangeState();
                String sOriginalFQID = sChangeState.substring(sChangeState.indexOf(58) + 2);
                String sProjectFQID = mdo.getFQID();
                map.put(sOriginalFQID, sProjectFQID);
                map.put(sProjectFQID, sOriginalFQID);
            }
            Workspace.getDefaultLogger().debug("Ending checkout");
            HashMap<String, String> hashMap = map;
            return hashMap;
        }
        finally {
            store.dispose();
        }
    }

    public static void undocheckoutMetadata(List metaObjects, CMetadata projectRepository) throws MdException, RemoteException {
        int iServerVersion = Workspace.getMetadataServerVersionNumber();
        if (iServerVersion >= 9134) {
            ProjectUtil.undoCheckoutUsingClientTemplates(metaObjects, projectRepository);
        } else if (iServerVersion > 0) {
            ProjectUtil.undoCheckoutUsingServerTemplates(metaObjects, projectRepository);
        } else {
            ProjectUtil.undoCheckoutImpl(metaObjects, projectRepository);
        }
    }

    public static void undoCheckout(List metaObjects, CMetadata projectRepository) throws MdException, RemoteException {
        ProjectUtil.undocheckoutMetadata(metaObjects, projectRepository);
    }

    public static void undoCheckoutImpl(List metaObjects, CMetadata projectRepository) throws MdException, RemoteException {
        String strMoreXML;
        CMetadata object;
        int objIndex;
        String midXML;
        Document ioutDoc;
        int flags = 1032;
        String inXML = "<UndoCheckoutMetadata><METADATA>";
        String endXML = "</METADATA><ns>SAS</ns><flags>" + flags + "</flags><options></options></UndoCheckoutMetadata>";
        Vector<CMetadata> extTableObjects = new Vector<CMetadata>();
        MdObjectStore etStore = Workspace.getMdFactory().createObjectStore();
        Vector newETSimpleObjects = new Vector();
        Vector<CMetadata> jobObjects = new Vector<CMetadata>();
        MdObjectStore jobStore = Workspace.getMdFactory().createObjectStore();
        Vector newJobSimpleObjects = new Vector();
        for (int objIndex2 = 0; objIndex2 < metaObjects.size(); ++objIndex2) {
            CMetadata object2 = (CMetadata)metaObjects.get(objIndex2);
            if (object2 instanceof ExternalTable) {
                extTableObjects.add(object2);
                metaObjects.remove(object2);
                --objIndex2;
            }
            if (!(object2 instanceof Job)) continue;
            jobObjects.add(object2);
            metaObjects.remove(object2);
            --objIndex2;
        }
        for (int i = 0; i < metaObjects.size(); ++i) {
            CMetadata object3 = (CMetadata)metaObjects.get(i);
            String strMoreXML2 = "<" + object3.getCMetadataType() + " Id=\"" + object3.getFQID() + "\" />";
            inXML = inXML + strMoreXML2;
        }
        inXML = inXML + endXML;
        Workspace.getDefaultLogger().debug("Starting undocheckout");
        try {
            ioutDoc = Workspace.getMdFactory().getOMIUtil().DoRequest(inXML, false);
        }
        catch (Exception e) {
            throw new MdException(e.toString());
        }
        MdObjectStore store = Workspace.getMdFactory().createObjectStore();
        Vector newSimpleObjects = ProjectUtil.createAllObjects(store, ioutDoc);
        if (extTableObjects.size() > 0) {
            inXML = "<UndoCheckoutMetadata><METADATA>";
            midXML = "</METADATA><ProjectReposid>" + projectRepository.getFQID() + "</ProjectReposid><ns>SAS</ns><flags>" + (flags |= 0x10000) + "</flags><options>";
            endXML = "</options></UndoCheckoutMetadata>";
            for (objIndex = 0; objIndex < extTableObjects.size(); ++objIndex) {
                object = (CMetadata)extTableObjects.get(objIndex);
                strMoreXML = "<" + object.getCMetadataType() + " Id=\"" + object.getFQID() + "\" />";
                inXML = inXML + strMoreXML;
            }
            inXML = inXML + midXML + strETLockTemplateXML + endXML;
            try {
                ioutDoc = Workspace.getMdFactory().getOMIUtil().DoRequest(inXML, false);
            }
            catch (Exception e) {
                throw new MdException(e.toString());
            }
            newETSimpleObjects = ProjectUtil.createAllObjects(etStore, ioutDoc);
        }
        if (jobObjects.size() > 0) {
            inXML = "<UndoCheckoutMetadata><METADATA>";
            midXML = "</METADATA><ProjectReposid>" + projectRepository.getFQID() + "</ProjectReposid><ns>SAS</ns><flags>" + (flags |= 0x10000) + "</flags><options>";
            endXML = "</options></UndoCheckoutMetadata>";
            for (objIndex = 0; objIndex < jobObjects.size(); ++objIndex) {
                object = (CMetadata)jobObjects.get(objIndex);
                strMoreXML = "<" + object.getCMetadataType() + " Id=\"" + object.getFQID() + "\" />";
                inXML = inXML + strMoreXML;
            }
            inXML = inXML + midXML + strJobLockTemplateXML + endXML;
            try {
                ioutDoc = Workspace.getMdFactory().getOMIUtil().DoRequest(inXML, false);
            }
            catch (Exception e) {
                throw new MdException(e.toString());
            }
            newJobSimpleObjects = ProjectUtil.createAllObjects(jobStore, ioutDoc);
        }
        if (metaObjects.size() > 0) {
            ProjectUtil.fireMetadataUndoCheckout(new ChangeEvent(projectRepository), newSimpleObjects);
        }
        if (extTableObjects.size() > 0) {
            ProjectUtil.fireMetadataUndoCheckout(new ChangeEvent(projectRepository), newETSimpleObjects);
        }
        etStore.dispose();
        if (jobObjects.size() > 0) {
            ProjectUtil.fireMetadataUndoCheckout(new ChangeEvent(projectRepository), newJobSimpleObjects);
        }
        jobStore.dispose();
        Workspace.getDefaultLogger().debug("Ending undocheckout");
        store.dispose();
    }

    public static void undoCheckoutUsingServerTemplates(List metaObjects, CMetadata projectRepository) throws MdException, RemoteException {
        Document ioutDoc;
        int flags = 1032;
        String inXML = "<UndoCheckoutMetadata><METADATA>";
        String endXML = "</METADATA><ns>SAS</ns><flags>" + flags + "</flags><options></options></UndoCheckoutMetadata>";
        for (int i = 0; i < metaObjects.size(); ++i) {
            CMetadata object = (CMetadata)metaObjects.get(i);
            String strMoreXML = "<" + object.getCMetadataType() + " Id=\"" + object.getFQID() + "\" />";
            inXML = inXML + strMoreXML;
        }
        inXML = inXML + endXML;
        Workspace.getDefaultLogger().debug("Starting undocheckout");
        try {
            ioutDoc = Workspace.getMdFactory().getOMIUtil().DoRequest(inXML, false);
        }
        catch (Exception e) {
            throw new MdException(e.toString());
        }
        MdObjectStore store = Workspace.getMdFactory().createObjectStore();
        Vector newSimpleObjects = ProjectUtil.createAllObjects(store, ioutDoc);
        ProjectUtil.fireMetadataUndoCheckout(new ChangeEvent(projectRepository), newSimpleObjects);
        Workspace.getDefaultLogger().debug("Ending undocheckout");
        store.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void undoCheckoutUsingClientTemplates(List metaObjects, CMetadata projectRepository) throws MdException, RemoteException {
        Document ioutDoc;
        StringBuffer checkoutXML = new StringBuffer();
        int flags = 66568;
        checkoutXML.append("<UndoCheckoutMetadata><METADATA>");
        for (int i = 0; i < metaObjects.size(); ++i) {
            CMetadata object = (CMetadata)metaObjects.get(i);
            checkoutXML.append("<").append(object.getCMetadataType()).append(" Id=\"").append(object.getFQID()).append("\" />");
        }
        checkoutXML.append("</METADATA><ns>SAS</ns><flags>").append(flags).append("</flags><options>");
        String typeXML = ProjectUtil.getLockTemplateXML(metaObjects);
        if (typeXML.length() > 0) {
            checkoutXML.append(typeXML);
        }
        checkoutXML.append("</options></UndoCheckoutMetadata>");
        Workspace.getDefaultLogger().debug("Starting undocheckout");
        try {
            ioutDoc = Workspace.getMdFactory().getOMIUtil().DoRequest(checkoutXML.toString(), false);
        }
        catch (Exception e) {
            throw new MdException(e.toString());
        }
        MdObjectStore store = Workspace.getMdFactory().createObjectStore();
        try {
            Vector newObjects = ProjectUtil.createAllObjects(store, ioutDoc);
            ProjectUtil.fireMetadataUndoCheckout(new ChangeEvent(projectRepository), newObjects);
            Workspace.getDefaultLogger().debug("Ending undocheckout");
        }
        finally {
            store.dispose();
        }
    }

    public static void fetchMetadata(List metaObjects, CMetadata projectRepository) throws MdException, RemoteException {
        int iServerVersion = Workspace.getMetadataServerVersionNumber();
        if (iServerVersion >= 9134) {
            ProjectUtil.fetchUsingClientTemplates(metaObjects, projectRepository);
        } else if (iServerVersion > 0) {
            ProjectUtil.fetchUsingServerTemplates(metaObjects, projectRepository);
        } else {
            ProjectUtil.fetchImpl(new Vector(metaObjects), projectRepository);
        }
    }

    public static void fetch(Vector metaObjects, CMetadata projectRepository) throws MdException, RemoteException {
        ProjectUtil.fetchMetadata(metaObjects, projectRepository);
    }

    public static void fetchUsingServerTemplates(List metaObjects, CMetadata projectRepository) throws MdException, RemoteException {
        Document ioutDoc;
        String inXML = "<FetchMetadata><METADATA>";
        String endXML = "</METADATA><ProjectReposid>" + projectRepository.getFQID() + "</ProjectReposid><ns>SAS</ns><flags>" + 1024 + "</flags><options></options></FetchMetadata>";
        for (int i = 0; i < metaObjects.size(); ++i) {
            CMetadata object = (CMetadata)metaObjects.get(i);
            String strMoreXML = "<" + object.getCMetadataType() + " Id=\"" + object.getFQID() + "\" />";
            inXML = inXML + strMoreXML;
        }
        inXML = inXML + endXML;
        Workspace.getDefaultLogger().debug("Starting fetch");
        try {
            ioutDoc = Workspace.getMdFactory().getOMIUtil().DoRequest(inXML, false);
        }
        catch (Exception e) {
            throw new MdException(e.toString());
        }
        MdObjectStore store = Workspace.getMdFactory().createObjectStore();
        Vector newSimpleObjects = ProjectUtil.createAllObjects(store, ioutDoc);
        ProjectUtil.fireMetadataFetched(new ChangeEvent(projectRepository), newSimpleObjects);
        store.dispose();
        Workspace.getDefaultLogger().debug("Ending fetch");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fetchUsingClientTemplates(List metaObjects, CMetadata projectRepository) throws MdException, RemoteException {
        Document ioutDoc;
        StringBuffer checkoutXML = new StringBuffer();
        int flags = 66568;
        checkoutXML.append("<FetchMetadata><METADATA>");
        for (int i = 0; i < metaObjects.size(); ++i) {
            CMetadata object = (CMetadata)metaObjects.get(i);
            checkoutXML.append("<").append(object.getCMetadataType()).append(" Id=\"").append(object.getFQID()).append("\" />");
        }
        checkoutXML.append("</METADATA><ProjectReposid>").append(projectRepository.getFQID()).append("</ProjectReposid>").append("<ns>SAS</ns><flags>").append(flags).append("</flags><options>");
        String typeXML = ProjectUtil.getLockTemplateXML(metaObjects);
        if (typeXML.length() > 0) {
            checkoutXML.append(typeXML);
        }
        checkoutXML.append("</options></FetchMetadata>");
        Workspace.getDefaultLogger().debug("Starting fetch");
        try {
            ioutDoc = Workspace.getMdFactory().getOMIUtil().DoRequest(checkoutXML.toString(), false);
        }
        catch (Exception e) {
            throw new MdException(e.toString());
        }
        MdObjectStore store = Workspace.getMdFactory().createObjectStore();
        try {
            Vector newObjects = ProjectUtil.createAllObjects(store, ioutDoc);
            ProjectUtil.fireMetadataFetched(new ChangeEvent(projectRepository), newObjects);
            Workspace.getDefaultLogger().debug("Ending fetch");
        }
        finally {
            store.dispose();
        }
    }

    private static void fetchImpl(Vector metaObjects, CMetadata projectRepository) throws MdException, RemoteException {
        String strMoreXML;
        CMetadata object;
        String midXML;
        int flags;
        Document ioutDoc;
        String inXML = "<FetchMetadata><METADATA>";
        String endXML = "</METADATA><ProjectReposid>" + projectRepository.getFQID() + "</ProjectReposid><ns>SAS</ns><flags>" + 1024 + "</flags><options></options></FetchMetadata>";
        Vector<CMetadata> extTableObjects = new Vector<CMetadata>();
        MdObjectStore etStore = Workspace.getMdFactory().createObjectStore();
        Vector newETSimpleObjects = new Vector();
        Vector<CMetadata> jobObjects = new Vector<CMetadata>();
        MdObjectStore jobStore = Workspace.getMdFactory().createObjectStore();
        Vector newJobSimpleObjects = new Vector();
        for (int objIndex = 0; objIndex < metaObjects.size(); ++objIndex) {
            CMetadata object2 = (CMetadata)metaObjects.get(objIndex);
            if (object2 instanceof ExternalTable) {
                extTableObjects.add(object2);
                metaObjects.remove(object2);
                --objIndex;
            }
            if (!(object2 instanceof Job)) continue;
            jobObjects.add(object2);
            metaObjects.remove(object2);
            --objIndex;
        }
        for (int i = 0; i < metaObjects.size(); ++i) {
            CMetadata object3 = (CMetadata)metaObjects.get(i);
            String strMoreXML2 = "<" + object3.getCMetadataType() + " Id=\"" + object3.getFQID() + "\" />";
            inXML = inXML + strMoreXML2;
        }
        inXML = inXML + endXML;
        Workspace.getDefaultLogger().debug("Starting fetch");
        try {
            ioutDoc = Workspace.getMdFactory().getOMIUtil().DoRequest(inXML, false);
        }
        catch (Exception e) {
            throw new MdException(e.toString());
        }
        if (extTableObjects.size() > 0) {
            flags = 66560;
            inXML = "<FetchMetadata><METADATA>";
            midXML = "</METADATA><ProjectReposid>" + projectRepository.getFQID() + "</ProjectReposid><ns>SAS</ns><flags>" + flags + "</flags><options>";
            endXML = "</options></FetchMetadata>";
            for (int objIndex = 0; objIndex < extTableObjects.size(); ++objIndex) {
                object = (CMetadata)extTableObjects.get(objIndex);
                strMoreXML = "<" + object.getCMetadataType() + " Id=\"" + object.getFQID() + "\" />";
                inXML = inXML + strMoreXML;
            }
            inXML = inXML + midXML + strETLockTemplateXML + endXML;
            try {
                ioutDoc = Workspace.getMdFactory().getOMIUtil().DoRequest(inXML, false);
            }
            catch (Exception e) {
                throw new MdException(e.toString());
            }
            newETSimpleObjects = ProjectUtil.createAllObjects(etStore, ioutDoc);
        }
        if (jobObjects.size() > 0) {
            flags = 66560;
            inXML = "<FetchMetadata><METADATA>";
            midXML = "</METADATA><ProjectReposid>" + projectRepository.getFQID() + "</ProjectReposid><ns>SAS</ns><flags>" + flags + "</flags><options>";
            endXML = "</options></FetchMetadata>";
            for (int objIndex = 0; objIndex < jobObjects.size(); ++objIndex) {
                object = (CMetadata)jobObjects.get(objIndex);
                strMoreXML = "<" + object.getCMetadataType() + " Id=\"" + object.getFQID() + "\" />";
                inXML = inXML + strMoreXML;
            }
            inXML = inXML + midXML + strJobLockTemplateXML + endXML;
            try {
                ioutDoc = Workspace.getMdFactory().getOMIUtil().DoRequest(inXML, false);
            }
            catch (Exception e) {
                throw new MdException(e.toString());
            }
            newJobSimpleObjects = ProjectUtil.createAllObjects(jobStore, ioutDoc);
        }
        MdObjectStore store = Workspace.getMdFactory().createObjectStore();
        Vector newSimpleObjects = ProjectUtil.createAllObjects(store, ioutDoc);
        if (metaObjects.size() > 0) {
            ProjectUtil.fireMetadataFetched(new ChangeEvent(projectRepository), newSimpleObjects);
        }
        store.dispose();
        if (extTableObjects.size() > 0) {
            ProjectUtil.fireMetadataFetched(new ChangeEvent(projectRepository), newETSimpleObjects);
        }
        etStore.dispose();
        if (jobObjects.size() > 0) {
            ProjectUtil.fireMetadataFetched(new ChangeEvent(projectRepository), newJobSimpleObjects);
        }
        jobStore.dispose();
        Workspace.getDefaultLogger().debug("Ending fetch");
    }

    public static void addObjects(MdObjectStore store, CMetadata projectRepository) throws MdException, RemoteException {
    }

    public static void newObjectsAdded(CMetadata projectRepository, ArrayList objects) throws MdException, RemoteException {
        ProjectUtil.fireNewObjectsAdded(new ChangeEvent(projectRepository), objects);
    }

    public static boolean isGroupableObject(CMetadata object) {
        try {
            String sType = object.getCMetadataType();
            return sType.equals("Cube") || sType.equals("ExternalTable") || sType.equals("PhysicalTable") || sType.equals("Report") || sType.equals("TextStore") || sType.equals("Document") || sType.equals("DeployedComponent") || sType.equals("SASLibrary") || sType.equals("Tree") || sType.equals("Job");
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
            return false;
        }
    }

    public static boolean isCheckoutableObject(CMetadata object) {
        try {
            return ProjectUtil.isCheckoutableObject(object.getCMetadataType());
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
            return false;
        }
    }

    public static boolean isCheckoutableObject(String sType) {
        return sType.equals("ExternalTable") || sType.equals("PhysicalTable") || sType.equals("Report") || sType.equals("TextStore") || sType.equals("Document") || sType.equals("Prototype") || sType.equals("Job") || sType.equals("SASLibrary") || sType.equals("DeployedComponent") || sType.equals("Tree");
    }

    protected static Vector createAllObjects(MdObjectStore store, Document outDoc) throws MdException, RemoteException {
        Node newNode = outDoc.getFirstChild().getFirstChild();
        Vector<Root> objects = new Vector<Root>();
        NodeList newNodeList = newNode.getChildNodes();
        int newNodeListLength = newNodeList.getLength();
        if (newNodeListLength == 0) {
            return objects;
        }
        NodeList tempNodeList = newNodeList;
        if (tempNodeList.item(0).getNodeName().equals("UpdatedObjects")) {
            newNodeList = tempNodeList.item(0).getChildNodes();
        } else if (tempNodeList.item(0).getNodeName().equals("DeletedObjects")) {
            return objects;
        }
        int length = newNodeList.getLength();
        for (int i = 0; i < length; ++i) {
            String strType = newNodeList.item(i).getNodeName();
            NamedNodeMap newNodeMap = newNodeList.item(i).getAttributes();
            String strNewId = newNodeMap.getNamedItem("Id").getNodeValue();
            String strName = null;
            try {
                strName = newNodeMap.getNamedItem("Name").getNodeValue();
            }
            catch (Exception e) {
                Workspace.getDefaultLogger().error((Object)"", e);
                strName = "";
            }
            String strChangeState = null;
            try {
                strChangeState = newNodeMap.getNamedItem("ChangeState").getNodeValue();
            }
            catch (Exception e) {
                Workspace.getDefaultLogger().error("Missing changestate ");
            }
            Root object = (Root)Workspace.getMdFactory().createComplexMetadataObject(store, strName, strType, strNewId);
            if (strChangeState != null) {
                object.setChangeState(strChangeState);
            }
            if (strChangeState == null) {
                objects.add(object);
                continue;
            }
            if (strChangeState.indexOf("New") >= 0) continue;
            objects.add(object);
        }
        return objects;
    }

    protected static Vector createAllClearObjects(MdObjectStore store, Document outDoc) throws MdException, RemoteException {
        Node newNode = outDoc.getFirstChild().getFirstChild();
        Vector<Root> objects = new Vector<Root>();
        NodeList newNodeList = newNode.getChildNodes();
        int newNodeListLength = newNodeList.getLength();
        if (newNodeListLength == 0) {
            return objects;
        }
        NodeList tempNodeList = newNodeList;
        if (tempNodeList.item(0).getNodeName().equals("UpdatedObjects")) {
            newNodeList = tempNodeList.item(0).getChildNodes();
        } else if (tempNodeList.item(0).getNodeName().equals("DeletedObjects")) {
            return objects;
        }
        int length = newNodeList.getLength();
        for (int i = 0; i < length; ++i) {
            String strType = newNodeList.item(i).getNodeName();
            NamedNodeMap newNodeMap = newNodeList.item(i).getAttributes();
            String strNewId = newNodeMap.getNamedItem("Id").getNodeValue();
            String strName = null;
            try {
                strName = newNodeMap.getNamedItem("Name").getNodeValue();
            }
            catch (Exception e) {
                Workspace.getDefaultLogger().error((Object)"", e);
                strName = "";
            }
            String strChangeState = null;
            try {
                strChangeState = newNodeMap.getNamedItem("ChangeState").getNodeValue();
            }
            catch (Exception e) {
                Workspace.getDefaultLogger().error("Missing changestate ");
            }
            Root object = (Root)Workspace.getMdFactory().createComplexMetadataObject(store, strName, strType, strNewId);
            if (strChangeState != null) {
                object.setChangeState(strChangeState);
            }
            objects.add(object);
        }
        return objects;
    }

    protected static Vector createDestroyedObjects(Document outDoc) {
        Node newNode = outDoc.getFirstChild().getFirstChild();
        Vector<String> objects = new Vector<String>();
        NodeList newNodeList = newNode.getChildNodes();
        int newNodeListLength = newNodeList.getLength();
        if (newNodeListLength == 0) {
            return objects;
        }
        NodeList tempNodeList = newNodeList;
        for (int j = 0; j < newNodeListLength; ++j) {
            if (!tempNodeList.item(j).getNodeName().equals("DeletedObjects")) continue;
            newNodeList = tempNodeList.item(j).getChildNodes();
            int length = newNodeList.getLength();
            for (int i = 0; i < length; ++i) {
                NamedNodeMap newNodeMap = newNodeList.item(i).getAttributes();
                String strNewId = newNodeMap.getNamedItem("Id").getNodeValue();
                objects.add(strNewId);
            }
        }
        return objects;
    }

    public static Vector checkIn(CMetadata projectRepository, String strChangeName, String strChangeDesc) throws MdException, RemoteException {
        Vector oldDestroyedObjects;
        Document ioutDoc;
        String strCleanChangeName = Workspace.getMdFactory().getOMIUtil().cleanStringForXML(strChangeName);
        String strCleanChangeDesc = Workspace.getMdFactory().getOMIUtil().cleanStringForXML(strChangeDesc);
        String inXML = "<CheckinMetadata><Metadata/><ProjectReposid>" + projectRepository.getFQID() + "</ProjectReposid><ChangeName>" + strCleanChangeName + "</ChangeName>";
        if (!strChangeDesc.trim().equals("")) {
            inXML = inXML + "<ChangeDesc>" + strCleanChangeDesc + "</ChangeDesc>";
        }
        inXML = inXML + "<ns>SAS</ns><flags>" + 1024 + "</flags><options></options></CheckinMetadata>";
        Workspace.getDefaultLogger().debug("Starting checkin");
        try {
            ioutDoc = Workspace.getMdFactory().getOMIUtil().DoRequest(inXML, false);
        }
        catch (Exception e) {
            throw new MdException(e.toString());
        }
        MdObjectStore store = Workspace.getMdFactory().createObjectStore();
        Vector newSimpleObjects = ProjectUtil.createAllObjects(store, ioutDoc);
        if (newSimpleObjects.size() > 0) {
            ProjectUtil.fireMetadataCheckIn(new ChangeEvent(projectRepository), newSimpleObjects);
        }
        if ((oldDestroyedObjects = ProjectUtil.createDestroyedObjects(ioutDoc)).size() > 0) {
            ProjectUtil.fireMetadataDestroyed(new ChangeEvent(projectRepository), oldDestroyedObjects);
        }
        if (newSimpleObjects.size() == 0) {
            store.dispose();
        }
        Workspace.getDefaultLogger().debug("Ending checkin");
        return newSimpleObjects;
    }

    public static void copyObjects(Vector metaObjects, CMetadata repository) throws MdException, RemoteException {
        Document ioutDoc;
        String inXML = "<CopyMetadata><METADATA>";
        String endXML = "</METADATA><ToReposid>" + repository.getFQID() + "</ToReposid><ns>SAS</ns><flags>" + 1024 + "</flags><options></options></CopyMetadata>";
        for (int i = 0; i < metaObjects.size(); ++i) {
            CMetadata object = (CMetadata)metaObjects.get(i);
            String strMoreXML = "<" + object.getCMetadataType() + " Id=\"" + object.getFQID() + "\" />";
            inXML = inXML + strMoreXML;
        }
        inXML = inXML + endXML;
        Workspace.getDefaultLogger().debug("Starting copy");
        try {
            ioutDoc = Workspace.getMdFactory().getOMIUtil().DoRequest(inXML, false);
        }
        catch (Exception e) {
            throw new MdException(e.toString());
        }
        MdObjectStore store = Workspace.getMdFactory().createObjectStore();
        Vector newSimpleObjects = ProjectUtil.createAllObjects(store, ioutDoc);
        ProjectUtil.fireMetadataCopied(new ChangeEvent(repository), newSimpleObjects);
        store.dispose();
        Workspace.getDefaultLogger().debug("Ending copy");
    }

    public static void destroy(Vector metaObjects, CMetadata projectRepository) throws MdException, RemoteException {
        int flags = 0x10000000;
        String inXML = "<DeleteMetadata><METADATA>";
        String endXML = "</METADATA><ns>SAS</ns><flags>" + flags + "</flags><options></options></DeleteMetadata>";
        for (int i = 0; i < metaObjects.size(); ++i) {
            CMetadata object = (CMetadata)metaObjects.get(i);
            String strMoreXML = "<" + object.getCMetadataType() + " Id=\"" + object.getFQID() + "\" />";
            inXML = inXML + strMoreXML;
        }
        inXML = inXML + endXML;
        Workspace.getDefaultLogger().debug("destroy metadata: " + inXML);
        Workspace.getDefaultLogger().debug("Starting destroy");
        try {
            Workspace.getMdFactory().getOMIUtil().DoRequest(inXML, false);
        }
        catch (Exception e) {
            throw new MdException(e.toString());
        }
        ProjectUtil.fireMetadataUndoCheckout(new ChangeEvent(projectRepository), metaObjects);
        Workspace.getDefaultLogger().debug("Ending destroy");
    }

    public static void lockObjects(CMetadata cmGroupTop, Vector nodeObjects, CMetadata projectRepository) throws MdException, RemoteException {
    }

    public static void addProjectEventListener(ProjectEventListener l) {
        listenerList.add(ProjectEventListener.class, l);
    }

    public static void removeProjectEventListener(ProjectEventListener l) {
        listenerList.remove(ProjectEventListener.class, l);
    }

    public static void fireMetadataCheckOut(ChangeEvent e, Vector items) {
        Object[] listeners = listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ProjectEventListener.class) continue;
            ((ProjectEventListener)listeners[i + 1]).objectsCheckedOut(e, items);
        }
    }

    public static void fireNewObjectsAdded(ChangeEvent e, ArrayList objects) {
        Object[] listeners = listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ProjectEventListener.class) continue;
            ((ProjectEventListener)listeners[i + 1]).objectsNewAdded(e, objects);
        }
    }

    public static void fireMetadataFetched(ChangeEvent e, Vector items) {
        Object[] listeners = listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ProjectEventListener.class) continue;
            ((ProjectEventListener)listeners[i + 1]).objectsFetched(e, items);
        }
    }

    public static void fireMetadataCopied(ChangeEvent e, Vector items) {
        Object[] listeners = listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ProjectEventListener.class) continue;
            ((ProjectEventListener)listeners[i + 1]).objectsCopied(e, items);
        }
    }

    public static void fireMetadataLocked(ChangeEvent e, Vector items) {
        Object[] listeners = listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ProjectEventListener.class) continue;
            ((ProjectEventListener)listeners[i + 1]).objectsLocked(e, items);
        }
    }

    public static void fireMetadataUnLocked(ChangeEvent e, Vector items) {
        Object[] listeners = listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ProjectEventListener.class) continue;
            ((ProjectEventListener)listeners[i + 1]).objectsUnLocked(e, items);
        }
    }

    public static void fireMetadataCheckIn(ChangeEvent e, Vector items) {
        Object[] listeners = listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ProjectEventListener.class) continue;
            ((ProjectEventListener)listeners[i + 1]).objectsCheckedIn(e, items);
        }
    }

    public static void fireMetadataDestroyed(ChangeEvent e, Vector items) {
        Object[] listeners = listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ProjectEventListener.class) continue;
            ((ProjectEventListener)listeners[i + 1]).objectsDestroyed(e, items);
        }
    }

    public static void fireMetadataUndoCheckout(ChangeEvent e, Vector items) {
        Object[] listeners = listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ProjectEventListener.class) continue;
            ((ProjectEventListener)listeners[i + 1]).objectsUndoCheckout(e, items);
        }
    }

    public static void fireMetadataClearProject(ChangeEvent e, Vector items) {
        Object[] listeners = listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (!(listeners[i + 1] instanceof ProjectEventListener2)) continue;
            ((ProjectEventListener2)listeners[i + 1]).objectsClearProject(e, items);
        }
    }

    public static void clearProject(String projectRepositoryID) throws MdException, RemoteException {
        Document ioutDoc;
        int flags = 1033;
        StringBuffer clearXML = new StringBuffer().append("<UndoCheckoutMetadata><METADATA>");
        clearXML.append("<PhysicalTable ID=\"").append(projectRepositoryID.substring(9)).append(".A0000000\"");
        clearXML.append("/></METADATA><ns>SAS</ns><flags>").append(flags).append("</flags><options></options></UndoCheckoutMetadata>");
        System.out.println("XML: " + clearXML.toString());
        Workspace.getDefaultLogger().debug("Starting ClearProject");
        try {
            ioutDoc = Workspace.getMdFactory().getOMIUtil().DoRequest(clearXML.toString(), false);
        }
        catch (Exception e) {
            throw new MdException(e.toString());
        }
        MdObjectStore store = Workspace.getMdFactory().createObjectStore();
        Vector newSimpleObjects = ProjectUtil.createAllClearObjects(store, ioutDoc);
        ProjectUtil.fireMetadataClearProject(new ChangeEvent(Workspace.getWorkspace().getDefaultRepository()), newSimpleObjects);
        Workspace.getDefaultLogger().debug("Ending ClearProject");
        store.dispose();
    }

    public static void clearProject(String sFirstRepos, String sSecondRepos) throws MdException, RemoteException {
        Document ioutDoc;
        int flags = 1033;
        StringBuffer clearXML = new StringBuffer().append("<UndoCheckoutMetadata><METADATA>");
        clearXML.append("<PhysicalTable ID=\"").append(sFirstRepos.substring(9)).append(".A0000000\"");
        if (sSecondRepos != null) {
            clearXML.append(" CHANGESTATE=\"").append(sSecondRepos.substring(9)).append("\"");
        }
        clearXML.append("/></METADATA><ns>SAS</ns><flags>").append(flags).append("</flags><options></options></UndoCheckoutMetadata>");
        System.out.println("XML: " + clearXML.toString());
        Workspace.getDefaultLogger().debug("Starting ClearProject");
        try {
            ioutDoc = Workspace.getMdFactory().getOMIUtil().DoRequest(clearXML.toString(), false);
        }
        catch (Exception e) {
            throw new MdException(e.toString());
        }
        MdObjectStore store = Workspace.getMdFactory().createObjectStore();
        Vector newSimpleObjects = ProjectUtil.createAllClearObjects(store, ioutDoc);
        ProjectUtil.fireMetadataClearProject(new ChangeEvent(Workspace.getWorkspace().getDefaultRepository()), newSimpleObjects);
        Workspace.getDefaultLogger().debug("Ending ClearProject");
        store.dispose();
    }

    public static String getLockedByName(Root mdo) throws MdException, RemoteException {
        return ProjectUtil.getLockedByName(mdo.getCMetadataType(), mdo.getFQID());
    }

    public static String getLockedByName(String sType, String sFQID) throws MdException, RemoteException {
        String sLockedByFQID = ProjectUtil.getLockedByFQID(sType, sFQID);
        return sLockedByFQID == null ? null : ProjectUtil.getNameForFQID(sLockedByFQID);
    }

    public static String getLockedByFQID(Root mdo) throws MdException, RemoteException {
        return ProjectUtil.getLockedByFQID(mdo.getCMetadataType(), mdo.getFQID());
    }

    public static String getLockedByFQID(String sType, String sFQID) throws MdException, RemoteException {
        String sLockedByFQID = ProjectUtil.getAttributeValue(sType, sFQID, "LockedBy");
        return sLockedByFQID.length() == 0 ? null : sLockedByFQID;
    }

    private static String getNameForFQID(String sFQID) throws MdException, RemoteException {
        try {
            return ProjectUtil.getAttributeValue("Person", sFQID, "Name");
        }
        catch (MdException ex) {
            return ProjectUtil.getAttributeValue("Identity", sFQID, "Name");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException(re);
            return ProjectUtil.getAttributeValue("Identity", sFQID, "Name");
        }
    }

    private static String getAttributeValue(String sType, String sFQID, String sAttr) throws MdException, RemoteException {
        ArrayList<String> lAttrs = new ArrayList<String>();
        lAttrs.add(sAttr);
        List lValues = Workspace.getMdFactory().getOMIUtil().getMetadataSimple(sType, sFQID, lAttrs);
        return (String)lValues.get(0);
    }

    public static String getParentRepositoryID(Root object) {
        try {
            String sObjectChangeState = object.getChangeState();
            if (sObjectChangeState.length() > 0) {
                return sObjectChangeState.substring(17);
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
        return null;
    }

    public static String getLockTemplateXML(List lObjects) {
        StringBuffer lockXML = new StringBuffer();
        HashSet<String> types = new HashSet<String>();
        try {
            for (int i = 0; i < lObjects.size(); ++i) {
                CMetadata object = (CMetadata)lObjects.get(i);
                types.add(object.getCMetadataType());
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
        if (types.isEmpty()) {
            return "";
        }
        lockXML.append("<LockTemplates>");
        for (String type : types) {
            lockXML.append("<LockTemplate Type=\"").append(type).append("\">");
            if (type.equals("Cube")) {
                lockXML.append(sCubeLockTemplate34);
            } else if (type.equals("Document")) {
                lockXML.append(sDocumentLockTemplate34);
            } else if (type.equals("ExternalTable")) {
                lockXML.append(sExternalTableLockTemplate34);
            } else if (type.equals("Job")) {
                lockXML.append(sJobLockTemplate34);
            } else if (type.equals("PhysicalTable")) {
                lockXML.append(sPhysicalTableLockTemplate34);
            } else if (type.equals("Report")) {
                lockXML.append(sReportLockTemplate34);
            } else if (type.equals("SASLibrary")) {
                lockXML.append(sSASLibraryLockTemplate34);
            } else if (type.equals("ServerComponent")) {
                lockXML.append(sServerComponentLockTemplate34);
            } else if (type.equals("ServerContext")) {
                lockXML.append(sServerContextLockTemplate34);
            } else if (type.equals("TextStore")) {
                lockXML.append(sTextStoreLockTemplate34);
            } else if (type.equals("Tree")) {
                lockXML.append(sTreeLockTemplate34);
            } else if (type.equals("Prototype")) {
                lockXML.append(sPrototypeLockTemplate34);
            }
            lockXML.append("</LockTemplate>");
        }
        lockXML.append("</LockTemplates>");
        return lockXML.toString();
    }
}

