/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.metadata.remote.MdException;
import com.sas.services.ServiceException;
import com.sas.workspace.DesktopUtil;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceUtil;
import com.sas.workspace.WsButtonsLayout;
import com.sas.workspace.WsMessagesPropertyTab;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class MessageUtil {
    private static WAdminResource bundle = WAdminResource.getBundle(MessageUtil.class);
    private static Window g_wndMain;
    public static final int INFORMATIONTYPE = 1;
    public static final int WARNINGTYPE = 2;
    public static final int ERRORTYPE = 0;
    public static final int INFORMATION_MESSAGE = 1;
    public static final int WARNING_MESSAGE = 2;
    public static final int ERROR_MESSAGE = 0;
    public static final int QUESTION_MESSAGE = 3;
    public static final int PLAIN_MESSAGE = -1;
    public static final int DEFAULT_OPTION = -1;
    public static final int YES_NO_OPTION = 0;
    public static final int YES_NO_CANCEL_OPTION = 1;
    public static final int OK_CANCEL_OPTION = 2;
    public static final int OK_TO_ALL_CANCEL_OPTION = 100;
    public static final int YES_TO_ALL_NO_CANCEL_OPTION = 101;
    public static final int YES_TO_ALL_NO_TO_ALL_CANCEL_OPTION = 102;
    public static final int YES_OPTION = 0;
    public static final int NO_OPTION = 1;
    public static final int CANCEL_OPTION = 2;
    public static final int OK_OPTION = 0;
    public static final int CLOSED_OPTION = -1;
    public static final int YES_TO_ALL_OPTION = 100;
    public static final int NO_TO_ALL_OPTION = 101;
    public static final int OK_TO_ALL_OPTION = 102;
    public static final String ACCESSING = "Accessing";
    public static final String CREATING = "Creating";
    public static final String READING = "Reading";
    public static final String WRITING = "Writing";
    public static final String DELETING = "Deleting";
    public static final String CHECKING_OUT = "Checkingout";
    public static final String CHECKING_IN = "Checkingin";
    public static final String FETCHING = "Fetching";
    public static final String UNDO_CHECK_OUT = "UndoCheckOut";
    public static final String CLEAR_PROJECT = "ClearProject";

    private MessageUtil() {
    }

    public static void setMainWindow(Window wndMain) {
        if (!(wndMain instanceof JFrame) && !(wndMain instanceof JDialog)) {
            throw new UnsupportedOperationException("MainWindow must be an instance of JFrame or JDialog");
        }
        g_wndMain = wndMain;
    }

    public static Window getMainWindow() {
        return g_wndMain;
    }

    private static Window getFocusWindow() {
        Window focusWindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
        if (focusWindow == null || !focusWindow.isVisible()) {
            focusWindow = MessageUtil.getMainWindow();
        }
        return focusWindow;
    }

    public static int displayMessage(String sMessage, int eType, int eOptions) {
        return MessageUtil.displayMessage(sMessage, MessageUtil.getDefaultTitle(eType), eType, eOptions);
    }

    public static void displayMessage(String sMessage) {
        MessageUtil.displayMessage(sMessage, 2);
    }

    public static void displayMessage(String sMessage, String sTitle) {
        MessageUtil.displayMessage(sMessage, sTitle, 2);
    }

    public static void displayMessage(String sMessage, String sTitle, int eType) {
        MessageUtil.displayMessage(sMessage, sTitle, eType, -1);
    }

    public static void displayMessage(String sMessage, int eType) {
        MessageUtil.displayMessage(sMessage, MessageUtil.getDefaultTitle(eType), eType);
    }

    public static int displayMessage(String sMessage, String sTitle, int eType, int eOptions) {
        cDisplayMessageRunnable run = new cDisplayMessageRunnable(sMessage, sTitle, eType, eOptions);
        if (SwingUtilities.isEventDispatchThread()) {
            run.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(run);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return run.getReturnCode();
    }

    public static int displayMessage(String sMessage, String sTitle, int eType, JButton[] aButtons) {
        cDisplayMessageRunnable run = new cDisplayMessageRunnable(sMessage, sTitle, eType, aButtons);
        if (SwingUtilities.isEventDispatchThread()) {
            run.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(run);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return run.getReturnCode();
    }

    public static void displayListMessage(String sMessage, List lValues) {
        MessageUtil.displayListMessage(sMessage, lValues, 2);
    }

    public static void displayListMessage(String sMessage, List lValues, int eType) {
        MessageUtil.displayListMessage(sMessage, lValues, MessageUtil.getDefaultTitle(eType), eType);
    }

    public static void displayListMessage(String sMessage, List lValues, String sTitle) {
        MessageUtil.displayListMessage(sMessage, lValues, sTitle, 2);
    }

    public static void displayListMessage(String sMessage, List lValues, String sTitle, int eType) {
        MessageUtil.displayListMessage(sMessage, lValues, sTitle, eType, -1);
    }

    public static int displayListMessage(String sMessage, List lValues, String sTitle, int eType, int eOptions) {
        cDisplayMessageRunnable run = new cDisplayMessageRunnable(sMessage, lValues, sTitle, eType, eOptions);
        if (SwingUtilities.isEventDispatchThread()) {
            run.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(run);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return run.getReturnCode();
    }

    public static int displayListMessage(String sMessage, JList lValues, String sTitle, int eType, int eOptions) {
        cDisplayMessageRunnable run = new cDisplayMessageRunnable(sMessage, lValues, sTitle, eType, eOptions);
        if (SwingUtilities.isEventDispatchThread()) {
            run.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(run);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return run.getReturnCode();
    }

    public static void displayDetailsMessage(String sMessage, String sDetails) {
        MessageUtil.displayDetailsMessage(sMessage, 2, sDetails);
    }

    public static void displayDetailsMessage(String sMessage, int eType, String sDetails) {
        MessageUtil.displayDetailsMessage(sMessage, eType, -1, sDetails);
    }

    public static int displayDetailsMessage(String sMessage, int eType, int eOptions, String sDetails) {
        return MessageUtil.displayDetailsMessage(sMessage, MessageUtil.getDefaultTitle(eType), eType, eOptions, sDetails);
    }

    public static void displayDetailsMessage(String sMessage, String sTitle, String sDetails) {
        MessageUtil.displayDetailsMessage(sMessage, sTitle, 2, sDetails);
    }

    public static void displayDetailsMessage(String sMessage, String sTitle, int eType, String sDetails) {
        MessageUtil.displayDetailsMessage(sMessage, sTitle, eType, -1, sDetails);
    }

    public static int displayDetailsMessage(String sMessage, String sTitle, int eType, int eOptions, String sDetails) {
        WATextArea txtDetails = new WATextArea(sDetails);
        txtDetails.setBehavior(2);
        txtDetails.setColumns(30);
        txtDetails.setAutosize(true);
        return MessageUtil.displayDetailsMessage(sMessage, sTitle, eType, eOptions, txtDetails);
    }

    public static void displayDetailsMessage(String sMessage, JComponent cmpDetails) {
        MessageUtil.displayDetailsMessage(sMessage, 2, cmpDetails);
    }

    public static void displayDetailsMessage(String sMessage, int eType, JComponent cmpDetails) {
        MessageUtil.displayDetailsMessage(sMessage, eType, -1, cmpDetails);
    }

    public static int displayDetailsMessage(String sMessage, int eType, int eOptions, JComponent cmpDetails) {
        return MessageUtil.displayDetailsMessage(sMessage, MessageUtil.getDefaultTitle(eType), eType, eOptions, cmpDetails);
    }

    public static void displayDetailsMessage(String sMessage, String sTitle, JComponent cmpDetails) {
        MessageUtil.displayDetailsMessage(sMessage, sTitle, 2, cmpDetails);
    }

    public static void displayDetailsMessage(String sMessage, String sTitle, int eType, JComponent cmpDetails) {
        MessageUtil.displayDetailsMessage(sMessage, sTitle, eType, -1, cmpDetails);
    }

    public static int displayDetailsMessage(String sMessage, String sTitle, int eType, int eOptions, JComponent cmpDetails) {
        cDisplayMessageRunnable run = new cDisplayMessageRunnable(sMessage, sTitle, eType, eOptions, cmpDetails);
        if (SwingUtilities.isEventDispatchThread()) {
            run.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(run);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return run.getReturnCode();
    }

    public static int displayDetailsMessage(String sMessage, String sTitle, int eType, int eOptions, JComponent cmpDetails, String sHelpSet, String sHelpContext, String docsetVersion) {
        cDisplayMessageRunnable run = new cDisplayMessageRunnable(sMessage, sTitle, eType, eOptions, cmpDetails, sHelpSet, sHelpContext, docsetVersion);
        if (SwingUtilities.isEventDispatchThread()) {
            run.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(run);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return run.getReturnCode();
    }

    public static void displayMetadataExceptionMessage(final MdException e, final String sAccess) {
        int iRC;
        if (Workspace.getWorkspace().isServerStatusCheckEnabled() && Workspace.getWorkspace().isConnected() && (iRC = Workspace.getWorkspace().checkMetadataServerStatus(true)) != Workspace.SERVERSTATUS_OK) {
            return;
        }
        Runnable runDisplayMessage = new Runnable(){

            @Override
            public void run() {
                String exceptionMessage = e.getLocalizedMessage() == null ? bundle.getString("Common.ErrorNullException.txt") : e.getLocalizedMessage();
                String sText = bundle.getString("Common.Error" + sAccess + "Metadata.txt") + exceptionMessage;
                MessageUtil.displayMessage(sText, 0);
                if (Workspace.getWorkspace() != null) {
                    WsMessagesPropertyTab.getInstance().addMessage(sText, 1);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runDisplayMessage.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runDisplayMessage);
            }
            catch (InvocationTargetException exc) {
                exc.printStackTrace();
            }
            catch (InterruptedException exc) {
                exc.printStackTrace();
            }
        }
    }

    public static void displayRemoteExceptionMessage(final RemoteException ex) {
        int iRC;
        if (Workspace.getWorkspace().isServerStatusCheckEnabled() && Workspace.getWorkspace().isConnected() && (iRC = Workspace.getWorkspace().checkMetadataServerStatus(true)) != Workspace.SERVERSTATUS_OK) {
            return;
        }
        Runnable runDisplayMessage = new Runnable(){

            @Override
            public void run() {
                MessageUtil.displayMessage(ex.getLocalizedMessage(), 0);
                if (Workspace.getWorkspace() != null) {
                    WsMessagesPropertyTab.getInstance().addMessage(ex.getLocalizedMessage(), 1);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runDisplayMessage.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runDisplayMessage);
            }
            catch (InvocationTargetException exc) {
                exc.printStackTrace();
            }
            catch (InterruptedException exc) {
                exc.printStackTrace();
            }
        }
    }

    public static void displayServiceExceptionMessage(final ServiceException e) {
        int iRC;
        if (Workspace.getWorkspace().isServerStatusCheckEnabled() && Workspace.getWorkspace().isConnected() && (iRC = Workspace.getWorkspace().checkMetadataServerStatus(true)) != Workspace.SERVERSTATUS_OK) {
            return;
        }
        Runnable runDisplayMessage = new Runnable(){

            @Override
            public void run() {
                String message = e.getLocalizedMessage() == null ? bundle.getString("Common.ErrorNullException.txt") : e.getLocalizedMessage();
                String[] causes = MessageUtil.getCauseMessages((Exception)((Object)e));
                if (causes.length > 0) {
                    MessageUtil.displayDetailsMessage(message, 0, MessageUtil.getCauseMessageString((Exception)((Object)e)));
                } else {
                    MessageUtil.displayMessage(message, 0);
                }
                if (Workspace.getWorkspace() != null) {
                    WsMessagesPropertyTab.getInstance().addMessage(message, 1);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runDisplayMessage.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runDisplayMessage);
            }
            catch (InvocationTargetException exc) {
                exc.printStackTrace();
            }
            catch (InterruptedException exc) {
                exc.printStackTrace();
            }
        }
    }

    public static String[] getCauseMessages(Exception exception) {
        String message;
        ArrayList<String> messages = new ArrayList<String>();
        Throwable cause = exception.getCause();
        if (cause == null && (message = exception.getLocalizedMessage()) != null) {
            messages.add(exception.getClass().getName() + ": " + message);
        }
        while (cause != null) {
            message = cause.getLocalizedMessage();
            if (message != null && !messages.contains(message)) {
                messages.add(cause.getLocalizedMessage());
            }
            cause = cause.getCause();
        }
        Collections.reverse(messages);
        return messages.toArray(new String[messages.size()]);
    }

    public static String getCauseMessageString(Exception exception) {
        String[] messages = MessageUtil.getCauseMessages(exception);
        StringBuffer buffer = new StringBuffer();
        String separator = "";
        for (int i = 0; i < messages.length; ++i) {
            buffer.append(separator);
            buffer.append(messages[i]);
            separator = "\n";
        }
        return buffer.toString();
    }

    public static void displayChainedExceptionMessage(Exception e, String title, int type) {
        String[] causes = MessageUtil.getCauseMessages(e);
        if (causes.length > 0) {
            MessageUtil.displayDetailsMessage(e.getLocalizedMessage(), title, type, MessageUtil.getCauseMessageString(e));
        } else {
            MessageUtil.displayMessage(e.getLocalizedMessage(), title, type);
        }
    }

    protected static int showLongMessageDialog(String sMessage, String sTitle, int eType, int eOptions) {
        Window focusWindow = MessageUtil.getFocusWindow();
        cMessageDialog dialog = focusWindow instanceof JFrame ? new cMessageDialog((JFrame)focusWindow, sMessage, sTitle, eType, eOptions) : new cMessageDialog((JDialog)focusWindow, sMessage, sTitle, eType, eOptions);
        dialog.pack();
        WorkspaceUtil.centerOver(dialog, focusWindow);
        dialog.setVisible(true);
        return dialog.getReturn();
    }

    protected static int showListMessageDialog(String sMessage, List lValues, String sTitle, int eType, int eOptions) {
        Window focusWindow = MessageUtil.getFocusWindow();
        cMessageDialog dialog = focusWindow instanceof JFrame ? new cMessageDialog((JFrame)focusWindow, sMessage, lValues, sTitle, eType, eOptions) : new cMessageDialog((JDialog)focusWindow, sMessage, lValues, sTitle, eType, eOptions);
        dialog.pack();
        WorkspaceUtil.centerOver(dialog, focusWindow);
        dialog.setVisible(true);
        return dialog.getReturn();
    }

    protected static int showListMessageDialog(String sMessage, JList lValues, String sTitle, int eType, int eOptions) {
        Window focusWindow = MessageUtil.getFocusWindow();
        cMessageDialog dialog = focusWindow instanceof JFrame ? new cMessageDialog((JFrame)focusWindow, sMessage, lValues, sTitle, eType, eOptions) : new cMessageDialog((JDialog)focusWindow, sMessage, lValues, sTitle, eType, eOptions);
        dialog.pack();
        WorkspaceUtil.centerOver(dialog, focusWindow);
        dialog.setVisible(true);
        return dialog.getReturn();
    }

    protected static int showDetailsMessageDialog(String sMessage, String sTitle, int eType, int eOptions, JComponent cmpDetails) {
        Window focusWindow = MessageUtil.getFocusWindow();
        cMessageDialog dialog = focusWindow instanceof JFrame ? new cMessageDialog((JFrame)focusWindow, sMessage, sTitle, eType, eOptions, cmpDetails) : new cMessageDialog((JDialog)focusWindow, sMessage, sTitle, eType, eOptions, cmpDetails);
        dialog.pack();
        WorkspaceUtil.centerOver(dialog, focusWindow);
        dialog.setVisible(true);
        return dialog.getReturn();
    }

    protected static int showDetailsMessageDialog(String sMessage, String sTitle, int eType, int eOptions, JComponent cmpDetails, String sHelpSet, String sHelpContext, String docsetVersion) {
        Window focusWindow = MessageUtil.getFocusWindow();
        cMessageDialog dialog = focusWindow instanceof JFrame ? new cMessageDialog((JFrame)focusWindow, sMessage, sTitle, eType, eOptions, cmpDetails, sHelpSet, sHelpContext, docsetVersion) : new cMessageDialog((JDialog)focusWindow, sMessage, sTitle, eType, eOptions, cmpDetails, sHelpSet, sHelpContext, docsetVersion);
        dialog.pack();
        WorkspaceUtil.centerOver(dialog, focusWindow);
        dialog.setVisible(true);
        return dialog.getReturn();
    }

    private static int showMessageDialog(String sMessage, String sTitle, int eType, JButton[] aButtons) {
        Window focusWindow = MessageUtil.getFocusWindow();
        cMessageDialog dialog = focusWindow instanceof JFrame ? new cMessageDialog((JFrame)focusWindow, sMessage, sTitle, eType, aButtons) : new cMessageDialog((JDialog)focusWindow, sMessage, sTitle, eType, aButtons);
        dialog.pack();
        WorkspaceUtil.centerOver(dialog, focusWindow);
        dialog.setVisible(true);
        return dialog.getReturn();
    }

    private static String getDefaultTitle(int eType) {
        String sTitleRes;
        switch (eType) {
            case 2: {
                sTitleRes = "Common.Warning.txt";
                break;
            }
            case 0: {
                sTitleRes = "Common.Error.txt";
                break;
            }
            case 3: {
                sTitleRes = "Common.Question.txt";
                break;
            }
            case -1: {
                return "";
            }
            default: {
                sTitleRes = "Common.Information.txt";
            }
        }
        return bundle.getString(sTitleRes);
    }

    public static boolean OkToContinue(String strMessage, String strTitle) {
        Object[] warningOptions = new Object[]{bundle.getString("Common.OK.txt"), bundle.getString("Common.Cancel.txt")};
        int warningChoice = JOptionPane.showOptionDialog(MessageUtil.getFocusWindow(), strMessage, strTitle, 2, 2, null, warningOptions, warningOptions[0]);
        return warningChoice == 0;
    }

    public static int YesNoToContinue(String strMessage, String strTitle) {
        Object[] warningOptions = new Object[]{bundle.getString("Common.Yes.nomnem.txt"), bundle.getString("Common.No.nomnem.txt"), bundle.getString("Common.Cancel.txt")};
        int choice = JOptionPane.showOptionDialog(MessageUtil.getFocusWindow(), strMessage, strTitle, 1, 2, null, warningOptions, warningOptions[0]);
        return choice;
    }

    protected static class cDisplayMessageRunnable
    implements Runnable {
        protected String m_sTitle;
        protected List m_lValues;
        protected String m_sMessage;
        protected int m_eType;
        protected int m_eOptions;
        protected JComponent m_cmpDetails;
        protected int m_eReturnCode;
        protected JList m_lstComponent;
        private JButton[] m_aButtons;
        protected String m_sHelpContext;
        protected String m_sHelpSet;
        protected String docsetVersion;

        public cDisplayMessageRunnable(String sMessage, String sTitle, int eType, int eOptions) {
            this.m_sMessage = sMessage;
            this.m_sTitle = sTitle;
            this.m_eType = eType;
            this.m_eOptions = eOptions;
        }

        public cDisplayMessageRunnable(String sMessage, String sTitle, int eType, JButton[] aButtons) {
            this.m_sMessage = sMessage;
            this.m_sTitle = sTitle;
            this.m_eType = eType;
            this.m_aButtons = aButtons;
        }

        public cDisplayMessageRunnable(String sMessage, List lValues, String sTitle, int eType, int eOptions) {
            this.m_sMessage = sMessage;
            this.m_lValues = lValues;
            this.m_sTitle = sTitle;
            this.m_eType = eType;
            this.m_eOptions = eOptions;
        }

        public cDisplayMessageRunnable(String sMessage, JList lValues, String sTitle, int eType, int eOptions) {
            this.m_sMessage = sMessage;
            this.m_lstComponent = lValues;
            this.m_sTitle = sTitle;
            this.m_eType = eType;
            this.m_eOptions = eOptions;
        }

        public cDisplayMessageRunnable(String sMessage, String sTitle, int eType, int eOptions, JComponent cmpDetails) {
            this.m_sMessage = sMessage;
            this.m_sTitle = sTitle;
            this.m_eType = eType;
            this.m_eOptions = eOptions;
            this.m_cmpDetails = cmpDetails;
        }

        public cDisplayMessageRunnable(String sMessage, String sTitle, int eType, int eOptions, JComponent cmpDetails, String sHelpSet, String sHelpContext, String docsetVersion) {
            this.m_sMessage = sMessage;
            this.m_sTitle = sTitle;
            this.m_eType = eType;
            this.m_eOptions = eOptions;
            this.m_cmpDetails = cmpDetails;
            this.m_sHelpContext = sHelpContext;
            this.m_sHelpSet = sHelpSet;
            this.docsetVersion = docsetVersion;
        }

        @Override
        public void run() {
            this.m_eReturnCode = this.m_lstComponent != null ? MessageUtil.showListMessageDialog(this.m_sMessage, this.m_lstComponent, this.m_sTitle, this.m_eType, this.m_eOptions) : (this.m_lValues != null ? MessageUtil.showListMessageDialog(this.m_sMessage, this.m_lValues, this.m_sTitle, this.m_eType, this.m_eOptions) : (this.m_cmpDetails != null ? (this.m_sHelpSet != null ? MessageUtil.showDetailsMessageDialog(this.m_sMessage, this.m_sTitle, this.m_eType, this.m_eOptions, this.m_cmpDetails, this.m_sHelpSet, this.m_sHelpContext, this.docsetVersion) : MessageUtil.showDetailsMessageDialog(this.m_sMessage, this.m_sTitle, this.m_eType, this.m_eOptions, this.m_cmpDetails)) : (this.m_aButtons != null ? MessageUtil.showMessageDialog(this.m_sMessage, this.m_sTitle, this.m_eType, this.m_aButtons) : MessageUtil.showLongMessageDialog(this.m_sMessage, this.m_sTitle, this.m_eType, this.m_eOptions))));
        }

        public int getReturnCode() {
            return this.m_eReturnCode;
        }
    }

    public static class cMessageDialog
    extends JDialog {
        private static final long serialVersionUID = 1L;
        protected int m_eReturn = -1;
        protected boolean m_bDetailsVisible;
        protected WATextArea m_txtMessage;
        protected JLabel m_lblIcon;
        protected JPanel m_pnlButtons;
        protected JList m_lstValues;
        protected JScrollPane m_scrValues;
        protected JSeparator m_sepDetails;
        protected JComponent m_cmpDetails;
        private JButton[] m_aButtons;
        private ActionListener[] m_aListeners;

        public cMessageDialog(JFrame frmParent, String sMessage, String sTitle) {
            this(frmParent, sMessage, sTitle, 2);
        }

        public cMessageDialog(JFrame frmParent, String sMessage, String sTitle, int eType) {
            this(frmParent, sMessage, sTitle, eType, -1);
        }

        public cMessageDialog(JFrame frmParent, String sMessage, String sTitle, int eType, int eOptions) {
            super(frmParent, sTitle, true);
            this.initialize(sMessage, sTitle, eType, eOptions);
        }

        public cMessageDialog(JDialog dlgParent, String sMessage, String sTitle, int eType, int eOptions) {
            super(dlgParent, sTitle, true);
            this.initialize(sMessage, sTitle, eType, eOptions);
        }

        private void initialize(String sMessage, String sTitle, int eType, int eOptions) {
            this.setResizable(false);
            this.setDefaultCloseOperation(2);
            this.addCloseAction();
            this.m_txtMessage = this.createMessageText(sMessage);
            this.m_lblIcon = this.createIconLabel(eType);
            this.m_pnlButtons = this.createButtonsPanel(eOptions);
            this.layoutComponents();
        }

        public cMessageDialog(JFrame frmParent, String sMessage, String sTitle, int eType, JButton[] aButtons) {
            super(frmParent, sTitle, true);
            this.initialize(sMessage, sTitle, eType, aButtons);
        }

        public cMessageDialog(JDialog dlgParent, String sMessage, String sTitle, int eType, JButton[] aButtons) {
            super(dlgParent, sTitle, true);
            this.initialize(sMessage, sTitle, eType, aButtons);
        }

        private void initialize(String sMessage, String sTitle, int eType, JButton[] aButtons) {
            this.setResizable(false);
            this.setDefaultCloseOperation(2);
            this.addCloseAction();
            this.m_txtMessage = this.createMessageText(sMessage);
            this.m_lblIcon = this.createIconLabel(eType);
            this.m_pnlButtons = this.createButtonsPanel(aButtons);
            this.layoutComponents();
        }

        public cMessageDialog(JFrame frmParent, String sMessage, List lValues, String sTitle, int eType, int eOptions) {
            super(frmParent, sTitle, true);
            this.initialize(sMessage, lValues, sTitle, eType, eOptions);
        }

        public cMessageDialog(JFrame frmParent, String sMessage, JList lValues, String sTitle, int eType, int eOptions) {
            super(frmParent, sTitle, true);
            this.initialize(sMessage, lValues, sTitle, eType, eOptions);
        }

        public cMessageDialog(JDialog dlgParent, String sMessage, List lValues, String sTitle, int eType, int eOptions) {
            super(dlgParent, sTitle, true);
            this.initialize(sMessage, lValues, sTitle, eType, eOptions);
        }

        private void initialize(String sMessage, List lValues, String sTitle, int eType, int eOptions) {
            this.setResizable(false);
            this.setDefaultCloseOperation(2);
            this.addCloseAction();
            this.m_txtMessage = this.createMessageText(sMessage);
            this.m_lstValues = this.createValuesList(lValues);
            this.m_scrValues = new JScrollPane(this.m_lstValues);
            this.m_lblIcon = this.createIconLabel(eType);
            this.m_pnlButtons = this.createButtonsPanel(eOptions);
            this.layoutComponents();
        }

        public cMessageDialog(JDialog dlgParent, String sMessage, JList lValues, String sTitle, int eType, int eOptions) {
            super(dlgParent, sTitle, true);
            this.initialize(sMessage, lValues, sTitle, eType, eOptions);
        }

        private void initialize(String sMessage, JList lValues, String sTitle, int eType, int eOptions) {
            this.setResizable(false);
            this.setDefaultCloseOperation(2);
            this.addCloseAction();
            this.m_txtMessage = this.createMessageText(sMessage);
            this.m_lstValues = lValues;
            this.m_scrValues = new JScrollPane(this.m_lstValues);
            this.m_lblIcon = this.createIconLabel(eType);
            this.m_pnlButtons = this.createButtonsPanel(eOptions);
            this.layoutComponents();
        }

        public cMessageDialog(JFrame frmParent, String sMessage, String sTitle, int eType, int eOptions, JComponent cmpDetails) {
            super(frmParent, sTitle, true);
            this.initialize(sMessage, sTitle, eType, eOptions, cmpDetails);
        }

        public cMessageDialog(JFrame frmParent, String sMessage, String sTitle, int eType, int eOptions, JComponent cmpDetails, String sHelpSet, String sHelpContext, String docsetVersion) {
            super(frmParent, sTitle, true);
            this.initialize(sMessage, sTitle, eType, eOptions, cmpDetails, sHelpSet, sHelpContext, docsetVersion);
        }

        public cMessageDialog(JDialog dlgParent, String sMessage, String sTitle, int eType, int eOptions, JComponent cmpDetails) {
            super(dlgParent, sTitle, true);
            this.initialize(sMessage, sTitle, eType, eOptions, cmpDetails);
        }

        public cMessageDialog(JDialog dlgParent, String sMessage, String sTitle, int eType, int eOptions, JComponent cmpDetails, String sHelpSet, String sHelpContext, String docsetVersion) {
            super(dlgParent, sTitle, true);
            this.initialize(sMessage, sTitle, eType, eOptions, cmpDetails, sHelpSet, sHelpContext, docsetVersion);
        }

        private void initialize(String sMessage, String sTitle, int eType, int eOptions, JComponent cmpDetails) {
            this.setResizable(false);
            this.setDefaultCloseOperation(2);
            this.addCloseAction();
            this.m_txtMessage = this.createMessageText(sMessage);
            this.m_lblIcon = this.createIconLabel(eType);
            this.m_pnlButtons = this.createButtonsPanel(eOptions);
            this.m_pnlButtons.add(new cDetailsButton(this));
            this.m_sepDetails = new JSeparator();
            this.m_cmpDetails = cmpDetails;
            this.m_sepDetails.setVisible(false);
            this.m_cmpDetails.setVisible(false);
            this.layoutComponents();
        }

        private void initialize(String sMessage, String sTitle, int eType, int eOptions, JComponent cmpDetails, String sHelpSet, String sHelpContext, String docsetVersion) {
            this.setResizable(false);
            this.setDefaultCloseOperation(2);
            this.addCloseAction();
            this.m_txtMessage = this.createMessageText(sMessage);
            this.m_lblIcon = this.createIconLabel(eType);
            this.m_pnlButtons = this.createButtonsPanel(eOptions);
            this.m_pnlButtons.add(new cHelpButton(this, sHelpSet, sHelpContext, docsetVersion));
            this.m_pnlButtons.add(new cDetailsButton(this));
            this.m_sepDetails = new JSeparator();
            this.m_cmpDetails = cmpDetails;
            this.m_sepDetails.setVisible(false);
            this.m_cmpDetails.setVisible(false);
            this.layoutComponents();
        }

        public int getReturn() {
            return this.m_eReturn;
        }

        public void setReturn(int eReturn) {
            this.m_eReturn = eReturn;
        }

        protected WATextArea createMessageText(String sMessage) {
            WATextArea txtMessage = new WATextArea();
            txtMessage.setColumns(30);
            txtMessage.setText(sMessage);
            txtMessage.setBackground(SystemColor.control);
            txtMessage.setBehavior(1);
            txtMessage.setAutosize(true);
            return txtMessage;
        }

        protected JLabel createIconLabel(int eType) {
            String sIconRes;
            switch (eType) {
                case 2: {
                    sIconRes = "OptionPane.warningIcon";
                    break;
                }
                case 0: {
                    sIconRes = "OptionPane.errorIcon";
                    break;
                }
                case 3: {
                    sIconRes = "OptionPane.questionIcon";
                    break;
                }
                case -1: {
                    return new JLabel();
                }
                default: {
                    sIconRes = "OptionPane.informationIcon";
                }
            }
            return new JLabel(UIManager.getDefaults().getIcon(sIconRes));
        }

        protected JList createValuesList(List lValues) {
            return new JList<Object>(lValues.toArray());
        }

        protected JPanel createButtonsPanel(int eOptions) {
            JPanel pnlButtons = new JPanel(new WsButtonsLayout());
            switch (eOptions) {
                default: {
                    pnlButtons.add(new cOptionButton(this, "Common.OK", 0, false));
                    break;
                }
                case 2: {
                    pnlButtons.add(new cOptionButton(this, "Common.OK", 0, false));
                    pnlButtons.add(new cOptionButton(this, "Common.Cancel", 2, false));
                    break;
                }
                case 0: {
                    pnlButtons.add(new cOptionButton(this, "Common.Yes", 0));
                    pnlButtons.add(new cOptionButton(this, "Common.No", 1));
                    break;
                }
                case 1: {
                    pnlButtons.add(new cOptionButton(this, "Common.Yes", 0));
                    pnlButtons.add(new cOptionButton(this, "Common.No", 1));
                    pnlButtons.add(new cOptionButton(this, "Common.Cancel", 2, false));
                    break;
                }
                case 100: {
                    pnlButtons.add(new cOptionButton(this, "Common.OK", 0, false));
                    pnlButtons.add(new cOptionButton(this, "Common.OKToAll", 102));
                    pnlButtons.add(new cOptionButton(this, "Common.Cancel", 2, false));
                    break;
                }
                case 101: {
                    pnlButtons.add(new cOptionButton(this, "Common.Yes", 0));
                    pnlButtons.add(new cOptionButton(this, "Common.YesToAll", 100));
                    pnlButtons.add(new cOptionButton(this, "Common.No", 1));
                    pnlButtons.add(new cOptionButton(this, "Common.Cancel", 2, false));
                    break;
                }
                case 102: {
                    pnlButtons.add(new cOptionButton(this, "Common.Yes", 0));
                    pnlButtons.add(new cOptionButton(this, "Common.YesToAll", 100));
                    pnlButtons.add(new cOptionButton(this, "Common.No", 1));
                    pnlButtons.add(new cOptionButton(this, "Common.NoToAll", 101));
                    pnlButtons.add(new cOptionButton(this, "Common.Cancel", 2, false));
                }
            }
            JButton btnDefault = (JButton)pnlButtons.getComponents()[0];
            this.getRootPane().setDefaultButton(btnDefault);
            return pnlButtons;
        }

        protected JPanel createButtonsPanel(JButton[] aButtons) {
            JPanel pnlButtons = new JPanel(new WsButtonsLayout());
            this.m_aButtons = aButtons;
            this.m_aListeners = new ActionListener[aButtons.length];
            for (int iButton = 0; iButton < aButtons.length; ++iButton) {
                this.m_aListeners[iButton] = new ButtonAction(iButton);
                aButtons[iButton].addActionListener(this.m_aListeners[iButton]);
                pnlButtons.add(aButtons[iButton]);
            }
            this.getRootPane().setDefaultButton(aButtons[0]);
            return pnlButtons;
        }

        protected void layoutComponents() {
            Container pnlContents = this.getContentPane();
            pnlContents.setLayout(new GridBagLayout());
            pnlContents.add((Component)this.m_lblIcon, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 3, new Insets(7, 7, 7, 7), 0, 0));
            pnlContents.add((Component)this.m_txtMessage, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(7, 7, 7, 7), 0, 0));
            if (this.m_scrValues != null) {
                pnlContents.add((Component)this.m_scrValues, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 7, 7, 7), 0, 0));
            }
            pnlContents.add((Component)this.m_pnlButtons, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 15, 0, new Insets(7, 0, 7, 0), 0, 0));
            if (this.m_sepDetails != null) {
                pnlContents.add((Component)this.m_sepDetails, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 15, 2, new Insets(0, 7, 0, 7), 0, 0));
            }
            if (this.m_cmpDetails != null) {
                pnlContents.add((Component)this.m_cmpDetails, new GridBagConstraints(0, 4, 2, 1, 1.0, 1.0, 15, 1, new Insets(7, 7, 7, 7), 0, 0));
            }
            this.pack();
        }

        protected void setDetailsVisible(boolean bDetailsVisible) {
            if (this.m_bDetailsVisible == bDetailsVisible) {
                return;
            }
            this.m_bDetailsVisible = bDetailsVisible;
            this.m_sepDetails.setVisible(this.m_bDetailsVisible);
            this.m_cmpDetails.setVisible(this.m_bDetailsVisible);
            this.pack();
        }

        protected boolean isDetailsVisible() {
            return this.m_bDetailsVisible;
        }

        protected void addCloseAction() {
            this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "close");
            this.getRootPane().getActionMap().put("close", new cCloseAction());
        }

        @Override
        public void dispose() {
            if (this.m_aListeners != null) {
                for (int iButton = 0; iButton < this.m_aButtons.length; ++iButton) {
                    this.m_aButtons[iButton].removeActionListener(this.m_aListeners[iButton]);
                }
            }
            super.dispose();
        }

        private class ButtonAction
        implements ActionListener {
            private int m_eReturnCode;

            public ButtonAction(int eReturnCode) {
                this.m_eReturnCode = eReturnCode;
            }

            @Override
            public void actionPerformed(ActionEvent ev) {
                cMessageDialog.this.setReturn(this.m_eReturnCode);
                cMessageDialog.this.dispose();
            }
        }

        protected class cCloseAction
        extends AbstractAction {
            private static final long serialVersionUID = 1L;

            protected cCloseAction() {
            }

            @Override
            public void actionPerformed(ActionEvent ev) {
                cMessageDialog.this.dispose();
            }
        }
    }

    protected static class cHelpButton
    extends JButton
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        protected cMessageDialog m_dlgParent;
        protected int m_eReturnCode;
        private String docsetId;
        private String docsetTarget;
        private String docsetVersion;

        public cHelpButton(cMessageDialog dlgParent, String docsetId, String docsetTarget, String docsetVersion) {
            this.docsetId = docsetId;
            this.docsetTarget = docsetTarget;
            this.docsetVersion = docsetVersion;
            this.m_dlgParent = dlgParent;
            this.setText(bundle.getString("MessageUtil.Help.txt"));
            this.setMnemonic(bundle.getString("MessageUtil.Help.mnem").charAt(0));
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            DesktopUtil.openHelpDoc(this.docsetId, this.docsetTarget, this.docsetVersion, null);
            this.m_dlgParent.pack();
        }
    }

    protected static class cDetailsButton
    extends JButton
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        protected cMessageDialog m_dlgParent;
        protected int m_eReturnCode;

        public cDetailsButton(cMessageDialog dlgParent) {
            this.updateText(false);
            this.m_dlgParent = dlgParent;
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            this.m_dlgParent.setDetailsVisible(!this.m_dlgParent.isDetailsVisible());
            this.updateText(this.m_dlgParent.isDetailsVisible());
            this.m_dlgParent.pack();
        }

        private void updateText(boolean bVisible) {
            if (bVisible) {
                this.setText(bundle.getString("MessageUtil.HideDetails.txt"));
                this.setMnemonic(bundle.getString("MessageUtil.HideDetails.mnem").charAt(0));
            } else {
                this.setText(bundle.getString("MessageUtil.ShowDetails.txt"));
                this.setMnemonic(bundle.getString("MessageUtil.ShowDetails.mnem").charAt(0));
            }
        }
    }

    protected static class cOptionButton
    extends JButton
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        protected cMessageDialog m_dlgParent;
        protected int m_eReturnCode;

        public cOptionButton(cMessageDialog dlgParent, String sResource, int eReturnCode) {
            this(dlgParent, sResource, eReturnCode, true);
        }

        public cOptionButton(cMessageDialog dlgParent, String sResource, int eReturnCode, boolean bHasMnemonic) {
            super(bundle.getString(sResource + ".txt"));
            if (bHasMnemonic) {
                this.setMnemonic(bundle.getString(sResource + ".mnem").charAt(0));
            }
            this.m_dlgParent = dlgParent;
            this.m_eReturnCode = eReturnCode;
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            this.m_dlgParent.setReturn(this.m_eReturnCode);
            this.m_dlgParent.dispose();
        }
    }
}

