/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.AuthenticationDomain;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Connection;
import com.sas.metadata.remote.CredentialResolver;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.DatabaseSchema;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.DeployedDataPackage;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdLibGenInterface;
import com.sas.metadata.remote.MdModelUtil;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.RelationalSchema;
import com.sas.metadata.remote.SASClientConnection;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.ServerContext;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIServer;
import com.sas.services.security.RemoteCallbackHandler;
import com.sas.services.user.UserContextInterface;
import com.sas.util.SasPasswordEncodingException;
import com.sas.util.SasPasswordString;
import com.sas.workspace.AppServer;
import com.sas.workspace.AppServerException;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.SASCodeGeneration;
import com.sas.workspace.ServerSupport;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerCodeException;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.WsAppServerLibraryException;
import java.net.PasswordAuthentication;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class LibraryUtil {
    private static final String BLOTTED_PASSWORD = "********";
    private static WAdminResource bundle = WAdminResource.getBundle(LibraryUtil.class);
    private static String LIBRARY_MACR0_NAME = "etls_remoteMacro";
    public static final int NONE = -1;
    public static final int USERPASSWORD = -2;
    public static final int PROMPTFOR = -3;
    public static final int UNKNOWN = -4;
    public static final String CLASSID_TABLESERVER = "E803E04B-AAF0-4C74-86A6-F7008AA702DC";

    public static SASLibrary getLibrary(DataTable iTab, ServerContext iDefault) throws MdException, RemoteException {
        RelationalSchema iContainer = iTab.getTablePackage();
        if (iContainer instanceof SASLibrary) {
            return LibraryUtil.getClientLibrary((SASLibrary)iContainer, iDefault);
        }
        if (iContainer instanceof DatabaseSchema) {
            SASLibrary lib = LibraryUtil.getSASLibrary(iContainer);
            if (lib != null) {
                return LibraryUtil.getClientLibrary(lib, iDefault);
            }
            return null;
        }
        return null;
    }

    public static String getLibraryOptions(SASLibrary xmlLibrary) {
        return LibraryUtil.getLibraryProperty(xmlLibrary, "OptionString");
    }

    public static String getLibraryProperty(SASLibrary library, String propertyName) {
        if (library != null && propertyName.length() > 0) {
            try {
                AssociationList alProps = library.getProperties();
                if (!alProps.isEmpty()) {
                    for (int i = 0; i < alProps.size(); ++i) {
                        Property prop = (Property)alProps.get(i);
                        if (!prop.getPropertyName().equalsIgnoreCase(propertyName)) continue;
                        return prop.getDefaultValue();
                    }
                }
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage(e, "Reading");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException(re);
            }
        }
        return "";
    }

    public static String getXMLProductName(SASLibrary xmlLibrary) {
        try {
            if (xmlLibrary.getEngine().equalsIgnoreCase("XML")) {
                String sType = "XML" + LibraryUtil.getLibraryProperty(xmlLibrary, "XMLTYPE");
                if (sType.equalsIgnoreCase(bundle.getString("XMLImporter.description.XMLORACLE.notrans")) || sType.equalsIgnoreCase(bundle.getString("XMLImporter.description.XMLACCESS.notrans")) || sType.equalsIgnoreCase(bundle.getString("XMLImporter.description.XMLCDISC.notrans"))) {
                    return sType;
                }
                return "XML";
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
        return "";
    }

    public static String getXMLV2ProductName(SASLibrary xmlLibrary) {
        try {
            if (xmlLibrary.getEngine().equalsIgnoreCase("XMLV2")) {
                String sType = "XMLV2" + LibraryUtil.getLibraryProperty(xmlLibrary, "XMLTYPE");
                if (sType.equalsIgnoreCase(bundle.getString("XMLImporter.description.XMLV2XMLMAP.notrans"))) {
                    return sType;
                }
                return "XMLV2";
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
        return "";
    }

    public static AppServer interactiveAccessPath(SASLibrary iLib) throws MdException, RemoteException, AppServerException {
        String sDefaultAppServer = Workspace.getWorkspace().getAppDefaultsFile().getPropertyString("AppServer.Default");
        AppServer iApp = new AppServer(iLib.getObjectStore(), sDefaultAppServer);
        return LibraryUtil.interactiveAccessPath(iLib, iApp);
    }

    public static WsAppServer interactiveAccessPath(SASLibrary iLib, WsAppServer iDefaultApp) throws MdException, RemoteException, WsAppServerFailException, WsAppServerCodeException, WsAppServerLibraryException {
        return LibraryUtil.interactiveAccessPath(iLib, iDefaultApp, "");
    }

    public static WsAppServer interactiveAccessPath(SASLibrary iLib, WsAppServer iDefaultApp, String parameterCode) throws MdException, RemoteException, WsAppServerFailException, WsAppServerCodeException, WsAppServerLibraryException {
        return LibraryUtil.interactiveAccessPath(iLib, iDefaultApp, parameterCode, true);
    }

    public static WsAppServer interactiveAccessPath(SASLibrary iLib, WsAppServer iDefaultApp, String parameterCode, boolean bPromptCredentials) throws MdException, RemoteException, WsAppServerFailException, WsAppServerCodeException, WsAppServerLibraryException {
        WsAppServer iRetApp = null;
        boolean remoteToAppServer = false;
        String sDefaultAppServer = iDefaultApp.getServerContext().getId();
        AssociationList lServers = iLib.getDeployedComponents();
        ServerContext iServer = null;
        boolean done = false;
        if (lServers.size() == 0) {
            iRetApp = iDefaultApp;
        } else {
            int i;
            for (int i2 = 0; i2 < lServers.size(); ++i2) {
                ServerComponent iSC = (ServerComponent)lServers.get(i2);
                if (!iSC.getClassIdentifier().equals("SHARE")) continue;
                throw new MdException(bundle.formatString("LibraryUtil.CannotAssignShare.msg.txt", iLib.getName()));
            }
            Vector<ServerContext> lIOMServers = new Vector<ServerContext>();
            for (i = 0; i < lServers.size(); ++i) {
                ServerContext iSCx = (ServerContext)lServers.get(i);
                AssociationList lLogicals = iSCx.getUsingComponents();
                for (int j = 0; j < lLogicals.size() && !done; ++j) {
                    LogicalServer iLs = (LogicalServer)lLogicals.get(j);
                    if (iLs.getClassIdentifier().compareTo("440196D4-90F0-11D0-9F41-00A024BB830C") != 0) continue;
                    lIOMServers.add(iSCx);
                }
            }
            if (lIOMServers.size() > 0) {
                for (i = 0; i < lIOMServers.size(); ++i) {
                    if (((ServerContext)lIOMServers.get(i)).getId().compareTo(sDefaultAppServer) != 0) continue;
                    iServer = (ServerContext)lIOMServers.get(i);
                }
                if (iServer == null) {
                    iServer = (ServerContext)lIOMServers.get(0);
                }
                iRetApp = WsAppServer.createAppServer(iServer.getId());
            } else {
                iRetApp = iDefaultApp;
                remoteToAppServer = true;
            }
        }
        if (iRetApp != null) {
            String AppServerName = iRetApp.getServerContext().getName();
            Workspace.getDefaultLogger().info("Selected AppServer: " + AppServerName);
            iRetApp.open(bPromptCredentials);
            if (parameterCode != null && parameterCode.length() > 0) {
                iRetApp.submitSASCode(parameterCode);
            }
            if (remoteToAppServer) {
                StringBuffer sCode = LibraryUtil.accessPath(iLib, iRetApp.getServerContext());
                ServerContext iServer2 = LibraryUtil.getServer(iLib, iRetApp.getServerContext());
                ServerSupport iServSupp = new ServerSupport(iServer2);
                String remoteLibname = "\nlibname " + iLib.getLibref() + " REMOTE server=" + iServSupp.getHostName() + ";\n";
                sCode.append(remoteLibname);
                iRetApp.submitSASCode(sCode.toString());
                Workspace.getDefaultLogger().info(iRetApp.getLogBuffer());
            } else {
                iRetApp.assignLibref(iLib, bPromptCredentials);
            }
            if (!iRetApp.isLibrefAssigned(iLib.getLibref())) {
                ServerSupport.clearSignonCache();
            }
            return iRetApp;
        }
        return null;
    }

    public static String assignLibname(SASLibrary iLib, WsAppServer iAppServer, String parameterCode, boolean bPromptCredentials) throws MdException, RemoteException, WsAppServerFailException, WsAppServerCodeException, WsAppServerLibraryException {
        return LibraryUtil.assignLibname(iLib, iAppServer, parameterCode, bPromptCredentials, true);
    }

    public static String assignLibname(SASLibrary iLib, WsAppServer iAppServer, String parameterCode, boolean bPromptCredentials, boolean generateRCCalls) throws MdException, RemoteException, WsAppServerFailException, WsAppServerCodeException, WsAppServerLibraryException {
        boolean remoteToAppServer = false;
        String sDefaultAppServer = null;
        if (iAppServer != null) {
            sDefaultAppServer = iAppServer.getServerContext().getId();
        }
        AssociationList lServers = iLib.getDeployedComponents();
        ServerContext iServer = null;
        boolean done = false;
        if (lServers.size() != 0) {
            int i;
            for (int i2 = 0; i2 < lServers.size(); ++i2) {
                ServerComponent iSC = (ServerComponent)lServers.get(i2);
                if (!iSC.getClassIdentifier().equals("SHARE")) continue;
                throw new MdException(bundle.formatString("LibraryUtil.CannotAssignShare.msg.txt", iLib.getName()));
            }
            Vector<ServerContext> lIOMServers = new Vector<ServerContext>();
            for (i = 0; i < lServers.size(); ++i) {
                ServerContext iSCx = (ServerContext)lServers.get(i);
                AssociationList lLogicals = iSCx.getUsingComponents();
                for (int j = 0; j < lLogicals.size() && !done; ++j) {
                    LogicalServer iLs = (LogicalServer)lLogicals.get(j);
                    if (iLs.getClassIdentifier().compareTo("440196D4-90F0-11D0-9F41-00A024BB830C") != 0) continue;
                    lIOMServers.add(iSCx);
                }
            }
            if (lIOMServers.size() > 0) {
                for (i = 0; i < lIOMServers.size(); ++i) {
                    if (!((ServerContext)lIOMServers.get(i)).getId().equals(sDefaultAppServer)) continue;
                    iServer = (ServerContext)lIOMServers.get(i);
                }
                if (iServer == null) {
                    iServer = (ServerContext)lIOMServers.get(0);
                }
            } else {
                remoteToAppServer = true;
            }
        }
        String libref = iLib.getLibref();
        if (iAppServer != null) {
            String AppServerName = iAppServer.getServerContext().getName();
            Workspace.getDefaultLogger().info("Selected AppServer: " + AppServerName);
            iAppServer.open(bPromptCredentials);
            if (parameterCode != null && parameterCode.length() > 0) {
                iAppServer.submitSASCode(parameterCode);
            }
            if (remoteToAppServer) {
                StringBuffer sCode = LibraryUtil.accessPath(iLib, iAppServer.getServerContext(), null, true, null, generateRCCalls);
                ServerContext iServer2 = LibraryUtil.getServer(iLib, iAppServer.getServerContext());
                ServerSupport iServSupp = new ServerSupport(iServer2);
                String remoteLibname = "\nlibname " + iLib.getLibref() + " REMOTE server=" + iServSupp.getHostName() + ";\n";
                sCode.append(remoteLibname);
                iAppServer.submitSASCode(sCode.toString());
                Workspace.getDefaultLogger().info(iAppServer.getLogBuffer());
            } else {
                libref = iAppServer.assignLibref(iLib, bPromptCredentials);
            }
            if (!iAppServer.isLibrefAssigned(iLib.getLibref())) {
                ServerSupport.clearSignonCache();
            }
            return libref;
        }
        return null;
    }

    public static WsAppServer getLibraryServer(WsAppServer iDefaultApp, SASLibrary iLib) throws RemoteException, MdException {
        WsAppServer iRetApp = null;
        Object sDefaultAppServer = null;
        AssociationList lServers = iLib.getDeployedComponents();
        ServerContext iServer = null;
        boolean done = false;
        if (lServers.size() == 0) {
            iRetApp = iDefaultApp;
        } else {
            int i;
            for (int i2 = 0; i2 < lServers.size(); ++i2) {
                ServerComponent iSC = (ServerComponent)lServers.get(i2);
                if (!iSC.getClassIdentifier().equals("SHARE")) continue;
                throw new MdException(bundle.formatString("LibraryUtil.CannotAssignShare.msg.txt", iLib.getName()));
            }
            Vector<ServerContext> lIOMServers = new Vector<ServerContext>();
            for (i = 0; i < lServers.size(); ++i) {
                ServerContext iSCx = (ServerContext)lServers.get(i);
                AssociationList lLogicals = iSCx.getUsingComponents();
                for (int j = 0; j < lLogicals.size() && !done; ++j) {
                    LogicalServer iLs = (LogicalServer)lLogicals.get(j);
                    if (iLs.getClassIdentifier().compareTo("440196D4-90F0-11D0-9F41-00A024BB830C") != 0) continue;
                    lIOMServers.add(iSCx);
                }
            }
            if (lIOMServers.size() > 0) {
                for (i = 0; i < lIOMServers.size(); ++i) {
                    if (!((ServerContext)lIOMServers.get(i)).getId().equals(sDefaultAppServer)) continue;
                    iServer = (ServerContext)lIOMServers.get(i);
                }
                if (iServer == null) {
                    iServer = (ServerContext)lIOMServers.get(0);
                }
                iRetApp = WsAppServer.createAppServer(iServer.getId());
            } else {
                iRetApp = iDefaultApp;
            }
        }
        if (iRetApp == null) {
            boolean updateDefault = true;
            if (null == WsAppServer.findAppServer(WsAppServer.getDefaultAppServerFQID())) {
                WsAppServer.showDefaultAppServerPrompt();
                updateDefault = false;
            }
            iRetApp = WsAppServer.createDefaultAppServer(updateDefault);
        }
        return iRetApp;
    }

    public static AppServer interactiveAccessPath(SASLibrary iLib, AppServer iDefaultApp) throws MdException, RemoteException, AppServerException {
        return LibraryUtil.interactiveAccessPath(iLib, iDefaultApp, "");
    }

    public static AppServer interactiveAccessPath(SASLibrary iLib, AppServer iDefaultApp, String parameterCode) throws MdException, RemoteException, AppServerException {
        AppServer iRetApp = null;
        boolean remoteToAppServer = false;
        String sDefaultAppServer = iDefaultApp.getServerContext().getId();
        AssociationList lServers = iLib.getDeployedComponents();
        ServerContext iServer = null;
        boolean done = false;
        if (lServers.size() == 0) {
            iRetApp = iDefaultApp;
        } else {
            int i;
            for (int i2 = 0; i2 < lServers.size(); ++i2) {
                ServerComponent iSC = (ServerComponent)lServers.get(i2);
                if (!iSC.getClassIdentifier().equals("SHARE")) continue;
                throw new MdException(bundle.formatString("LibraryUtil.CannotAssignShare.msg.txt", iLib.getName()));
            }
            Vector<ServerContext> lIOMServers = new Vector<ServerContext>();
            for (i = 0; i < lServers.size(); ++i) {
                ServerContext iSCx = (ServerContext)lServers.get(i);
                AssociationList lLogicals = iSCx.getUsingComponents();
                for (int j = 0; j < lLogicals.size() && !done; ++j) {
                    LogicalServer iLs = (LogicalServer)lLogicals.get(j);
                    if (iLs.getClassIdentifier().compareTo("440196D4-90F0-11D0-9F41-00A024BB830C") != 0) continue;
                    lIOMServers.add(iSCx);
                }
            }
            if (lIOMServers.size() > 0) {
                for (i = 0; i < lIOMServers.size(); ++i) {
                    if (((ServerContext)lIOMServers.get(i)).getId().compareTo(sDefaultAppServer) != 0) continue;
                    iServer = (ServerContext)lIOMServers.get(i);
                }
                if (iServer == null) {
                    iServer = (ServerContext)lIOMServers.get(0);
                }
                iRetApp = new AppServer(iServer.getObjectStore(), iServer.getId());
            } else {
                iRetApp = iDefaultApp;
                remoteToAppServer = true;
            }
        }
        if (iRetApp != null) {
            String AppServerName = iRetApp.getServerContext().getName();
            Workspace.getDefaultLogger().info("Selected AppServer: " + AppServerName);
            iRetApp.makeConnection();
            iRetApp.makeSQLConnection();
            if (parameterCode != null && parameterCode.length() > 0) {
                iRetApp.submitSrc(parameterCode);
            }
            try {
                if (remoteToAppServer) {
                    StringBuffer sCode = LibraryUtil.accessPath(iLib, iRetApp.getServerContext());
                    ServerContext iServer2 = LibraryUtil.getServer(iLib, iRetApp.getServerContext());
                    ServerSupport iServSupp = new ServerSupport(iServer2);
                    String remoteLibname = "\nlibname " + iLib.getLibref() + " REMOTE server=" + iServSupp.getHostName() + ";\n";
                    sCode.append(remoteLibname);
                    iRetApp.submitSrc(sCode.toString());
                    Workspace.getDefaultLogger().info(iRetApp.getLog().toString());
                } else {
                    iRetApp.assignLibref(iLib);
                }
            }
            catch (AppServerException appServerException) {
                // empty catch block
            }
            if (!iRetApp.isLibrefAssigned(iLib)) {
                ServerSupport.clearSignonCache();
            }
            return iRetApp;
        }
        return null;
    }

    public static StringBuffer accessPath(SASLibrary iLib, ServerContext iSCx) throws MdException, RemoteException {
        return LibraryUtil.accessPath(iLib, iSCx, null);
    }

    public static StringBuffer accessPath(SASLibrary iLib, ServerContext iSCx, List remoteMacroVars) throws MdException, RemoteException {
        return LibraryUtil.accessPath(iLib, iSCx, remoteMacroVars, true);
    }

    public static StringBuffer accessPath(SASLibrary iLib, ServerContext iSCx, List remoteMacroVars, boolean generateFileNameForXML) throws MdException, RemoteException {
        return LibraryUtil.accessPath(iLib, iSCx, remoteMacroVars, generateFileNameForXML, null);
    }

    public static StringBuffer accessPath(SASLibrary iLib, ServerContext iSCx, List remoteMacroVars, boolean generateFileNameForXML, SASCodeGeneration codegen) throws MdException, RemoteException {
        return LibraryUtil.accessPath(iLib, iSCx, remoteMacroVars, generateFileNameForXML, codegen, true);
    }

    public static StringBuffer accessPath(SASLibrary iLib, ServerContext iSCx, List remoteMacroVars, boolean generateFileNameForXML, SASCodeGeneration codegen, boolean generateReturnCodeCalls) throws MdException, RemoteException {
        StringBuffer sRetStr = new StringBuffer();
        if (iLib.getIsPreassigned() == 0) {
            if (codegen == null) {
                codegen = new SASCodeGeneration();
            }
            sRetStr.append(codegen.makeComment(bundle.formatString("LibraryUtil.LibnameComment.msg.txt", iLib.getName())));
            AssociationList lServers = iLib.getDeployedComponents();
            for (int i = 0; i < lServers.size(); ++i) {
                ServerComponent iSC = (ServerComponent)lServers.get(i);
                if (!iSC.getClassIdentifier().equals("SHARE")) continue;
                throw new MdException(bundle.formatString("LibraryUtil.CannotAssignShare.msg.txt", iLib.getName()));
            }
            Workspace.getDefaultLogger().debug("Selected Library: " + iLib.getName());
            boolean isLocal = LibraryUtil.isLibraryServerLocalToDefault(iLib, iSCx);
            ServerSupport iServerUtil = new ServerSupport(LibraryUtil.getServer(iLib, iSCx), iSCx);
            MdLibGenInterface libGen = LibraryUtil.getMdLibGenInterface(iLib, generateFileNameForXML);
            StringBuffer code = new StringBuffer(libGen.genLibname(iLib));
            if (generateReturnCodeCalls) {
                code.append(codegen.getRCSetCall("&syslibrc", false));
            }
            if (!isLocal) {
                sRetStr.append(iServerUtil.access()).append("\n");
                if (generateReturnCodeCalls) {
                    sRetStr.append(codegen.getReturnCodeRemoteSetup(iServerUtil.getHostName())).append("\n");
                }
                if (remoteMacroVars != null && !remoteMacroVars.isEmpty()) {
                    sRetStr.append(codegen.getRemoteMacroVariablesSetup(remoteMacroVars, iServerUtil.getHostName())).append("\n");
                }
                sRetStr.append(iServerUtil.startSubmit(SASCodeGeneration.SYSRPUTSYNC_YES)).append("\n");
                if (generateReturnCodeCalls) {
                    sRetStr.append(LibraryUtil.indentCode(codegen.getRCSetMacro(), 1)).append("\n");
                }
                sRetStr.append(LibraryUtil.indentCode("%macro " + LIBRARY_MACR0_NAME + ";", 1)).append("\n");
                code = LibraryUtil.indentCode(code, 2);
            }
            sRetStr.append(code).append("\n");
            if (!isLocal) {
                if (generateReturnCodeCalls) {
                    sRetStr.append(LibraryUtil.indentCode(codegen.getReturnCodeRemoteEnding(), 2)).append("\n");
                }
                sRetStr.append(LibraryUtil.indentCode("%mend " + LIBRARY_MACR0_NAME + ";", 1)).append("\n\n");
                sRetStr.append(LibraryUtil.indentCode("%" + LIBRARY_MACR0_NAME + ";", 1)).append("\n\n");
                sRetStr.append(iServerUtil.endSubmit());
            }
        }
        return sRetStr;
    }

    public static String getAccessPath(SASLibrary library, String libref) throws RemoteException, MdException {
        return LibraryUtil.getAccessPath(library, libref, LibraryUtil.isApplicationUsingEncodedPasswords(), true);
    }

    public static String getAccessPath(SASLibrary library) throws RemoteException, MdException {
        return LibraryUtil.getAccessPath(library, LibraryUtil.isApplicationUsingEncodedPasswords(), true);
    }

    public static String getAccessPath(SASLibrary library, boolean generateSeparateXMLStatement) throws RemoteException, MdException {
        return LibraryUtil.getAccessPath(library, LibraryUtil.isApplicationUsingEncodedPasswords(), generateSeparateXMLStatement);
    }

    public static String getAccessPath(SASLibrary library, boolean encodePasswords, boolean generateSeparateXMLStatement) throws RemoteException, MdException {
        return LibraryUtil.getAccessPath(library, null, encodePasswords, generateSeparateXMLStatement);
    }

    public static String getAccessPath(SASLibrary library, String libref, boolean encodePasswords, boolean generateSeparateXMLStatement) throws RemoteException, MdException {
        return LibraryUtil.getAccessPath(library, libref, encodePasswords, generateSeparateXMLStatement, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getAccessPath(SASLibrary library, String libref, boolean encodePasswords, boolean generateSeparateXMLStatement, boolean bPromptCredentials) throws RemoteException, MdException {
        UserContextInterface userContext;
        UserContextInterface userContextInterface = userContext = Workspace.getWorkspace().getUserContext();
        synchronized (userContextInterface) {
            String string;
            block8: {
                RemoteCallbackHandler handler = userContext.getChallengeCallbackHandler();
                if (!bPromptCredentials) {
                    userContext.setChallengeCallbackHandler(null);
                }
                try {
                    MdLibGenInterface mdLibGen = LibraryUtil.getMdLibGenInterface(library.getName(), encodePasswords, generateSeparateXMLStatement);
                    string = mdLibGen.genLibnameUsing(library, libref);
                    if (bPromptCredentials) break block8;
                }
                catch (Throwable throwable) {
                    if (!bPromptCredentials) {
                        userContext.setChallengeCallbackHandler(handler);
                    }
                    throw throwable;
                }
                userContext.setChallengeCallbackHandler(handler);
            }
            return string;
        }
    }

    private static boolean isApplicationUsingEncodedPasswords() {
        return true;
    }

    public static boolean isApplicationUsingAuthDomainForPasswords() {
        return Workspace.getWorkspace().getAppDefaultsFile().getPropertyBoolean("UseAuthDomainForLibraryGen", true);
    }

    public static String getConnectionOptions(SASLibrary library) throws RemoteException, MdException {
        return LibraryUtil.getConnectionOptions(library, LibraryUtil.isApplicationUsingEncodedPasswords());
    }

    public static String getConnectionOptions(SASLibrary library, boolean encodePasswords) throws RemoteException, MdException {
        MdLibGenInterface mdLibGen = LibraryUtil.getMdLibGenInterface(library.getName(), encodePasswords, true);
        return mdLibGen.genConnectionOptions(library);
    }

    public static Map getLibraryMap(SASLibrary library, String libref) throws RemoteException, MdException {
        MdLibGenInterface libInterface = LibraryUtil.getMdLibGenInterface(library);
        return libInterface.genAssignLibrefMap(library, libref);
    }

    public static MdLibGenInterface getMdLibGenInterface(SASLibrary library) throws RemoteException {
        return LibraryUtil.getMdLibGenInterface(library.getName(), LibraryUtil.isApplicationUsingEncodedPasswords(), true);
    }

    public static MdLibGenInterface getMdLibGenInterface(SASLibrary library, boolean generateFileNameForXML) throws RemoteException {
        return LibraryUtil.getMdLibGenInterface(library.getName(), LibraryUtil.isApplicationUsingEncodedPasswords(), generateFileNameForXML);
    }

    public static MdLibGenInterface getMdLibGenInterface(String name, boolean encodePasswords, boolean generateFileNameForXML) throws RemoteException {
        return LibraryUtil.getMdLibGenInterface(name, encodePasswords, generateFileNameForXML, true);
    }

    public static MdLibGenInterface getMdLibGenInterface(String name, boolean encodePasswords, boolean generateFileNameForXML, boolean useAuthDomain) throws RemoteException {
        int flags;
        int n = flags = generateFileNameForXML ? 2 : 0;
        if (LibraryUtil.isApplicationUsingEncodedPasswords()) {
            flags |= 1;
        }
        if (LibraryUtil.isApplicationUsingAuthDomainForPasswords() && useAuthDomain && Workspace.getWorkspace().isGlobalAuthDomainSupport()) {
            flags |= 8;
        }
        return MdModelUtil.getInstance((CredentialResolver)Workspace.getWorkspace().getUserContext(), (String)bundle.formatString("LibraryUtil.LibraryPrompt.txt", name), (int)flags);
    }

    public static boolean isCredentialPromptRequired(SASLibrary lib) throws RemoteException, MdException {
        if (lib == null) {
            return false;
        }
        MdLibGenInterface i = LibraryUtil.getMdLibGenInterface(lib.getName(), LibraryUtil.isApplicationUsingEncodedPasswords(), true, false);
        return i.isCredentialPromptRequired(lib);
    }

    public static PasswordAuthentication getPromptedCredentialsLibraryUserPass(SASLibrary lib) throws RemoteException, MdException {
        Object o;
        MdLibGenInterface i;
        Map m;
        if (LibraryUtil.isCredentialPromptRequired(lib) && (m = (i = LibraryUtil.getMdLibGenInterface(lib.getName(), LibraryUtil.isApplicationUsingEncodedPasswords(), true, false)).getCredentials(lib)) != null && m.containsKey("UserPass") && (o = m.get("UserPass")) instanceof PasswordAuthentication) {
            PasswordAuthentication pw = (PasswordAuthentication)o;
            try {
                pw = new PasswordAuthentication(pw.getUserName(), SasPasswordString.encode((String)"sas002", (String)new String(pw.getPassword())).toCharArray());
            }
            catch (SasPasswordEncodingException sasPasswordEncodingException) {
                // empty catch block
            }
            return pw;
        }
        return null;
    }

    private static boolean isLibraryServerLocalToDefault(SASLibrary iLib, ServerContext defaultServer) throws RemoteException, MdException {
        ServerContext iServer = LibraryUtil.getServer(iLib, defaultServer);
        ServerSupport iServerUtil = new ServerSupport(iServer, defaultServer);
        return iServerUtil.checkLocal();
    }

    public static StringBuffer getInteractiveAccessPath(SASLibrary iLib, ServerContext defaultServer) throws MdException, RemoteException, WsAppServerFailException, WsAppServerCodeException, WsAppServerLibraryException {
        return LibraryUtil.getInteractiveAccessPath(iLib, defaultServer, "");
    }

    public static StringBuffer getInteractiveAccessPath(SASLibrary iLib, ServerContext defaultServer, String parameterCode) throws MdException, RemoteException, WsAppServerFailException, WsAppServerCodeException, WsAppServerLibraryException {
        StringBuffer interactivePath = new StringBuffer();
        interactivePath.append(LibraryUtil.accessPath(iLib, defaultServer));
        if (LibraryUtil.isLibraryServerLocalToDefault(iLib, defaultServer)) {
            ServerContext iServer2 = LibraryUtil.getServer(iLib, defaultServer);
            ServerSupport iServSupp = new ServerSupport(iServer2);
            interactivePath.append("\nlibname ").append(iLib.getLibref()).append(" REMOTE ").append("server=").append(iServSupp.getHostName()).append(";\n");
        }
        Workspace.getDefaultLogger().info("libname generated = " + interactivePath);
        return interactivePath;
    }

    private static StringBuffer indentCode(StringBuffer code, int numIndents) {
        return LibraryUtil.indentCode(code.toString(), numIndents);
    }

    private static StringBuffer indentCode(String code, int numIndents) {
        String strRetCode = code;
        for (int i = 0; i < numIndents; ++i) {
            strRetCode = strRetCode.replaceAll("\n", "\n   ");
            strRetCode = "   " + strRetCode;
        }
        return new StringBuffer(strRetCode);
    }

    public static ServerContext getServer(SASLibrary iLib, ServerContext iDefaultServer) throws MdException, RemoteException {
        int i;
        ServerContext iServer = null;
        AssociationList lDeps = iLib.getDeployedComponents();
        if (lDeps.size() == 0) {
            return iDefaultServer;
        }
        for (i = 0; i < lDeps.size(); ++i) {
            iServer = (ServerContext)lDeps.get(i);
            if (!iServer.getFQID().equalsIgnoreCase(iDefaultServer.getFQID())) continue;
            return iServer;
        }
        for (i = 0; i < lDeps.size(); ++i) {
            iServer = (ServerContext)lDeps.get(i);
            AssociationList lLogicals = iServer.getUsingComponents();
            for (int j = 0; j < lLogicals.size(); ++j) {
                LogicalServer iLS = (LogicalServer)lLogicals.get(j);
                if (!iLS.getClassIdentifier().equalsIgnoreCase("028e4060-d545-11d5-880d-aa0004006d06")) continue;
                return iServer;
            }
        }
        throw new MdException(bundle.formatString("LibraryUtil.BadServerDefinition.txt", iLib.getName()));
    }

    public static SASLibrary getClientLibrary(SASLibrary iLibrary, WsAppServer iDefaultAppServer) throws MdException, RemoteException {
        ServerContext serverContext = null;
        if (iDefaultAppServer != null) {
            serverContext = iDefaultAppServer.getServerContext();
        }
        return LibraryUtil.getClientLibrary(iLibrary, serverContext);
    }

    public static SASLibrary getClientLibrary(SASLibrary iLibrary, AppServer iDefaultAppServer) throws MdException, RemoteException {
        return LibraryUtil.getClientLibrary(iLibrary, iDefaultAppServer.getServerContext());
    }

    public static SASLibrary getClientLibrary(SASLibrary iLibrary, ServerContext iDefaultServer) throws MdException, RemoteException {
        AssociationList lRemoteLibServers;
        SASLibrary iRemoteLib;
        AssociationList lServers = iLibrary.getDeployedComponents();
        boolean bIsServerLibrary = false;
        if (lServers.isEmpty()) {
            return iLibrary;
        }
        for (int i = 0; i < lServers.size(); ++i) {
            ServerComponent iSC = (ServerComponent)lServers.get(i);
            if (!iSC.getClassIdentifier().equals("SHARE")) continue;
            bIsServerLibrary = true;
        }
        if (!bIsServerLibrary) {
            return iLibrary;
        }
        AssociationList iRemoteLibs = LibraryUtil.getUsedByPackages((RelationalSchema)iLibrary);
        if (iRemoteLibs.size() == 0) {
            throw new MdException(bundle.formatString("LibraryUtil.CannotAssignShare.msg.txt", iLibrary.getName()));
        }
        if (iDefaultServer != null) {
            for (int i = 0; i < iRemoteLibs.size(); ++i) {
                iRemoteLib = (SASLibrary)iRemoteLibs.get(i);
                lRemoteLibServers = iRemoteLib.getDeployedComponents();
                for (int j = 0; j < lRemoteLibServers.size(); ++j) {
                    ServerContext iRemoteLibServer = (ServerContext)lRemoteLibServers.get(j);
                    if (!iRemoteLibServer.getId().equals(iDefaultServer.getId())) continue;
                    return iRemoteLib;
                }
            }
        }
        for (int i = 0; i < iRemoteLibs.size(); ++i) {
            iRemoteLib = (SASLibrary)iRemoteLibs.get(i);
            lRemoteLibServers = iRemoteLib.getDeployedComponents();
            if (lRemoteLibServers.size() != 0) continue;
            return iRemoteLib;
        }
        return (SASLibrary)iRemoteLibs.get(0);
    }

    public static AssociationList getUsedByPackages(RelationalSchema rSchema) {
        AssociationList usedByPackages = new AssociationList("");
        try {
            usedByPackages = rSchema.getUsedByPackages();
            if (usedByPackages.size() > 0) {
                return usedByPackages;
            }
            List metaQueryAll = null;
            String sOptions = rSchema instanceof SASLibrary ? "<XMLSelect search=\"*[UsingPackages/SASLibrary[@ID='" + rSchema.getFQID() + "']]\"/>" : "<XMLSelect search=\"*[UsingPackages/DatabaseSchema[@ID='" + rSchema.getFQID() + "']]\"/>";
            String reposID = Workspace.getWorkspace().getDefaultRepository().getFQID();
            MdObjectStore objStore = (MdObjectStore)rSchema.getObjectStore();
            boolean goToServer = objStore.isGoToServerForMetadata();
            if (!goToServer) {
                objStore.setGoToServerForMetadata(true);
            }
            metaQueryAll = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)objStore, reposID, "SASLibrary", 24704, sOptions);
            if (!goToServer) {
                objStore.setGoToServerForMetadata(false);
            }
            if (metaQueryAll.size() > 0) {
                metaQueryAll = Workspace.removeCheckouts(metaQueryAll);
            }
            usedByPackages.addAll((Collection)metaQueryAll);
        }
        catch (MdException mde) {
            usedByPackages.removeAllElements();
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException(re);
        }
        return usedByPackages;
    }

    public static SASLibrary getSASLibrary(RelationalSchema rSchema) {
        AssociationList libList = LibraryUtil.getUsedByPackages(rSchema);
        for (int i = 0; i < libList.size(); ++i) {
            DeployedDataPackage iLib = (DeployedDataPackage)libList.get(i);
            if (!(iLib instanceof SASLibrary)) continue;
            return (SASLibrary)iLib;
        }
        return null;
    }

    public static SASLibrary getSchemaLibrary(DatabaseSchema m_metadata) {
        List m_metaQueryAll = null;
        try {
            String sOptions = "<XMLSelect search=\"*[UsingPackages/DatabaseSchema[@ID='" + m_metadata.getFQID() + "']]\"/>";
            String reposID = Workspace.getWorkspace().getDefaultRepository().getFQID();
            MdObjectStore m_myStore = (MdObjectStore)m_metadata.getObjectStore();
            m_metaQueryAll = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)m_myStore, reposID, "SASLibrary", 8576, sOptions);
            if (m_metaQueryAll.size() > 0) {
                m_metaQueryAll = Workspace.removeCheckouts(m_metaQueryAll);
            }
        }
        catch (MdException mde) {
            return null;
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException(re);
        }
        if (m_metaQueryAll != null && !m_metaQueryAll.isEmpty()) {
            return (SASLibrary)m_metaQueryAll.get(0);
        }
        return null;
    }

    public static SASLibrary findLibraryForTable(AssociationList tablePackages) throws MdException, RemoteException {
        SASLibrary lib = null;
        for (int i = 0; i < tablePackages.size(); ++i) {
            AssociationList dbLibList;
            RelationalSchema tablePackage = (RelationalSchema)tablePackages.get(i);
            if (tablePackage instanceof SASLibrary) {
                lib = (SASLibrary)tablePackage;
                return lib;
            }
            if (!(tablePackage instanceof DatabaseSchema) || (lib = LibraryUtil.findLibraryForTable(dbLibList = tablePackage.getUsedByPackages())) == null) continue;
            return lib;
        }
        return lib;
    }

    private static boolean isDB2OS390Library(SASLibrary iMeta) {
        boolean isDB2OS390 = false;
        try {
            SASClientConnection iConn;
            ServerComponent sc;
            String productName;
            if (iMeta.getIsDBMSLibname() > 0 && (productName = (sc = (ServerComponent)(iConn = iMeta.getLibraryConnection()).getSource()).getProductName()).equals("DB2OS390")) {
                isDB2OS390 = true;
            }
        }
        catch (Exception e) {
            isDB2OS390 = false;
        }
        return isDB2OS390;
    }

    private static boolean checkLib4ContentServer(SASLibrary iMeta) throws RemoteException, MdException {
        ServerComponent iContentServer;
        AssociationList lContentServers;
        boolean m_bHasContentServer = false;
        AssociationList lDDP = iMeta.getUsingPackages();
        if (lDDP.size() > 0 && (lContentServers = ((DeployedDataPackage)lDDP.get(0)).getDeployedComponents()).size() > 0 && ((iContentServer = (ServerComponent)lContentServers.get(0)).getProductName().equals("Http Server") || iContentServer.getProductName().equals("Ftp Server"))) {
            m_bHasContentServer = true;
        }
        return m_bHasContentServer;
    }

    private static boolean isLocalTKTSLibrary(SASLibrary iMeta) throws RemoteException, MdException {
        SASClientConnection conn;
        boolean isLocalTKTS = false;
        if (iMeta.getIsDBMSLibname() > 0 && iMeta.getEngine().equalsIgnoreCase("FEDSVR") && (conn = iMeta.getLibraryConnection()).getApplicationProtocol().equalsIgnoreCase("TKTS") && conn.getCommunicationProtocol().equalsIgnoreCase("LOCAL")) {
            isLocalTKTS = true;
        }
        return isLocalTKTS;
    }

    private static LogicalServer getLogicalServer(DeployedComponent dc, String classID) throws MdException, RemoteException {
        AssociationList usedByList = dc.getUsedByComponents();
        Iterator usedByIt = usedByList.iterator();
        LogicalServer retVal = null;
        boolean serverFound = false;
        while (usedByIt.hasNext() && !serverFound) {
            DeployedComponent usingDc = (DeployedComponent)usedByIt.next();
            if (!(usingDc instanceof LogicalServer) || !usingDc.getClassIdentifier().equalsIgnoreCase(classID)) continue;
            retVal = (LogicalServer)usingDc;
            serverFound = true;
        }
        return retVal;
    }

    public static int resolveAuthType(Connection c, MdFactory factory) throws MdException, RemoteException {
        DeployedComponent dc = c.getSource();
        int authType = -4;
        if (dc.getProductName().equalsIgnoreCase("FEDSVR")) {
            LogicalServer ls = LibraryUtil.getLogicalServer(dc, CLASSID_TABLESERVER);
            if (ls != null) {
                String template = "<Templates><LogicalServer><Properties search=\"@PropertyName='AuthService' OR @PropertyName='SecurityPackage'\"/></LogicalServer></Templates>";
                int flags = 268;
                factory.getOMIUtil().getMetadataAllDepths((CMetadata)ls, null, null, template, flags);
                AssociationList propList = ls.getProperties(false);
                Iterator propIt = propList.iterator();
                String authService = null;
                boolean hasSecurityPackage = false;
                while (propIt.hasNext()) {
                    Property p = (Property)propIt.next();
                    if (p.getPropertyName().equalsIgnoreCase("AuthService")) {
                        authService = p.getDefaultValue();
                        continue;
                    }
                    if (!p.getPropertyName().equalsIgnoreCase("SecurityPackage")) continue;
                    hasSecurityPackage = true;
                }
                authType = authService != null ? (authService.equalsIgnoreCase("Metadata") ? -1 : (authService.equalsIgnoreCase("Prompt") ? -3 : (authService.equalsIgnoreCase("Host") ? (hasSecurityPackage ? -1 : -2) : -4))) : -2;
            }
        } else {
            String cAuthType = c.getAuthenticationType();
            authType = cAuthType.equalsIgnoreCase("none") ? -1 : (cAuthType.equalsIgnoreCase("user/password") ? -2 : (cAuthType.equalsIgnoreCase("prompt") ? -3 : -4));
        }
        return authType;
    }

    public static boolean requiresPromptForCrendentials(SASLibrary iMeta) throws MdException, RemoteException, ServiceException {
        boolean requiresCredentials = false;
        if (iMeta.getIsDBMSLibname() > 0) {
            requiresCredentials = true;
            SASClientConnection iDbms = iMeta.getLibraryConnection();
            if (iDbms == null) {
                throw new MdException(bundle.getString("LibraryUtil.ConnectionRequired.msg.txt"));
            }
            if (iMeta.getEngine().equalsIgnoreCase("SASIOIME")) {
                requiresCredentials = false;
            }
            boolean m_bIsRemote = iMeta.getEngine().toUpperCase().startsWith("REMOTE") && iMeta.getIsDBMSLibname() > 0;
            boolean isSPDS = false;
            boolean isTKTS = false;
            if (iMeta.getEngine().equalsIgnoreCase("SASSPDS")) {
                isSPDS = true;
            } else if (iMeta.getEngine().equalsIgnoreCase("FEDSVR")) {
                isTKTS = true;
            }
            if (requiresCredentials && !isTKTS && !isSPDS && !m_bIsRemote) {
                requiresCredentials = true;
            } else if (requiresCredentials && (isTKTS || isSPDS || m_bIsRemote)) {
                requiresCredentials = true;
            }
        }
        if (!requiresCredentials) {
            return false;
        }
        Object pw = null;
        String authDomStr = null;
        boolean needsCredentials = !LibraryUtil.isDB2OS390Library(iMeta);
        SASClientConnection iConn = null;
        if (iMeta.getIsDBMSLibname() == 0) {
            boolean m_bHasContentServer = LibraryUtil.checkLib4ContentServer(iMeta);
            if (m_bHasContentServer) {
                DeployedDataPackage temp = (DeployedDataPackage)iMeta.getUsingPackages().get(0);
                Directory iDir = null;
                if (!(temp instanceof Directory)) {
                    throw new MdException(bundle.getString("LibraryUtil.WebDAVPath.msg.txt"));
                }
                iDir = (Directory)temp;
                ServerComponent iContentServer = (ServerComponent)iDir.getDeployedComponents().get(0);
                iConn = (Connection)iContentServer.getSourceConnections().get(0);
            }
        } else {
            iConn = iMeta.getLibraryConnection();
        }
        if (needsCredentials && LibraryUtil.isLocalTKTSLibrary(iMeta)) {
            return false;
        }
        if (needsCredentials) {
            AuthenticationDomain iDom = iConn.getDomain();
            MdObjectStore store = (MdObjectStore)iMeta.getObjectStore();
            MdFactory factory = store.getFactory();
            int authType = LibraryUtil.resolveAuthType((Connection)iConn, factory);
            switch (authType) {
                case -3: 
                case -2: {
                    List creds;
                    if (iDom != null) {
                        authDomStr = iDom.getName();
                    }
                    if (iDom == null || authDomStr.isEmpty() || null == (creds = LibraryUtil.getNoncachedCredentials(authDomStr)) || !creds.isEmpty()) break;
                    return true;
                }
            }
        }
        return false;
    }

    public static List getNoncachedCredentials(String domain) throws ServiceException, MdException, RemoteException {
        OMIServer server = Workspace.getWorkspace().getConnectionManager().getMetadataServer();
        return null != server ? server.getLoginsForAuthDomain(domain) : null;
    }

    private static String getDomain(SASLibrary iMeta) throws RemoteException, MdException {
        SASClientConnection iConn = iMeta.getLibraryConnection();
        return iConn.getDomain().getName();
    }

    public static PasswordAuthentication getPasswordAuthentication(String strUserID, String strPassword) {
        PasswordAuthentication credentials = new PasswordAuthentication(strUserID, strPassword.toCharArray());
        return credentials;
    }
}

