/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.iom.SAS.IDataService;
import com.sas.iom.SAS.ILanguageService;
import com.sas.iom.SAS.ILanguageServicePackage.CarriageControlSeqHolder;
import com.sas.iom.SAS.ILanguageServicePackage.LineTypeSeqHolder;
import com.sas.iom.SAS.ILibref;
import com.sas.iom.SAS.IWorkspace;
import com.sas.iom.SASEvents.ILanguageEventsHelper;
import com.sas.iom.SASEvents._ILanguageEventsImplBase;
import com.sas.iom.SASIOMDefs.CP_ID;
import com.sas.iom.SASIOMDefs.ConnectionPoint;
import com.sas.iom.SASIOMDefs.ConnectionPointContainer;
import com.sas.iom.SASIOMDefs.ConnectionPointContainerHelper;
import com.sas.iom.SASIOMDefs.ConnectionPointHolder;
import com.sas.iom.SASIOMDefs.LongSeqHolder;
import com.sas.iom.SASIOMDefs.StringSeqHolder;
import com.sas.iom.SASIOMDefs.VariableArray2dOfLongHolder;
import com.sas.iom.SASIOMDefs.VariableArray2dOfStringHolder;
import com.sas.meta.SASOMI.IOMI;
import com.sas.meta.SASOMI.ISecurityPackage.InvalidCredHandle;
import com.sas.meta.SASOMI.ISecurity_1_1Package.AuthDomainDoesNotExist;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.Connection;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.DatabaseSchema;
import com.sas.metadata.remote.DeployedDataPackage;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.File;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdServerStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.RelationalSchema;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.SASPassword;
import com.sas.metadata.remote.ServerContext;
import com.sas.metadata.remote.TCPIPConnection;
import com.sas.rio.MVAConnection;
import com.sas.rio.MVAResultSet;
import com.sas.rio.MVAStatement;
import com.sas.services.connection.ExpiredCredentialsException;
import com.sas.services.connection.FatalConnectionFactoryException;
import com.sas.services.connection.LoginException;
import com.sas.util.ChainedException;
import com.sas.workspace.AppServerCodeErrorException;
import com.sas.workspace.AppServerException;
import com.sas.workspace.AppServerPasswordDialog;
import com.sas.workspace.DBMSNamesPropertyHandler;
import com.sas.workspace.DBMSNamesUtil;
import com.sas.workspace.IOMWorkspaceUtil;
import com.sas.workspace.LibraryUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.visuals.LogonView;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.text.Format;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.INV_OBJREF;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.Object;

public class AppServer {
    private static WAdminResource bundle = WAdminResource.getBundle(AppServer.class);
    protected HashMap m_SCMap;
    protected ArrayList m_populatedSC;
    protected ArrayList m_reposSC;
    protected PhysicalTable m_PhysTable;
    protected SASLibrary m_Library;
    protected File m_EFile;
    protected ServerContext m_ServerContext;
    protected LogicalServer m_LogicalServer;
    protected Workspace m_workspace;
    protected IWorkspace m_sasWorkspace;
    protected java.sql.Connection m_sqlConnection;
    protected MVAStatement m_sqlStmt;
    protected MVAResultSet m_rsltSet;
    protected ILanguageService m_sasLanguage;
    protected Boolean m_sasSubmitRunning;
    protected boolean m_operationComplete;
    protected IDataService m_rio;
    protected MdObjectStore m_store;
    protected boolean m_bLocalStore = false;
    private String m_userID = null;
    private String m_password = null;
    private static ConnectionPoint m_cpC;
    private static int m_handle;
    private static boolean m_codeError;
    private boolean m_CloseOnError = true;
    protected CarriageControlSeqHolder m_logCCHolder;
    protected LineTypeSeqHolder m_logTypeHolder;
    protected StringSeqHolder m_logLinesHolder;
    protected CarriageControlSeqHolder m_listCCHolder;
    protected LineTypeSeqHolder m_listTypeHolder;
    protected StringSeqHolder m_listLinesHolder;
    protected int m_status;
    protected String m_statusMsg;
    protected String m_2ndStatusMsg;
    public static final String WORKSPACECLASSID = "440196D4-90F0-11D0-9F41-00A024BB830C";
    public static final int MAX_STATUS_ERROR = 10;
    public static final int STATUS_OK = 0;
    public static final int STATUS_NoDCObj = 1;
    public static final int STATUS_NoConnObj = 2;
    public static final int STATUS_NoWSConf = 3;
    public static final int STATUS_NoPort = 4;
    public static final int STATUS_NoLoginObj = 5;
    public static final int STATUS_NoUserid = 6;
    public static final int STATUS_NoPassword = 7;
    public static final int STATUS_NoDCMetadata = 8;
    public static final int STATUS_NoServer = 9;
    public static final int STATUS_ConnFailed = 10;
    public static final int STATUS_SubmitFailed = 11;
    public static final int STATUS_SubmitCancelled = 12;
    public static final int STATUS_NoLogFetch = 13;
    public static final int STATUS_NoListFetch = 14;
    public static final int STATUS_NoLibAssign = 20;
    public static final int STATUS_NoSQLConn = 21;
    public static final int STATUS_TblOpenFail = 22;
    public static final int STATUS_TblClosFail = 23;
    public static final int STATUS_NoLibFound = 24;
    public static final int STATUS_NoLibAssign2 = 25;
    public static final int STATUS_SQLQryFail = 26;
    public static final int STATUS_SQLAbrtConn = 27;
    public static final int STATUS_TblOpenFail2 = 28;
    public static final int STATUS_ConnClosFail = 29;
    public static final int STATUS_CodeError = 30;
    public static final int STATUS_AttemptLimitReached = 31;
    public static final int STATUS_ConnectCancelled = 32;
    public static final int STATUS_BadServer = 33;
    public static final int Status_ExpiredCredentials = 34;
    public static final int STATUS_Abort = 35;

    public AppServer() {
        this._initialize();
        try {
            this.m_store = Workspace.getMdFactory().createObjectStore();
            this.m_bLocalStore = true;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
    }

    public AppServer(MdStore owningStore) {
        this._initialize();
        if (owningStore instanceof MdObjectStore) {
            this.m_store = (MdObjectStore)owningStore;
        } else if (owningStore instanceof MdServerStore) {
            try {
                this.m_store = Workspace.getMdFactory().createObjectStore();
                this.m_bLocalStore = true;
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException(ex);
            }
        }
    }

    public AppServer(String serverContextId, String userLoginId, String userPassword) {
        this._initialize();
        try {
            this.m_store = Workspace.getMdFactory().createObjectStore();
            this.m_bLocalStore = true;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
        this.setServerContext(serverContextId);
        this.m_userID = userLoginId;
        this.m_password = userPassword;
    }

    public AppServer(MdStore owningStore, String serverContextId, String userLoginId, String userPassword) {
        this._initialize();
        if (owningStore instanceof MdObjectStore) {
            this.m_store = (MdObjectStore)owningStore;
        } else if (owningStore instanceof MdServerStore) {
            try {
                this.m_store = Workspace.getMdFactory().createObjectStore();
                this.m_bLocalStore = true;
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException(ex);
            }
        }
        this.setServerContext(serverContextId);
        this.m_userID = userLoginId;
        this.m_password = userPassword;
    }

    public AppServer(String serverContextId) {
        this._initialize();
        try {
            this.m_store = Workspace.getMdFactory().createObjectStore();
            this.m_bLocalStore = true;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
        this.setServerContext(serverContextId);
    }

    public AppServer(MdStore owningStore, String serverContextId) {
        this._initialize();
        if (owningStore instanceof MdObjectStore) {
            this.m_store = (MdObjectStore)owningStore;
        } else if (owningStore instanceof MdServerStore) {
            try {
                this.m_store = Workspace.getMdFactory().createObjectStore();
                this.m_bLocalStore = true;
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException(ex);
            }
        }
        this.setServerContext(serverContextId);
    }

    public AppServer(PhysicalTable physTable) {
        this._initialize();
        try {
            MdStore tableStore = physTable.getObjectStore();
            if (tableStore instanceof MdObjectStore) {
                this.m_store = (MdObjectStore)tableStore;
            } else {
                this.m_store = Workspace.getMdFactory().createObjectStore();
                this.m_bLocalStore = true;
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
        this.setServerContext(physTable);
    }

    public AppServer(IWorkspace iWorkspace) {
        this.m_sasWorkspace = iWorkspace;
    }

    private void _initialize() {
        this.m_workspace = Workspace.getWorkspace();
        this.m_SCMap = new HashMap();
        this.m_populatedSC = new ArrayList();
    }

    private void initReposSCList() {
        List vRepos = this.m_workspace.getSelectedRepositories();
        try {
            for (int i = 0; i < vRepos.size(); ++i) {
                CMetadata repos = (CMetadata)vRepos.get(i);
                String sOptions = "";
                List vSCList = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)this.m_store, repos.getFQID(), "ServerContext", 396, sOptions);
                for (int j = 0; j < vSCList.size(); ++j) {
                    this.m_reposSC.add(vSCList.get(j));
                }
            }
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().error((java.lang.Object)"", e);
        }
    }

    private void getMetadata(ServerContext scObj) throws MdException, RemoteException {
        Vector inSimpleAttr = new Vector();
        Vector inComplexAttr = new Vector();
        Vector vecTemplate = new Vector();
        StringBuffer inXMLTemplate = new StringBuffer();
        int fOptions = this.createServerContextXML(inSimpleAttr, inComplexAttr, vecTemplate);
        int nTemplates = vecTemplate.size();
        if (nTemplates > 0) {
            inXMLTemplate.append("<TEMPLATES>");
            for (int i = 0; i < nTemplates; ++i) {
                inXMLTemplate.append(vecTemplate.elementAt(i));
            }
            inXMLTemplate.append("</TEMPLATES>");
        }
        try {
            scObj = (ServerContext)Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)scObj, inSimpleAttr, inComplexAttr, inXMLTemplate.toString(), fOptions);
        }
        catch (MdException mdE) {
            throw mdE;
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException(re);
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().error((java.lang.Object)"", e);
        }
    }

    private int createServerContextXML(Vector inSimpleAttr, Vector inComplexAttr, Vector inTemplate) {
        inComplexAttr.add("UsingComponents");
        inTemplate.add("<TCPIPConnection><Domain/></TCPIPConnection>");
        inTemplate.add("<DeployedComponent><UsingComponents/><SourceConnections/></DeployedComponent>");
        return 28;
    }

    private PhysicalTable getMetadata(PhysicalTable ptObj) {
        try {
            Vector inSimpleAttr = new Vector();
            Vector<String> inComplexAttr = new Vector<String>(3);
            StringBuffer inXMLTemplate = new StringBuffer();
            int fOptions = 28;
            inComplexAttr.add("TablePackage");
            inComplexAttr.add("SASPasswords");
            inComplexAttr.add("Properties");
            inComplexAttr.add("Columns");
            inXMLTemplate.append("<TEMPLATES>");
            inXMLTemplate.append("<Property/>");
            inXMLTemplate.append("<SASLibrary><Properties/><DeployedComponents/><UsingPackages/></SASLibrary>");
            inXMLTemplate.append("<RelationalSchema><DeployedComponents/><UsingPackages/></RelationalSchema>");
            Vector dcSimple = new Vector();
            Vector dcComplex = new Vector();
            Vector dcTemplate = new Vector();
            fOptions |= this.createServerContextXML(dcSimple, dcComplex, dcTemplate);
            inXMLTemplate.append(Workspace.getMdFactory().getOMIUtil().createGetXMLString("ServerContext", null, dcSimple, dcComplex));
            for (int i = 0; i < dcTemplate.size(); ++i) {
                inXMLTemplate.append(dcTemplate.elementAt(i));
            }
            inXMLTemplate.append("</TEMPLATES>");
            ptObj = (PhysicalTable)Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)ptObj, inSimpleAttr, inComplexAttr, inXMLTemplate.toString(), fOptions);
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().error((java.lang.Object)"", e);
        }
        return ptObj;
    }

    private void setAssociations() {
        try {
            this.m_LogicalServer = null;
            AssociationList logservs = this.m_ServerContext.getUsingComponents();
            for (int i = 0; i < logservs.size(); ++i) {
                LogicalServer ls = (LogicalServer)logservs.get(i);
                if (!ls.getClassIdentifier().equals(WORKSPACECLASSID)) continue;
                this.m_LogicalServer = ls;
                break;
            }
        }
        catch (MdException mde) {
            Workspace.getDefaultLogger().error((java.lang.Object)"", mde);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException(re);
        }
    }

    public void testConnection() throws AppServerException {
        this.makeConnection();
        try {
            IOMWorkspaceUtil.closeIOMConnection(this.m_sasWorkspace);
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().error((java.lang.Object)"", e);
        }
        finally {
            this.m_sasWorkspace = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConnection(String machine, String port, String userid, String password) throws AppServerException {
        try {
            this.m_sasWorkspace = Workspace.getMdFactory().getConnection().makeIOMConnection(machine, port, userid, password);
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().error((java.lang.Object)"", e);
            this.setStatus(10, e.getMessage());
        }
        finally {
            this.postCompletion();
        }
        try {
            IOMWorkspaceUtil.closeIOMConnection(this.m_sasWorkspace);
            this.m_sasWorkspace = null;
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().error((java.lang.Object)"", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IWorkspace makeConnection() throws AppServerException {
        this.m_sasWorkspace = null;
        this.determineStatus();
        boolean done = false;
        int retries = 0;
        while (!done) {
            try {
                IOMI iOMI = Workspace.getMdFactory().getConnection().getCMRHandle();
                if (this.m_userID == null || this.m_userID.length() == 0) {
                    this.m_userID = Workspace.getWorkspace().getAppServerUserID(this.m_LogicalServer.getId());
                    this.m_password = Workspace.getWorkspace().getAppServerPassword(this.m_LogicalServer.getId());
                }
                this.m_sasWorkspace = IOMWorkspaceUtil.makeIOMConnection(iOMI, this.m_ServerContext, this.m_userID, this.m_password);
                done = true;
                Workspace.getWorkspace().setAppServerUserID(this.m_userID, this.m_LogicalServer.getId());
                Workspace.getWorkspace().setAppServerPassword(this.m_password, this.m_LogicalServer.getId());
            }
            catch (Exception e) {
                try {
                    if (e instanceof ExpiredCredentialsException) {
                        done = true;
                        this.setStatus(34);
                        continue;
                    }
                    if (e instanceof LoginException || e instanceof AuthDomainDoesNotExist || e instanceof InvalidCredHandle) {
                        String message = retries == 0 ? bundle.formatString("AppServer.LoginMessage.txt", this.m_ServerContext.getName()) : bundle.formatString("AppServer.LoginMessageWithError.txt", this.m_ServerContext.getName());
                        if (retries < 4) {
                            String userid = Workspace.getWorkspace().getAppServerUserID(this.m_LogicalServer.getId());
                            String password = Workspace.getWorkspace().getAppServerPassword(this.m_LogicalServer.getId());
                            cPasswordPrompt pw = new cPasswordPrompt(message, userid, password);
                            if (SwingUtilities.isEventDispatchThread()) {
                                pw.run();
                            } else {
                                try {
                                    SwingUtilities.invokeAndWait(pw);
                                }
                                catch (InvocationTargetException ex) {
                                    Workspace.getDefaultLogger().error((java.lang.Object)"", e);
                                }
                                catch (InterruptedException ex) {
                                    Workspace.getDefaultLogger().error((java.lang.Object)"", e);
                                }
                            }
                            Vector vCredentials = new Vector();
                            if (pw.getReturnCode(vCredentials) == 0) {
                                this.m_userID = (String)vCredentials.get(0);
                                this.m_password = (String)vCredentials.get(1);
                            } else {
                                done = true;
                                this.setStatus(32);
                            }
                            ++retries;
                            continue;
                        }
                        done = true;
                        this.setStatus(31);
                        continue;
                    }
                    if (e instanceof FatalConnectionFactoryException) {
                        done = true;
                        FatalConnectionFactoryException fcfe = (FatalConnectionFactoryException)e;
                        if (ChainedException.chainContains((Throwable)fcfe, INV_OBJREF.class)) {
                            done = true;
                            this.setStatus(33, new java.lang.Object[]{this.m_ServerContext.getName()});
                        } else if (ChainedException.chainContains((Throwable)fcfe, COMM_FAILURE.class)) {
                            done = true;
                            this.setStatus(9, ChainedException.getRootException((Throwable)e).getMessage());
                        }
                        this.setStatus(10, ChainedException.getRootException((Throwable)e).getMessage());
                        continue;
                    }
                    done = true;
                    this.setStatus(10, ChainedException.getRootException((Throwable)e).getMessage());
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            finally {
                if (!done) continue;
                this.postCompletion();
            }
        }
        return this.m_sasWorkspace;
    }

    public void dropConnection() {
        if (this.m_sasWorkspace != null) {
            try {
                IOMWorkspaceUtil.closeIOMConnection(this.m_sasWorkspace);
            }
            catch (Exception e) {
                Workspace.getDefaultLogger().error((java.lang.Object)"Couldn't close workspace", e);
            }
            this.m_sasWorkspace = null;
        }
    }

    public void setStore(MdObjectStore inStore) {
        if (this.m_bLocalStore) {
            try {
                this.m_store.dispose();
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException(ex);
            }
        }
        this.m_bLocalStore = false;
        this.m_store = inStore;
    }

    public MdObjectStore getStore() {
        return this.m_store;
    }

    public void termAppServer() {
        if (this.m_PhysTable != null) {
            this.closeJDBCTable();
        }
        if (this.m_sqlConnection != null || this.m_sqlStmt != null) {
            this.dropSQLConnection();
        }
        if (this.m_sasWorkspace != null) {
            this.dropConnection();
        }
        if (this.m_reposSC != null) {
            this.m_reposSC = null;
        }
        if (this.m_bLocalStore) {
            try {
                this.m_store.dispose();
            }
            catch (Exception e) {
                Workspace.getDefaultLogger().error((java.lang.Object)"", e);
            }
        }
    }

    public int determineStatus() {
        int newStatus = 0;
        if (this.m_ServerContext == null) {
            newStatus = 1;
        } else if (this.m_LogicalServer == null) {
            newStatus = 3;
        }
        this.setStatus(newStatus);
        return this.m_status;
    }

    public void setSASLibrary(SASLibrary inLibrary) {
        this.m_Library = inLibrary;
    }

    public void setPhysicalTable(PhysicalTable table) throws MdException, RemoteException {
        this.m_PhysTable = table;
        this.setSASLibrary();
    }

    private void setSASLibrary() throws MdException, RemoteException {
        AssociationList schemaList = this.m_PhysTable.getTablePackages();
        DeployedDataPackage ddp = null;
        DatabaseSchema dSchema = null;
        this.m_Library = this.findLibrary(schemaList);
        if (this.m_Library == null) {
            for (int k = 0; k < schemaList.size(); ++k) {
                ddp = (DeployedDataPackage)schemaList.get(k);
                if (!(ddp instanceof DatabaseSchema)) continue;
                dSchema = (DatabaseSchema)ddp;
                SASLibrary oLibrary = this.getSchemaLibrary(dSchema);
                if ((oLibrary = LibraryUtil.getClientLibrary(oLibrary, this)) == null) continue;
                this.m_Library = oLibrary;
                break;
            }
        }
    }

    public SASLibrary getSASLibrary() {
        return this.m_Library;
    }

    public String getAssignedLibref() {
        try {
            String strLibref;
            String strAssignedLibref = strLibref = this.m_Library.getLibref();
            boolean alreadyAssigned = this.isLibrefAssigned(strAssignedLibref);
            if (!alreadyAssigned) {
                try {
                    strAssignedLibref = this.assignLibref(this.m_Library);
                }
                catch (Exception ge) {
                    Workspace.getDefaultLogger().error((java.lang.Object)"", ge);
                    this.dropSQLConnection();
                    this.setStatus(20, new java.lang.Object[]{strLibref, this.m_Library.getName()}, ge.getMessage());
                    return null;
                }
            }
            return strAssignedLibref;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
            return null;
        }
    }

    public void clearLibref(String strLibref) {
        try {
            this.m_rio.UseLibref(strLibref);
            this.m_rio.DeassignLibref(strLibref);
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().error((java.lang.Object)"", e);
        }
    }

    public void clearLibref(SASLibrary iLib) {
        String strLibref;
        try {
            strLibref = iLib.getLibref();
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().error((java.lang.Object)"", e);
            return;
        }
        this.clearLibref(strLibref);
    }

    protected void setStatus(int newStatus) {
        this.m_status = newStatus;
        this.setStatusMsg(null);
    }

    public void resetStatus() {
        this.m_status = 0;
        this.setStatusMsg(null);
    }

    protected void setStatus(int newStatus, java.lang.Object[] subStrs) {
        this.m_status = newStatus;
        this.setStatusMsg(subStrs);
    }

    protected void setStatus(int newStatus, String str2ndMsg) {
        this.m_2ndStatusMsg = str2ndMsg;
        this.setStatus(newStatus);
    }

    protected void setStatus(int newStatus, java.lang.Object[] subStrs, String str2ndMsg) {
        this.m_2ndStatusMsg = str2ndMsg;
        this.setStatus(newStatus, subStrs);
    }

    private void setStatusMsg(java.lang.Object[] subStrs) {
        if (this.m_status != 0) {
            java.lang.Object message;
            String msgName = "AppServer.Status.Msg" + String.valueOf(this.m_status) + ".txt";
            String format = bundle.getString(msgName);
            if (subStrs == null) {
                this.m_statusMsg = format;
            } else {
                message = new MessageFormat(format);
                this.m_statusMsg = ((Format)message).format(subStrs);
            }
            message = this.getFullStatusMsg();
            if (this.m_status == 3) {
                try {
                    this.m_statusMsg = message = bundle.formatString(msgName, this.m_ServerContext.getName());
                }
                catch (RemoteException ex) {
                    Workspace.handleRemoteException(ex);
                    this.m_statusMsg = message = bundle.getString(msgName);
                }
            } else if (this.m_status > 10) {
                if (this.m_status == 30) {
                    Workspace.getDefaultLogger().error(this.getLog().toString());
                    throw new AppServerCodeErrorException((String)message);
                }
                if (this.m_status == 11) {
                    throw new AppServerCodeErrorException((String)message);
                }
                if (this.m_status == 35) {
                    throw new AppServerCodeErrorException((String)message);
                }
                this.m_status = 0;
                this.m_statusMsg = null;
                this.m_2ndStatusMsg = null;
            }
            throw new AppServerException((String)message);
        }
        this.m_statusMsg = bundle.getString("AppServer.Status.OK.txt");
    }

    public int getStatus() {
        return this.m_status;
    }

    public String getFullStatusMsg() {
        StringBuffer strBuf = new StringBuffer(128);
        if (this.m_statusMsg != null) {
            strBuf.append(this.m_statusMsg);
        }
        if (this.m_2ndStatusMsg != null) {
            strBuf.append("  ");
            strBuf.append(this.m_2ndStatusMsg);
        }
        return strBuf.toString();
    }

    public String getStatusMsg() {
        return this.m_statusMsg;
    }

    public String getStatusMsg2() {
        return this.m_2ndStatusMsg;
    }

    public synchronized void postCompletion() {
        this.m_operationComplete = true;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int submitSrc(String sasStmts) throws AppServerException {
        this.m_operationComplete = false;
        m_codeError = false;
        if (!this.m_CloseOnError) {
            this.m_status = 0;
        }
        this.m_sasSubmitRunning = new Boolean(false);
        boolean fDropConnection = false;
        if (this.m_sasWorkspace == null) {
            this.m_sasWorkspace = this.makeConnection();
            fDropConnection = true;
        }
        this.m_sasLanguage = this.m_sasWorkspace.LanguageService();
        m_cpC = AppServer.getConnectionPoint(this.m_sasLanguage);
        m_handle = AppServer.registerLanguageListener(new ILanguageEventsListener(), m_cpC);
        try {
            Boolean bl = this.m_sasSubmitRunning;
            synchronized (bl) {
                this.m_sasSubmitRunning = Boolean.TRUE;
            }
            this.m_sasLanguage.Submit(sasStmts);
            this.waitForCompletion();
        }
        catch (Exception ge) {
            if (ge instanceof OBJECT_NOT_EXIST) {
                this.setStatus(35, ge.getLocalizedMessage());
            } else {
                this.setStatus(11, ge.getLocalizedMessage());
            }
        }
        finally {
            Boolean ge = this.m_sasSubmitRunning;
            synchronized (ge) {
                this.m_sasSubmitRunning = Boolean.FALSE;
                AppServer.unregisterLanguageListener();
            }
            if ((this.m_status != 30 || this.m_CloseOnError) && this.m_status != 0) {
                if (this.m_status != 35) {
                    this.dropConnection();
                } else {
                    this.m_sasWorkspace = null;
                }
                this.postCompletion();
            }
        }
        this.m_logCCHolder = new CarriageControlSeqHolder();
        this.m_logTypeHolder = new LineTypeSeqHolder();
        this.m_logLinesHolder = new StringSeqHolder();
        try {
            this.m_sasLanguage.FlushLogLines(Integer.MAX_VALUE, this.m_logCCHolder, this.m_logTypeHolder, this.m_logLinesHolder);
        }
        catch (Exception ge) {
            this.setStatus(13, ge.getMessage());
        }
        this.m_listCCHolder = new CarriageControlSeqHolder();
        this.m_listTypeHolder = new LineTypeSeqHolder();
        this.m_listLinesHolder = new StringSeqHolder();
        try {
            this.m_sasLanguage.FlushListLines(Integer.MAX_VALUE, this.m_listCCHolder, this.m_listTypeHolder, this.m_listLinesHolder);
        }
        catch (Exception ge) {
            this.setStatus(14, ge.getMessage());
        }
        this.m_sasLanguage = null;
        if (fDropConnection) {
            this.dropConnection();
        }
        this.postCompletion();
        if (m_codeError) {
            this.setStatus(30);
        }
        if (this.m_status != 0) {
            throw new AppServerException(this.getFullStatusMsg());
        }
        return 0;
    }

    public void setCloseOnError(boolean bDoTheClose) {
        this.m_CloseOnError = bDoTheClose;
    }

    public StringSeqHolder getLogLinesHolder() {
        return this.m_logLinesHolder;
    }

    public LineTypeSeqHolder getLogTypeHolder() {
        return this.m_logTypeHolder;
    }

    public CarriageControlSeqHolder getLogCCHolder() {
        return this.m_logCCHolder;
    }

    public StringSeqHolder getListLinesHolder() {
        return this.m_listLinesHolder;
    }

    public StringBuffer getLog() {
        StringBuffer strLog = new StringBuffer();
        String[] lines = this.m_logLinesHolder.value;
        for (int i = 0; i < lines.length; ++i) {
            strLog.append(lines[i] + '\n');
        }
        return strLog;
    }

    public StringBuffer getList() {
        StringBuffer strList = new StringBuffer();
        String[] lines = this.m_listLinesHolder.value;
        for (int i = 0; i < lines.length; ++i) {
            strList.append(lines[i] + '\n');
        }
        return strList;
    }

    public java.sql.Connection getSQLConnection() {
        return this.m_sqlConnection;
    }

    public String getConnectionHostName() {
        return "No Data Here!";
    }

    public LineTypeSeqHolder getListTypeHolder() {
        return this.m_listTypeHolder;
    }

    public CarriageControlSeqHolder getListCCHolder() {
        return this.m_listCCHolder;
    }

    public ArrayList getReposServerContexts() {
        if (this.m_reposSC == null) {
            this.m_reposSC = new ArrayList();
            this.initReposSCList();
        }
        return this.m_reposSC;
    }

    public void clearReposServerContexts() {
        this.m_reposSC = null;
        this.m_ServerContext = null;
    }

    public ServerContext getServerContext() {
        return this.m_ServerContext;
    }

    public void setServerContext(ServerContext scObj) throws AppServerException {
        try {
            this.setServerContext(scObj != null ? scObj.getFQID() : "");
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
    }

    public ServerContext setServerContext(String strSCId) throws AppServerException {
        try {
            if (this.m_ServerContext != null && strSCId.compareTo(this.m_ServerContext.getFQID()) == 0) {
                return this.m_ServerContext;
            }
            this.m_ServerContext = null;
            boolean fSeenBefore = true;
            ServerContext scObj = (ServerContext)this.m_SCMap.get(strSCId);
            if (scObj == null) {
                fSeenBefore = false;
                scObj = (ServerContext)Workspace.getMdFactory().createComplexMetadataObject(this.m_store, null, "", "ServerContext", strSCId);
            }
            if (!this.m_populatedSC.contains(scObj)) {
                try {
                    this.getMetadata(scObj);
                    this.m_populatedSC.add(scObj);
                    if (!fSeenBefore) {
                        this.m_SCMap.put(scObj.getFQID(), scObj);
                    }
                }
                catch (Exception ge) {
                    this.setStatus(8, new java.lang.Object[]{scObj.getName(), scObj.getFQID()}, ge.getMessage());
                }
            }
            this.m_ServerContext = scObj;
            this.setAssociations();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
        return this.m_ServerContext;
    }

    public ServerContext setServerContext(PhysicalTable physTable) {
        this.m_PhysTable = physTable = this.getMetadata(physTable);
        String serverContextId = "";
        Vector scVector = this.getBestDeployment(physTable);
        if (scVector != null) {
            this.m_Library = (SASLibrary)scVector.elementAt(0);
            ServerContext sc = (ServerContext)scVector.elementAt(1);
            try {
                serverContextId = sc.getFQID();
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException(ex);
            }
        }
        return this.setServerContext(serverContextId);
    }

    public void setLogin(String strUserid, String strPassword) {
        this.m_userID = strUserid;
        this.m_password = strPassword;
    }

    public void updateMetadataAll() {
        try {
            this.m_ServerContext.updateMetadataAll();
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().error((java.lang.Object)"", e);
        }
    }

    public MVAResultSet openJDBCTable(PhysicalTable physTable) throws AppServerException {
        this.getMetadata(physTable);
        try {
            String strAssignedLibref;
            boolean alreadyAssigned;
            String strTable = physTable.getSASTableName();
            if (this.m_Library == null) {
                AssociationList schemaList = physTable.getTablePackages();
                DeployedDataPackage ddp = null;
                DatabaseSchema dSchema = null;
                this.m_Library = this.findLibrary(schemaList);
                if (this.m_Library == null) {
                    for (int k = 0; k < schemaList.size(); ++k) {
                        ddp = (DeployedDataPackage)schemaList.get(k);
                        if (!(ddp instanceof DatabaseSchema)) continue;
                        dSchema = (DatabaseSchema)ddp;
                        SASLibrary oLibrary = this.getSchemaLibrary(dSchema);
                        if ((oLibrary = LibraryUtil.getClientLibrary(oLibrary, this)) == null) continue;
                        this.m_Library = oLibrary;
                        break;
                    }
                }
            }
            if (this.m_Library == null) {
                this.setStatus(24, new java.lang.Object[]{physTable.getName()});
            }
            String strLibref = this.m_Library.getLibref();
            if (this.m_sqlConnection == null) {
                this.makeSQLConnection();
            }
            if (!(alreadyAssigned = this.isLibrefAssigned(strAssignedLibref = strLibref))) {
                try {
                    strAssignedLibref = this.assignLibref(this.m_Library);
                }
                catch (Exception ge) {
                    Workspace.getDefaultLogger().error((java.lang.Object)"", ge);
                    this.dropSQLConnection();
                    this.setStatus(20, new java.lang.Object[]{strLibref, this.m_Library.getName()}, ge.getMessage());
                }
            }
            String[] sasPasswords = new String[3];
            AssociationList passList = physTable.getSASPasswords(false);
            for (int i = 0; i < passList.size(); ++i) {
                SASPassword passObj = (SASPassword)passList.elementAt(i);
                String strType = passObj.getType();
                if (strType.compareTo("ALL") == 0) {
                    sasPasswords[1] = sasPasswords[2] = passObj.getPassword();
                    sasPasswords[0] = sasPasswords[2];
                    continue;
                }
                if (strType.compareTo("Read") == 0) {
                    sasPasswords[0] = passObj.getPassword();
                    continue;
                }
                if (strType.compareTo("Write") == 0) {
                    sasPasswords[1] = passObj.getPassword();
                    continue;
                }
                if (strType.compareTo("Alter") != 0) continue;
                sasPasswords[2] = passObj.getPassword();
            }
            boolean selectStar = false;
            do {
                this.m_rsltSet = null;
                try {
                    StringBuffer query = new StringBuffer("SELECT ");
                    if (!selectStar) {
                        AssociationList tColumns = physTable.getColumns();
                        if (tColumns.size() < 1) {
                            JOptionPane.showMessageDialog(Workspace.getWorkspace(), bundle.getString("AppServer.NoColumnsError.txt"), bundle.getString("AppServer.NoColumnsError.title.txt"), 0);
                            return null;
                        }
                        Iterator cIter = tColumns.iterator();
                        while (cIter.hasNext()) {
                            Column columnObject = (Column)cIter.next();
                            String sasColumnName = columnObject.getSASColumnName();
                            sasColumnName = DBMSNamesUtil.getQuotedString(sasColumnName, (DataTable)physTable);
                            query.append(sasColumnName);
                            String format = columnObject.getSASFormat();
                            if (format != null && format.length() > 0) {
                                query.append(" FORMAT=");
                                query.append(format);
                                if (format.indexOf(".") == -1) {
                                    query.append(".");
                                }
                            }
                            if (!cIter.hasNext()) continue;
                            query.append(",");
                        }
                    } else {
                        selectStar = false;
                        query.append(" *");
                    }
                    query.append(" FROM ");
                    query.append(strAssignedLibref);
                    query.append(".");
                    strTable = DBMSNamesUtil.getQuotedString(strTable, (DataTable)physTable);
                    query.append(strTable);
                    Workspace.getDefaultLogger().info(query.toString());
                    String specChar = DBMSNamesPropertyHandler.getSpecCharPropertyValue((Root)physTable);
                    if (specChar.equals("Y")) {
                        this.submitSrc("options VALIDVARNAME=ANY;");
                    }
                    this.m_rsltSet = (MVAResultSet)this.m_sqlStmt.executeQuery(query.substring(0, query.length()));
                    this.m_rsltSet.setFetchSize(100);
                }
                catch (Exception ge) {
                    String msg = ge.getMessage().toUpperCase();
                    if (ge instanceof SQLException && msg.indexOf("COLUMNS") >= 0 && msg.indexOf("NOT FOUND") >= 0) {
                        int answer = JOptionPane.showConfirmDialog(Workspace.getWorkspace(), bundle.getString("AppServer.MissingColumns.msg.txt"), bundle.getString("AppServer.MissingColumns.title.txt"), 0, 2);
                        if (answer != 0) continue;
                        selectStar = true;
                        continue;
                    }
                    Workspace.getDefaultLogger().error((java.lang.Object)"", ge);
                    this.closeJDBCTable();
                    this.setStatus(22, new java.lang.Object[]{physTable.getName(), this.m_Library.getName(), strAssignedLibref, strTable}, ge.getMessage());
                }
            } while (selectStar);
            return this.m_rsltSet;
        }
        catch (MdException e) {
            Workspace.getDefaultLogger().error((java.lang.Object)"", e);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException(re);
        }
        return null;
    }

    public SASLibrary getSchemaLibrary(DatabaseSchema m_metadata) {
        List m_metaQueryAll = null;
        SASLibrary sLibrary = null;
        try {
            String sOptions = "<XMLSelect search=\"*[UsingPackages/DatabaseSchema[@ID='" + m_metadata.getFQID() + "']]\"/>";
            String reposID = Workspace.getWorkspace().getDefaultRepository().getFQID();
            MdObjectStore m_myStore = (MdObjectStore)m_metadata.getObjectStore();
            m_metaQueryAll = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)m_myStore, reposID, "SASLibrary", 8576, sOptions);
            if (m_metaQueryAll.size() > 0) {
                m_metaQueryAll = Workspace.removeCheckouts(m_metaQueryAll);
            }
        }
        catch (MdException mde) {
            return null;
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException(re);
        }
        try {
            sLibrary = (SASLibrary)m_metaQueryAll.get(0);
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().error((java.lang.Object)"", e);
        }
        return sLibrary;
    }

    public static String bldOptionString(AssociationList optionList, String optionRole) {
        String strOptions = "";
        return strOptions;
    }

    public void makeSQLConnection() throws AppServerException {
        this.m_sasWorkspace = this.makeConnection();
        this.m_rio = this.m_sasWorkspace.DataService();
        try {
            Properties JDBCProperties = new Properties();
            JDBCProperties.put("APPLYFORMATS", "true");
            this.m_sqlConnection = new MVAConnection(this.m_rio, JDBCProperties);
            this.m_sqlStmt = (MVAStatement)this.m_sqlConnection.createStatement();
        }
        catch (Exception ge) {
            Workspace.getDefaultLogger().error((java.lang.Object)"", ge);
            if (this.m_sqlConnection != null) {
                try {
                    this.m_sqlConnection.close();
                }
                catch (Exception ex) {
                    Workspace.getDefaultLogger().error((java.lang.Object)"", ex);
                }
            }
            this.m_sqlConnection = null;
            this.m_sqlStmt = null;
            this.setStatus(21, ge.getMessage());
        }
    }

    public MVAResultSet getTable(String strLibref, String strTable, String strMemType, String[] sasPasswords, String strOptions) throws AppServerException {
        this.m_rsltSet = null;
        try {
            this.m_rsltSet = (MVAResultSet)this.m_sqlStmt.getTable(strLibref, strTable, strMemType, sasPasswords, strOptions);
            this.m_rsltSet.setFetchSize(1000);
        }
        catch (SQLException se) {
            Workspace.getDefaultLogger().error((java.lang.Object)"", se);
        }
        catch (Exception ge) {
            this.setStatus(28, new java.lang.Object[]{strTable, strLibref}, ge.getMessage());
        }
        return this.m_rsltSet;
    }

    public String makeSQLConnection(String tempLibRef, String engine, String path, String strIncomingOptions) throws AppServerException {
        this.makeSQLConnection();
        String strLibref = null;
        try {
            strLibref = this.assignLibref(this.m_Library);
        }
        catch (AppServerException appServerException) {
            // empty catch block
        }
        return strLibref;
    }

    public String assignLibref(String strLibref0, String strEngine, String strPath, String strOptions) throws AppServerException, MdException, RemoteException {
        MdObjectStore tempStore = Workspace.getMdFactory().createObjectStore();
        SASLibrary iLibrary = (SASLibrary)Workspace.getMdFactory().createComplexMetadataObject(tempStore, null, "TempLib", "SASLibrary", "A0000002");
        if (strLibref0 != null) {
            iLibrary.setLibref(strLibref0);
        }
        if (strEngine != null) {
            iLibrary.setEngine(strEngine);
        }
        if (strPath != null) {
            Directory iDir = (Directory)Workspace.getMdFactory().createComplexMetadataObject(tempStore, null, "TempPath", "Directory", "A0000002");
            iDir.setDirectoryName(strPath);
            AssociationList dirs = new AssociationList("UsingPackages", (java.lang.Object)iDir);
            iLibrary.setUsingPackages(dirs);
        }
        if (strOptions != null) {
            Property iProp = (Property)Workspace.getMdFactory().createComplexMetadataObject(tempStore, null, "TempProp", "Property", "A0000002");
            iProp.setName("AdditionalProperties");
            iProp.setPropertyName("AdditionalProperties");
            iProp.setUseValueOnly(1);
            iProp.setDefaultValue(strOptions);
            iLibrary.getProperties().add((java.lang.Object)iProp);
        }
        String retStr = this.assignLibref(iLibrary);
        tempStore.dispose();
        return retStr;
    }

    public boolean isPreassignedMetaEngine(SASLibrary iLib) throws AppServerException {
        boolean metaEngine;
        block6: {
            metaEngine = false;
            try {
                String strLibref = iLib.getLibref();
                if (iLib.getIsPreassigned() != 1) break block6;
                try {
                    StringSeqHolder listLibrefs = new StringSeqHolder();
                    this.m_rio.ListLibrefs(listLibrefs);
                    String[] librefsArray = listLibrefs.value;
                    for (int i = 0; i < librefsArray.length; ++i) {
                        if (librefsArray[i].compareToIgnoreCase(strLibref) != 0) continue;
                        ILibref preassign = this.m_rio.UseLibref(librefsArray[i]);
                        boolean[] fieldInclusionMask = new boolean[]{true, true, true, true, true, true};
                        StringSeqHolder engineName = new StringSeqHolder();
                        VariableArray2dOfLongHolder engineAttrs = new VariableArray2dOfLongHolder();
                        LongSeqHolder libraryAttrs = new LongSeqHolder();
                        StringSeqHolder physicalName = new StringSeqHolder();
                        VariableArray2dOfStringHolder infoPropertyNames = new VariableArray2dOfStringHolder();
                        VariableArray2dOfStringHolder infoPropertyValues = new VariableArray2dOfStringHolder();
                        preassign.LevelInfo(fieldInclusionMask, engineName, engineAttrs, libraryAttrs, physicalName, infoPropertyNames, infoPropertyValues);
                        String[] engineNameArray = engineName.value;
                        if (engineNameArray[0].toString().compareToIgnoreCase("META") == 0) {
                            metaEngine = true;
                        }
                        break;
                    }
                }
                catch (Exception ge) {
                    Workspace.getDefaultLogger().error((java.lang.Object)"", ge);
                    this.setStatus(25, new java.lang.Object[]{strLibref});
                }
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException(ex);
            }
        }
        return metaEngine;
    }

    public String assignLibref(SASLibrary iLib) throws AppServerException {
        try {
            String strLibref;
            int numtmplib = 0;
            String strLibref0 = strLibref = iLib.getLibref();
            boolean fLibRef = false;
            if (iLib.getIsPreassigned() == 0) {
                while (!fLibRef) {
                    try {
                        this.m_rio.UseLibref(strLibref);
                        String suffix = String.valueOf(numtmplib);
                        int suffixLen = suffix.length();
                        if (strLibref0.length() + suffixLen > 8) {
                            strLibref0 = strLibref0.substring(0, 8 - suffixLen);
                        }
                        strLibref = strLibref0 + String.valueOf(numtmplib);
                        ++numtmplib;
                    }
                    catch (Exception ge) {
                        Workspace.getDefaultLogger().error((java.lang.Object)"", ge);
                        fLibRef = true;
                    }
                }
            }
            String tempLibRef = "";
            try {
                tempLibRef = strLibref.compareToIgnoreCase(iLib.getLibref()) != 0 ? LibraryUtil.getAccessPath(iLib, strLibref) : LibraryUtil.getAccessPath(iLib);
                this.submitSrc(tempLibRef);
                this.m_rio.UseLibref(strLibref);
            }
            catch (Exception ge) {
                this.setStatus(25, new java.lang.Object[]{strLibref, tempLibRef});
            }
            return strLibref;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
            return "";
        }
    }

    public String assignLibref(String strLibref0, String strEngine, String strPath, String strOptions, boolean useOldMethod) throws AppServerException, MdException, RemoteException {
        return this.assignLibref(strLibref0, strEngine, strPath, strOptions);
    }

    public boolean isLibrefAssigned(SASLibrary iLib) throws AppServerException {
        try {
            return this.isLibrefAssigned(iLib.getLibref());
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
            return false;
        }
    }

    public boolean isLibrefAssigned(String strLibref) throws AppServerException {
        try {
            this.m_rio.UseLibref(strLibref);
        }
        catch (Exception ge) {
            Workspace.getDefaultLogger().error((java.lang.Object)"", ge);
            return false;
        }
        return true;
    }

    public MVAResultSet submitSQLStatement(String strStatement) throws AppServerException {
        if (this.m_sqlConnection == null || this.m_sqlStmt == null) {
            this.setStatus(27);
        }
        this.m_rsltSet = null;
        try {
            this.m_rsltSet = (MVAResultSet)this.m_sqlStmt.executeQuery(strStatement);
            this.m_rsltSet.setFetchSize(1000);
        }
        catch (Exception ge) {
            this.setStatus(26, new java.lang.Object[]{strStatement}, ge.getMessage());
        }
        return this.m_rsltSet;
    }

    public MVAResultSet submitSQLStatement(String strStatement, MVAStatement sqlStatement) throws AppServerException {
        if (this.m_sqlConnection == null || sqlStatement == null) {
            this.setStatus(27);
        }
        this.m_rsltSet = null;
        try {
            this.m_rsltSet = (MVAResultSet)sqlStatement.executeQuery(strStatement);
            this.m_rsltSet.setFetchSize(1000);
        }
        catch (Exception ge) {
            this.setStatus(26, new java.lang.Object[]{strStatement}, ge.getMessage());
        }
        return this.m_rsltSet;
    }

    private SASLibrary findLibrary(AssociationList tablePackages) {
        SASLibrary lib = null;
        try {
            for (int i = 0; i < tablePackages.size(); ++i) {
                AssociationList dbLibList;
                RelationalSchema tablePackage = (RelationalSchema)tablePackages.elementAt(i);
                if (tablePackage instanceof SASLibrary) {
                    lib = (SASLibrary)tablePackage;
                    lib = LibraryUtil.getClientLibrary((SASLibrary)tablePackage, this);
                } else if (!(tablePackage instanceof DatabaseSchema) || (lib = this.findLibrary(dbLibList = tablePackage.getUsedByPackages(false))) == null) {
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().error((java.lang.Object)"", e);
        }
        return lib;
    }

    public void closeJDBCTable() throws AppServerException {
        if (this.m_rsltSet != null) {
            try {
                this.m_rsltSet.close();
            }
            catch (Exception ge) {
                this.setStatus(23, ge.getMessage());
            }
            finally {
                this.m_rsltSet = null;
            }
        }
        try {
            if (this.m_sqlStmt != null) {
                this.m_sqlStmt.close();
            }
            if (this.m_sqlConnection != null) {
                this.m_sqlConnection.close();
            }
        }
        catch (Exception ge) {
            this.setStatus(29, ge.getMessage());
        }
        finally {
            this.m_sqlStmt = null;
            this.m_sqlConnection = null;
            this.dropConnection();
        }
    }

    public void dropSQLConnection() throws AppServerException {
        this.closeJDBCTable();
    }

    private Vector getBestDeployment(PhysicalTable physTable) {
        try {
            AssociationList lLibsTemp = physTable.getTablePackages(false);
            Vector<java.lang.Object> lLibs = new Vector<java.lang.Object>();
            AssociationList lHosts = null;
            RelationalSchema iLib = null;
            ServerContext iHost = null;
            boolean found = false;
            Vector<java.lang.Object> returnVector = null;
            if (lLibsTemp.size() > 0) {
                int i;
                for (i = 0; i < lLibsTemp.size(); ++i) {
                    iLib = (RelationalSchema)lLibsTemp.get(i);
                    if (iLib instanceof SASLibrary) {
                        lLibs.add(iLib);
                        continue;
                    }
                    AssociationList lLibs2 = iLib.getUsedByPackages();
                    for (int j = 0; j < lLibs2.size(); ++j) {
                        lLibs.add(lLibs2.get(j));
                    }
                }
                for (i = 0; i < lLibs.size() && !found; ++i) {
                    iLib = (SASLibrary)lLibs.get(i);
                    lHosts = iLib.getDeployedComponents();
                    block5: for (int j = 0; j < lHosts.size() && !found; ++j) {
                        iHost = (ServerContext)lHosts.get(j);
                        AssociationList connList = iHost.getSourceConnections();
                        for (int k = 0; k < connList.size(); ++k) {
                            TCPIPConnection tcpConn;
                            Connection conn = (Connection)connList.elementAt(k);
                            if (!(conn instanceof TCPIPConnection) || (tcpConn = (TCPIPConnection)conn).getApplicationProtocol().compareTo("Bridge") != 0) continue;
                            found = true;
                            continue block5;
                        }
                    }
                }
                if (!found) {
                    iLib = (SASLibrary)lLibs.get(0);
                    lHosts = iLib.getDeployedComponents(false);
                    if (lHosts.size() == 0) {
                        return null;
                    }
                    iHost = (ServerContext)lHosts.get(0);
                }
                returnVector = new Vector<java.lang.Object>(2);
                returnVector.add(iLib);
                returnVector.add(iHost);
            } else {
                this.setStatus(24, new java.lang.Object[]{physTable.getName()});
            }
            return returnVector;
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().error((java.lang.Object)"", e);
            return null;
        }
    }

    public synchronized int waitForCompletion() throws AppServerException {
        try {
            int count = 0;
            while (!this.m_operationComplete) {
                this.wait(200L);
                if (++count != 500) continue;
                throw new AppServerException(bundle.getString("AppServer.CodeSubmissionTimeOutError.txt"));
            }
        }
        catch (InterruptedException e) {
            this.m_status = 1;
        }
        return this.m_status;
    }

    private static ConnectionPoint getConnectionPoint(ILanguageService LS) {
        int i;
        String cpidString = ILanguageEventsHelper.id();
        int d1 = (int)Long.parseLong(cpidString.substring(4, 12), 16);
        short d2 = (short)Integer.parseInt(cpidString.substring(13, 17), 16);
        short d3 = (short)Integer.parseInt(cpidString.substring(18, 22), 16);
        byte[] d4 = new byte[8];
        for (i = 0; i < 2; ++i) {
            d4[i] = (byte)Short.parseShort(cpidString.substring(23 + i * 2, 25 + i * 2), 16);
        }
        for (i = 0; i < 6; ++i) {
            d4[i + 2] = (byte)Short.parseShort(cpidString.substring(28 + i * 2, 30 + i * 2), 16);
        }
        CP_ID cpid = new CP_ID(d1, d2, d3, d4);
        ConnectionPointContainer cpContainer = ConnectionPointContainerHelper.narrow((Object)LS);
        ConnectionPointHolder cpHolder = new ConnectionPointHolder();
        cpContainer.FindConnectionPoint(cpid, cpHolder);
        ConnectionPoint cpC = cpHolder.value;
        return cpC;
    }

    private static int registerLanguageListener(ILanguageEventsListener sasListenerC, ConnectionPoint cpC) {
        IntHolder handleHolder = new IntHolder();
        cpC.Advise((Object)sasListenerC, handleHolder);
        int handleC = handleHolder.value;
        return handleC;
    }

    private static void unregisterLanguageListener() {
        m_cpC.Unadvise(m_handle);
    }

    static {
        m_handle = 0;
        m_codeError = false;
    }

    public class cPasswordPrompt
    implements Runnable {
        protected String m_sMessage = null;
        protected String m_sUserid = null;
        protected String m_sPassword = null;
        protected int m_ReturnCode = 0;

        public cPasswordPrompt(String message, String userid, String password) {
            this.m_sMessage = message;
            this.m_sUserid = userid;
            this.m_sPassword = password;
        }

        @Override
        public void run() {
            AppServerPasswordDialog dialog = null;
            dialog = new AppServerPasswordDialog(Workspace.getWorkspace(), this.m_sMessage, true);
            LogonView view = new LogonView();
            view.setUserName(this.m_sUserid);
            view.setPassword(this.m_sPassword);
            dialog.setMainPanel(view);
            dialog.show();
            if (dialog.getReturnValue() != 2) {
                this.m_sUserid = view.getUserName();
                this.m_sPassword = view.getPassword();
            } else {
                this.m_ReturnCode = 1;
            }
            dialog.dispose();
        }

        public int getReturnCode(Vector vCredentials) {
            if (this.m_ReturnCode == 0) {
                vCredentials.clear();
                vCredentials.add(this.m_sUserid);
                vCredentials.add(this.m_sPassword);
            }
            return this.m_ReturnCode;
        }
    }

    private class ILanguageEventsListener
    extends _ILanguageEventsImplBase {
        public void ProcStart(String procname) {
        }

        public void SubmitComplete(int sasrc) {
            Workspace.getDefaultLogger().debug("SubmitComplete");
            AppServer.this.m_operationComplete = true;
            ((java.lang.Object)((java.lang.Object)this)).notifyAll();
        }

        public void ProcComplete(String procname) {
        }

        public void DatastepStart() {
        }

        public void DatastepComplete() {
        }

        public void StepError() {
            Workspace.getDefaultLogger().info("Step Error");
            m_codeError = true;
        }
    }
}

